/*******************************************************************
*   WI_SID_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'WI_SID_2012_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 CPT1                      16-  20 (A)
 CPT2                      21-  25 (A)
 CPT3                      26-  30 (A)
 CPT4                      31-  35 (A)
 CPT5                      36-  40 (A)
 CPT6                      41-  45 (A)
 CPT7                      46-  50 (A)
 CPT8                      51-  55 (A)
 CPT9                      56-  60 (A)
 CPT10                     61-  65 (A)
 CPT11                     66-  70 (A)
 CPT12                     71-  75 (A)
 CPT13                     76-  80 (A)
 CPT14                     81-  85 (A)
 CPT15                     86-  90 (A)
 CPT16                     91-  95 (A)
 CPT17                     96- 100 (A)
 CPT18                    101- 105 (A)
 CPT19                    106- 110 (A)
 CPT20                    111- 115 (A)
 CPT21                    116- 120 (A)
 CPT22                    121- 125 (A)
 CPT23                    126- 130 (A)
 CPT24                    131- 135 (A)
 CPT25                    136- 140 (A)
 CPT26                    141- 145 (A)
 CPT27                    146- 150 (A)
 CPT28                    151- 155 (A)
 CPT29                    156- 160 (A)
 CPT30                    161- 165 (A)
 CPT31                    166- 170 (A)
 CPT32                    171- 175 (A)
 CPT33                    176- 180 (A)
 CPT34                    181- 185 (A)
 CPT35                    186- 190 (A)
 CPT36                    191- 195 (A)
 CPT37                    196- 200 (A)
 CPT38                    201- 205 (A)
 CPT39                    206- 210 (A)
 CPT40                    211- 215 (A)
 CPT41                    216- 220 (A)
 CPT42                    221- 225 (A)
 CPT43                    226- 230 (A)
 CPT44                    231- 235 (A)
 CPT45                    236- 240 (A)
 CPT46                    241- 245 (A)
 CPT47                    246- 250 (A)
 CPT48                    251- 255 (A)
 CPT49                    256- 260 (A)
 CPT50                    261- 265 (A)
 CPTCCS1                  266- 268
 CPTCCS2                  269- 271
 CPTCCS3                  272- 274
 CPTCCS4                  275- 277
 CPTCCS5                  278- 280
 CPTCCS6                  281- 283
 CPTCCS7                  284- 286
 CPTCCS8                  287- 289
 CPTCCS9                  290- 292
 CPTCCS10                 293- 295
 CPTCCS11                 296- 298
 CPTCCS12                 299- 301
 CPTCCS13                 302- 304
 CPTCCS14                 305- 307
 CPTCCS15                 308- 310
 CPTCCS16                 311- 313
 CPTCCS17                 314- 316
 CPTCCS18                 317- 319
 CPTCCS19                 320- 322
 CPTCCS20                 323- 325
 CPTCCS21                 326- 328
 CPTCCS22                 329- 331
 CPTCCS23                 332- 334
 CPTCCS24                 335- 337
 CPTCCS25                 338- 340
 CPTCCS26                 341- 343
 CPTCCS27                 344- 346
 CPTCCS28                 347- 349
 CPTCCS29                 350- 352
 CPTCCS30                 353- 355
 CPTCCS31                 356- 358
 CPTCCS32                 359- 361
 CPTCCS33                 362- 364
 CPTCCS34                 365- 367
 CPTCCS35                 368- 370
 CPTCCS36                 371- 373
 CPTCCS37                 374- 376
 CPTCCS38                 377- 379
 CPTCCS39                 380- 382
 CPTCCS40                 383- 385
 CPTCCS41                 386- 388
 CPTCCS42                 389- 391
 CPTCCS43                 392- 394
 CPTCCS44                 395- 397
 CPTCCS45                 398- 400
 CPTCCS46                 401- 403
 CPTCCS47                 404- 406
 CPTCCS48                 407- 409
 CPTCCS49                 410- 412
 CPTCCS50                 413- 415
 DIED                     416- 417
 DISPUB04                 418- 419
 DISPUNIFORM              420- 421
 DISP_X                   422- 423 (A)
 DQTR                     424- 425
 DRG                      426- 428
 DRG24                    429- 431
 DRGVER                   432- 433
 DRG_NoPOA                434- 436
 DSHOSPID                 437- 453 (A)
 DX1                      454- 458 (A)
 DX2                      459- 463 (A)
 DX3                      464- 468 (A)
 DX4                      469- 473 (A)
 DX5                      474- 478 (A)
 DX6                      479- 483 (A)
 DX7                      484- 488 (A)
 DX8                      489- 493 (A)
 DX9                      494- 498 (A)
 DX10                     499- 503 (A)
 DX11                     504- 508 (A)
 DX12                     509- 513 (A)
 DX13                     514- 518 (A)
 DX14                     519- 523 (A)
 DX15                     524- 528 (A)
 DX16                     529- 533 (A)
 DX17                     534- 538 (A)
 DX18                     539- 543 (A)
 DX19                     544- 548 (A)
 DX20                     549- 553 (A)
 DX21                     554- 558 (A)
 DX22                     559- 563 (A)
 DX23                     564- 568 (A)
 DX24                     569- 573 (A)
 DX25                     574- 578 (A)
 DX26                     579- 583 (A)
 DX27                     584- 588 (A)
 DX28                     589- 593 (A)
 DX29                     594- 598 (A)
 DX30                     599- 603 (A)
 DX31                     604- 608 (A)
 DX32                     609- 613 (A)
 DX33                     614- 618 (A)
 DX34                     619- 623 (A)
 DX35                     624- 628 (A)
 DX36                     629- 633 (A)
 DX37                     634- 638 (A)
 DX38                     639- 643 (A)
 DX39                     644- 648 (A)
 DX40                     649- 653 (A)
 DX41                     654- 658 (A)
 DX42                     659- 663 (A)
 DX43                     664- 668 (A)
 DX44                     669- 673 (A)
 DX45                     674- 678 (A)
 DX46                     679- 683 (A)
 DX47                     684- 688 (A)
 DX48                     689- 693 (A)
 DX49                     694- 698 (A)
 DX50                     699- 703 (A)
 DXCCS1                   704- 707
 DXCCS2                   708- 711
 DXCCS3                   712- 715
 DXCCS4                   716- 719
 DXCCS5                   720- 723
 DXCCS6                   724- 727
 DXCCS7                   728- 731
 DXCCS8                   732- 735
 DXCCS9                   736- 739
 DXCCS10                  740- 743
 DXCCS11                  744- 747
 DXCCS12                  748- 751
 DXCCS13                  752- 755
 DXCCS14                  756- 759
 DXCCS15                  760- 763
 DXCCS16                  764- 767
 DXCCS17                  768- 771
 DXCCS18                  772- 775
 DXCCS19                  776- 779
 DXCCS20                  780- 783
 DXCCS21                  784- 787
 DXCCS22                  788- 791
 DXCCS23                  792- 795
 DXCCS24                  796- 799
 DXCCS25                  800- 803
 DXCCS26                  804- 807
 DXCCS27                  808- 811
 DXCCS28                  812- 815
 DXCCS29                  816- 819
 DXCCS30                  820- 823
 DXCCS31                  824- 827
 DXCCS32                  828- 831
 DXCCS33                  832- 835
 DXCCS34                  836- 839
 DXCCS35                  840- 843
 DXCCS36                  844- 847
 DXCCS37                  848- 851
 DXCCS38                  852- 855
 DXCCS39                  856- 859
 DXCCS40                  860- 863
 DXCCS41                  864- 867
 DXCCS42                  868- 871
 DXCCS43                  872- 875
 DXCCS44                  876- 879
 DXCCS45                  880- 883
 DXCCS46                  884- 887
 DXCCS47                  888- 891
 DXCCS48                  892- 895
 DXCCS49                  896- 899
 DXCCS50                  900- 903
 DXPOA1                   904     (A)
 DXPOA2                   905     (A)
 DXPOA3                   906     (A)
 DXPOA4                   907     (A)
 DXPOA5                   908     (A)
 DXPOA6                   909     (A)
 DXPOA7                   910     (A)
 DXPOA8                   911     (A)
 DXPOA9                   912     (A)
 DXPOA10                  913     (A)
 DXPOA11                  914     (A)
 DXPOA12                  915     (A)
 DXPOA13                  916     (A)
 DXPOA14                  917     (A)
 DXPOA15                  918     (A)
 DXPOA16                  919     (A)
 DXPOA17                  920     (A)
 DXPOA18                  921     (A)
 DXPOA19                  922     (A)
 DXPOA20                  923     (A)
 DXPOA21                  924     (A)
 DXPOA22                  925     (A)
 DXPOA23                  926     (A)
 DXPOA24                  927     (A)
 DXPOA25                  928     (A)
 DXPOA26                  929     (A)
 DXPOA27                  930     (A)
 DXPOA28                  931     (A)
 DXPOA29                  932     (A)
 DXPOA30                  933     (A)
 DXPOA31                  934     (A)
 DXPOA32                  935     (A)
 DXPOA33                  936     (A)
 DXPOA34                  937     (A)
 DXPOA35                  938     (A)
 DXPOA36                  939     (A)
 DXPOA37                  940     (A)
 DXPOA38                  941     (A)
 DXPOA39                  942     (A)
 DXPOA40                  943     (A)
 DXPOA41                  944     (A)
 DXPOA42                  945     (A)
 DXPOA43                  946     (A)
 DXPOA44                  947     (A)
 DXPOA45                  948     (A)
 DXPOA46                  949     (A)
 DXPOA47                  950     (A)
 DXPOA48                  951     (A)
 DXPOA49                  952     (A)
 DXPOA50                  953     (A)
 DX_Admitting             954- 958 (A)
 ECODE1                   959- 963 (A)
 ECODE2                   964- 968 (A)
 ECODE3                   969- 973 (A)
 ECODE4                   974- 978 (A)
 ECODE5                   979- 983 (A)
 ECODE6                   984- 988 (A)
 ECODE7                   989- 993 (A)
 ECODE8                   994- 998 (A)
 E_CCS1                   999-1002
 E_CCS2                  1003-1006
 E_CCS3                  1007-1010
 E_CCS4                  1011-1014
 E_CCS5                  1015-1018
 E_CCS6                  1019-1022
 E_CCS7                  1023-1026
 E_CCS8                  1027-1030
 E_POA1                  1031     (A)
 E_POA2                  1032     (A)
 E_POA3                  1033     (A)
 E_POA4                  1034     (A)
 E_POA5                  1035     (A)
 E_POA6                  1036     (A)
 E_POA7                  1037     (A)
 E_POA8                  1038     (A)
 FEMALE                  1039-1040
 HCUP_ED                 1041-1042
 HCUP_OS                 1043-1044
 HISPANIC_X              1045     (A)
 HOSPBRTH                1046-1048
 HOSPST                  1049-1050 (A)
 HOSP_NPI                1051-1060 (A)
 Homeless                1061-1062
 KEY                     1063-1077
 LOS                     1078-1082
 LOS_X                   1083-1088
 MDC                     1089-1090
 MDC24                   1091-1092
 MDC_NoPOA               1093-1094
 MDSPEC1                 1095-1097 (A)
 MDSPEC2                 1098-1100 (A)
 MEDINCSTQ               1101-1102
 MRN_R                   1103-1111
 NCHRONIC                1112-1114
 NCPT                    1115-1117
 NDX                     1118-1119
 NECODE                  1120-1121
 NEOMAT                  1122-1123
 NPR                     1124-1125
 ORPROC                  1126-1127
 OS_TIME                 1128-1135
 PAY1                    1136-1137
 PAY1_X                  1138-1142 (A)
 PAY2                    1143-1144
 PAY2_X                  1145-1149 (A)
 PL_CBSA                 1150-1152
 PL_MSA1993              1153-1155
 PL_NCHS2006             1156-1157
 PL_RUCA10_2005          1158-1159
 PL_RUCA2005             1160-1163
 PL_RUCA4_2005           1164-1165
 PL_RUCC2003             1166-1167
 PL_UIC2003              1168-1169
 PL_UR_CAT4              1170-1171
 PR1                     1172-1175 (A)
 PR2                     1176-1179 (A)
 PR3                     1180-1183 (A)
 PR4                     1184-1187 (A)
 PR5                     1188-1191 (A)
 PR6                     1192-1195 (A)
 PR7                     1196-1199 (A)
 PR8                     1200-1203 (A)
 PR9                     1204-1207 (A)
 PR10                    1208-1211 (A)
 PR11                    1212-1215 (A)
 PR12                    1216-1219 (A)
 PR13                    1220-1223 (A)
 PR14                    1224-1227 (A)
 PR15                    1228-1231 (A)
 PR16                    1232-1235 (A)
 PR17                    1236-1239 (A)
 PR18                    1240-1243 (A)
 PR19                    1244-1247 (A)
 PR20                    1248-1251 (A)
 PR21                    1252-1255 (A)
 PR22                    1256-1259 (A)
 PR23                    1260-1263 (A)
 PR24                    1264-1267 (A)
 PR25                    1268-1271 (A)
 PR26                    1272-1275 (A)
 PR27                    1276-1279 (A)
 PR28                    1280-1283 (A)
 PR29                    1284-1287 (A)
 PR30                    1288-1291 (A)
 PR31                    1292-1295 (A)
 PR32                    1296-1299 (A)
 PR33                    1300-1303 (A)
 PR34                    1304-1307 (A)
 PR35                    1308-1311 (A)
 PR36                    1312-1315 (A)
 PR37                    1316-1319 (A)
 PR38                    1320-1323 (A)
 PR39                    1324-1327 (A)
 PR40                    1328-1331 (A)
 PR41                    1332-1335 (A)
 PR42                    1336-1339 (A)
 PR43                    1340-1343 (A)
 PR44                    1344-1347 (A)
 PR45                    1348-1351 (A)
 PR46                    1352-1355 (A)
 PR47                    1356-1359 (A)
 PR48                    1360-1363 (A)
 PR49                    1364-1367 (A)
 PR50                    1368-1371 (A)
 PRCCS1                  1372-1374
 PRCCS2                  1375-1377
 PRCCS3                  1378-1380
 PRCCS4                  1381-1383
 PRCCS5                  1384-1386
 PRCCS6                  1387-1389
 PRCCS7                  1390-1392
 PRCCS8                  1393-1395
 PRCCS9                  1396-1398
 PRCCS10                 1399-1401
 PRCCS11                 1402-1404
 PRCCS12                 1405-1407
 PRCCS13                 1408-1410
 PRCCS14                 1411-1413
 PRCCS15                 1414-1416
 PRCCS16                 1417-1419
 PRCCS17                 1420-1422
 PRCCS18                 1423-1425
 PRCCS19                 1426-1428
 PRCCS20                 1429-1431
 PRCCS21                 1432-1434
 PRCCS22                 1435-1437
 PRCCS23                 1438-1440
 PRCCS24                 1441-1443
 PRCCS25                 1444-1446
 PRCCS26                 1447-1449
 PRCCS27                 1450-1452
 PRCCS28                 1453-1455
 PRCCS29                 1456-1458
 PRCCS30                 1459-1461
 PRCCS31                 1462-1464
 PRCCS32                 1465-1467
 PRCCS33                 1468-1470
 PRCCS34                 1471-1473
 PRCCS35                 1474-1476
 PRCCS36                 1477-1479
 PRCCS37                 1480-1482
 PRCCS38                 1483-1485
 PRCCS39                 1486-1488
 PRCCS40                 1489-1491
 PRCCS41                 1492-1494
 PRCCS42                 1495-1497
 PRCCS43                 1498-1500
 PRCCS44                 1501-1503
 PRCCS45                 1504-1506
 PRCCS46                 1507-1509
 PRCCS47                 1510-1512
 PRCCS48                 1513-1515
 PRCCS49                 1516-1518
 PRCCS50                 1519-1521
 PRDAY1                  1522-1526
 PROCTYPE                1527-1529
 PSTATE                  1530-1531 (A)
 PSTCO2                  1532-1536
 PointOfOriginUB04       1537     (A)
 PointOfOrigin_X         1538     (A)
 RACE                    1539-1540
 RACE_X                  1541     (A)
 TOTCHG                  1542-1551
 TOTCHG_X                1552-1566
 TRAN_IN                 1567-1568
 TRAN_OUT                1569-1570
 YEAR                    1571-1574
 ZIP3                    1575-1577 (A)
 ZIPINC_QRTL             1578-1580
 ZIP                     1581-1585 (A)
 AYEAR                   1586-1589
 DMONTH                  1590-1591
 BMONTH                  1592-1593
 BYEAR                   1594-1597
 PRMONTH1                1598-1599
 PRYEAR1                 1600-1603.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTCCS31                (F4.0) /
 CPTCCS32                (F4.0) /
 CPTCCS33                (F4.0) /
 CPTCCS34                (F4.0) /
 CPTCCS35                (F4.0) /
 CPTCCS36                (F4.0) /
 CPTCCS37                (F4.0) /
 CPTCCS38                (F4.0) /
 CPTCCS39                (F4.0) /
 CPTCCS40                (F4.0) /
 CPTCCS41                (F4.0) /
 CPTCCS42                (F4.0) /
 CPTCCS43                (F4.0) /
 CPTCCS44                (F4.0) /
 CPTCCS45                (F4.0) /
 CPTCCS46                (F4.0) /
 CPTCCS47                (F4.0) /
 CPTCCS48                (F4.0) /
 CPTCCS49                (F4.0) /
 CPTCCS50                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 OS_TIME                 (F4.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRCCS38                 (F3.0) /
 PRCCS39                 (F3.0) /
 PRCCS40                 (F3.0) /
 PRCCS41                 (F3.0) /
 PRCCS42                 (F3.0) /
 PRCCS43                 (F3.0) /
 PRCCS44                 (F3.0) /
 PRCCS45                 (F3.0) /
 PRCCS46                 (F3.0) /
 PRCCS47                 (F3.0) /
 PRCCS48                 (F3.0) /
 PRCCS49                 (F3.0) /
 PRCCS50                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPT31                   "CPT/HCPCS procedure code 31"
 CPT32                   "CPT/HCPCS procedure code 32"
 CPT33                   "CPT/HCPCS procedure code 33"
 CPT34                   "CPT/HCPCS procedure code 34"
 CPT35                   "CPT/HCPCS procedure code 35"
 CPT36                   "CPT/HCPCS procedure code 36"
 CPT37                   "CPT/HCPCS procedure code 37"
 CPT38                   "CPT/HCPCS procedure code 38"
 CPT39                   "CPT/HCPCS procedure code 39"
 CPT40                   "CPT/HCPCS procedure code 40"
 CPT41                   "CPT/HCPCS procedure code 41"
 CPT42                   "CPT/HCPCS procedure code 42"
 CPT43                   "CPT/HCPCS procedure code 43"
 CPT44                   "CPT/HCPCS procedure code 44"
 CPT45                   "CPT/HCPCS procedure code 45"
 CPT46                   "CPT/HCPCS procedure code 46"
 CPT47                   "CPT/HCPCS procedure code 47"
 CPT48                   "CPT/HCPCS procedure code 48"
 CPT49                   "CPT/HCPCS procedure code 49"
 CPT50                   "CPT/HCPCS procedure code 50"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTCCS31                "CCS: CPT 31"
 CPTCCS32                "CCS: CPT 32"
 CPTCCS33                "CCS: CPT 33"
 CPTCCS34                "CCS: CPT 34"
 CPTCCS35                "CCS: CPT 35"
 CPTCCS36                "CCS: CPT 36"
 CPTCCS37                "CCS: CPT 37"
 CPTCCS38                "CCS: CPT 38"
 CPTCCS39                "CCS: CPT 39"
 CPTCCS40                "CCS: CPT 40"
 CPTCCS41                "CCS: CPT 41"
 CPTCCS42                "CCS: CPT 42"
 CPTCCS43                "CCS: CPT 43"
 CPTCCS44                "CCS: CPT 44"
 CPTCCS45                "CCS: CPT 45"
 CPTCCS46                "CCS: CPT 46"
 CPTCCS47                "CCS: CPT 47"
 CPTCCS48                "CCS: CPT 48"
 CPTCCS49                "CCS: CPT 49"
 CPTCCS50                "CCS: CPT 50"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DX34                    "Diagnosis 34"
 DX35                    "Diagnosis 35"
 DX36                    "Diagnosis 36"
 DX37                    "Diagnosis 37"
 DX38                    "Diagnosis 38"
 DX39                    "Diagnosis 39"
 DX40                    "Diagnosis 40"
 DX41                    "Diagnosis 41"
 DX42                    "Diagnosis 42"
 DX43                    "Diagnosis 43"
 DX44                    "Diagnosis 44"
 DX45                    "Diagnosis 45"
 DX46                    "Diagnosis 46"
 DX47                    "Diagnosis 47"
 DX48                    "Diagnosis 48"
 DX49                    "Diagnosis 49"
 DX50                    "Diagnosis 50"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 DXCCS34                 "CCS: diagnosis 34"
 DXCCS35                 "CCS: diagnosis 35"
 DXCCS36                 "CCS: diagnosis 36"
 DXCCS37                 "CCS: diagnosis 37"
 DXCCS38                 "CCS: diagnosis 38"
 DXCCS39                 "CCS: diagnosis 39"
 DXCCS40                 "CCS: diagnosis 40"
 DXCCS41                 "CCS: diagnosis 41"
 DXCCS42                 "CCS: diagnosis 42"
 DXCCS43                 "CCS: diagnosis 43"
 DXCCS44                 "CCS: diagnosis 44"
 DXCCS45                 "CCS: diagnosis 45"
 DXCCS46                 "CCS: diagnosis 46"
 DXCCS47                 "CCS: diagnosis 47"
 DXCCS48                 "CCS: diagnosis 48"
 DXCCS49                 "CCS: diagnosis 49"
 DXCCS50                 "CCS: diagnosis 50"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DXPOA25                 "Diagnosis 25, present on admission indicator"
 DXPOA26                 "Diagnosis 26, present on admission indicator"
 DXPOA27                 "Diagnosis 27, present on admission indicator"
 DXPOA28                 "Diagnosis 28, present on admission indicator"
 DXPOA29                 "Diagnosis 29, present on admission indicator"
 DXPOA30                 "Diagnosis 30, present on admission indicator"
 DXPOA31                 "Diagnosis 31, present on admission indicator"
 DXPOA32                 "Diagnosis 32, present on admission indicator"
 DXPOA33                 "Diagnosis 33, present on admission indicator"
 DXPOA34                 "Diagnosis 34, present on admission indicator"
 DXPOA35                 "Diagnosis 35, present on admission indicator"
 DXPOA36                 "Diagnosis 36, present on admission indicator"
 DXPOA37                 "Diagnosis 37, present on admission indicator"
 DXPOA38                 "Diagnosis 38, present on admission indicator"
 DXPOA39                 "Diagnosis 39, present on admission indicator"
 DXPOA40                 "Diagnosis 40, present on admission indicator"
 DXPOA41                 "Diagnosis 41, present on admission indicator"
 DXPOA42                 "Diagnosis 42, present on admission indicator"
 DXPOA43                 "Diagnosis 43, present on admission indicator"
 DXPOA44                 "Diagnosis 44, present on admission indicator"
 DXPOA45                 "Diagnosis 45, present on admission indicator"
 DXPOA46                 "Diagnosis 46, present on admission indicator"
 DXPOA47                 "Diagnosis 47, present on admission indicator"
 DXPOA48                 "Diagnosis 48, present on admission indicator"
 DXPOA49                 "Diagnosis 49, present on admission indicator"
 DXPOA50                 "Diagnosis 50, present on admission indicator"
 DX_Admitting            "Admitting Diagnosis Code"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 HOSP_NPI                "Hospital NPI"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MDSPEC1                 "Physician 1 specialty (as received from source)"
 MDSPEC2                 "Physician 2 specialty (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 OS_TIME                 "Observation stay time summed from UNITS"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PR26                    "Procedure 26"
 PR27                    "Procedure 27"
 PR28                    "Procedure 28"
 PR29                    "Procedure 29"
 PR30                    "Procedure 30"
 PR31                    "Procedure 31"
 PR32                    "Procedure 32"
 PR33                    "Procedure 33"
 PR34                    "Procedure 34"
 PR35                    "Procedure 35"
 PR36                    "Procedure 36"
 PR37                    "Procedure 37"
 PR38                    "Procedure 38"
 PR39                    "Procedure 39"
 PR40                    "Procedure 40"
 PR41                    "Procedure 41"
 PR42                    "Procedure 42"
 PR43                    "Procedure 43"
 PR44                    "Procedure 44"
 PR45                    "Procedure 45"
 PR46                    "Procedure 46"
 PR47                    "Procedure 47"
 PR48                    "Procedure 48"
 PR49                    "Procedure 49"
 PR50                    "Procedure 50"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRCCS26                 "CCS: procedure 26"
 PRCCS27                 "CCS: procedure 27"
 PRCCS28                 "CCS: procedure 28"
 PRCCS29                 "CCS: procedure 29"
 PRCCS30                 "CCS: procedure 30"
 PRCCS31                 "CCS: procedure 31"
 PRCCS32                 "CCS: procedure 32"
 PRCCS33                 "CCS: procedure 33"
 PRCCS34                 "CCS: procedure 34"
 PRCCS35                 "CCS: procedure 35"
 PRCCS36                 "CCS: procedure 36"
 PRCCS37                 "CCS: procedure 37"
 PRCCS38                 "CCS: procedure 38"
 PRCCS39                 "CCS: procedure 39"
 PRCCS40                 "CCS: procedure 40"
 PRCCS41                 "CCS: procedure 41"
 PRCCS42                 "CCS: procedure 42"
 PRCCS43                 "CCS: procedure 43"
 PRCCS44                 "CCS: procedure 44"
 PRCCS45                 "CCS: procedure 45"
 PRCCS46                 "CCS: procedure 46"
 PRCCS47                 "CCS: procedure 47"
 PRCCS48                 "CCS: procedure 48"
 PRCCS49                 "CCS: procedure 49"
 PRCCS50                 "CCS: procedure 50"
 PRDAY1                  "Number of days from admission to PR1"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRYEAR1                 "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SID_2012_CORE.SAV' /COMPRESSED.
