/*******************************************************************
* Creation Date: 02/03/2017   
*   WI_SID_2015q1q3_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'WI_SID_2015q1q3_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 CPT1                           20-  24 (A)
 CPT2                           25-  29 (A)
 CPT3                           30-  34 (A)
 CPT4                           35-  39 (A)
 CPT5                           40-  44 (A)
 CPT6                           45-  49 (A)
 CPT7                           50-  54 (A)
 CPT8                           55-  59 (A)
 CPT9                           60-  64 (A)
 CPT10                          65-  69 (A)
 CPT11                          70-  74 (A)
 CPT12                          75-  79 (A)
 CPT13                          80-  84 (A)
 CPT14                          85-  89 (A)
 CPT15                          90-  94 (A)
 CPT16                          95-  99 (A)
 CPT17                         100- 104 (A)
 CPT18                         105- 109 (A)
 CPT19                         110- 114 (A)
 CPT20                         115- 119 (A)
 CPT21                         120- 124 (A)
 CPT22                         125- 129 (A)
 CPT23                         130- 134 (A)
 CPT24                         135- 139 (A)
 CPT25                         140- 144 (A)
 CPT26                         145- 149 (A)
 CPT27                         150- 154 (A)
 CPT28                         155- 159 (A)
 CPT29                         160- 164 (A)
 CPT30                         165- 169 (A)
 CPT31                         170- 174 (A)
 CPT32                         175- 179 (A)
 CPT33                         180- 184 (A)
 CPT34                         185- 189 (A)
 CPT35                         190- 194 (A)
 CPT36                         195- 199 (A)
 CPT37                         200- 204 (A)
 CPT38                         205- 209 (A)
 CPT39                         210- 214 (A)
 CPT40                         215- 219 (A)
 CPT41                         220- 224 (A)
 CPT42                         225- 229 (A)
 CPT43                         230- 234 (A)
 CPT44                         235- 239 (A)
 CPT45                         240- 244 (A)
 CPT46                         245- 249 (A)
 CPT47                         250- 254 (A)
 CPT48                         255- 259 (A)
 CPT49                         260- 264 (A)
 CPT50                         265- 269 (A)
 CPT51                         270- 274 (A)
 CPT52                         275- 279 (A)
 CPT53                         280- 284 (A)
 CPTCCS1                       285- 287
 CPTCCS2                       288- 290
 CPTCCS3                       291- 293
 CPTCCS4                       294- 296
 CPTCCS5                       297- 299
 CPTCCS6                       300- 302
 CPTCCS7                       303- 305
 CPTCCS8                       306- 308
 CPTCCS9                       309- 311
 CPTCCS10                      312- 314
 CPTCCS11                      315- 317
 CPTCCS12                      318- 320
 CPTCCS13                      321- 323
 CPTCCS14                      324- 326
 CPTCCS15                      327- 329
 CPTCCS16                      330- 332
 CPTCCS17                      333- 335
 CPTCCS18                      336- 338
 CPTCCS19                      339- 341
 CPTCCS20                      342- 344
 CPTCCS21                      345- 347
 CPTCCS22                      348- 350
 CPTCCS23                      351- 353
 CPTCCS24                      354- 356
 CPTCCS25                      357- 359
 CPTCCS26                      360- 362
 CPTCCS27                      363- 365
 CPTCCS28                      366- 368
 CPTCCS29                      369- 371
 CPTCCS30                      372- 374
 CPTCCS31                      375- 377
 CPTCCS32                      378- 380
 CPTCCS33                      381- 383
 CPTCCS34                      384- 386
 CPTCCS35                      387- 389
 CPTCCS36                      390- 392
 CPTCCS37                      393- 395
 CPTCCS38                      396- 398
 CPTCCS39                      399- 401
 CPTCCS40                      402- 404
 CPTCCS41                      405- 407
 CPTCCS42                      408- 410
 CPTCCS43                      411- 413
 CPTCCS44                      414- 416
 CPTCCS45                      417- 419
 CPTCCS46                      420- 422
 CPTCCS47                      423- 425
 CPTCCS48                      426- 428
 CPTCCS49                      429- 431
 CPTCCS50                      432- 434
 CPTCCS51                      435- 437
 CPTCCS52                      438- 440
 CPTCCS53                      441- 443
 DaysToEvent                   444- 449
 DIED                          450- 451
 DISP_X                        452- 453 (A)
 DISPUB04                      454- 455
 DISPUNIFORM                   456- 457
 DMONTH                        458- 459
 DQTR                          460- 461
 DRG                           462- 464
 DRG_NoPOA                     465- 467
 DRG32                         468- 470
 DRGVER                        471- 472
 DSHOSPID                      473- 489 (A)
 DX_Admitting                  490- 496 (A)
 DX1                           497- 503 (A)
 DX2                           504- 510 (A)
 DX3                           511- 517 (A)
 DX4                           518- 524 (A)
 DX5                           525- 531 (A)
 DX6                           532- 538 (A)
 DX7                           539- 545 (A)
 DX8                           546- 552 (A)
 DX9                           553- 559 (A)
 DX10                          560- 566 (A)
 DX11                          567- 573 (A)
 DX12                          574- 580 (A)
 DX13                          581- 587 (A)
 DX14                          588- 594 (A)
 DX15                          595- 601 (A)
 DX16                          602- 608 (A)
 DX17                          609- 615 (A)
 DX18                          616- 622 (A)
 DX19                          623- 629 (A)
 DX20                          630- 636 (A)
 DX21                          637- 643 (A)
 DX22                          644- 650 (A)
 DX23                          651- 657 (A)
 DX24                          658- 664 (A)
 DX25                          665- 671 (A)
 DX26                          672- 678 (A)
 DX27                          679- 685 (A)
 DX28                          686- 692 (A)
 DX29                          693- 699 (A)
 DX30                          700- 706 (A)
 DX31                          707- 713 (A)
 DX32                          714- 720 (A)
 DX33                          721- 727 (A)
 DX34                          728- 734 (A)
 DX35                          735- 741 (A)
 DX36                          742- 748 (A)
 DX37                          749- 755 (A)
 DX38                          756- 762 (A)
 DX39                          763- 769 (A)
 DX40                          770- 776 (A)
 DX41                          777- 783 (A)
 DX42                          784- 790 (A)
 DX43                          791- 797 (A)
 DX44                          798- 804 (A)
 DX45                          805- 811 (A)
 DX46                          812- 818 (A)
 DX47                          819- 825 (A)
 DX48                          826- 832 (A)
 DX49                          833- 839 (A)
 DX50                          840- 846 (A)
 DX51                          847- 853 (A)
 DX52                          854- 860 (A)
 DX53                          861- 867 (A)
 DX54                          868- 874 (A)
 DX55                          875- 881 (A)
 DX56                          882- 888 (A)
 DX57                          889- 895 (A)
 DX58                          896- 902 (A)
 DX59                          903- 909 (A)
 DX60                          910- 916 (A)
 DX61                          917- 923 (A)
 DX62                          924- 930 (A)
 DX63                          931- 937 (A)
 DX64                          938- 944 (A)
 DX65                          945- 951 (A)
 DX66                          952- 958 (A)
 DX67                          959- 965 (A)
 DXCCS1                        966- 969
 DXCCS2                        970- 973
 DXCCS3                        974- 977
 DXCCS4                        978- 981
 DXCCS5                        982- 985
 DXCCS6                        986- 989
 DXCCS7                        990- 993
 DXCCS8                        994- 997
 DXCCS9                        998-1001
 DXCCS10                      1002-1005
 DXCCS11                      1006-1009
 DXCCS12                      1010-1013
 DXCCS13                      1014-1017
 DXCCS14                      1018-1021
 DXCCS15                      1022-1025
 DXCCS16                      1026-1029
 DXCCS17                      1030-1033
 DXCCS18                      1034-1037
 DXCCS19                      1038-1041
 DXCCS20                      1042-1045
 DXCCS21                      1046-1049
 DXCCS22                      1050-1053
 DXCCS23                      1054-1057
 DXCCS24                      1058-1061
 DXCCS25                      1062-1065
 DXCCS26                      1066-1069
 DXCCS27                      1070-1073
 DXCCS28                      1074-1077
 DXCCS29                      1078-1081
 DXCCS30                      1082-1085
 DXCCS31                      1086-1089
 DXCCS32                      1090-1093
 DXCCS33                      1094-1097
 DXCCS34                      1098-1101
 DXCCS35                      1102-1105
 DXCCS36                      1106-1109
 DXCCS37                      1110-1113
 DXCCS38                      1114-1117
 DXCCS39                      1118-1121
 DXCCS40                      1122-1125
 DXCCS41                      1126-1129
 DXCCS42                      1130-1133
 DXCCS43                      1134-1137
 DXCCS44                      1138-1141
 DXCCS45                      1142-1145
 DXCCS46                      1146-1149
 DXCCS47                      1150-1153
 DXCCS48                      1154-1157
 DXCCS49                      1158-1161
 DXCCS50                      1162-1165
 DXCCS51                      1166-1169
 DXCCS52                      1170-1173
 DXCCS53                      1174-1177
 DXCCS54                      1178-1181
 DXCCS55                      1182-1185
 DXCCS56                      1186-1189
 DXCCS57                      1190-1193
 DXCCS58                      1194-1197
 DXCCS59                      1198-1201
 DXCCS60                      1202-1205
 DXCCS61                      1206-1209
 DXCCS62                      1210-1213
 DXCCS63                      1214-1217
 DXCCS64                      1218-1221
 DXCCS65                      1222-1225
 DXCCS66                      1226-1229
 DXCCS67                      1230-1233
 DXPOA1                       1234     (A)
 DXPOA2                       1235     (A)
 DXPOA3                       1236     (A)
 DXPOA4                       1237     (A)
 DXPOA5                       1238     (A)
 DXPOA6                       1239     (A)
 DXPOA7                       1240     (A)
 DXPOA8                       1241     (A)
 DXPOA9                       1242     (A)
 DXPOA10                      1243     (A)
 DXPOA11                      1244     (A)
 DXPOA12                      1245     (A)
 DXPOA13                      1246     (A)
 DXPOA14                      1247     (A)
 DXPOA15                      1248     (A)
 DXPOA16                      1249     (A)
 DXPOA17                      1250     (A)
 DXPOA18                      1251     (A)
 DXPOA19                      1252     (A)
 DXPOA20                      1253     (A)
 DXPOA21                      1254     (A)
 DXPOA22                      1255     (A)
 DXPOA23                      1256     (A)
 DXPOA24                      1257     (A)
 DXPOA25                      1258     (A)
 DXPOA26                      1259     (A)
 DXPOA27                      1260     (A)
 DXPOA28                      1261     (A)
 DXPOA29                      1262     (A)
 DXPOA30                      1263     (A)
 DXPOA31                      1264     (A)
 DXPOA32                      1265     (A)
 DXPOA33                      1266     (A)
 DXPOA34                      1267     (A)
 DXPOA35                      1268     (A)
 DXPOA36                      1269     (A)
 DXPOA37                      1270     (A)
 DXPOA38                      1271     (A)
 DXPOA39                      1272     (A)
 DXPOA40                      1273     (A)
 DXPOA41                      1274     (A)
 DXPOA42                      1275     (A)
 DXPOA43                      1276     (A)
 DXPOA44                      1277     (A)
 DXPOA45                      1278     (A)
 DXPOA46                      1279     (A)
 DXPOA47                      1280     (A)
 DXPOA48                      1281     (A)
 DXPOA49                      1282     (A)
 DXPOA50                      1283     (A)
 DXPOA51                      1284     (A)
 DXPOA52                      1285     (A)
 DXPOA53                      1286     (A)
 DXPOA54                      1287     (A)
 DXPOA55                      1288     (A)
 DXPOA56                      1289     (A)
 DXPOA57                      1290     (A)
 DXPOA58                      1291     (A)
 DXPOA59                      1292     (A)
 DXPOA60                      1293     (A)
 DXPOA61                      1294     (A)
 DXPOA62                      1295     (A)
 DXPOA63                      1296     (A)
 DXPOA64                      1297     (A)
 DXPOA65                      1298     (A)
 DXPOA66                      1299     (A)
 DXPOA67                      1300     (A)
 DXVER                        1301-1303
 E_CCS1                       1304-1307
 E_CCS2                       1308-1311
 E_CCS3                       1312-1315
 E_CCS4                       1316-1319
 E_CCS5                       1320-1323
 E_CCS6                       1324-1327
 E_CCS7                       1328-1331
 E_CCS8                       1332-1335
 E_CCS9                       1336-1339
 E_POA1                       1340     (A)
 E_POA2                       1341     (A)
 E_POA3                       1342     (A)
 E_POA4                       1343     (A)
 E_POA5                       1344     (A)
 E_POA6                       1345     (A)
 E_POA7                       1346     (A)
 E_POA8                       1347     (A)
 E_POA9                       1348     (A)
 ECODE1                       1349-1355 (A)
 ECODE2                       1356-1362 (A)
 ECODE3                       1363-1369 (A)
 ECODE4                       1370-1376 (A)
 ECODE5                       1377-1383 (A)
 ECODE6                       1384-1390 (A)
 ECODE7                       1391-1397 (A)
 ECODE8                       1398-1404 (A)
 ECODE9                       1405-1411 (A)
 FEMALE                       1412-1413
 HCUP_ED                      1414-1415
 HCUP_OS                      1416-1417
 HISPANIC                     1418-1419
 HISPANIC_X                   1420     (A)
 Homeless                     1421-1422
 HOSP_NPI                     1423-1432 (A)
 HOSPBRTH                     1433-1435
 HOSPST                       1436-1437 (A)
 KEY                          1438-1452
 LOS                          1453-1457
 LOS_X                        1458-1463
 MDC                          1464-1465
 MDC_NoPOA                    1466-1467
 MDC32                        1468-1469
 MDSPEC1                      1470-1472 (A)
 MDSPEC2                      1473-1475 (A)
 MEDINCSTQ                    1476-1477
 MRN_R                        1478-1486
 NCHRONIC                     1487-1489
 NCPT                         1490-1493
 NDX                          1494-1496
 NECODE                       1497-1498
 NEOMAT                       1499-1500
 NPR                          1501-1503
 ORPROC                       1504-1505
 OS_TIME                      1506-1516
 PAY1                         1517-1518
 PAY1_X                       1519-1523 (A)
 PAY2                         1524-1525
 PAY2_X                       1526-1530 (A)
 PL_CBSA                      1531-1533
 PL_NCHS                      1534-1535
 PL_RUCC                      1536-1537
 PL_UIC                       1538-1539
 PL_UR_CAT4                   1540-1541
 POA_Disch_Edit1              1542-1543
 POA_Disch_Edit2              1544-1545
 POA_Hosp_Edit1               1546-1547
 POA_Hosp_Edit2               1548-1549
 POA_Hosp_Edit3               1550-1551
 POA_Hosp_Edit3_Value         1552-1559
 PointOfOrigin_X              1560     (A)
 PointOfOriginUB04            1561     (A)
 PR1                          1562-1568 (A)
 PR2                          1569-1575 (A)
 PR3                          1576-1582 (A)
 PR4                          1583-1589 (A)
 PR5                          1590-1596 (A)
 PR6                          1597-1603 (A)
 PR7                          1604-1610 (A)
 PR8                          1611-1617 (A)
 PR9                          1618-1624 (A)
 PR10                         1625-1631 (A)
 PR11                         1632-1638 (A)
 PR12                         1639-1645 (A)
 PR13                         1646-1652 (A)
 PR14                         1653-1659 (A)
 PR15                         1660-1666 (A)
 PR16                         1667-1673 (A)
 PR17                         1674-1680 (A)
 PR18                         1681-1687 (A)
 PR19                         1688-1694 (A)
 PR20                         1695-1701 (A)
 PR21                         1702-1708 (A)
 PR22                         1709-1715 (A)
 PR23                         1716-1722 (A)
 PR24                         1723-1729 (A)
 PR25                         1730-1736 (A)
 PR26                         1737-1743 (A)
 PR27                         1744-1750 (A)
 PR28                         1751-1757 (A)
 PR29                         1758-1764 (A)
 PR30                         1765-1771 (A)
 PR31                         1772-1778 (A)
 PR32                         1779-1785 (A)
 PR33                         1786-1792 (A)
 PR34                         1793-1799 (A)
 PR35                         1800-1806 (A)
 PR36                         1807-1813 (A)
 PR37                         1814-1820 (A)
 PR38                         1821-1827 (A)
 PR39                         1828-1834 (A)
 PR40                         1835-1841 (A)
 PR41                         1842-1848 (A)
 PR42                         1849-1855 (A)
 PR43                         1856-1862 (A)
 PR44                         1863-1869 (A)
 PR45                         1870-1876 (A)
 PR46                         1877-1883 (A)
 PR47                         1884-1890 (A)
 PR48                         1891-1897 (A)
 PR49                         1898-1904 (A)
 PR50                         1905-1911 (A)
 PRCCS1                       1912-1914
 PRCCS2                       1915-1917
 PRCCS3                       1918-1920
 PRCCS4                       1921-1923
 PRCCS5                       1924-1926
 PRCCS6                       1927-1929
 PRCCS7                       1930-1932
 PRCCS8                       1933-1935
 PRCCS9                       1936-1938
 PRCCS10                      1939-1941
 PRCCS11                      1942-1944
 PRCCS12                      1945-1947
 PRCCS13                      1948-1950
 PRCCS14                      1951-1953
 PRCCS15                      1954-1956
 PRCCS16                      1957-1959
 PRCCS17                      1960-1962
 PRCCS18                      1963-1965
 PRCCS19                      1966-1968
 PRCCS20                      1969-1971
 PRCCS21                      1972-1974
 PRCCS22                      1975-1977
 PRCCS23                      1978-1980
 PRCCS24                      1981-1983
 PRCCS25                      1984-1986
 PRCCS26                      1987-1989
 PRCCS27                      1990-1992
 PRCCS28                      1993-1995
 PRCCS29                      1996-1998
 PRCCS30                      1999-2001
 PRCCS31                      2002-2004
 PRCCS32                      2005-2007
 PRCCS33                      2008-2010
 PRCCS34                      2011-2013
 PRCCS35                      2014-2016
 PRCCS36                      2017-2019
 PRCCS37                      2020-2022
 PRCCS38                      2023-2025
 PRCCS39                      2026-2028
 PRCCS40                      2029-2031
 PRCCS41                      2032-2034
 PRCCS42                      2035-2037
 PRCCS43                      2038-2040
 PRCCS44                      2041-2043
 PRCCS45                      2044-2046
 PRCCS46                      2047-2049
 PRCCS47                      2050-2052
 PRCCS48                      2053-2055
 PRCCS49                      2056-2058
 PRCCS50                      2059-2061
 PRDAY1                       2062-2066
 PROCTYPE                     2067-2069
 PRVER                        2070-2072
 PSTATE                       2073-2074 (A)
 PSTCO2                       2075-2079
 RACE                         2080-2081
 RACE_X                       2082-2083 (A)
 SERVICELINE                  2084-2085
 TOTCHG                       2086-2095
 TOTCHG_X                     2096-2110
 TRAN_IN                      2111-2112
 TRAN_OUT                     2113-2114
 VisitLink                    2115-2123
 YEAR                         2124-2127
 ZIP                          2128-2132 (A)
 ZIP3                         2133-2135 (A)
 ZIPINC_QRTL                  2136-2138
 AYEAR                        2139-2142
 BMONTH                       2143-2144
 BYEAR                        2145-2148
 PRMONTH1                     2149-2150
 PRYEAR1                      2151-2154.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 DXCCS31                      (F4.0) /
 DXCCS32                      (F4.0) /
 DXCCS33                      (F4.0) /
 DXCCS34                      (F4.0) /
 DXCCS35                      (F4.0) /
 DXCCS36                      (F4.0) /
 DXCCS37                      (F4.0) /
 DXCCS38                      (F4.0) /
 DXCCS39                      (F4.0) /
 DXCCS40                      (F4.0) /
 DXCCS41                      (F4.0) /
 DXCCS42                      (F4.0) /
 DXCCS43                      (F4.0) /
 DXCCS44                      (F4.0) /
 DXCCS45                      (F4.0) /
 DXCCS46                      (F4.0) /
 DXCCS47                      (F4.0) /
 DXCCS48                      (F4.0) /
 DXCCS49                      (F4.0) /
 DXCCS50                      (F4.0) /
 DXCCS51                      (F4.0) /
 DXCCS52                      (F4.0) /
 DXCCS53                      (F4.0) /
 DXCCS54                      (F4.0) /
 DXCCS55                      (F4.0) /
 DXCCS56                      (F4.0) /
 DXCCS57                      (F4.0) /
 DXCCS58                      (F4.0) /
 DXCCS59                      (F4.0) /
 DXCCS60                      (F4.0) /
 DXCCS61                      (F4.0) /
 DXCCS62                      (F4.0) /
 DXCCS63                      (F4.0) /
 DXCCS64                      (F4.0) /
 DXCCS65                      (F4.0) /
 DXCCS66                      (F4.0) /
 DXCCS67                      (F4.0) /
 DXVER                        (F3.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 E_CCS9                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRCCS26                      (F3.0) /
 PRCCS27                      (F3.0) /
 PRCCS28                      (F3.0) /
 PRCCS29                      (F3.0) /
 PRCCS30                      (F3.0) /
 PRCCS31                      (F3.0) /
 PRCCS32                      (F3.0) /
 PRCCS33                      (F3.0) /
 PRCCS34                      (F3.0) /
 PRCCS35                      (F3.0) /
 PRCCS36                      (F3.0) /
 PRCCS37                      (F3.0) /
 PRCCS38                      (F3.0) /
 PRCCS39                      (F3.0) /
 PRCCS40                      (F3.0) /
 PRCCS41                      (F3.0) /
 PRCCS42                      (F3.0) /
 PRCCS43                      (F3.0) /
 PRCCS44                      (F3.0) /
 PRCCS45                      (F3.0) /
 PRCCS46                      (F3.0) /
 PRCCS47                      (F3.0) /
 PRCCS48                      (F3.0) /
 PRCCS49                      (F3.0) /
 PRCCS50                      (F3.0) /
 PRDAY1                       (F4.0) /
 PROCTYPE                     (F3.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 SERVICELINE                  (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRYEAR1                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DX_Admitting                 "Admitting Diagnosis Code"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DX31                         "Diagnosis 31"
 DX32                         "Diagnosis 32"
 DX33                         "Diagnosis 33"
 DX34                         "Diagnosis 34"
 DX35                         "Diagnosis 35"
 DX36                         "Diagnosis 36"
 DX37                         "Diagnosis 37"
 DX38                         "Diagnosis 38"
 DX39                         "Diagnosis 39"
 DX40                         "Diagnosis 40"
 DX41                         "Diagnosis 41"
 DX42                         "Diagnosis 42"
 DX43                         "Diagnosis 43"
 DX44                         "Diagnosis 44"
 DX45                         "Diagnosis 45"
 DX46                         "Diagnosis 46"
 DX47                         "Diagnosis 47"
 DX48                         "Diagnosis 48"
 DX49                         "Diagnosis 49"
 DX50                         "Diagnosis 50"
 DX51                         "Diagnosis 51"
 DX52                         "Diagnosis 52"
 DX53                         "Diagnosis 53"
 DX54                         "Diagnosis 54"
 DX55                         "Diagnosis 55"
 DX56                         "Diagnosis 56"
 DX57                         "Diagnosis 57"
 DX58                         "Diagnosis 58"
 DX59                         "Diagnosis 59"
 DX60                         "Diagnosis 60"
 DX61                         "Diagnosis 61"
 DX62                         "Diagnosis 62"
 DX63                         "Diagnosis 63"
 DX64                         "Diagnosis 64"
 DX65                         "Diagnosis 65"
 DX66                         "Diagnosis 66"
 DX67                         "Diagnosis 67"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXCCS31                      "CCS: diagnosis 31"
 DXCCS32                      "CCS: diagnosis 32"
 DXCCS33                      "CCS: diagnosis 33"
 DXCCS34                      "CCS: diagnosis 34"
 DXCCS35                      "CCS: diagnosis 35"
 DXCCS36                      "CCS: diagnosis 36"
 DXCCS37                      "CCS: diagnosis 37"
 DXCCS38                      "CCS: diagnosis 38"
 DXCCS39                      "CCS: diagnosis 39"
 DXCCS40                      "CCS: diagnosis 40"
 DXCCS41                      "CCS: diagnosis 41"
 DXCCS42                      "CCS: diagnosis 42"
 DXCCS43                      "CCS: diagnosis 43"
 DXCCS44                      "CCS: diagnosis 44"
 DXCCS45                      "CCS: diagnosis 45"
 DXCCS46                      "CCS: diagnosis 46"
 DXCCS47                      "CCS: diagnosis 47"
 DXCCS48                      "CCS: diagnosis 48"
 DXCCS49                      "CCS: diagnosis 49"
 DXCCS50                      "CCS: diagnosis 50"
 DXCCS51                      "CCS: diagnosis 51"
 DXCCS52                      "CCS: diagnosis 52"
 DXCCS53                      "CCS: diagnosis 53"
 DXCCS54                      "CCS: diagnosis 54"
 DXCCS55                      "CCS: diagnosis 55"
 DXCCS56                      "CCS: diagnosis 56"
 DXCCS57                      "CCS: diagnosis 57"
 DXCCS58                      "CCS: diagnosis 58"
 DXCCS59                      "CCS: diagnosis 59"
 DXCCS60                      "CCS: diagnosis 60"
 DXCCS61                      "CCS: diagnosis 61"
 DXCCS62                      "CCS: diagnosis 62"
 DXCCS63                      "CCS: diagnosis 63"
 DXCCS64                      "CCS: diagnosis 64"
 DXCCS65                      "CCS: diagnosis 65"
 DXCCS66                      "CCS: diagnosis 66"
 DXCCS67                      "CCS: diagnosis 67"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_CCS9                       "CCS: E Code 9"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 E_POA9                       "E Code 9, present on admission indicator"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 ECODE9                       "E code 9"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSP_NPI                     "Hospital NPI"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2
"Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1
"Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2
"Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value
"Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PR26                         "Procedure 26"
 PR27                         "Procedure 27"
 PR28                         "Procedure 28"
 PR29                         "Procedure 29"
 PR30                         "Procedure 30"
 PR31                         "Procedure 31"
 PR32                         "Procedure 32"
 PR33                         "Procedure 33"
 PR34                         "Procedure 34"
 PR35                         "Procedure 35"
 PR36                         "Procedure 36"
 PR37                         "Procedure 37"
 PR38                         "Procedure 38"
 PR39                         "Procedure 39"
 PR40                         "Procedure 40"
 PR41                         "Procedure 41"
 PR42                         "Procedure 42"
 PR43                         "Procedure 43"
 PR44                         "Procedure 44"
 PR45                         "Procedure 45"
 PR46                         "Procedure 46"
 PR47                         "Procedure 47"
 PR48                         "Procedure 48"
 PR49                         "Procedure 49"
 PR50                         "Procedure 50"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRCCS26                      "CCS: procedure 26"
 PRCCS27                      "CCS: procedure 27"
 PRCCS28                      "CCS: procedure 28"
 PRCCS29                      "CCS: procedure 29"
 PRCCS30                      "CCS: procedure 30"
 PRCCS31                      "CCS: procedure 31"
 PRCCS32                      "CCS: procedure 32"
 PRCCS33                      "CCS: procedure 33"
 PRCCS34                      "CCS: procedure 34"
 PRCCS35                      "CCS: procedure 35"
 PRCCS36                      "CCS: procedure 36"
 PRCCS37                      "CCS: procedure 37"
 PRCCS38                      "CCS: procedure 38"
 PRCCS39                      "CCS: procedure 39"
 PRCCS40                      "CCS: procedure 40"
 PRCCS41                      "CCS: procedure 41"
 PRCCS42                      "CCS: procedure 42"
 PRCCS43                      "CCS: procedure 43"
 PRCCS44                      "CCS: procedure 44"
 PRCCS45                      "CCS: procedure 45"
 PRCCS46                      "CCS: procedure 46"
 PRCCS47                      "CCS: procedure 47"
 PRCCS48                      "CCS: procedure 48"
 PRCCS49                      "CCS: procedure 49"
 PRCCS50                      "CCS: procedure 50"
 PRDAY1                       "Number of days from admission to PR1"
 PROCTYPE                     "Procedure type indicator"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 SERVICELINE                  "Hospital Service Line"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRYEAR1                      "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS62
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS63
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS64
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS65
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS66
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS67
 (-999,-888,-666,-555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SID_2015q1q3_CORE.SAV' /COMPRESSED.
