/*******************************************************************
* Creation Date: 02/13/2015   
*   WV_SID_2013_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'WV_SID_2013_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 ATYPE                          10-  11
 AWEEKEND                       12-  13
 BILLTYPE                       14-  17 (A)
 DIED                           18-  19
 DISPUB04                       20-  21
 DISPUNIFORM                    22-  23
 DISP_X                         24-  25 (A)
 DQTR                           26-  27
 DRG                            28-  30
 DRG24                          31-  33
 DRGVER                         34-  35
 DRG_NoPOA                      36-  38
 DSHOSPID                       39-  55 (A)
 DX1                            56-  60 (A)
 DX2                            61-  65 (A)
 DX3                            66-  70 (A)
 DX4                            71-  75 (A)
 DX5                            76-  80 (A)
 DX6                            81-  85 (A)
 DX7                            86-  90 (A)
 DX8                            91-  95 (A)
 DX9                            96- 100 (A)
 DX10                          101- 105 (A)
 DX11                          106- 110 (A)
 DX12                          111- 115 (A)
 DX13                          116- 120 (A)
 DX14                          121- 125 (A)
 DX15                          126- 130 (A)
 DX16                          131- 135 (A)
 DX17                          136- 140 (A)
 DX18                          141- 145 (A)
 DXCCS1                        146- 149
 DXCCS2                        150- 153
 DXCCS3                        154- 157
 DXCCS4                        158- 161
 DXCCS5                        162- 165
 DXCCS6                        166- 169
 DXCCS7                        170- 173
 DXCCS8                        174- 177
 DXCCS9                        178- 181
 DXCCS10                       182- 185
 DXCCS11                       186- 189
 DXCCS12                       190- 193
 DXCCS13                       194- 197
 DXCCS14                       198- 201
 DXCCS15                       202- 205
 DXCCS16                       206- 209
 DXCCS17                       210- 213
 DXCCS18                       214- 217
 DXPOA1                        218     (A)
 DXPOA2                        219     (A)
 DXPOA3                        220     (A)
 DXPOA4                        221     (A)
 DXPOA5                        222     (A)
 DXPOA6                        223     (A)
 DXPOA7                        224     (A)
 DXPOA8                        225     (A)
 DXPOA9                        226     (A)
 DXPOA10                       227     (A)
 DXPOA11                       228     (A)
 DXPOA12                       229     (A)
 DXPOA13                       230     (A)
 DXPOA14                       231     (A)
 DXPOA15                       232     (A)
 DXPOA16                       233     (A)
 DXPOA17                       234     (A)
 DXPOA18                       235     (A)
 DX_Admitting                  236- 240 (A)
 ECODE1                        241- 245 (A)
 ECODE2                        246- 250 (A)
 ECODE3                        251- 255 (A)
 ECODE4                        256- 260 (A)
 ECODE5                        261- 265 (A)
 ECODE6                        266- 270 (A)
 ECODE7                        271- 275 (A)
 ECODE8                        276- 280 (A)
 E_CCS1                        281- 284
 E_CCS2                        285- 288
 E_CCS3                        289- 292
 E_CCS4                        293- 296
 E_CCS5                        297- 300
 E_CCS6                        301- 304
 E_CCS7                        305- 308
 E_CCS8                        309- 312
 E_POA1                        313     (A)
 E_POA2                        314     (A)
 E_POA3                        315     (A)
 E_POA4                        316     (A)
 E_POA5                        317     (A)
 E_POA6                        318     (A)
 E_POA7                        319     (A)
 E_POA8                        320     (A)
 FEMALE                        321- 322
 HCUP_ED                       323- 324
 HCUP_OS                       325- 326
 HOSPBRTH                      327- 329
 HOSPST                        330- 331 (A)
 KEY                           332- 346
 LOS                           347- 351
 LOS_X                         352- 357
 MDC                           358- 359
 MDC24                         360- 361
 MDC_NoPOA                     362- 363
 MEDINCSTQ                     364- 365
 NCHRONIC                      366- 368
 NDX                           369- 371
 NECODE                        372- 373
 NEOMAT                        374- 375
 NPR                           376- 378
 ORPROC                        379- 380
 OS_TIME                       381- 388
 P7EDSRC_X                     389- 390 (A)
 PAY1                          391- 392
 PAY2                          393- 394
 PAY3                          395- 396
 PL_CBSA                       397- 399
 PL_NCHS                       400- 401
 PL_RUCA10_2005                402- 403
 PL_RUCA4_2005                 404- 405
 PL_UR_CAT4                    406- 407
 PR1                           408- 411 (A)
 PR2                           412- 415 (A)
 PR3                           416- 419 (A)
 PR4                           420- 423 (A)
 PR5                           424- 427 (A)
 PR6                           428- 431 (A)
 PRCCS1                        432- 434
 PRCCS2                        435- 437
 PRCCS3                        438- 440
 PRCCS4                        441- 443
 PRCCS5                        444- 446
 PRCCS6                        447- 449
 PROCTYPE                      450- 452
 PSTATE                        453- 454 (A)
 PointOfOriginUB04             455     (A)
 PointOfOrigin_X               456     (A)
 TOTCHG                        457- 466
 TOTCHG_X                      467- 481
 TRAN_IN                       482- 483
 TRAN_OUT                      484- 485
 YEAR                          486- 489
 ZIPINC_QRTL                   490- 492
 AYEAR                         493- 496.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG24                        (F3.0) /
 DRGVER                       (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC24                        (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MEDINCSTQ                    (F3.0) /
 NCHRONIC                     (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 OS_TIME                      (F4.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA4_2005                (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PROCTYPE                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG24                        "DRG, version 24"
 DRGVER                       "DRG grouper version used on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DSHOSPID                     "Data source hospital identifier"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DX_Admitting                 "Admitting Diagnosis Code"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC24                        "MDC, version 24"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCHRONIC                     "Number of chronic conditions"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X
"Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY3                         "Tertiary expected payer (uniform)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WV_SID_2013_CORE.SAV' /COMPRESSED.
