/*******************************************************************
* Creation Date: 01/15/2025   
*   MD_SID_2023_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SID CORE FILE INTO SPSS                                    
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'MD_SID_2023_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 ATYPE                          10-  11
 AWEEKEND                       12-  13
 BWT                            14-  17
 DaysBurnUnit                   18-  20
 DaysCCU                        21-  23
 DaysICU                        24-  26
 DaysNICU                       27-  29
 DaysPICU                       30-  32
 DaysShockUnit                  33-  35
 DaysToEvent                    36-  41
 DIED                           42-  43
 DISP_X                         44-  45 (A)
 DISPUB04                       46-  47
 DISPUNIFORM                    48-  49
 DQTR                           50-  51
 DRG                            52-  54
 DRG_NoPOA                      55-  57
 DRGVER                         58-  59
 DSHOSPID                       60-  76 (A)
 DXPOA1                         77     (A)
 DXPOA2                         78     (A)
 DXPOA3                         79     (A)
 DXPOA4                         80     (A)
 DXPOA5                         81     (A)
 DXPOA6                         82     (A)
 DXPOA7                         83     (A)
 DXPOA8                         84     (A)
 DXPOA9                         85     (A)
 DXPOA10                        86     (A)
 DXPOA11                        87     (A)
 DXPOA12                        88     (A)
 DXPOA13                        89     (A)
 DXPOA14                        90     (A)
 DXPOA15                        91     (A)
 DXPOA16                        92     (A)
 DXPOA17                        93     (A)
 DXPOA18                        94     (A)
 DXPOA19                        95     (A)
 DXPOA20                        96     (A)
 DXPOA21                        97     (A)
 DXPOA22                        98     (A)
 DXPOA23                        99     (A)
 DXPOA24                       100     (A)
 DXPOA25                       101     (A)
 DXPOA26                       102     (A)
 DXPOA27                       103     (A)
 DXPOA28                       104     (A)
 DXPOA29                       105     (A)
 DXPOA30                       106     (A)
 DXPOA31                       107     (A)
 DXPOA32                       108     (A)
 DXPOA33                       109     (A)
 DXPOA34                       110     (A)
 DXPOA35                       111     (A)
 DXPOA36                       112     (A)
 DXPOA37                       113     (A)
 DXPOA38                       114     (A)
 DXPOA39                       115     (A)
 DXPOA40                       116     (A)
 DXPOA41                       117     (A)
 DXPOA42                       118     (A)
 DXPOA43                       119     (A)
 DXPOA44                       120     (A)
 DXPOA45                       121     (A)
 DXPOA46                       122     (A)
 DXPOA47                       123     (A)
 DXPOA48                       124     (A)
 DXPOA49                       125     (A)
 DXPOA50                       126     (A)
 DXPOA51                       127     (A)
 DXPOA52                       128     (A)
 DXPOA53                       129     (A)
 DXPOA54                       130     (A)
 DXPOA55                       131     (A)
 DXPOA56                       132     (A)
 DXPOA57                       133     (A)
 DXPOA58                       134     (A)
 DXPOA59                       135     (A)
 DXPOA60                       136     (A)
 DXPOA61                       137     (A)
 DXPOA62                       138     (A)
 DXPOA63                       139     (A)
 DXPOA64                       140     (A)
 DXPOA65                       141     (A)
 DXPOA66                       142     (A)
 DXPOA67                       143     (A)
 DXPOA68                       144     (A)
 DXPOA69                       145     (A)
 DXPOA70                       146     (A)
 DXPOA71                       147     (A)
 DXPOA72                       148     (A)
 DXPOA73                       149     (A)
 DXPOA74                       150     (A)
 DXPOA75                       151     (A)
 DXPOA76                       152     (A)
 DXPOA77                       153     (A)
 DXPOA78                       154     (A)
 DXPOA79                       155     (A)
 DXPOA80                       156     (A)
 DXPOA81                       157     (A)
 DXPOA82                       158     (A)
 DXPOA83                       159     (A)
 DXPOA84                       160     (A)
 DXPOA85                       161     (A)
 DXPOA86                       162     (A)
 DXPOA87                       163     (A)
 DXPOA88                       164     (A)
 DXPOA89                       165     (A)
 DXPOA90                       166     (A)
 DXPOA91                       167     (A)
 DXPOA92                       168     (A)
 DXPOA93                       169     (A)
 DXPOA94                       170     (A)
 DXPOA95                       171     (A)
 DXPOA96                       172     (A)
 DXPOA97                       173     (A)
 DXPOA98                       174     (A)
 DXPOA99                       175     (A)
 DXPOA100                      176     (A)
 FEMALE                        177- 178
 HCUP_ED                       179- 180
 HCUP_OS                       181- 182
 HISPANIC                      183- 184
 HISPANIC_X                    185     (A)
 Homeless                      186- 187
 HospitalUnit                  188- 189
 HOSPST                        190- 191 (A)
 I10_BIRTH                     192- 194
 I10_DELIVERY                  195- 197
 I10_DX1                       198- 204 (A)
 I10_DX2                       205- 211 (A)
 I10_DX3                       212- 218 (A)
 I10_DX4                       219- 225 (A)
 I10_DX5                       226- 232 (A)
 I10_DX6                       233- 239 (A)
 I10_DX7                       240- 246 (A)
 I10_DX8                       247- 253 (A)
 I10_DX9                       254- 260 (A)
 I10_DX10                      261- 267 (A)
 I10_DX11                      268- 274 (A)
 I10_DX12                      275- 281 (A)
 I10_DX13                      282- 288 (A)
 I10_DX14                      289- 295 (A)
 I10_DX15                      296- 302 (A)
 I10_DX16                      303- 309 (A)
 I10_DX17                      310- 316 (A)
 I10_DX18                      317- 323 (A)
 I10_DX19                      324- 330 (A)
 I10_DX20                      331- 337 (A)
 I10_DX21                      338- 344 (A)
 I10_DX22                      345- 351 (A)
 I10_DX23                      352- 358 (A)
 I10_DX24                      359- 365 (A)
 I10_DX25                      366- 372 (A)
 I10_DX26                      373- 379 (A)
 I10_DX27                      380- 386 (A)
 I10_DX28                      387- 393 (A)
 I10_DX29                      394- 400 (A)
 I10_DX30                      401- 407 (A)
 I10_DX31                      408- 414 (A)
 I10_DX32                      415- 421 (A)
 I10_DX33                      422- 428 (A)
 I10_DX34                      429- 435 (A)
 I10_DX35                      436- 442 (A)
 I10_DX36                      443- 449 (A)
 I10_DX37                      450- 456 (A)
 I10_DX38                      457- 463 (A)
 I10_DX39                      464- 470 (A)
 I10_DX40                      471- 477 (A)
 I10_DX41                      478- 484 (A)
 I10_DX42                      485- 491 (A)
 I10_DX43                      492- 498 (A)
 I10_DX44                      499- 505 (A)
 I10_DX45                      506- 512 (A)
 I10_DX46                      513- 519 (A)
 I10_DX47                      520- 526 (A)
 I10_DX48                      527- 533 (A)
 I10_DX49                      534- 540 (A)
 I10_DX50                      541- 547 (A)
 I10_DX51                      548- 554 (A)
 I10_DX52                      555- 561 (A)
 I10_DX53                      562- 568 (A)
 I10_DX54                      569- 575 (A)
 I10_DX55                      576- 582 (A)
 I10_DX56                      583- 589 (A)
 I10_DX57                      590- 596 (A)
 I10_DX58                      597- 603 (A)
 I10_DX59                      604- 610 (A)
 I10_DX60                      611- 617 (A)
 I10_DX61                      618- 624 (A)
 I10_DX62                      625- 631 (A)
 I10_DX63                      632- 638 (A)
 I10_DX64                      639- 645 (A)
 I10_DX65                      646- 652 (A)
 I10_DX66                      653- 659 (A)
 I10_DX67                      660- 666 (A)
 I10_DX68                      667- 673 (A)
 I10_DX69                      674- 680 (A)
 I10_DX70                      681- 687 (A)
 I10_DX71                      688- 694 (A)
 I10_DX72                      695- 701 (A)
 I10_DX73                      702- 708 (A)
 I10_DX74                      709- 715 (A)
 I10_DX75                      716- 722 (A)
 I10_DX76                      723- 729 (A)
 I10_DX77                      730- 736 (A)
 I10_DX78                      737- 743 (A)
 I10_DX79                      744- 750 (A)
 I10_DX80                      751- 757 (A)
 I10_DX81                      758- 764 (A)
 I10_DX82                      765- 771 (A)
 I10_DX83                      772- 778 (A)
 I10_DX84                      779- 785 (A)
 I10_DX85                      786- 792 (A)
 I10_DX86                      793- 799 (A)
 I10_DX87                      800- 806 (A)
 I10_DX88                      807- 813 (A)
 I10_DX89                      814- 820 (A)
 I10_DX90                      821- 827 (A)
 I10_DX91                      828- 834 (A)
 I10_DX92                      835- 841 (A)
 I10_DX93                      842- 848 (A)
 I10_DX94                      849- 855 (A)
 I10_DX95                      856- 862 (A)
 I10_DX96                      863- 869 (A)
 I10_DX97                      870- 876 (A)
 I10_DX98                      877- 883 (A)
 I10_DX99                      884- 890 (A)
 I10_DX100                     891- 897 (A)
 I10_DX101                     898- 904 (A)
 I10_NDX                       905- 907
 I10_NPR                       908- 910
 I10_PR1                       911- 917 (A)
 I10_PR2                       918- 924 (A)
 I10_PR3                       925- 931 (A)
 I10_PR4                       932- 938 (A)
 I10_PR5                       939- 945 (A)
 I10_PR6                       946- 952 (A)
 I10_PR7                       953- 959 (A)
 I10_PR8                       960- 966 (A)
 I10_PR9                       967- 973 (A)
 I10_PR10                      974- 980 (A)
 I10_PR11                      981- 987 (A)
 I10_PR12                      988- 994 (A)
 I10_PR13                      995-1001 (A)
 I10_PR14                     1002-1008 (A)
 I10_PR15                     1009-1015 (A)
 I10_PR16                     1016-1022 (A)
 I10_PR17                     1023-1029 (A)
 I10_PR18                     1030-1036 (A)
 I10_PR19                     1037-1043 (A)
 I10_PR20                     1044-1050 (A)
 I10_PR21                     1051-1057 (A)
 I10_PR22                     1058-1064 (A)
 I10_PR23                     1065-1071 (A)
 I10_PR24                     1072-1078 (A)
 I10_PR25                     1079-1085 (A)
 I10_PR26                     1086-1092 (A)
 I10_PR27                     1093-1099 (A)
 I10_PR28                     1100-1106 (A)
 I10_PR29                     1107-1113 (A)
 I10_PR30                     1114-1120 (A)
 I10_PR31                     1121-1127 (A)
 I10_PR32                     1128-1134 (A)
 I10_PR33                     1135-1141 (A)
 I10_PR34                     1142-1148 (A)
 I10_PR35                     1149-1155 (A)
 I10_PR36                     1156-1162 (A)
 I10_PR37                     1163-1169 (A)
 I10_PR38                     1170-1176 (A)
 I10_PR39                     1177-1183 (A)
 I10_PR40                     1184-1190 (A)
 I10_PR41                     1191-1197 (A)
 I10_PR42                     1198-1204 (A)
 I10_PR43                     1205-1211 (A)
 I10_PR44                     1212-1218 (A)
 I10_PR45                     1219-1225 (A)
 I10_PR46                     1226-1232 (A)
 I10_PR47                     1233-1239 (A)
 I10_PR48                     1240-1246 (A)
 I10_PR49                     1247-1253 (A)
 I10_PR50                     1254-1260 (A)
 I10_PR51                     1261-1267 (A)
 I10_PR52                     1268-1274 (A)
 I10_PR53                     1275-1281 (A)
 I10_PR54                     1282-1288 (A)
 I10_PR55                     1289-1295 (A)
 I10_PR56                     1296-1302 (A)
 I10_PR57                     1303-1309 (A)
 I10_PR58                     1310-1316 (A)
 I10_PR59                     1317-1323 (A)
 I10_PR60                     1324-1330 (A)
 I10_PR61                     1331-1337 (A)
 I10_PR62                     1338-1344 (A)
 I10_PR63                     1345-1351 (A)
 I10_PR64                     1352-1358 (A)
 I10_PR65                     1359-1365 (A)
 I10_PR66                     1366-1372 (A)
 I10_PR67                     1373-1379 (A)
 I10_PR68                     1380-1386 (A)
 I10_PR69                     1387-1393 (A)
 I10_PR70                     1394-1400 (A)
 I10_PR71                     1401-1407 (A)
 I10_PR72                     1408-1414 (A)
 I10_PR73                     1415-1421 (A)
 I10_PR74                     1422-1428 (A)
 I10_PR75                     1429-1435 (A)
 I10_PR76                     1436-1442 (A)
 I10_PR77                     1443-1449 (A)
 I10_PR78                     1450-1456 (A)
 I10_PR79                     1457-1463 (A)
 I10_PR80                     1464-1470 (A)
 I10_PR81                     1471-1477 (A)
 I10_PR82                     1478-1484 (A)
 I10_PR83                     1485-1491 (A)
 I10_PR84                     1492-1498 (A)
 I10_PR85                     1499-1505 (A)
 I10_PR86                     1506-1512 (A)
 I10_PR87                     1513-1519 (A)
 I10_PR88                     1520-1526 (A)
 I10_PR89                     1527-1533 (A)
 I10_PR90                     1534-1540 (A)
 I10_PR91                     1541-1547 (A)
 I10_PR92                     1548-1554 (A)
 I10_PR93                     1555-1561 (A)
 I10_PR94                     1562-1568 (A)
 I10_PR95                     1569-1575 (A)
 I10_PR96                     1576-1582 (A)
 I10_PR97                     1583-1589 (A)
 I10_PR98                     1590-1596 (A)
 I10_PR99                     1597-1603 (A)
 I10_PR100                    1604-1610 (A)
 I10_PROCTYPE                 1611-1613
 I10_SERVICELINE              1614-1615
 KEY                          1616-1630
 LOS                          1631-1635
 LOS_X                        1636-1641
 MARITALSTATUS_X              1642     (A)
 MARITALSTATUSUB04            1643     (A)
 MDC                          1644-1645
 MDC_NoPOA                    1646-1647
 MDNUM1_R                     1648-1656
 MDNUM2_R                     1657-1665
 MEDINCSTQ                    1666-1667
 MRN_R                        1668-1676
 OS_TIME                      1677-1687
 P7EDSRC_X                    1688-1689 (A)
 PAY1                         1690-1691
 PAY1_X                       1692-1693 (A)
 PAY2                         1694-1695
 PAY2_X                       1696-1697 (A)
 PAY3                         1698-1699
 PAY3_X                       1700-1701 (A)
 PAYER1_X                     1702-1704 (A)
 PAYER2_X                     1705-1707 (A)
 PAYER3_X                     1708-1710 (A)
 PCLASS_ORPROC                1711-1712
 PL_CBSA                      1713-1715
 PL_NCHS                      1716-1717
 PL_RUCC                      1718-1719
 PL_UIC                       1720-1721
 PL_UR_CAT4                   1722-1723
 POA_Disch_Edit1              1724-1725
 POA_Disch_Edit2              1726-1727
 POA_Hosp_Edit1               1728-1729
 POA_Hosp_Edit2               1730-1731
 POA_Hosp_Edit3               1732-1733
 POA_Hosp_Edit3_Value         1734-1741
 PointOfOrigin_X              1742-1743 (A)
 PointOfOriginUB04            1744     (A)
 PRDAY1                       1745-1749
 PRDAY2                       1750-1754
 PRDAY3                       1755-1759
 PRDAY4                       1760-1764
 PRDAY5                       1765-1769
 PRDAY6                       1770-1774
 PRDAY7                       1775-1779
 PRDAY8                       1780-1784
 PRDAY9                       1785-1789
 PRDAY10                      1790-1794
 PRDAY11                      1795-1799
 PRDAY12                      1800-1804
 PRDAY13                      1805-1809
 PRDAY14                      1810-1814
 PRDAY15                      1815-1819
 PRDAY16                      1820-1824
 PRDAY17                      1825-1829
 PRDAY18                      1830-1834
 PRDAY19                      1835-1839
 PRDAY20                      1840-1844
 PRDAY21                      1845-1849
 PRDAY22                      1850-1854
 PRDAY23                      1855-1859
 PRDAY24                      1860-1864
 PRDAY25                      1865-1869
 PRDAY26                      1870-1874
 PRDAY27                      1875-1879
 PRDAY28                      1880-1884
 PRDAY29                      1885-1889
 PRDAY30                      1890-1894
 PRDAY31                      1895-1899
 PRDAY32                      1900-1904
 PRDAY33                      1905-1909
 PRDAY34                      1910-1914
 PRDAY35                      1915-1919
 PRDAY36                      1920-1924
 PRDAY37                      1925-1929
 PRDAY38                      1930-1934
 PRDAY39                      1935-1939
 PRDAY40                      1940-1944
 PRDAY41                      1945-1949
 PRDAY42                      1950-1954
 PRDAY43                      1955-1959
 PRDAY44                      1960-1964
 PRDAY45                      1965-1969
 PRDAY46                      1970-1974
 PRDAY47                      1975-1979
 PRDAY48                      1980-1984
 PRDAY49                      1985-1989
 PRDAY50                      1990-1994
 PRDAY51                      1995-1999
 PRDAY52                      2000-2004
 PRDAY53                      2005-2009
 PRDAY54                      2010-2014
 PRDAY55                      2015-2019
 PRDAY56                      2020-2024
 PRDAY57                      2025-2029
 PRDAY58                      2030-2034
 PRDAY59                      2035-2039
 PRDAY60                      2040-2044
 PRDAY61                      2045-2049
 PRDAY62                      2050-2054
 PRDAY63                      2055-2059
 PRDAY64                      2060-2064
 PRDAY65                      2065-2069
 PRDAY66                      2070-2074
 PRDAY67                      2075-2079
 PRDAY68                      2080-2084
 PRDAY69                      2085-2089
 PRDAY70                      2090-2094
 PRDAY71                      2095-2099
 PRDAY72                      2100-2104
 PRDAY73                      2105-2109
 PRDAY74                      2110-2114
 PRDAY75                      2115-2119
 PRDAY76                      2120-2124
 PRDAY77                      2125-2129
 PRDAY78                      2130-2134
 PRDAY79                      2135-2139
 PRDAY80                      2140-2144
 PRDAY81                      2145-2149
 PRDAY82                      2150-2154
 PRDAY83                      2155-2159
 PRDAY84                      2160-2164
 PRDAY85                      2165-2169
 PRDAY86                      2170-2174
 PRDAY87                      2175-2179
 PRDAY88                      2180-2184
 PRDAY89                      2185-2189
 PRDAY90                      2190-2194
 PRDAY91                      2195-2199
 PRDAY92                      2200-2204
 PRDAY93                      2205-2209
 PRDAY94                      2210-2214
 PRDAY95                      2215-2219
 PRDAY96                      2220-2224
 PRDAY97                      2225-2229
 PRDAY98                      2230-2234
 PRDAY99                      2235-2239
 PRDAY100                     2240-2244
 PrimLang                     2245-2247 (A)
 PSTATE                       2248-2249 (A)
 PSTATE_GEO                   2250-2251 (A)
 PSTCO                        2252-2256
 PSTCO_GEO                    2257-2261
 RACE                         2262-2263
 RACE_PCT_MISS_HOSP           2264-2270
 RACE_X                       2271     (A)
 READMIT                      2272-2273
 TOTCHG                       2274-2283
 TOTCHG_X                     2284-2298
 TRAN_IN                      2299-2300
 TRAN_OUT                     2301-2302
 VisitLink                    2303-2311
 YEAR                         2312-2315
 ZIP                          2316-2320 (A)
 ZIP3                         2321-2323 (A)
 ZIPINC_QRTL                  2324-2326
 AYEAR                        2327-2330.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysBurnUnit                 (F3.0) /
 DaysCCU                      (F3.0) /
 DaysICU                      (F3.0) /
 DaysNICU                     (F3.0) /
 DaysPICU                     (F3.0) /
 DaysShockUnit                (F3.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PCLASS_ORPROC                (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRDAY61                      (F4.0) /
 PRDAY62                      (F4.0) /
 PRDAY63                      (F4.0) /
 PRDAY64                      (F4.0) /
 PRDAY65                      (F4.0) /
 PRDAY66                      (F4.0) /
 PRDAY67                      (F4.0) /
 PRDAY68                      (F4.0) /
 PRDAY69                      (F4.0) /
 PRDAY70                      (F4.0) /
 PRDAY71                      (F4.0) /
 PRDAY72                      (F4.0) /
 PRDAY73                      (F4.0) /
 PRDAY74                      (F4.0) /
 PRDAY75                      (F4.0) /
 PRDAY76                      (F4.0) /
 PRDAY77                      (F4.0) /
 PRDAY78                      (F4.0) /
 PRDAY79                      (F4.0) /
 PRDAY80                      (F4.0) /
 PRDAY81                      (F4.0) /
 PRDAY82                      (F4.0) /
 PRDAY83                      (F4.0) /
 PRDAY84                      (F4.0) /
 PRDAY85                      (F4.0) /
 PRDAY86                      (F4.0) /
 PRDAY87                      (F4.0) /
 PRDAY88                      (F4.0) /
 PRDAY89                      (F4.0) /
 PRDAY90                      (F4.0) /
 PRDAY91                      (F4.0) /
 PRDAY92                      (F4.0) /
 PRDAY93                      (F4.0) /
 PRDAY94                      (F4.0) /
 PRDAY95                      (F4.0) /
 PRDAY96                      (F4.0) /
 PRDAY97                      (F4.0) /
 PRDAY98                      (F4.0) /
 PRDAY99                      (F4.0) /
 PRDAY100                     (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 READMIT                      (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysBurnUnit                 "Days in burn care unit (as received from source)"
 DaysCCU                      "Days in coronary care unit (as received from source)"
 DaysICU                      "Days in medical/surgical intensive care unit (as received from source)"
 DaysNICU                     "Days in neonetal care unit (as received from source)"
 DaysPICU                     "Days in pediatric care unit (as received from source)"
 DaysShockUnit                "Days in shock trauma unit (as received from source"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXPOA72                      "Diagnosis 72, present on admission indicator"
 DXPOA73                      "Diagnosis 73, present on admission indicator"
 DXPOA74                      "Diagnosis 74, present on admission indicator"
 DXPOA75                      "Diagnosis 75, present on admission indicator"
 DXPOA76                      "Diagnosis 76, present on admission indicator"
 DXPOA77                      "Diagnosis 77, present on admission indicator"
 DXPOA78                      "Diagnosis 78, present on admission indicator"
 DXPOA79                      "Diagnosis 79, present on admission indicator"
 DXPOA80                      "Diagnosis 80, present on admission indicator"
 DXPOA81                      "Diagnosis 81, present on admission indicator"
 DXPOA82                      "Diagnosis 82, present on admission indicator"
 DXPOA83                      "Diagnosis 83, present on admission indicator"
 DXPOA84                      "Diagnosis 84, present on admission indicator"
 DXPOA85                      "Diagnosis 85, present on admission indicator"
 DXPOA86                      "Diagnosis 86, present on admission indicator"
 DXPOA87                      "Diagnosis 87, present on admission indicator"
 DXPOA88                      "Diagnosis 88, present on admission indicator"
 DXPOA89                      "Diagnosis 89, present on admission indicator"
 DXPOA90                      "Diagnosis 90, present on admission indicator"
 DXPOA91                      "Diagnosis 91, present on admission indicator"
 DXPOA92                      "Diagnosis 92, present on admission indicator"
 DXPOA93                      "Diagnosis 93, present on admission indicator"
 DXPOA94                      "Diagnosis 94, present on admission indicator"
 DXPOA95                      "Diagnosis 95, present on admission indicator"
 DXPOA96                      "Diagnosis 96, present on admission indicator"
 DXPOA97                      "Diagnosis 97, present on admission indicator"
 DXPOA98                      "Diagnosis 98, present on admission indicator"
 DXPOA99                      "Diagnosis 99, present on admission indicator"
 DXPOA100                     "Diagnosis 100, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_DX72                     "ICD-10-CM Diagnosis 72"
 I10_DX73                     "ICD-10-CM Diagnosis 73"
 I10_DX74                     "ICD-10-CM Diagnosis 74"
 I10_DX75                     "ICD-10-CM Diagnosis 75"
 I10_DX76                     "ICD-10-CM Diagnosis 76"
 I10_DX77                     "ICD-10-CM Diagnosis 77"
 I10_DX78                     "ICD-10-CM Diagnosis 78"
 I10_DX79                     "ICD-10-CM Diagnosis 79"
 I10_DX80                     "ICD-10-CM Diagnosis 80"
 I10_DX81                     "ICD-10-CM Diagnosis 81"
 I10_DX82                     "ICD-10-CM Diagnosis 82"
 I10_DX83                     "ICD-10-CM Diagnosis 83"
 I10_DX84                     "ICD-10-CM Diagnosis 84"
 I10_DX85                     "ICD-10-CM Diagnosis 85"
 I10_DX86                     "ICD-10-CM Diagnosis 86"
 I10_DX87                     "ICD-10-CM Diagnosis 87"
 I10_DX88                     "ICD-10-CM Diagnosis 88"
 I10_DX89                     "ICD-10-CM Diagnosis 89"
 I10_DX90                     "ICD-10-CM Diagnosis 90"
 I10_DX91                     "ICD-10-CM Diagnosis 91"
 I10_DX92                     "ICD-10-CM Diagnosis 92"
 I10_DX93                     "ICD-10-CM Diagnosis 93"
 I10_DX94                     "ICD-10-CM Diagnosis 94"
 I10_DX95                     "ICD-10-CM Diagnosis 95"
 I10_DX96                     "ICD-10-CM Diagnosis 96"
 I10_DX97                     "ICD-10-CM Diagnosis 97"
 I10_DX98                     "ICD-10-CM Diagnosis 98"
 I10_DX99                     "ICD-10-CM Diagnosis 99"
 I10_DX100                    "ICD-10-CM Diagnosis 100"
 I10_DX101                    "ICD-10-CM Diagnosis 101"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PR61                     "ICD-10-PCS Procedure 61"
 I10_PR62                     "ICD-10-PCS Procedure 62"
 I10_PR63                     "ICD-10-PCS Procedure 63"
 I10_PR64                     "ICD-10-PCS Procedure 64"
 I10_PR65                     "ICD-10-PCS Procedure 65"
 I10_PR66                     "ICD-10-PCS Procedure 66"
 I10_PR67                     "ICD-10-PCS Procedure 67"
 I10_PR68                     "ICD-10-PCS Procedure 68"
 I10_PR69                     "ICD-10-PCS Procedure 69"
 I10_PR70                     "ICD-10-PCS Procedure 70"
 I10_PR71                     "ICD-10-PCS Procedure 71"
 I10_PR72                     "ICD-10-PCS Procedure 72"
 I10_PR73                     "ICD-10-PCS Procedure 73"
 I10_PR74                     "ICD-10-PCS Procedure 74"
 I10_PR75                     "ICD-10-PCS Procedure 75"
 I10_PR76                     "ICD-10-PCS Procedure 76"
 I10_PR77                     "ICD-10-PCS Procedure 77"
 I10_PR78                     "ICD-10-PCS Procedure 78"
 I10_PR79                     "ICD-10-PCS Procedure 79"
 I10_PR80                     "ICD-10-PCS Procedure 80"
 I10_PR81                     "ICD-10-PCS Procedure 81"
 I10_PR82                     "ICD-10-PCS Procedure 82"
 I10_PR83                     "ICD-10-PCS Procedure 83"
 I10_PR84                     "ICD-10-PCS Procedure 84"
 I10_PR85                     "ICD-10-PCS Procedure 85"
 I10_PR86                     "ICD-10-PCS Procedure 86"
 I10_PR87                     "ICD-10-PCS Procedure 87"
 I10_PR88                     "ICD-10-PCS Procedure 88"
 I10_PR89                     "ICD-10-PCS Procedure 89"
 I10_PR90                     "ICD-10-PCS Procedure 90"
 I10_PR91                     "ICD-10-PCS Procedure 91"
 I10_PR92                     "ICD-10-PCS Procedure 92"
 I10_PR93                     "ICD-10-PCS Procedure 93"
 I10_PR94                     "ICD-10-PCS Procedure 94"
 I10_PR95                     "ICD-10-PCS Procedure 95"
 I10_PR96                     "ICD-10-PCS Procedure 96"
 I10_PR97                     "ICD-10-PCS Procedure 97"
 I10_PR98                     "ICD-10-PCS Procedure 98"
 I10_PR99                     "ICD-10-PCS Procedure 99"
 I10_PR100                    "ICD-10-PCS Procedure 100"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PAYER1_X                     "Primary expected payer plan identifier (as received from source)"
 PAYER2_X                     "Secondary expected payer plan identifier (as received from source)"
 PAYER3_X                     "Tertiary expected payer plan identifier (as received from source)"
 PCLASS_ORPROC                "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PRDAY61                      "Number of days from admission to I10_PR61"
 PRDAY62                      "Number of days from admission to I10_PR62"
 PRDAY63                      "Number of days from admission to I10_PR63"
 PRDAY64                      "Number of days from admission to I10_PR64"
 PRDAY65                      "Number of days from admission to I10_PR65"
 PRDAY66                      "Number of days from admission to I10_PR66"
 PRDAY67                      "Number of days from admission to I10_PR67"
 PRDAY68                      "Number of days from admission to I10_PR68"
 PRDAY69                      "Number of days from admission to I10_PR69"
 PRDAY70                      "Number of days from admission to I10_PR70"
 PRDAY71                      "Number of days from admission to I10_PR71"
 PRDAY72                      "Number of days from admission to I10_PR72"
 PRDAY73                      "Number of days from admission to I10_PR73"
 PRDAY74                      "Number of days from admission to I10_PR74"
 PRDAY75                      "Number of days from admission to I10_PR75"
 PRDAY76                      "Number of days from admission to I10_PR76"
 PRDAY77                      "Number of days from admission to I10_PR77"
 PRDAY78                      "Number of days from admission to I10_PR78"
 PRDAY79                      "Number of days from admission to I10_PR79"
 PRDAY80                      "Number of days from admission to I10_PR80"
 PRDAY81                      "Number of days from admission to I10_PR81"
 PRDAY82                      "Number of days from admission to I10_PR82"
 PRDAY83                      "Number of days from admission to I10_PR83"
 PRDAY84                      "Number of days from admission to I10_PR84"
 PRDAY85                      "Number of days from admission to I10_PR85"
 PRDAY86                      "Number of days from admission to I10_PR86"
 PRDAY87                      "Number of days from admission to I10_PR87"
 PRDAY88                      "Number of days from admission to I10_PR88"
 PRDAY89                      "Number of days from admission to I10_PR89"
 PRDAY90                      "Number of days from admission to I10_PR90"
 PRDAY91                      "Number of days from admission to I10_PR91"
 PRDAY92                      "Number of days from admission to I10_PR92"
 PRDAY93                      "Number of days from admission to I10_PR93"
 PRDAY94                      "Number of days from admission to I10_PR94"
 PRDAY95                      "Number of days from admission to I10_PR95"
 PRDAY96                      "Number of days from admission to I10_PR96"
 PRDAY97                      "Number of days from admission to I10_PR97"
 PRDAY98                      "Number of days from admission to I10_PR98"
 PRDAY99                      "Number of days from admission to I10_PR99"
 PRDAY100                     "Number of days from admission to I10_PR100"
 PrimLang                     "Primary language of patient"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 READMIT                      "Readmission"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBurnUnit
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysNICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysPICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysShockUnit
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_DELIVERY
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY61
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY62
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY63
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY64
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY65
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY66
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY67
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY68
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY69
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY70
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY71
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY72
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY73
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY74
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY75
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY76
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY77
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY78
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY79
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY80
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY81
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY82
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY83
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY84
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY85
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY86
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY87
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY88
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY89
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY90
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY91
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY92
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY93
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY94
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY95
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY96
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY97
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY98
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY99
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY100
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MD_SID_2023_CORE.sav' /COMPRESSED.
