/*******************************************************************
*   ME_SID_2006_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'ME_SID_2006_DX_PR_GRPS.ASC' FIXED / 
 KEY                        1-  14
 CCSMGN1                   15-  17
 CCSMGN2                   18-  20
 CCSMGN3                   21-  23
 CCSMGN4                   24-  26
 CCSMGN5                   27-  29
 CCSMGN6                   30-  32
 CCSMGN7                   33-  35
 CCSMGN8                   36-  38
 CCSMGN9                   39-  41
 CCSMGN10                  42-  44
 CCSMSP1                   45-  48
 CCSMSP2                   49-  52
 CCSMSP3                   53-  56
 CCSMSP4                   57-  60
 CCSMSP5                   61-  64
 CCSMSP6                   65-  68
 CCSMSP7                   69-  72
 CCSMSP8                   73-  76
 CCSMSP9                   77-  80
 CCSMSP10                  81-  84
 CHRON1                    85-  86
 CHRON2                    87-  88
 CHRON3                    89-  90
 CHRON4                    91-  92
 CHRON5                    93-  94
 CHRON6                    95-  96
 CHRON7                    97-  98
 CHRON8                    99- 100
 CHRON9                   101- 102
 CHRON10                  103- 104
 CHRONB1                  105- 106
 CHRONB2                  107- 108
 CHRONB3                  109- 110
 CHRONB4                  111- 112
 CHRONB5                  113- 114
 CHRONB6                  115- 116
 CHRONB7                  117- 118
 CHRONB8                  119- 120
 CHRONB9                  121- 122
 CHRONB10                 123- 124
 ECCSMGN1                 125- 127
 ECCSMGN2                 128- 130
 ECCSMGN3                 131- 133
 ECCSMGN4                 134- 136
 ECCSMGN5                 137- 139
 PCLASS1                  140- 141
 PCLASS2                  142- 143
 PCLASS3                  144- 145
 PCLASS4                  146- 147
 PCLASS5                  148- 149
 PCLASS6                  150- 151
 U_BLOOD                  152- 153
 U_CATH                   154- 155
 U_CCU                    156- 157
 U_CHESTX                 158- 159
 U_CTSCAN                 160- 161
 U_DIALYS                 162- 163
 U_ECHO                   164- 165
 U_ED                     166- 167
 U_EEG                    168- 169
 U_EKG                    170- 171
 U_EPO                    172- 173
 U_ICU                    174- 175
 U_LITHOT                 176- 177
 U_MHSA                   178- 179
 U_MRT                    180- 181
 U_NEWBN2                 182- 183
 U_NEWBN3                 184- 185
 U_NEWBN4                 186- 187
 U_NUCMED                 188- 189
 U_OBSERV                 190- 191
 U_OCCTHE                 192- 193
 U_ORGANA                 194- 195
 U_OTHIMP                 196- 197
 U_PACEMA                 198- 199
 U_PHYTHE                 200- 201
 U_RADTHE                 202- 203
 U_RESPTH                 204- 205
 U_SPEECH                 206- 207
 U_STRESS                 208- 209
 U_ULTRAS                 210- 211.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CCSMGN1                 (F3.0) /
 CCSMGN2                 (F3.0) /
 CCSMGN3                 (F3.0) /
 CCSMGN4                 (F3.0) /
 CCSMGN5                 (F3.0) /
 CCSMGN6                 (F3.0) /
 CCSMGN7                 (F3.0) /
 CCSMGN8                 (F3.0) /
 CCSMGN9                 (F3.0) /
 CCSMGN10                (F3.0) /
 CCSMSP1                 (F3.0) /
 CCSMSP2                 (F3.0) /
 CCSMSP3                 (F3.0) /
 CCSMSP4                 (F3.0) /
 CCSMSP5                 (F3.0) /
 CCSMSP6                 (F3.0) /
 CCSMSP7                 (F3.0) /
 CCSMSP8                 (F3.0) /
 CCSMSP9                 (F3.0) /
 CCSMSP10                (F3.0) /
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 ECCSMGN1                (F3.0) /
 ECCSMGN2                (F3.0) /
 ECCSMGN3                (F3.0) /
 ECCSMGN4                (F3.0) /
 ECCSMGN5                (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTX                (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYS                (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOT                (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2                (F3.0) /
 U_NEWBN3                (F3.0) /
 U_NEWBN4                (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERV                (F3.0) /
 U_OCCTHE                (F3.0) /
 U_ORGANA                (F3.0) /
 U_OTHIMP                (F3.0) /
 U_PACEMA                (F3.0) /
 U_PHYTHE                (F3.0) /
 U_RADTHE                (F3.0) /
 U_RESPTH                (F3.0) /
 U_SPEECH                (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRAS                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CCSMGN1   "CCS-MHSA general category: principal diagnosis"
 CCSMGN2   "CCS-MHSA general category: diagnosis 2"
 CCSMGN3   "CCS-MHSA general category: diagnosis 3"
 CCSMGN4   "CCS-MHSA general category: diagnosis 4"
 CCSMGN5   "CCS-MHSA general category: diagnosis 5"
 CCSMGN6   "CCS-MHSA general category: diagnosis 6"
 CCSMGN7   "CCS-MHSA general category: diagnosis 7"
 CCSMGN8   "CCS-MHSA general category: diagnosis 8"
 CCSMGN9   "CCS-MHSA general category: diagnosis 9"
 CCSMGN10  "CCS-MHSA general category: diagnosis 10"
 CCSMSP1   "CCS-MHSA specific category: principal diagnosis"
 CCSMSP2   "CCS-MHSA specific category: diagnosis 2"
 CCSMSP3   "CCS-MHSA specific category: diagnosis 3"
 CCSMSP4   "CCS-MHSA specific category: diagnosis 4"
 CCSMSP5   "CCS-MHSA specific category: diagnosis 5"
 CCSMSP6   "CCS-MHSA specific category: diagnosis 6"
 CCSMSP7   "CCS-MHSA specific category: diagnosis 7"
 CCSMSP8   "CCS-MHSA specific category: diagnosis 8"
 CCSMSP9   "CCS-MHSA specific category: diagnosis 9"
 CCSMSP10  "CCS-MHSA specific category: diagnosis 10"
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRON10   "Chronic condition indicator 10"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 CHRONB10  "Chronic condition body system 10"
 ECCSMGN1  "CCS-MHSA general category: E Code 1"
 ECCSMGN2  "CCS-MHSA general category: E Code 2"
 ECCSMGN3  "CCS-MHSA general category: E Code 3"
 ECCSMGN4  "CCS-MHSA general category: E Code 4"
 ECCSMGN5  "CCS-MHSA general category: E Code 5"
 PCLASS1   "Principal procedure class"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PCLASS5   "Procedure class 5"
 PCLASS6   "Procedure class 6"
 U_BLOOD   "Utilization Flag: Blood"
 U_CATH    "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU     "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTX  "Utilization Flag: Chest X-Ray"
 U_CTSCAN  "Utilization Flag: Computed Tomography Scan"
 U_DIALYS  "Utilization Flag: Renal Dialysis"
 U_ECHO    "Utilization Flag: Echocardiology"
 U_ED      "Utilization Flag: Emergency Room"
 U_EEG     "Utilization Flag: Electroencephalogram"
 U_EKG     "Utilization Flag: Electrocardiogram"
 U_EPO     "Utilization Flag: EPO"
 U_ICU     "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOT  "Utilization Flag: Lithotripsy"
 U_MHSA    "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT     "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2  "Utilization Flag: Nursery Level II"
 U_NEWBN3  "Utilization Flag: Nursery Level III"
 U_NEWBN4  "Utilization Flag: Nursery Level IV"
 U_NUCMED  "Utilization Flag: Nuclear Medicine"
 U_OBSERV  "Utilization Flag: Observation Room"
 U_OCCTHE  "Utilization Flag: Occupational Therapy"
 U_ORGANA  "Utilization Flag: Organ Acquisition"
 U_OTHIMP  "Utilization Flag: Other Implants"
 U_PACEMA  "Utilization Flag: Pacemaker"
 U_PHYTHE  "Utilization Flag: Physical Therapy"
 U_RADTHE  "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTH  "Utilization Flag: Respiratory Services"
 U_SPEECH  "Utilization Flag: Speech - Language Pathology"
 U_STRESS  "Utilization Flag: Cardiac Stress Test"
 U_ULTRAS  "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CCSMGN1
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN2
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN3
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN4
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN5
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN6
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN7
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN8
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN9
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN10
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMSP1
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP2
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP3
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP4
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP5
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP6
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP7
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP8
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP9
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP10
 (-999,-888,-666,-555=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE ECCSMGN1
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN2
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN3
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN4
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN5
 (-99,-88,-66,-55=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTX
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERV
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMP
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRAS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SID_2006_DX_PR_GRPS.SAV' /COMPRESSED.
