/*******************************************************************
* Creation Date: 10/13/2020   
*   MN_SID_2019_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MN_SID_2019_CORE.ASC' FIXED SKIP=2 / 
 ADRG                            1-   3
 ADRGRISKMORTALITY               4-   5
 ADRGSEV                         6-   7
 AGE                             8-  10
 AGEDAY                         11-  13
 AGEMONTH                       14-  16
 AHOUR                          17-  20
 AMDC                           21-  22
 AMONTH                         23-  24
 ATYPE                          25-  26
 AWEEKEND                       27-  28
 BILLTYPE                       29-  32 (A)
 DHOUR                          33-  36
 DIED                           37-  38
 DISPUB04                       39-  40
 DISPUNIFORM                    41-  42
 DISP_X                         43-  44 (A)
 DMONTH                         45-  46
 DQTR                           47-  48
 DRG                            49-  51
 DRGVER                         52-  53
 DRG_NoPOA                      54-  56
 DXPOA1                         57     (A)
 DXPOA2                         58     (A)
 DXPOA3                         59     (A)
 DXPOA4                         60     (A)
 DXPOA5                         61     (A)
 DXPOA6                         62     (A)
 DXPOA7                         63     (A)
 DXPOA8                         64     (A)
 DXPOA9                         65     (A)
 DXPOA10                        66     (A)
 DXPOA11                        67     (A)
 DXPOA12                        68     (A)
 DXPOA13                        69     (A)
 DXPOA14                        70     (A)
 DXPOA15                        71     (A)
 DXPOA16                        72     (A)
 DXPOA17                        73     (A)
 DXPOA18                        74     (A)
 DXPOA19                        75     (A)
 DXPOA20                        76     (A)
 DXPOA21                        77     (A)
 DXPOA22                        78     (A)
 DXPOA23                        79     (A)
 DXPOA24                        80     (A)
 DXPOA25                        81     (A)
 DXPOA26                        82     (A)
 DXPOA27                        83     (A)
 DXPOA28                        84     (A)
 DXPOA29                        85     (A)
 DXPOA30                        86     (A)
 DXPOA31                        87     (A)
 DXPOA32                        88     (A)
 DXPOA33                        89     (A)
 DXPOA34                        90     (A)
 DXPOA35                        91     (A)
 DXPOA36                        92     (A)
 DXPOA37                        93     (A)
 DXPOA38                        94     (A)
 DXPOA39                        95     (A)
 DXPOA40                        96     (A)
 DXPOA41                        97     (A)
 DXPOA42                        98     (A)
 DXPOA43                        99     (A)
 DXPOA44                       100     (A)
 DXPOA45                       101     (A)
 DXPOA46                       102     (A)
 DXPOA47                       103     (A)
 DXPOA48                       104     (A)
 DXPOA49                       105     (A)
 DXPOA50                       106     (A)
 DXPOA51                       107     (A)
 DXPOA52                       108     (A)
 DXPOA53                       109     (A)
 DXPOA54                       110     (A)
 DXPOA55                       111     (A)
 DXPOA56                       112     (A)
 DXPOA57                       113     (A)
 DXPOA58                       114     (A)
 DXPOA59                       115     (A)
 DXPOA60                       116     (A)
 DXPOA61                       117     (A)
 DXPOA62                       118     (A)
 DXPOA63                       119     (A)
 DXPOA64                       120     (A)
 DXPOA65                       121     (A)
 DXPOA66                       122     (A)
 DXPOA67                       123     (A)
 DXPOA68                       124     (A)
 DXPOA69                       125     (A)
 DXPOA70                       126     (A)
 DXPOA71                       127     (A)
 DXPOA72                       128     (A)
 DXPOA73                       129     (A)
 DXPOA74                       130     (A)
 DXPOA75                       131     (A)
 DXPOA76                       132     (A)
 DXPOA77                       133     (A)
 DXPOA78                       134     (A)
 DXPOA79                       135     (A)
 DXPOA80                       136     (A)
 DXPOA81                       137     (A)
 DXPOA82                       138     (A)
 DXPOA83                       139     (A)
 DXPOA84                       140     (A)
 DXPOA85                       141     (A)
 DXPOA86                       142     (A)
 FEMALE                        143- 144
 HCUP_ED                       145- 146
 HCUP_OS                       147- 148
 HISPANIC                      149- 150
 HISPANIC_X                    151- 152 (A)
 HOSPST                        153- 154 (A)
 I10_BIRTH                     155- 156
 I10_DELIVERY                  157- 158
 I10_DX1                       159- 165 (A)
 I10_DX2                       166- 172 (A)
 I10_DX3                       173- 179 (A)
 I10_DX4                       180- 186 (A)
 I10_DX5                       187- 193 (A)
 I10_DX6                       194- 200 (A)
 I10_DX7                       201- 207 (A)
 I10_DX8                       208- 214 (A)
 I10_DX9                       215- 221 (A)
 I10_DX10                      222- 228 (A)
 I10_DX11                      229- 235 (A)
 I10_DX12                      236- 242 (A)
 I10_DX13                      243- 249 (A)
 I10_DX14                      250- 256 (A)
 I10_DX15                      257- 263 (A)
 I10_DX16                      264- 270 (A)
 I10_DX17                      271- 277 (A)
 I10_DX18                      278- 284 (A)
 I10_DX19                      285- 291 (A)
 I10_DX20                      292- 298 (A)
 I10_DX21                      299- 305 (A)
 I10_DX22                      306- 312 (A)
 I10_DX23                      313- 319 (A)
 I10_DX24                      320- 326 (A)
 I10_DX25                      327- 333 (A)
 I10_DX26                      334- 340 (A)
 I10_DX27                      341- 347 (A)
 I10_DX28                      348- 354 (A)
 I10_DX29                      355- 361 (A)
 I10_DX30                      362- 368 (A)
 I10_DX31                      369- 375 (A)
 I10_DX32                      376- 382 (A)
 I10_DX33                      383- 389 (A)
 I10_DX34                      390- 396 (A)
 I10_DX35                      397- 403 (A)
 I10_DX36                      404- 410 (A)
 I10_DX37                      411- 417 (A)
 I10_DX38                      418- 424 (A)
 I10_DX39                      425- 431 (A)
 I10_DX40                      432- 438 (A)
 I10_DX41                      439- 445 (A)
 I10_DX42                      446- 452 (A)
 I10_DX43                      453- 459 (A)
 I10_DX44                      460- 466 (A)
 I10_DX45                      467- 473 (A)
 I10_DX46                      474- 480 (A)
 I10_DX47                      481- 487 (A)
 I10_DX48                      488- 494 (A)
 I10_DX49                      495- 501 (A)
 I10_DX50                      502- 508 (A)
 I10_DX51                      509- 515 (A)
 I10_DX52                      516- 522 (A)
 I10_DX53                      523- 529 (A)
 I10_DX54                      530- 536 (A)
 I10_DX55                      537- 543 (A)
 I10_DX56                      544- 550 (A)
 I10_DX57                      551- 557 (A)
 I10_DX58                      558- 564 (A)
 I10_DX59                      565- 571 (A)
 I10_DX60                      572- 578 (A)
 I10_DX61                      579- 585 (A)
 I10_DX62                      586- 592 (A)
 I10_DX63                      593- 599 (A)
 I10_DX64                      600- 606 (A)
 I10_DX65                      607- 613 (A)
 I10_DX66                      614- 620 (A)
 I10_DX67                      621- 627 (A)
 I10_DX68                      628- 634 (A)
 I10_DX69                      635- 641 (A)
 I10_DX70                      642- 648 (A)
 I10_DX71                      649- 655 (A)
 I10_DX72                      656- 662 (A)
 I10_DX73                      663- 669 (A)
 I10_DX74                      670- 676 (A)
 I10_DX75                      677- 683 (A)
 I10_DX76                      684- 690 (A)
 I10_DX77                      691- 697 (A)
 I10_DX78                      698- 704 (A)
 I10_DX79                      705- 711 (A)
 I10_DX80                      712- 718 (A)
 I10_DX81                      719- 725 (A)
 I10_DX82                      726- 732 (A)
 I10_DX83                      733- 739 (A)
 I10_DX84                      740- 746 (A)
 I10_DX85                      747- 753 (A)
 I10_DX86                      754- 760 (A)
 I10_DX_Admitting              761- 767 (A)
 I10_NDX                       768- 770
 I10_NPR                       771- 773
 I10_ORPROC                    774- 775
 I10_PR1                       776- 782 (A)
 I10_PR2                       783- 789 (A)
 I10_PR3                       790- 796 (A)
 I10_PR4                       797- 803 (A)
 I10_PR5                       804- 810 (A)
 I10_PR6                       811- 817 (A)
 I10_PR7                       818- 824 (A)
 I10_PR8                       825- 831 (A)
 I10_PR9                       832- 838 (A)
 I10_PR10                      839- 845 (A)
 I10_PR11                      846- 852 (A)
 I10_PR12                      853- 859 (A)
 I10_PR13                      860- 866 (A)
 I10_PR14                      867- 873 (A)
 I10_PR15                      874- 880 (A)
 I10_PR16                      881- 887 (A)
 I10_PR17                      888- 894 (A)
 I10_PR18                      895- 901 (A)
 I10_PR19                      902- 908 (A)
 I10_PR20                      909- 915 (A)
 I10_PR21                      916- 922 (A)
 I10_PR22                      923- 929 (A)
 I10_PR23                      930- 936 (A)
 I10_PR24                      937- 943 (A)
 I10_PR25                      944- 950 (A)
 I10_PR26                      951- 957 (A)
 I10_PR27                      958- 964 (A)
 I10_PR28                      965- 971 (A)
 I10_PR29                      972- 978 (A)
 I10_PR30                      979- 985 (A)
 I10_PR31                      986- 992 (A)
 I10_PR32                      993- 999 (A)
 I10_PR33                     1000-1006 (A)
 I10_PR34                     1007-1013 (A)
 I10_PR35                     1014-1020 (A)
 I10_PR36                     1021-1027 (A)
 I10_PR37                     1028-1034 (A)
 I10_PR38                     1035-1041 (A)
 I10_PR39                     1042-1048 (A)
 I10_PR40                     1049-1055 (A)
 I10_PR41                     1056-1062 (A)
 I10_PR42                     1063-1069 (A)
 I10_PR43                     1070-1076 (A)
 I10_PR44                     1077-1083 (A)
 I10_PR45                     1084-1090 (A)
 I10_PR46                     1091-1097 (A)
 I10_PR47                     1098-1104 (A)
 I10_PR48                     1105-1111 (A)
 I10_PR49                     1112-1118 (A)
 I10_PR50                     1119-1125 (A)
 I10_PR51                     1126-1132 (A)
 I10_PR52                     1133-1139 (A)
 I10_PR53                     1140-1146 (A)
 I10_PR54                     1147-1153 (A)
 I10_PR55                     1154-1160 (A)
 I10_PR56                     1161-1167 (A)
 I10_PR57                     1168-1174 (A)
 I10_PR58                     1175-1181 (A)
 I10_PR59                     1182-1188 (A)
 I10_PR60                     1189-1195 (A)
 I10_PR61                     1196-1202 (A)
 I10_PR62                     1203-1209 (A)
 I10_PR63                     1210-1216 (A)
 I10_PR64                     1217-1223 (A)
 I10_PR65                     1224-1230 (A)
 I10_PR66                     1231-1237 (A)
 I10_PR67                     1238-1244 (A)
 I10_PR68                     1245-1251 (A)
 I10_PR69                     1252-1258 (A)
 I10_PR70                     1259-1265 (A)
 I10_PR71                     1266-1272 (A)
 I10_PR72                     1273-1279 (A)
 I10_PR73                     1280-1286 (A)
 I10_PR74                     1287-1293 (A)
 I10_PR75                     1294-1300 (A)
 I10_PR76                     1301-1307 (A)
 I10_PR77                     1308-1314 (A)
 I10_PR78                     1315-1321 (A)
 I10_PR79                     1322-1328 (A)
 I10_PR80                     1329-1335 (A)
 I10_PROCTYPE                 1336-1338
 I10_SERVICELINE              1339-1340
 KEY                          1341-1355
 LOS                          1356-1360
 LOS_X                        1361-1366
 MDC                          1367-1368
 MDC_NoPOA                    1369-1370
 MEDINCSTQ                    1371-1372
 MRN_R                        1373-1381
 OS_TIME                      1382-1392
 PAY1                         1393-1394
 PAY1_X                       1395-1401 (A)
 PAY2                         1402-1403
 PAY2_X                       1404-1410 (A)
 PAY3                         1411-1412
 PAY3_X                       1413-1419 (A)
 PL_CBSA                      1420-1422
 PL_NCHS                      1423-1424
 PL_RUCC                      1425-1426
 PL_UIC                       1427-1428
 PL_UR_CAT4                   1429-1430
 POA_Disch_Edit1              1431-1432
 POA_Disch_Edit2              1433-1434
 POA_Hosp_Edit1               1435-1436
 POA_Hosp_Edit2               1437-1438
 POA_Hosp_Edit3               1439-1440
 POA_Hosp_Edit3_Value         1441-1448
 PRDAY1                       1449-1453
 PRDAY2                       1454-1458
 PRDAY3                       1459-1463
 PRDAY4                       1464-1468
 PRDAY5                       1469-1473
 PRDAY6                       1474-1478
 PRDAY7                       1479-1483
 PRDAY8                       1484-1488
 PRDAY9                       1489-1493
 PRDAY10                      1494-1498
 PRDAY11                      1499-1503
 PRDAY12                      1504-1508
 PRDAY13                      1509-1513
 PRDAY14                      1514-1518
 PRDAY15                      1519-1523
 PRDAY16                      1524-1528
 PRDAY17                      1529-1533
 PRDAY18                      1534-1538
 PRDAY19                      1539-1543
 PRDAY20                      1544-1548
 PRDAY21                      1549-1553
 PRDAY22                      1554-1558
 PRDAY23                      1559-1563
 PRDAY24                      1564-1568
 PRDAY25                      1569-1573
 PRDAY26                      1574-1578
 PRDAY27                      1579-1583
 PRDAY28                      1584-1588
 PRDAY29                      1589-1593
 PRDAY30                      1594-1598
 PRDAY31                      1599-1603
 PRDAY32                      1604-1608
 PRDAY33                      1609-1613
 PRDAY34                      1614-1618
 PRDAY35                      1619-1623
 PRDAY36                      1624-1628
 PRDAY37                      1629-1633
 PRDAY38                      1634-1638
 PRDAY39                      1639-1643
 PRDAY40                      1644-1648
 PRDAY41                      1649-1653
 PRDAY42                      1654-1658
 PRDAY43                      1659-1663
 PRDAY44                      1664-1668
 PRDAY45                      1669-1673
 PRDAY46                      1674-1678
 PRDAY47                      1679-1683
 PRDAY48                      1684-1688
 PRDAY49                      1689-1693
 PRDAY50                      1694-1698
 PRDAY51                      1699-1703
 PRDAY52                      1704-1708
 PRDAY53                      1709-1713
 PRDAY54                      1714-1718
 PRDAY55                      1719-1723
 PRDAY56                      1724-1728
 PRDAY57                      1729-1733
 PRDAY58                      1734-1738
 PRDAY59                      1739-1743
 PRDAY60                      1744-1748
 PRDAY61                      1749-1753
 PRDAY62                      1754-1758
 PRDAY63                      1759-1763
 PRDAY64                      1764-1768
 PRDAY65                      1769-1773
 PRDAY66                      1774-1778
 PRDAY67                      1779-1783
 PRDAY68                      1784-1788
 PRDAY69                      1789-1793
 PRDAY70                      1794-1798
 PRDAY71                      1799-1803
 PRDAY72                      1804-1808
 PRDAY73                      1809-1813
 PRDAY74                      1814-1818
 PRDAY75                      1819-1823
 PRDAY76                      1824-1828
 PRDAY77                      1829-1833
 PRDAY78                      1834-1838
 PRDAY79                      1839-1843
 PRDAY80                      1844-1848
 PSTATE                       1849-1850 (A)
 PSTATE_GEO                   1851-1852 (A)
 PSTCO_GEO                    1853-1857
 PointOfOriginUB04            1858     (A)
 PointOfOrigin_X              1859     (A)
 PrimLang                     1860-1862 (A)
 RACE                         1863-1864
 RACE_EDIT                    1865-1866
 RACE_X                       1867-1886 (A)
 TOTCHG                       1887-1896
 TOTCHG_X                     1897-1911
 TRAN_IN                      1912-1913
 TRAN_OUT                     1914-1915
 YEAR                         1916-1919
 ZIP                          1920-1924 (A)
 ZIP3                         1925-1927 (A)
 ZIPINC_QRTL                  1928-1930
 AYEAR                        1931-1934
 BMONTH                       1935-1936
 BYEAR                        1937-1940
 PRMONTH1                     1941-1942
 PRMONTH2                     1943-1944
 PRMONTH3                     1945-1946
 PRMONTH4                     1947-1948
 PRMONTH5                     1949-1950
 PRMONTH6                     1951-1952
 PRMONTH7                     1953-1954
 PRMONTH8                     1955-1956
 PRMONTH9                     1957-1958
 PRMONTH10                    1959-1960
 PRMONTH11                    1961-1962
 PRMONTH12                    1963-1964
 PRMONTH13                    1965-1966
 PRMONTH14                    1967-1968
 PRMONTH15                    1969-1970
 PRMONTH16                    1971-1972
 PRMONTH17                    1973-1974
 PRMONTH18                    1975-1976
 PRMONTH19                    1977-1978
 PRMONTH20                    1979-1980
 PRMONTH21                    1981-1982
 PRMONTH22                    1983-1984
 PRMONTH23                    1985-1986
 PRMONTH24                    1987-1988
 PRMONTH25                    1989-1990
 PRMONTH26                    1991-1992
 PRMONTH27                    1993-1994
 PRMONTH28                    1995-1996
 PRMONTH29                    1997-1998
 PRMONTH30                    1999-2000
 PRMONTH31                    2001-2002
 PRMONTH32                    2003-2004
 PRMONTH33                    2005-2006
 PRMONTH34                    2007-2008
 PRMONTH35                    2009-2010
 PRMONTH36                    2011-2012
 PRMONTH37                    2013-2014
 PRMONTH38                    2015-2016
 PRMONTH39                    2017-2018
 PRMONTH40                    2019-2020
 PRMONTH41                    2021-2022
 PRMONTH42                    2023-2024
 PRMONTH43                    2025-2026
 PRMONTH44                    2027-2028
 PRMONTH45                    2029-2030
 PRMONTH46                    2031-2032
 PRMONTH47                    2033-2034
 PRMONTH48                    2035-2036
 PRMONTH49                    2037-2038
 PRMONTH50                    2039-2040
 PRMONTH51                    2041-2042
 PRMONTH52                    2043-2044
 PRMONTH53                    2045-2046
 PRMONTH54                    2047-2048
 PRMONTH55                    2049-2050
 PRMONTH56                    2051-2052
 PRMONTH57                    2053-2054
 PRMONTH58                    2055-2056
 PRMONTH59                    2057-2058
 PRMONTH60                    2059-2060
 PRMONTH61                    2061-2062
 PRMONTH62                    2063-2064
 PRMONTH63                    2065-2066
 PRMONTH64                    2067-2068
 PRMONTH65                    2069-2070
 PRMONTH66                    2071-2072
 PRMONTH67                    2073-2074
 PRMONTH68                    2075-2076
 PRMONTH69                    2077-2078
 PRMONTH70                    2079-2080
 PRMONTH71                    2081-2082
 PRMONTH72                    2083-2084
 PRMONTH73                    2085-2086
 PRMONTH74                    2087-2088
 PRMONTH75                    2089-2090
 PRMONTH76                    2091-2092
 PRMONTH77                    2093-2094
 PRMONTH78                    2095-2096
 PRMONTH79                    2097-2098
 PRMONTH80                    2099-2100
 PRYEAR1                      2101-2104
 PRYEAR2                      2105-2108
 PRYEAR3                      2109-2112
 PRYEAR4                      2113-2116
 PRYEAR5                      2117-2120
 PRYEAR6                      2121-2124
 PRYEAR7                      2125-2128
 PRYEAR8                      2129-2132
 PRYEAR9                      2133-2136
 PRYEAR10                     2137-2140
 PRYEAR11                     2141-2144
 PRYEAR12                     2145-2148
 PRYEAR13                     2149-2152
 PRYEAR14                     2153-2156
 PRYEAR15                     2157-2160
 PRYEAR16                     2161-2164
 PRYEAR17                     2165-2168
 PRYEAR18                     2169-2172
 PRYEAR19                     2173-2176
 PRYEAR20                     2177-2180
 PRYEAR21                     2181-2184
 PRYEAR22                     2185-2188
 PRYEAR23                     2189-2192
 PRYEAR24                     2193-2196
 PRYEAR25                     2197-2200
 PRYEAR26                     2201-2204
 PRYEAR27                     2205-2208
 PRYEAR28                     2209-2212
 PRYEAR29                     2213-2216
 PRYEAR30                     2217-2220
 PRYEAR31                     2221-2224
 PRYEAR32                     2225-2228
 PRYEAR33                     2229-2232
 PRYEAR34                     2233-2236
 PRYEAR35                     2237-2240
 PRYEAR36                     2241-2244
 PRYEAR37                     2245-2248
 PRYEAR38                     2249-2252
 PRYEAR39                     2253-2256
 PRYEAR40                     2257-2260
 PRYEAR41                     2261-2264
 PRYEAR42                     2265-2268
 PRYEAR43                     2269-2272
 PRYEAR44                     2273-2276
 PRYEAR45                     2277-2280
 PRYEAR46                     2281-2284
 PRYEAR47                     2285-2288
 PRYEAR48                     2289-2292
 PRYEAR49                     2293-2296
 PRYEAR50                     2297-2300
 PRYEAR51                     2301-2304
 PRYEAR52                     2305-2308
 PRYEAR53                     2309-2312
 PRYEAR54                     2313-2316
 PRYEAR55                     2317-2320
 PRYEAR56                     2321-2324
 PRYEAR57                     2325-2328
 PRYEAR58                     2329-2332
 PRYEAR59                     2333-2336
 PRYEAR60                     2337-2340
 PRYEAR61                     2341-2344
 PRYEAR62                     2345-2348
 PRYEAR63                     2349-2352
 PRYEAR64                     2353-2356
 PRYEAR65                     2357-2360
 PRYEAR66                     2361-2364
 PRYEAR67                     2365-2368
 PRYEAR68                     2369-2372
 PRYEAR69                     2373-2376
 PRYEAR70                     2377-2380
 PRYEAR71                     2381-2384
 PRYEAR72                     2385-2388
 PRYEAR73                     2389-2392
 PRYEAR74                     2393-2396
 PRYEAR75                     2397-2400
 PRYEAR76                     2401-2404
 PRYEAR77                     2405-2408
 PRYEAR78                     2409-2412
 PRYEAR79                     2413-2416
 PRYEAR80                     2417-2420.


***  Specify write formats  ***.
FORMATS
 ADRG                         (F3.0) /
 ADRGRISKMORTALITY            (F3.0) /
 ADRGSEV                      (F3.0) /
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMDC                         (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRGVER                       (F3.0) /
 DRG_NoPOA                    (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRDAY61                      (F4.0) /
 PRDAY62                      (F4.0) /
 PRDAY63                      (F4.0) /
 PRDAY64                      (F4.0) /
 PRDAY65                      (F4.0) /
 PRDAY66                      (F4.0) /
 PRDAY67                      (F4.0) /
 PRDAY68                      (F4.0) /
 PRDAY69                      (F4.0) /
 PRDAY70                      (F4.0) /
 PRDAY71                      (F4.0) /
 PRDAY72                      (F4.0) /
 PRDAY73                      (F4.0) /
 PRDAY74                      (F4.0) /
 PRDAY75                      (F4.0) /
 PRDAY76                      (F4.0) /
 PRDAY77                      (F4.0) /
 PRDAY78                      (F4.0) /
 PRDAY79                      (F4.0) /
 PRDAY80                      (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_EDIT                    (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRMONTH46                    (F3.0) /
 PRMONTH47                    (F3.0) /
 PRMONTH48                    (F3.0) /
 PRMONTH49                    (F3.0) /
 PRMONTH50                    (F3.0) /
 PRMONTH51                    (F3.0) /
 PRMONTH52                    (F3.0) /
 PRMONTH53                    (F3.0) /
 PRMONTH54                    (F3.0) /
 PRMONTH55                    (F3.0) /
 PRMONTH56                    (F3.0) /
 PRMONTH57                    (F3.0) /
 PRMONTH58                    (F3.0) /
 PRMONTH59                    (F3.0) /
 PRMONTH60                    (F3.0) /
 PRMONTH61                    (F3.0) /
 PRMONTH62                    (F3.0) /
 PRMONTH63                    (F3.0) /
 PRMONTH64                    (F3.0) /
 PRMONTH65                    (F3.0) /
 PRMONTH66                    (F3.0) /
 PRMONTH67                    (F3.0) /
 PRMONTH68                    (F3.0) /
 PRMONTH69                    (F3.0) /
 PRMONTH70                    (F3.0) /
 PRMONTH71                    (F3.0) /
 PRMONTH72                    (F3.0) /
 PRMONTH73                    (F3.0) /
 PRMONTH74                    (F3.0) /
 PRMONTH75                    (F3.0) /
 PRMONTH76                    (F3.0) /
 PRMONTH77                    (F3.0) /
 PRMONTH78                    (F3.0) /
 PRMONTH79                    (F3.0) /
 PRMONTH80                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) /
 PRYEAR46                     (F3.0) /
 PRYEAR47                     (F3.0) /
 PRYEAR48                     (F3.0) /
 PRYEAR49                     (F3.0) /
 PRYEAR50                     (F3.0) /
 PRYEAR51                     (F3.0) /
 PRYEAR52                     (F3.0) /
 PRYEAR53                     (F3.0) /
 PRYEAR54                     (F3.0) /
 PRYEAR55                     (F3.0) /
 PRYEAR56                     (F3.0) /
 PRYEAR57                     (F3.0) /
 PRYEAR58                     (F3.0) /
 PRYEAR59                     (F3.0) /
 PRYEAR60                     (F3.0) /
 PRYEAR61                     (F3.0) /
 PRYEAR62                     (F3.0) /
 PRYEAR63                     (F3.0) /
 PRYEAR64                     (F3.0) /
 PRYEAR65                     (F3.0) /
 PRYEAR66                     (F3.0) /
 PRYEAR67                     (F3.0) /
 PRYEAR68                     (F3.0) /
 PRYEAR69                     (F3.0) /
 PRYEAR70                     (F3.0) /
 PRYEAR71                     (F3.0) /
 PRYEAR72                     (F3.0) /
 PRYEAR73                     (F3.0) /
 PRYEAR74                     (F3.0) /
 PRYEAR75                     (F3.0) /
 PRYEAR76                     (F3.0) /
 PRYEAR77                     (F3.0) /
 PRYEAR78                     (F3.0) /
 PRYEAR79                     (F3.0) /
 PRYEAR80                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 ADRG                         "All Patient Refined DRG"
 ADRGRISKMORTALITY            "All Patient Refined DRG mortality risk"
 ADRGSEV                      "All Patient Refined DRG severity level"
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMDC                         "All Patient Refined MDC"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRGVER                       "DRG grouper version used on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXPOA72                      "Diagnosis 72, present on admission indicator"
 DXPOA73                      "Diagnosis 73, present on admission indicator"
 DXPOA74                      "Diagnosis 74, present on admission indicator"
 DXPOA75                      "Diagnosis 75, present on admission indicator"
 DXPOA76                      "Diagnosis 76, present on admission indicator"
 DXPOA77                      "Diagnosis 77, present on admission indicator"
 DXPOA78                      "Diagnosis 78, present on admission indicator"
 DXPOA79                      "Diagnosis 79, present on admission indicator"
 DXPOA80                      "Diagnosis 80, present on admission indicator"
 DXPOA81                      "Diagnosis 81, present on admission indicator"
 DXPOA82                      "Diagnosis 82, present on admission indicator"
 DXPOA83                      "Diagnosis 83, present on admission indicator"
 DXPOA84                      "Diagnosis 84, present on admission indicator"
 DXPOA85                      "Diagnosis 85, present on admission indicator"
 DXPOA86                      "Diagnosis 86, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_DX72                     "ICD-10-CM Diagnosis 72"
 I10_DX73                     "ICD-10-CM Diagnosis 73"
 I10_DX74                     "ICD-10-CM Diagnosis 74"
 I10_DX75                     "ICD-10-CM Diagnosis 75"
 I10_DX76                     "ICD-10-CM Diagnosis 76"
 I10_DX77                     "ICD-10-CM Diagnosis 77"
 I10_DX78                     "ICD-10-CM Diagnosis 78"
 I10_DX79                     "ICD-10-CM Diagnosis 79"
 I10_DX80                     "ICD-10-CM Diagnosis 80"
 I10_DX81                     "ICD-10-CM Diagnosis 81"
 I10_DX82                     "ICD-10-CM Diagnosis 82"
 I10_DX83                     "ICD-10-CM Diagnosis 83"
 I10_DX84                     "ICD-10-CM Diagnosis 84"
 I10_DX85                     "ICD-10-CM Diagnosis 85"
 I10_DX86                     "ICD-10-CM Diagnosis 86"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PR61                     "ICD-10-PCS Procedure 61"
 I10_PR62                     "ICD-10-PCS Procedure 62"
 I10_PR63                     "ICD-10-PCS Procedure 63"
 I10_PR64                     "ICD-10-PCS Procedure 64"
 I10_PR65                     "ICD-10-PCS Procedure 65"
 I10_PR66                     "ICD-10-PCS Procedure 66"
 I10_PR67                     "ICD-10-PCS Procedure 67"
 I10_PR68                     "ICD-10-PCS Procedure 68"
 I10_PR69                     "ICD-10-PCS Procedure 69"
 I10_PR70                     "ICD-10-PCS Procedure 70"
 I10_PR71                     "ICD-10-PCS Procedure 71"
 I10_PR72                     "ICD-10-PCS Procedure 72"
 I10_PR73                     "ICD-10-PCS Procedure 73"
 I10_PR74                     "ICD-10-PCS Procedure 74"
 I10_PR75                     "ICD-10-PCS Procedure 75"
 I10_PR76                     "ICD-10-PCS Procedure 76"
 I10_PR77                     "ICD-10-PCS Procedure 77"
 I10_PR78                     "ICD-10-PCS Procedure 78"
 I10_PR79                     "ICD-10-PCS Procedure 79"
 I10_PR80                     "ICD-10-PCS Procedure 80"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PRDAY61                      "Number of days from admission to I10_PR61"
 PRDAY62                      "Number of days from admission to I10_PR62"
 PRDAY63                      "Number of days from admission to I10_PR63"
 PRDAY64                      "Number of days from admission to I10_PR64"
 PRDAY65                      "Number of days from admission to I10_PR65"
 PRDAY66                      "Number of days from admission to I10_PR66"
 PRDAY67                      "Number of days from admission to I10_PR67"
 PRDAY68                      "Number of days from admission to I10_PR68"
 PRDAY69                      "Number of days from admission to I10_PR69"
 PRDAY70                      "Number of days from admission to I10_PR70"
 PRDAY71                      "Number of days from admission to I10_PR71"
 PRDAY72                      "Number of days from admission to I10_PR72"
 PRDAY73                      "Number of days from admission to I10_PR73"
 PRDAY74                      "Number of days from admission to I10_PR74"
 PRDAY75                      "Number of days from admission to I10_PR75"
 PRDAY76                      "Number of days from admission to I10_PR76"
 PRDAY77                      "Number of days from admission to I10_PR77"
 PRDAY78                      "Number of days from admission to I10_PR78"
 PRDAY79                      "Number of days from admission to I10_PR79"
 PRDAY80                      "Number of days from admission to I10_PR80"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PrimLang                     "Primary language of patient"
 RACE                         "Race (uniform)"
 RACE_EDIT                    "Race Edit Checks"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRMONTH46                    "Month of procedure 46"
 PRMONTH47                    "Month of procedure 47"
 PRMONTH48                    "Month of procedure 48"
 PRMONTH49                    "Month of procedure 49"
 PRMONTH50                    "Month of procedure 50"
 PRMONTH51                    "Month of procedure 51"
 PRMONTH52                    "Month of procedure 52"
 PRMONTH53                    "Month of procedure 53"
 PRMONTH54                    "Month of procedure 54"
 PRMONTH55                    "Month of procedure 55"
 PRMONTH56                    "Month of procedure 56"
 PRMONTH57                    "Month of procedure 57"
 PRMONTH58                    "Month of procedure 58"
 PRMONTH59                    "Month of procedure 59"
 PRMONTH60                    "Month of procedure 60"
 PRMONTH61                    "Month of procedure 61"
 PRMONTH62                    "Month of procedure 62"
 PRMONTH63                    "Month of procedure 63"
 PRMONTH64                    "Month of procedure 64"
 PRMONTH65                    "Month of procedure 65"
 PRMONTH66                    "Month of procedure 66"
 PRMONTH67                    "Month of procedure 67"
 PRMONTH68                    "Month of procedure 68"
 PRMONTH69                    "Month of procedure 69"
 PRMONTH70                    "Month of procedure 70"
 PRMONTH71                    "Month of procedure 71"
 PRMONTH72                    "Month of procedure 72"
 PRMONTH73                    "Month of procedure 73"
 PRMONTH74                    "Month of procedure 74"
 PRMONTH75                    "Month of procedure 75"
 PRMONTH76                    "Month of procedure 76"
 PRMONTH77                    "Month of procedure 77"
 PRMONTH78                    "Month of procedure 78"
 PRMONTH79                    "Month of procedure 79"
 PRMONTH80                    "Month of procedure 80"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45"
 PRYEAR46                     "Year of procedure 46"
 PRYEAR47                     "Year of procedure 47"
 PRYEAR48                     "Year of procedure 48"
 PRYEAR49                     "Year of procedure 49"
 PRYEAR50                     "Year of procedure 50"
 PRYEAR51                     "Year of procedure 51"
 PRYEAR52                     "Year of procedure 52"
 PRYEAR53                     "Year of procedure 53"
 PRYEAR54                     "Year of procedure 54"
 PRYEAR55                     "Year of procedure 55"
 PRYEAR56                     "Year of procedure 56"
 PRYEAR57                     "Year of procedure 57"
 PRYEAR58                     "Year of procedure 58"
 PRYEAR59                     "Year of procedure 59"
 PRYEAR60                     "Year of procedure 60"
 PRYEAR61                     "Year of procedure 61"
 PRYEAR62                     "Year of procedure 62"
 PRYEAR63                     "Year of procedure 63"
 PRYEAR64                     "Year of procedure 64"
 PRYEAR65                     "Year of procedure 65"
 PRYEAR66                     "Year of procedure 66"
 PRYEAR67                     "Year of procedure 67"
 PRYEAR68                     "Year of procedure 68"
 PRYEAR69                     "Year of procedure 69"
 PRYEAR70                     "Year of procedure 70"
 PRYEAR71                     "Year of procedure 71"
 PRYEAR72                     "Year of procedure 72"
 PRYEAR73                     "Year of procedure 73"
 PRYEAR74                     "Year of procedure 74"
 PRYEAR75                     "Year of procedure 75"
 PRYEAR76                     "Year of procedure 76"
 PRYEAR77                     "Year of procedure 77"
 PRYEAR78                     "Year of procedure 78"
 PRYEAR79                     "Year of procedure 79"
 PRYEAR80                     "Year of procedure 80" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE ADRGRISKMORTALITY
 (-9,-8,-6,-5=SYSMIS).
RECODE ADRGSEV
 (-9,-8,-6,-5=SYSMIS).
RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMDC
 (-9,-8,-6,-5=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DELIVERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY61
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY62
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY63
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY64
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY65
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY66
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY67
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY68
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY69
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY70
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY71
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY72
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY73
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY74
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY75
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY76
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY77
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY78
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY79
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY80
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_EDIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH51
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH52
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH53
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH54
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH55
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH56
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH57
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH58
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH59
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH60
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH61
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH62
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH63
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH64
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH65
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH66
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH67
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH68
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH69
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH70
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH71
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH72
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH73
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH74
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH75
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH76
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH77
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH78
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH79
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH80
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR51
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR52
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR53
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR54
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR55
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR56
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR57
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR58
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR59
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR60
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR61
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR62
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR63
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR64
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR65
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR66
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR67
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR68
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR69
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR70
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR71
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR72
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR73
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR74
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR75
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR76
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR77
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR78
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR79
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR80
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MN_SID_2019_CORE.SAV' /COMPRESSED.
