/*******************************************************************
*   NJ_SID_2010_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NJ_SID_2010_CHGS.ASC' FIXED / 
 CHARGE                     1-  12
 CPTHCPCS                  13-  17 (A)
 CPTMod1                   18-  19 (A)
 CPTMod2                   20-  21 (A)
 KEY                       22-  39
 REVCODE                   40-  43 (A)
 UNITS                     44-  51.


***  Specify write formats  ***.
FORMATS
 CHARGE                  (F6.2) /
 KEY                     (F8.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHARGE                  "Line item charges (as received from source)"
 CPTHCPCS                "Line item CPT-4/HCPCS procedure code (as received from source)"
 CPTMod1                 "Line item CPT-4/HCPCS first modifier (as received from source)"
 CPTMod2                 "Line item CPT-4/HCPCS second modifier (as received from source)"
 KEY                     "HCUP record identifier"
 REVCODE                 "Line item revenue code (as received from source)"
 UNITS                   "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'NJ_SID_2010_CHGS.SAV' /COMPRESSED.
