/*******************************************************************
* Creation Date: 05/15/2014   
*   NV_SID_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NV_SID_2012_CORE.ASC' FIXED SKIP=2 / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ASOURCE                   16-  17
 ASOURCEUB92               18     (A)
 ASOURCE_X                 19-  20 (A)
 ATYPE                     21-  22
 AWEEKEND                  23-  24
 DHOUR                     25-  28
 DIED                      29-  30
 DISPUB04                  31-  32
 DISPUNIFORM               33-  34
 DISP_X                    35-  36 (A)
 DQTR                      37-  38
 DRG                       39-  41
 DRG24                     42-  44
 DRGVER                    45-  46
 DRG_NoPOA                 47-  49
 DSHOSPID                  50-  66 (A)
 DX1                       67-  71 (A)
 DX2                       72-  76 (A)
 DX3                       77-  81 (A)
 DX4                       82-  86 (A)
 DX5                       87-  91 (A)
 DX6                       92-  96 (A)
 DX7                       97- 101 (A)
 DX8                      102- 106 (A)
 DX9                      107- 111 (A)
 DX10                     112- 116 (A)
 DX11                     117- 121 (A)
 DX12                     122- 126 (A)
 DX13                     127- 131 (A)
 DX14                     132- 136 (A)
 DX15                     137- 141 (A)
 DX16                     142- 146 (A)
 DX17                     147- 151 (A)
 DX18                     152- 156 (A)
 DX19                     157- 161 (A)
 DX20                     162- 166 (A)
 DX21                     167- 171 (A)
 DX22                     172- 176 (A)
 DX23                     177- 181 (A)
 DX24                     182- 186 (A)
 DX25                     187- 191 (A)
 DX26                     192- 196 (A)
 DX27                     197- 201 (A)
 DX28                     202- 206 (A)
 DX29                     207- 211 (A)
 DX30                     212- 216 (A)
 DX31                     217- 221 (A)
 DX32                     222- 226 (A)
 DX33                     227- 231 (A)
 DXCCS1                   232- 235
 DXCCS2                   236- 239
 DXCCS3                   240- 243
 DXCCS4                   244- 247
 DXCCS5                   248- 251
 DXCCS6                   252- 255
 DXCCS7                   256- 259
 DXCCS8                   260- 263
 DXCCS9                   264- 267
 DXCCS10                  268- 271
 DXCCS11                  272- 275
 DXCCS12                  276- 279
 DXCCS13                  280- 283
 DXCCS14                  284- 287
 DXCCS15                  288- 291
 DXCCS16                  292- 295
 DXCCS17                  296- 299
 DXCCS18                  300- 303
 DXCCS19                  304- 307
 DXCCS20                  308- 311
 DXCCS21                  312- 315
 DXCCS22                  316- 319
 DXCCS23                  320- 323
 DXCCS24                  324- 327
 DXCCS25                  328- 331
 DXCCS26                  332- 335
 DXCCS27                  336- 339
 DXCCS28                  340- 343
 DXCCS29                  344- 347
 DXCCS30                  348- 351
 DXCCS31                  352- 355
 DXCCS32                  356- 359
 DXCCS33                  360- 363
 DXPOA1                   364     (A)
 DXPOA2                   365     (A)
 DXPOA3                   366     (A)
 DXPOA4                   367     (A)
 DXPOA5                   368     (A)
 DXPOA6                   369     (A)
 DXPOA7                   370     (A)
 DXPOA8                   371     (A)
 DXPOA9                   372     (A)
 DXPOA10                  373     (A)
 DXPOA11                  374     (A)
 DXPOA12                  375     (A)
 DXPOA13                  376     (A)
 DXPOA14                  377     (A)
 DXPOA15                  378     (A)
 DXPOA16                  379     (A)
 DXPOA17                  380     (A)
 DXPOA18                  381     (A)
 DXPOA19                  382     (A)
 DXPOA20                  383     (A)
 DXPOA21                  384     (A)
 DXPOA22                  385     (A)
 DXPOA23                  386     (A)
 DXPOA24                  387     (A)
 DXPOA25                  388     (A)
 DXPOA26                  389     (A)
 DXPOA27                  390     (A)
 DXPOA28                  391     (A)
 DXPOA29                  392     (A)
 DXPOA30                  393     (A)
 DXPOA31                  394     (A)
 DXPOA32                  395     (A)
 DXPOA33                  396     (A)
 DX_Admitting             397- 401 (A)
 ECODE1                   402- 406 (A)
 ECODE2                   407- 411 (A)
 ECODE3                   412- 416 (A)
 ECODE4                   417- 421 (A)
 E_CCS1                   422- 425
 E_CCS2                   426- 429
 E_CCS3                   430- 433
 E_CCS4                   434- 437
 E_POA1                   438     (A)
 E_POA2                   439     (A)
 E_POA3                   440     (A)
 E_POA4                   441     (A)
 FEMALE                   442- 443
 HCUP_ED                  444- 445
 HCUP_OS                  446- 447
 HOSPBRTH                 448- 450
 HOSPST                   451- 452 (A)
 KEY                      453- 467
 LOS                      468- 472
 LOS_X                    473- 478
 MARITALSTATUSUB04        479     (A)
 MARITALSTATUS_X          480     (A)
 MDC                      481- 482
 MDC24                    483- 484
 MDC_NoPOA                485- 486
 MDNUM1_R                 487- 495
 MDNUM2_R                 496- 504
 MDNUMTYPE1               505     (A)
 MDNUMTYPE2               506     (A)
 MEDINCSTQ                507- 508
 NCHRONIC                 509- 511
 NDX                      512- 513
 NECODE                   514- 515
 NEOMAT                   516- 517
 NPR                      518- 519
 ORPROC                   520- 521
 OS_TIME                  522- 529
 PAY1                     530- 531
 PAY1_X                   532- 533 (A)
 PAY2                     534- 535
 PAY2_X                   536- 537 (A)
 PAY3                     538- 539
 PAY3_X                   540- 541 (A)
 PL_NCHS2006              542- 543
 PL_RUCA10_2005           544- 545
 PL_RUCA2005              546- 549
 PL_RUCA4_2005            550- 551
 PL_RUCC2003              552- 553
 PL_UIC2003               554- 555
 PL_UR_CAT4               556- 557
 PR1                      558- 561 (A)
 PR2                      562- 565 (A)
 PR3                      566- 569 (A)
 PR4                      570- 573 (A)
 PR5                      574- 577 (A)
 PR6                      578- 581 (A)
 PR7                      582- 585 (A)
 PR8                      586- 589 (A)
 PR9                      590- 593 (A)
 PR10                     594- 597 (A)
 PR11                     598- 601 (A)
 PR12                     602- 605 (A)
 PRCCS1                   606- 608
 PRCCS2                   609- 611
 PRCCS3                   612- 614
 PRCCS4                   615- 617
 PRCCS5                   618- 620
 PRCCS6                   621- 623
 PRCCS7                   624- 626
 PRCCS8                   627- 629
 PRCCS9                   630- 632
 PRCCS10                  633- 635
 PRCCS11                  636- 638
 PRCCS12                  639- 641
 PRDAY1                   642- 646
 PRDAY2                   647- 651
 PRDAY3                   652- 656
 PRDAY4                   657- 661
 PRDAY5                   662- 666
 PRDAY6                   667- 671
 PRDAY7                   672- 676
 PRDAY8                   677- 681
 PRDAY9                   682- 686
 PRDAY10                  687- 691
 PRDAY11                  692- 696
 PRDAY12                  697- 701
 PROCTYPE                 702- 704
 PSTATE                   705- 706 (A)
 PSTCO                    707- 711
 PSTCO2                   712- 716
 PointOfOriginUB04        717     (A)
 PointOfOrigin_X          718- 719 (A)
 RACE                     720- 721
 RACE_X                   722- 723 (A)
 TOTCHG                   724- 733
 TOTCHG_X                 734- 748
 TRAN_IN                  749- 750
 TRAN_OUT                 751- 752
 YEAR                     753- 756
 ZIPINC_QRTL              757- 759
 AYEAR                    760- 763
 DMONTH                   764- 765.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 OS_TIME                 (F4.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PAY3                    (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCEUB92             "Admission source (UB-92 standard coding)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DXPOA25                 "Diagnosis 25, present on admission indicator"
 DXPOA26                 "Diagnosis 26, present on admission indicator"
 DXPOA27                 "Diagnosis 27, present on admission indicator"
 DXPOA28                 "Diagnosis 28, present on admission indicator"
 DXPOA29                 "Diagnosis 29, present on admission indicator"
 DXPOA30                 "Diagnosis 30, present on admission indicator"
 DXPOA31                 "Diagnosis 31, present on admission indicator"
 DXPOA32                 "Diagnosis 32, present on admission indicator"
 DXPOA33                 "Diagnosis 33, present on admission indicator"
 DX_Admitting            "Admitting Diagnosis Code"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MARITALSTATUSUB04       "Patient's marital status, UB-04 standard coding"
 MARITALSTATUS_X         "Patient's marital status (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MDNUMTYPE1              "Physician 1 number type"
 MDNUMTYPE2              "Physician 2 number type"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 OS_TIME                 "Observation stay time summed from UNITS"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3                    "Tertiary expected payer (uniform)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 YEAR                    "Calendar year"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NV_SID_2012_CORE.SAV' /COMPRESSED.
