/*******************************************************************
*   RI_SID_2003_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'RI_SID_2003_CHGS.ASC' FIXED / 
 KEY                        1-  14
 CHG1                      15-  26
 CHG2                      27-  38
 CHG3                      39-  50
 CHG4                      51-  62
 CHG5                      63-  74
 CHG6                      75-  86
 CHG7                      87-  98
 CHG8                      99- 110
 CHG9                     111- 122
 CHG10                    123- 134
 CHG11                    135- 146
 CHG12                    147- 158.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CHG1                    (F6.2) /
 CHG2                    (F6.2) /
 CHG3                    (F6.2) /
 CHG4                    (F6.2) /
 CHG5                    (F6.2) /
 CHG6                    (F6.2) /
 CHG7                    (F6.2) /
 CHG8                    (F6.2) /
 CHG9                    (F6.2) /
 CHG10                   (F6.2) /
 CHG11                   (F6.2) /
 CHG12                   (F6.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CHG1      "Detailed charges 1 (as received from source)"
 CHG2      "Detailed charges 2 (as received from source)"
 CHG3      "Detailed charges 3 (as received from source)"
 CHG4      "Detailed charges 4 (as received from source)"
 CHG5      "Detailed charges 5 (as received from source)"
 CHG6      "Detailed charges 6 (as received from source)"
 CHG7      "Detailed charges 7 (as received from source)"
 CHG8      "Detailed charges 8 (as received from source)"
 CHG9      "Detailed charges 9 (as received from source)"
 CHG10     "Detailed charges 10 (as received from source)"
 CHG11     "Detailed charges 11 (as received from source)"
 CHG12     "Detailed charges 12 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'RI_SID_2003_CHGS.SAV' /COMPRESSED.
