/*******************************************************************
* Creation Date: 05/31/2024   
*   SD_SID_2022_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'SD_SID_2022_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BWT                            16-  19
 DIED                           20-  21
 DISP_X                         22-  25 (A)
 DISPUB04                       26-  27
 DISPUNIFORM                    28-  29
 DMONTH                         30-  31
 DQTR                           32-  33
 DRG                            34-  36
 DRG_NoPOA                      37-  39
 DRGVER                         40-  41
 DXPOA1                         42     (A)
 DXPOA2                         43     (A)
 DXPOA3                         44     (A)
 DXPOA4                         45     (A)
 DXPOA5                         46     (A)
 DXPOA6                         47     (A)
 DXPOA7                         48     (A)
 DXPOA8                         49     (A)
 DXPOA9                         50     (A)
 DXPOA10                        51     (A)
 DXPOA11                        52     (A)
 DXPOA12                        53     (A)
 DXPOA13                        54     (A)
 DXPOA14                        55     (A)
 DXPOA15                        56     (A)
 DXPOA16                        57     (A)
 DXPOA17                        58     (A)
 DXPOA18                        59     (A)
 DXPOA19                        60     (A)
 DXPOA20                        61     (A)
 DXPOA21                        62     (A)
 DXPOA22                        63     (A)
 DXPOA23                        64     (A)
 DXPOA24                        65     (A)
 DXPOA25                        66     (A)
 DXPOA26                        67     (A)
 DXPOA27                        68     (A)
 DXPOA28                        69     (A)
 DXPOA29                        70     (A)
 DXPOA30                        71     (A)
 DXPOA31                        72     (A)
 DXPOA32                        73     (A)
 DXPOA33                        74     (A)
 DXPOA34                        75     (A)
 DXPOA35                        76     (A)
 DXPOA36                        77     (A)
 DXPOA37                        78     (A)
 DXPOA38                        79     (A)
 DXPOA39                        80     (A)
 DXPOA40                        81     (A)
 DXPOA41                        82     (A)
 DXPOA42                        83     (A)
 DXPOA43                        84     (A)
 DXPOA44                        85     (A)
 DXPOA45                        86     (A)
 DXPOA46                        87     (A)
 DXPOA47                        88     (A)
 DXPOA48                        89     (A)
 DXPOA49                        90     (A)
 DXPOA50                        91     (A)
 DXPOA51                        92     (A)
 DXPOA52                        93     (A)
 DXPOA53                        94     (A)
 DXPOA54                        95     (A)
 DXPOA55                        96     (A)
 DXPOA56                        97     (A)
 DXPOA57                        98     (A)
 DXPOA58                        99     (A)
 DXPOA59                       100     (A)
 DXPOA60                       101     (A)
 DXPOA61                       102     (A)
 DXPOA62                       103     (A)
 DXPOA63                       104     (A)
 DXPOA64                       105     (A)
 DXPOA65                       106     (A)
 DXPOA66                       107     (A)
 DXPOA67                       108     (A)
 DXPOA68                       109     (A)
 DXPOA69                       110     (A)
 DXPOA70                       111     (A)
 DXPOA71                       112     (A)
 DXPOA72                       113     (A)
 DXPOA73                       114     (A)
 DXPOA74                       115     (A)
 DXPOA75                       116     (A)
 DXPOA76                       117     (A)
 DXPOA77                       118     (A)
 DXPOA78                       119     (A)
 DXPOA79                       120     (A)
 DXPOA80                       121     (A)
 DXPOA81                       122     (A)
 DXPOA82                       123     (A)
 FEMALE                        124- 125
 HCUP_ED                       126- 127
 HCUP_OS                       128- 129
 HISPANIC                      130- 131
 HISPANIC_X                    132     (A)
 HospitalUnit                  133- 134
 HOSPST                        135- 136 (A)
 I10_BIRTH                     137- 139
 I10_DELIVERY                  140- 142
 I10_DX_Admitting              143- 149 (A)
 I10_DX1                       150- 156 (A)
 I10_DX2                       157- 163 (A)
 I10_DX3                       164- 170 (A)
 I10_DX4                       171- 177 (A)
 I10_DX5                       178- 184 (A)
 I10_DX6                       185- 191 (A)
 I10_DX7                       192- 198 (A)
 I10_DX8                       199- 205 (A)
 I10_DX9                       206- 212 (A)
 I10_DX10                      213- 219 (A)
 I10_DX11                      220- 226 (A)
 I10_DX12                      227- 233 (A)
 I10_DX13                      234- 240 (A)
 I10_DX14                      241- 247 (A)
 I10_DX15                      248- 254 (A)
 I10_DX16                      255- 261 (A)
 I10_DX17                      262- 268 (A)
 I10_DX18                      269- 275 (A)
 I10_DX19                      276- 282 (A)
 I10_DX20                      283- 289 (A)
 I10_DX21                      290- 296 (A)
 I10_DX22                      297- 303 (A)
 I10_DX23                      304- 310 (A)
 I10_DX24                      311- 317 (A)
 I10_DX25                      318- 324 (A)
 I10_DX26                      325- 331 (A)
 I10_DX27                      332- 338 (A)
 I10_DX28                      339- 345 (A)
 I10_DX29                      346- 352 (A)
 I10_DX30                      353- 359 (A)
 I10_DX31                      360- 366 (A)
 I10_DX32                      367- 373 (A)
 I10_DX33                      374- 380 (A)
 I10_DX34                      381- 387 (A)
 I10_DX35                      388- 394 (A)
 I10_DX36                      395- 401 (A)
 I10_DX37                      402- 408 (A)
 I10_DX38                      409- 415 (A)
 I10_DX39                      416- 422 (A)
 I10_DX40                      423- 429 (A)
 I10_DX41                      430- 436 (A)
 I10_DX42                      437- 443 (A)
 I10_DX43                      444- 450 (A)
 I10_DX44                      451- 457 (A)
 I10_DX45                      458- 464 (A)
 I10_DX46                      465- 471 (A)
 I10_DX47                      472- 478 (A)
 I10_DX48                      479- 485 (A)
 I10_DX49                      486- 492 (A)
 I10_DX50                      493- 499 (A)
 I10_DX51                      500- 506 (A)
 I10_DX52                      507- 513 (A)
 I10_DX53                      514- 520 (A)
 I10_DX54                      521- 527 (A)
 I10_DX55                      528- 534 (A)
 I10_DX56                      535- 541 (A)
 I10_DX57                      542- 548 (A)
 I10_DX58                      549- 555 (A)
 I10_DX59                      556- 562 (A)
 I10_DX60                      563- 569 (A)
 I10_DX61                      570- 576 (A)
 I10_DX62                      577- 583 (A)
 I10_DX63                      584- 590 (A)
 I10_DX64                      591- 597 (A)
 I10_DX65                      598- 604 (A)
 I10_DX66                      605- 611 (A)
 I10_DX67                      612- 618 (A)
 I10_DX68                      619- 625 (A)
 I10_DX69                      626- 632 (A)
 I10_DX70                      633- 639 (A)
 I10_DX71                      640- 646 (A)
 I10_DX72                      647- 653 (A)
 I10_DX73                      654- 660 (A)
 I10_DX74                      661- 667 (A)
 I10_DX75                      668- 674 (A)
 I10_DX76                      675- 681 (A)
 I10_DX77                      682- 688 (A)
 I10_DX78                      689- 695 (A)
 I10_DX79                      696- 702 (A)
 I10_DX80                      703- 709 (A)
 I10_DX81                      710- 716 (A)
 I10_DX82                      717- 723 (A)
 I10_NDX                       724- 726
 I10_NPR                       727- 729
 I10_PR1                       730- 736 (A)
 I10_PR2                       737- 743 (A)
 I10_PR3                       744- 750 (A)
 I10_PR4                       751- 757 (A)
 I10_PR5                       758- 764 (A)
 I10_PR6                       765- 771 (A)
 I10_PR7                       772- 778 (A)
 I10_PR8                       779- 785 (A)
 I10_PR9                       786- 792 (A)
 I10_PR10                      793- 799 (A)
 I10_PR11                      800- 806 (A)
 I10_PR12                      807- 813 (A)
 I10_PR13                      814- 820 (A)
 I10_PR14                      821- 827 (A)
 I10_PR15                      828- 834 (A)
 I10_PR16                      835- 841 (A)
 I10_PR17                      842- 848 (A)
 I10_PR18                      849- 855 (A)
 I10_PR19                      856- 862 (A)
 I10_PR20                      863- 869 (A)
 I10_PR21                      870- 876 (A)
 I10_PR22                      877- 883 (A)
 I10_PR23                      884- 890 (A)
 I10_PR24                      891- 897 (A)
 I10_PR25                      898- 904 (A)
 I10_PR26                      905- 911 (A)
 I10_PR27                      912- 918 (A)
 I10_PR28                      919- 925 (A)
 I10_PR29                      926- 932 (A)
 I10_PR30                      933- 939 (A)
 I10_PR31                      940- 946 (A)
 I10_PR32                      947- 953 (A)
 I10_PR33                      954- 960 (A)
 I10_PR34                      961- 967 (A)
 I10_PR35                      968- 974 (A)
 I10_PR36                      975- 981 (A)
 I10_PR37                      982- 988 (A)
 I10_PR38                      989- 995 (A)
 I10_PR39                      996-1002 (A)
 I10_PR40                     1003-1009 (A)
 I10_PR41                     1010-1016 (A)
 I10_PR42                     1017-1023 (A)
 I10_PR43                     1024-1030 (A)
 I10_PR44                     1031-1037 (A)
 I10_PR45                     1038-1044 (A)
 I10_PROCTYPE                 1045-1047
 I10_SERVICELINE              1048-1049
 KEY                          1050-1064
 LOS                          1065-1069
 LOS_X                        1070-1075
 MDC                          1076-1077
 MDC_NoPOA                    1078-1079
 MDNUM1_R                     1080-1088
 MDNUM2_R                     1089-1097
 MEDINCSTQ                    1098-1099
 MRN_R                        1100-1108
 P7EDSRC_X                    1109-1110 (A)
 PAY1                         1111-1112
 PCLASS_ORPROC                1113-1114
 PL_CBSA                      1115-1117
 PL_NCHS                      1118-1119
 PL_RUCC                      1120-1121
 PL_UIC                       1122-1123
 PL_UR_CAT4                   1124-1125
 POA_Disch_Edit1              1126-1127
 POA_Disch_Edit2              1128-1129
 POA_Hosp_Edit1               1130-1131
 POA_Hosp_Edit2               1132-1133
 POA_Hosp_Edit3               1134-1135
 POA_Hosp_Edit3_Value         1136-1143
 PointOfOrigin_X              1144     (A)
 PointOfOriginUB04            1145     (A)
 PRDAY1                       1146-1150
 PRDAY2                       1151-1155
 PRDAY3                       1156-1160
 PRDAY4                       1161-1165
 PRDAY5                       1166-1170
 PRDAY6                       1171-1175
 PRDAY7                       1176-1180
 PRDAY8                       1181-1185
 PRDAY9                       1186-1190
 PRDAY10                      1191-1195
 PRDAY11                      1196-1200
 PRDAY12                      1201-1205
 PRDAY13                      1206-1210
 PRDAY14                      1211-1215
 PRDAY15                      1216-1220
 PRDAY16                      1221-1225
 PRDAY17                      1226-1230
 PRDAY18                      1231-1235
 PRDAY19                      1236-1240
 PRDAY20                      1241-1245
 PRDAY21                      1246-1250
 PRDAY22                      1251-1255
 PRDAY23                      1256-1260
 PRDAY24                      1261-1265
 PRDAY25                      1266-1270
 PRDAY26                      1271-1275
 PRDAY27                      1276-1280
 PRDAY28                      1281-1285
 PRDAY29                      1286-1290
 PRDAY30                      1291-1295
 PRDAY31                      1296-1300
 PRDAY32                      1301-1305
 PRDAY33                      1306-1310
 PRDAY34                      1311-1315
 PRDAY35                      1316-1320
 PRDAY36                      1321-1325
 PRDAY37                      1326-1330
 PRDAY38                      1331-1335
 PRDAY39                      1336-1340
 PRDAY40                      1341-1345
 PRDAY41                      1346-1350
 PRDAY42                      1351-1355
 PRDAY43                      1356-1360
 PRDAY44                      1361-1365
 PRDAY45                      1366-1370
 PSTATE                       1371-1372 (A)
 PSTATE_GEO                   1373-1374 (A)
 PSTCO                        1375-1379
 PSTCO_GEO                    1380-1384
 RACE                         1385-1386
 RACE_PCT_MISS_HOSP           1387-1393
 RACE_X                       1394     (A)
 TOTCHG                       1395-1404
 TOTCHG_X                     1405-1419
 TRAN_IN                      1420-1421
 TRAN_OUT                     1422-1423
 YEAR                         1424-1427
 ZIP                          1428-1432 (A)
 ZIP3                         1433-1435 (A)
 ZIPINC_QRTL                  1436-1438
 HOSPID                       1439-1443
 AYEAR                        1444-1447
 BMONTH                       1448-1449
 BYEAR                        1450-1453
 PRMONTH1                     1454-1455
 PRMONTH2                     1456-1457
 PRMONTH3                     1458-1459
 PRMONTH4                     1460-1461
 PRMONTH5                     1462-1463
 PRMONTH6                     1464-1465
 PRMONTH7                     1466-1467
 PRMONTH8                     1468-1469
 PRMONTH9                     1470-1471
 PRMONTH10                    1472-1473
 PRMONTH11                    1474-1475
 PRMONTH12                    1476-1477
 PRMONTH13                    1478-1479
 PRMONTH14                    1480-1481
 PRMONTH15                    1482-1483
 PRMONTH16                    1484-1485
 PRMONTH17                    1486-1487
 PRMONTH18                    1488-1489
 PRMONTH19                    1490-1491
 PRMONTH20                    1492-1493
 PRMONTH21                    1494-1495
 PRMONTH22                    1496-1497
 PRMONTH23                    1498-1499
 PRMONTH24                    1500-1501
 PRMONTH25                    1502-1503
 PRMONTH26                    1504-1505
 PRMONTH27                    1506-1507
 PRMONTH28                    1508-1509
 PRMONTH29                    1510-1511
 PRMONTH30                    1512-1513
 PRMONTH31                    1514-1515
 PRMONTH32                    1516-1517
 PRMONTH33                    1518-1519
 PRMONTH34                    1520-1521
 PRMONTH35                    1522-1523
 PRMONTH36                    1524-1525
 PRMONTH37                    1526-1527
 PRMONTH38                    1528-1529
 PRMONTH39                    1530-1531
 PRMONTH40                    1532-1533
 PRMONTH41                    1534-1535
 PRMONTH42                    1536-1537
 PRMONTH43                    1538-1539
 PRMONTH44                    1540-1541
 PRMONTH45                    1542-1543
 PRYEAR1                      1544-1547
 PRYEAR2                      1548-1551
 PRYEAR3                      1552-1555
 PRYEAR4                      1556-1559
 PRYEAR5                      1560-1563
 PRYEAR6                      1564-1567
 PRYEAR7                      1568-1571
 PRYEAR8                      1572-1575
 PRYEAR9                      1576-1579
 PRYEAR10                     1580-1583
 PRYEAR11                     1584-1587
 PRYEAR12                     1588-1591
 PRYEAR13                     1592-1595
 PRYEAR14                     1596-1599
 PRYEAR15                     1600-1603
 PRYEAR16                     1604-1607
 PRYEAR17                     1608-1611
 PRYEAR18                     1612-1615
 PRYEAR19                     1616-1619
 PRYEAR20                     1620-1623
 PRYEAR21                     1624-1627
 PRYEAR22                     1628-1631
 PRYEAR23                     1632-1635
 PRYEAR24                     1636-1639
 PRYEAR25                     1640-1643
 PRYEAR26                     1644-1647
 PRYEAR27                     1648-1651
 PRYEAR28                     1652-1655
 PRYEAR29                     1656-1659
 PRYEAR30                     1660-1663
 PRYEAR31                     1664-1667
 PRYEAR32                     1668-1671
 PRYEAR33                     1672-1675
 PRYEAR34                     1676-1679
 PRYEAR35                     1680-1683
 PRYEAR36                     1684-1687
 PRYEAR37                     1688-1691
 PRYEAR38                     1692-1695
 PRYEAR39                     1696-1699
 PRYEAR40                     1700-1703
 PRYEAR41                     1704-1707
 PRYEAR42                     1708-1711
 PRYEAR43                     1712-1715
 PRYEAR44                     1716-1719
 PRYEAR45                     1720-1723.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 PAY1                         (F3.0) /
 PCLASS_ORPROC                (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXPOA72                      "Diagnosis 72, present on admission indicator"
 DXPOA73                      "Diagnosis 73, present on admission indicator"
 DXPOA74                      "Diagnosis 74, present on admission indicator"
 DXPOA75                      "Diagnosis 75, present on admission indicator"
 DXPOA76                      "Diagnosis 76, present on admission indicator"
 DXPOA77                      "Diagnosis 77, present on admission indicator"
 DXPOA78                      "Diagnosis 78, present on admission indicator"
 DXPOA79                      "Diagnosis 79, present on admission indicator"
 DXPOA80                      "Diagnosis 80, present on admission indicator"
 DXPOA81                      "Diagnosis 81, present on admission indicator"
 DXPOA82                      "Diagnosis 82, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_DX72                     "ICD-10-CM Diagnosis 72"
 I10_DX73                     "ICD-10-CM Diagnosis 73"
 I10_DX74                     "ICD-10-CM Diagnosis 74"
 I10_DX75                     "ICD-10-CM Diagnosis 75"
 I10_DX76                     "ICD-10-CM Diagnosis 76"
 I10_DX77                     "ICD-10-CM Diagnosis 77"
 I10_DX78                     "ICD-10-CM Diagnosis 78"
 I10_DX79                     "ICD-10-CM Diagnosis 79"
 I10_DX80                     "ICD-10-CM Diagnosis 80"
 I10_DX81                     "ICD-10-CM Diagnosis 81"
 I10_DX82                     "ICD-10-CM Diagnosis 82"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PCLASS_ORPROC                "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_DELIVERY
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'SD_SID_2022_CORE.sav' /COMPRESSED.
