/************************************************************************************
Program Name: PRclassLoad.do 
Description : Load PRclass.dta file used to assign Procedure Classes from Stata. 
Developed   : By David Ross on 10/26/2009.
************************************************************************************/

local fyear     "2014"
local tool      PRclass
local prefix    PC
local ivar      pr
local ovar      PCLASS

if `"`ivar'"' == "pr" local icd9f icd9p
else local icd9f icd9

* Remove first two lines from file
infix str line  1-200 using `prefix'`fyear'.csv in 3/L, clear
outfile line using `prefix'`fyear'Stata.csv, noquote replace

infile str6  _`ivar'         ///
       str60 I9Description   ///
       str1  `ovar'          ///
       using `prefix'`fyear'Stata.csv, clear

destring `ovar', replace

`icd9f' clean _`ivar', dots
sort _`ivar'
keep _`ivar' `ovar'
save `tool', replace
