/*****************************************************************************
* SASload_KID_2009_Core.SAS
* This program will load the 2009 KID ASCII Core File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA KID_2009_Core; 
INFILE 'KID_2009_Core.ASC' LRECL = 601;                                                                                                                                                                                                    

*** Define data element attributes ***;
ATTRIB 
  HOSPID                     LENGTH=4            FORMAT=Z5.
  LABEL="HCUP hospital identification number"

  RECNUM                     LENGTH=5            FORMAT=Z8.
  LABEL="HCUP record number"

  AGE                        LENGTH=3
  LABEL="Age in years at admission"

  AGEDAY                     LENGTH=3
  LABEL="Age in days (when age < 1 year)"

  AGEMONTH                   LENGTH=3
  LABEL="Age in months (when age < 11 years)"

  AMONTH                     LENGTH=3
  LABEL="Admission month"

  ASOURCE                    LENGTH=3
  LABEL="Admission source (uniform)"

  ASOURCEUB92                LENGTH=$1
  LABEL="Admission source (UB-92 standard coding)"

  ASOURCE_X                  LENGTH=$3
  LABEL="Admission source (as received from source)"

  ATYPE                      LENGTH=3
  LABEL="Admission type"

  AWEEKEND                   LENGTH=3
  LABEL="Admission day is a weekend"

  BWT                        LENGTH=4
  LABEL="Birth weight in grams"

  DIED                       LENGTH=3
  LABEL="Died during hospitalization"

  DISCWT                     LENGTH=8
  LABEL="Weight to discharges in AHA universe"

  DISPUB04                   LENGTH=3
  LABEL="Disposition of patient (UB-04 standard coding)"

  DISPUNIFORM                LENGTH=3
  LABEL="Disposition of patient (uniform)"

  DQTR                       LENGTH=3
  LABEL="Discharge quarter"

  DQTR_X                     LENGTH=3
  LABEL="Discharge quarter (as received from source)"

  DRG                        LENGTH=3
  LABEL="DRG in effect on discharge date"

  DRG24                      LENGTH=3
  LABEL="DRG, version 24"

  DRGVER                     LENGTH=3
  LABEL="DRG grouper version used on discharge date"

  DRG_NoPOA                  LENGTH=3
  LABEL="DRG in use on discharge date, calculated without POA"

  DSHOSPID                   LENGTH=$17
  LABEL="Data source hospital identifier"

  DX1                        LENGTH=$5
  LABEL="Diagnosis 1"

  DX2                        LENGTH=$5
  LABEL="Diagnosis 2"

  DX3                        LENGTH=$5
  LABEL="Diagnosis 3"

  DX4                        LENGTH=$5
  LABEL="Diagnosis 4"

  DX5                        LENGTH=$5
  LABEL="Diagnosis 5"

  DX6                        LENGTH=$5
  LABEL="Diagnosis 6"

  DX7                        LENGTH=$5
  LABEL="Diagnosis 7"

  DX8                        LENGTH=$5
  LABEL="Diagnosis 8"

  DX9                        LENGTH=$5
  LABEL="Diagnosis 9"

  DX10                       LENGTH=$5
  LABEL="Diagnosis 10"

  DX11                       LENGTH=$5
  LABEL="Diagnosis 11"

  DX12                       LENGTH=$5
  LABEL="Diagnosis 12"

  DX13                       LENGTH=$5
  LABEL="Diagnosis 13"

  DX14                       LENGTH=$5
  LABEL="Diagnosis 14"

  DX15                       LENGTH=$5
  LABEL="Diagnosis 15"

  DX16                       LENGTH=$5
  LABEL="Diagnosis 16"

  DX17                       LENGTH=$5
  LABEL="Diagnosis 17"

  DX18                       LENGTH=$5
  LABEL="Diagnosis 18"

  DX19                       LENGTH=$5
  LABEL="Diagnosis 19"

  DX20                       LENGTH=$5
  LABEL="Diagnosis 20"

  DX21                       LENGTH=$5
  LABEL="Diagnosis 21"

  DX22                       LENGTH=$5
  LABEL="Diagnosis 22"

  DX23                       LENGTH=$5
  LABEL="Diagnosis 23"

  DX24                       LENGTH=$5
  LABEL="Diagnosis 24"

  DX25                       LENGTH=$5
  LABEL="Diagnosis 25"

  DXCCS1                     LENGTH=4
  LABEL="CCS: diagnosis 1"

  DXCCS2                     LENGTH=4
  LABEL="CCS: diagnosis 2"

  DXCCS3                     LENGTH=4
  LABEL="CCS: diagnosis 3"

  DXCCS4                     LENGTH=4
  LABEL="CCS: diagnosis 4"

  DXCCS5                     LENGTH=4
  LABEL="CCS: diagnosis 5"

  DXCCS6                     LENGTH=4
  LABEL="CCS: diagnosis 6"

  DXCCS7                     LENGTH=4
  LABEL="CCS: diagnosis 7"

  DXCCS8                     LENGTH=4
  LABEL="CCS: diagnosis 8"

  DXCCS9                     LENGTH=4
  LABEL="CCS: diagnosis 9"

  DXCCS10                    LENGTH=4
  LABEL="CCS: diagnosis 10"

  DXCCS11                    LENGTH=4
  LABEL="CCS: diagnosis 11"

  DXCCS12                    LENGTH=4
  LABEL="CCS: diagnosis 12"

  DXCCS13                    LENGTH=4
  LABEL="CCS: diagnosis 13"

  DXCCS14                    LENGTH=4
  LABEL="CCS: diagnosis 14"

  DXCCS15                    LENGTH=4
  LABEL="CCS: diagnosis 15"

  DXCCS16                    LENGTH=4
  LABEL="CCS: diagnosis 16"

  DXCCS17                    LENGTH=4
  LABEL="CCS: diagnosis 17"

  DXCCS18                    LENGTH=4
  LABEL="CCS: diagnosis 18"

  DXCCS19                    LENGTH=4
  LABEL="CCS: diagnosis 19"

  DXCCS20                    LENGTH=4
  LABEL="CCS: diagnosis 20"

  DXCCS21                    LENGTH=4
  LABEL="CCS: diagnosis 21"

  DXCCS22                    LENGTH=4
  LABEL="CCS: diagnosis 22"

  DXCCS23                    LENGTH=4
  LABEL="CCS: diagnosis 23"

  DXCCS24                    LENGTH=4
  LABEL="CCS: diagnosis 24"

  DXCCS25                    LENGTH=4
  LABEL="CCS: diagnosis 25"

  ECODE1                     LENGTH=$5
  LABEL="E code 1"

  ECODE2                     LENGTH=$5
  LABEL="E code 2"

  ECODE3                     LENGTH=$5
  LABEL="E code 3"

  ECODE4                     LENGTH=$5
  LABEL="E code 4"

  ELECTIVE                   LENGTH=3
  LABEL="Elective versus non-elective admission"

  E_CCS1                     LENGTH=3
  LABEL="CCS: E Code 1"

  E_CCS2                     LENGTH=3
  LABEL="CCS: E Code 2"

  E_CCS3                     LENGTH=3
  LABEL="CCS: E Code 3"

  E_CCS4                     LENGTH=3
  LABEL="CCS: E Code 4"

  FEMALE                     LENGTH=3
  LABEL="Indicator of sex"

  HCUP_ED                    LENGTH=3
  LABEL="HCUP Emergency Department service indicator"

  HOSPBRTH                   LENGTH=3
  LABEL="Indicator of birth in this hospital"

  HOSPST                     LENGTH=$2           FORMAT=$2.
  LABEL="Hospital state postal code"

  KID_STRATUM                LENGTH=4            FORMAT=4.
  LABEL="Stratum used to sample hospital"

  LOS                        LENGTH=4
  LABEL="Length of stay (cleaned)"

  LOS_X                      LENGTH=4
  LABEL="Length of stay (as received from source)"

  MDC                        LENGTH=3
  LABEL="MDC in effect on discharge date"

  MDC24                      LENGTH=3
  LABEL="MDC, version 24"

  MDC_NoPOA                  LENGTH=3
  LABEL="MDC in use on discharge date, calculated without POA"

  MDNUM1_R                   LENGTH=5
  LABEL="Physician 1 number (re-identified)"

  MDNUM2_R                   LENGTH=5
  LABEL="Physician 2 number (re-identified)"

  NCHRONIC                   LENGTH=3
  LABEL="Number of chronic conditions"

  NDX                        LENGTH=3
  LABEL="Number of diagnoses on this record"

  NECODE                     LENGTH=3
  LABEL="Number of E codes on this record"

  NEOMAT                     LENGTH=3
  LABEL="Neonatal and/or maternal DX and/or PR"

  NPR                        LENGTH=3
  LABEL="Number of procedures on this record"

  ORPROC                     LENGTH=3
  LABEL="Major operating room procedure indicator"

  PAY1                       LENGTH=3
  LABEL="Primary expected payer (uniform)"

  PAY1_X                     LENGTH=$10
  LABEL="Primary expected payer (as received from source)"

  PAY2                       LENGTH=3
  LABEL="Secondary expected payer (uniform)"

  PAY2_X                     LENGTH=$10
  LABEL="Secondary expected payer (as received from source)"

  PL_NCHS2006                LENGTH=3
  LABEL="Patient Location: NCHS Urban-Rural Code (V2006)"

  PR1                        LENGTH=$4
  LABEL="Procedure 1"

  PR2                        LENGTH=$4
  LABEL="Procedure 2"

  PR3                        LENGTH=$4
  LABEL="Procedure 3"

  PR4                        LENGTH=$4
  LABEL="Procedure 4"

  PR5                        LENGTH=$4
  LABEL="Procedure 5"

  PR6                        LENGTH=$4
  LABEL="Procedure 6"

  PR7                        LENGTH=$4
  LABEL="Procedure 7"

  PR8                        LENGTH=$4
  LABEL="Procedure 8"

  PR9                        LENGTH=$4
  LABEL="Procedure 9"

  PR10                       LENGTH=$4
  LABEL="Procedure 10"

  PR11                       LENGTH=$4
  LABEL="Procedure 11"

  PR12                       LENGTH=$4
  LABEL="Procedure 12"

  PR13                       LENGTH=$4
  LABEL="Procedure 13"

  PR14                       LENGTH=$4
  LABEL="Procedure 14"

  PR15                       LENGTH=$4
  LABEL="Procedure 15"

  PRCCS1                     LENGTH=3
  LABEL="CCS: procedure 1"

  PRCCS2                     LENGTH=3
  LABEL="CCS: procedure 2"

  PRCCS3                     LENGTH=3
  LABEL="CCS: procedure 3"

  PRCCS4                     LENGTH=3
  LABEL="CCS: procedure 4"

  PRCCS5                     LENGTH=3
  LABEL="CCS: procedure 5"

  PRCCS6                     LENGTH=3
  LABEL="CCS: procedure 6"

  PRCCS7                     LENGTH=3
  LABEL="CCS: procedure 7"

  PRCCS8                     LENGTH=3
  LABEL="CCS: procedure 8"

  PRCCS9                     LENGTH=3
  LABEL="CCS: procedure 9"

  PRCCS10                    LENGTH=3
  LABEL="CCS: procedure 10"

  PRCCS11                    LENGTH=3
  LABEL="CCS: procedure 11"

  PRCCS12                    LENGTH=3
  LABEL="CCS: procedure 12"

  PRCCS13                    LENGTH=3
  LABEL="CCS: procedure 13"

  PRCCS14                    LENGTH=3
  LABEL="CCS: procedure 14"

  PRCCS15                    LENGTH=3
  LABEL="CCS: procedure 15"

  PRDAY1                     LENGTH=4
  LABEL="Number of days from admission to PR1"

  PRDAY2                     LENGTH=4
  LABEL="Number of days from admission to PR2"

  PRDAY3                     LENGTH=4
  LABEL="Number of days from admission to PR3"

  PRDAY4                     LENGTH=4
  LABEL="Number of days from admission to PR4"

  PRDAY5                     LENGTH=4
  LABEL="Number of days from admission to PR5"

  PRDAY6                     LENGTH=4
  LABEL="Number of days from admission to PR6"

  PRDAY7                     LENGTH=4
  LABEL="Number of days from admission to PR7"

  PRDAY8                     LENGTH=4
  LABEL="Number of days from admission to PR8"

  PRDAY9                     LENGTH=4
  LABEL="Number of days from admission to PR9"

  PRDAY10                    LENGTH=4
  LABEL="Number of days from admission to PR10"

  PRDAY11                    LENGTH=4
  LABEL="Number of days from admission to PR11"

  PRDAY12                    LENGTH=4
  LABEL="Number of days from admission to PR12"

  PRDAY13                    LENGTH=4
  LABEL="Number of days from admission to PR13"

  PRDAY14                    LENGTH=4
  LABEL="Number of days from admission to PR14"

  PRDAY15                    LENGTH=4
  LABEL="Number of days from admission to PR15"

  PointOfOriginUB04          LENGTH=$1
  LABEL="Point of origin for admission or visit, UB-04 standard coding"

  PointOfOrigin_X            LENGTH=$8
  LABEL="Point of origin for admission or visit, as received from source"

  RACE                       LENGTH=3
  LABEL="Race (uniform)"

  TOTCHG                     LENGTH=6
  LABEL="Total charges (cleaned)"

  TOTCHG_X                   LENGTH=7
  LABEL="Total charges (as received from source)"

  TRAN_IN                    LENGTH=3
  LABEL="Transfer in indicator"

  UNCBRTH                    LENGTH=3
  LABEL="Normal uncomplicated birth in hospital"

  YEAR                       LENGTH=3
  LABEL="Calendar year"

  ZIPINC_QRTL                LENGTH=3
  LABEL="Median household income national quartile for patient ZIP Code"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSPID                   5.
      @6      RECNUM                   N8PF.
      @14     AGE                      N3PF.
      @17     AGEDAY                   N3PF.
      @20     AGEMONTH                 N3PF.
      @23     AMONTH                   N2PF.
      @25     ASOURCE                  N2PF.
      @27     ASOURCEUB92              $CHAR1.
      @28     ASOURCE_X                $CHAR3.
      @31     ATYPE                    N2PF.
      @33     AWEEKEND                 N2PF.
      @35     BWT                      N4PF.
      @39     DIED                     N2PF.
      @41     DISCWT                   N11P7F.
      @52     DISPUB04                 N2PF.
      @54     DISPUNIFORM              N2PF.
      @56     DQTR                     N2PF.
      @58     DQTR_X                   N2PF.
      @60     DRG                      N3PF.
      @63     DRG24                    N3PF.
      @66     DRGVER                   N2PF.
      @68     DRG_NoPOA                N3PF.
      @71     DSHOSPID                 $CHAR17.
      @88     DX1                      $CHAR5.
      @93     DX2                      $CHAR5.
      @98     DX3                      $CHAR5.
      @103    DX4                      $CHAR5.
      @108    DX5                      $CHAR5.
      @113    DX6                      $CHAR5.
      @118    DX7                      $CHAR5.
      @123    DX8                      $CHAR5.
      @128    DX9                      $CHAR5.
      @133    DX10                     $CHAR5.
      @138    DX11                     $CHAR5.
      @143    DX12                     $CHAR5.
      @148    DX13                     $CHAR5.
      @153    DX14                     $CHAR5.
      @158    DX15                     $CHAR5.
      @163    DX16                     $CHAR5.
      @168    DX17                     $CHAR5.
      @173    DX18                     $CHAR5.
      @178    DX19                     $CHAR5.
      @183    DX20                     $CHAR5.
      @188    DX21                     $CHAR5.
      @193    DX22                     $CHAR5.
      @198    DX23                     $CHAR5.
      @203    DX24                     $CHAR5.
      @208    DX25                     $CHAR5.
      @213    DXCCS1                   N3PF.
      @216    DXCCS2                   N3PF.
      @219    DXCCS3                   N3PF.
      @222    DXCCS4                   N3PF.
      @225    DXCCS5                   N3PF.
      @228    DXCCS6                   N3PF.
      @231    DXCCS7                   N3PF.
      @234    DXCCS8                   N3PF.
      @237    DXCCS9                   N3PF.
      @240    DXCCS10                  N3PF.
      @243    DXCCS11                  N3PF.
      @246    DXCCS12                  N3PF.
      @249    DXCCS13                  N3PF.
      @252    DXCCS14                  N3PF.
      @255    DXCCS15                  N3PF.
      @258    DXCCS16                  N3PF.
      @261    DXCCS17                  N3PF.
      @264    DXCCS18                  N3PF.
      @267    DXCCS19                  N3PF.
      @270    DXCCS20                  N3PF.
      @273    DXCCS21                  N3PF.
      @276    DXCCS22                  N3PF.
      @279    DXCCS23                  N3PF.
      @282    DXCCS24                  N3PF.
      @285    DXCCS25                  N3PF.
      @288    ECODE1                   $CHAR5.
      @293    ECODE2                   $CHAR5.
      @298    ECODE3                   $CHAR5.
      @303    ECODE4                   $CHAR5.
      @308    ELECTIVE                 N2PF.
      @310    E_CCS1                   N4PF.
      @314    E_CCS2                   N4PF.
      @318    E_CCS3                   N4PF.
      @322    E_CCS4                   N4PF.
      @326    FEMALE                   N2PF.
      @328    HCUP_ED                  N3PF.
      @331    HOSPBRTH                 N2PF.
      @333    HOSPST                   $CHAR2.
      @335    KID_STRATUM              N4PF.
      @339    LOS                      N5PF.
      @344    LOS_X                    N6PF.
      @350    MDC                      N2PF.
      @352    MDC24                    N2PF.
      @354    MDC_NoPOA                N2PF.
      @356    MDNUM1_R                 N5PF.
      @361    MDNUM2_R                 N5PF.
      @366    NCHRONIC                 N2PF.
      @368    NDX                      N2PF.
      @370    NECODE                   N3PF.
      @373    NEOMAT                   N2PF.
      @375    NPR                      N2PF.
      @377    ORPROC                   N2PF.
      @379    PAY1                     N2PF.
      @381    PAY1_X                   $CHAR10.
      @391    PAY2                     N2PF.
      @393    PAY2_X                   $CHAR10.
      @403    PL_NCHS2006              N3PF.
      @406    PR1                      $CHAR4.
      @410    PR2                      $CHAR4.
      @414    PR3                      $CHAR4.
      @418    PR4                      $CHAR4.
      @422    PR5                      $CHAR4.
      @426    PR6                      $CHAR4.
      @430    PR7                      $CHAR4.
      @434    PR8                      $CHAR4.
      @438    PR9                      $CHAR4.
      @442    PR10                     $CHAR4.
      @446    PR11                     $CHAR4.
      @450    PR12                     $CHAR4.
      @454    PR13                     $CHAR4.
      @458    PR14                     $CHAR4.
      @462    PR15                     $CHAR4.
      @466    PRCCS1                   N3PF.
      @469    PRCCS2                   N3PF.
      @472    PRCCS3                   N3PF.
      @475    PRCCS4                   N3PF.
      @478    PRCCS5                   N3PF.
      @481    PRCCS6                   N3PF.
      @484    PRCCS7                   N3PF.
      @487    PRCCS8                   N3PF.
      @490    PRCCS9                   N3PF.
      @493    PRCCS10                  N3PF.
      @496    PRCCS11                  N3PF.
      @499    PRCCS12                  N3PF.
      @502    PRCCS13                  N3PF.
      @505    PRCCS14                  N3PF.
      @508    PRCCS15                  N3PF.
      @511    PRDAY1                   N3PF.
      @514    PRDAY2                   N3PF.
      @517    PRDAY3                   N3PF.
      @520    PRDAY4                   N3PF.
      @523    PRDAY5                   N3PF.
      @526    PRDAY6                   N3PF.
      @529    PRDAY7                   N3PF.
      @532    PRDAY8                   N3PF.
      @535    PRDAY9                   N3PF.
      @538    PRDAY10                  N3PF.
      @541    PRDAY11                  N3PF.
      @544    PRDAY12                  N3PF.
      @547    PRDAY13                  N3PF.
      @550    PRDAY14                  N3PF.
      @553    PRDAY15                  N3PF.
      @556    PointOfOriginUB04        $CHAR1.
      @557    PointOfOrigin_X          $CHAR8.
      @565    RACE                     N2PF.
      @567    TOTCHG                   N10PF.
      @577    TOTCHG_X                 N15P2F.
      @592    TRAN_IN                  N2PF.
      @594    UNCBRTH                  N2PF.
      @596    YEAR                     N4PF.
      @600    ZIPINC_QRTL              N2PF.
      ;
RUN;
