/*****************************************************************************
* SPSSload_KID_2009_Core.SPS
* This program will load the 2009 KID ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2009_Core.ASC' FIXED / 
    HOSPID                     1-  5
    RECNUM                     6- 13
    AGE                       14- 16
    AGEDAY                    17- 19
    AGEMONTH                  20- 22
    AMONTH                    23- 24
    ASOURCE                   25- 26
    ASOURCEUB92               27     (A)
    ASOURCE_X                 28- 30 (A)
    ATYPE                     31- 32
    AWEEKEND                  33- 34
    BWT                       35- 38
    DIED                      39- 40
    DISCWT                    41- 51
    DISPUB04                  52- 53
    DISPUNIFORM               54- 55
    DQTR                      56- 57
    DQTR_X                    58- 59
    DRG                       60- 62
    DRG24                     63- 65
    DRGVER                    66- 67
    DRG_NoPOA                 68- 70
    DSHOSPID                  71- 87 (A)
    DX1                       88- 92 (A)
    DX2                       93- 97 (A)
    DX3                       98-102 (A)
    DX4                      103-107 (A)
    DX5                      108-112 (A)
    DX6                      113-117 (A)
    DX7                      118-122 (A)
    DX8                      123-127 (A)
    DX9                      128-132 (A)
    DX10                     133-137 (A)
    DX11                     138-142 (A)
    DX12                     143-147 (A)
    DX13                     148-152 (A)
    DX14                     153-157 (A)
    DX15                     158-162 (A)
    DX16                     163-167 (A)
    DX17                     168-172 (A)
    DX18                     173-177 (A)
    DX19                     178-182 (A)
    DX20                     183-187 (A)
    DX21                     188-192 (A)
    DX22                     193-197 (A)
    DX23                     198-202 (A)
    DX24                     203-207 (A)
    DX25                     208-212 (A)
    DXCCS1                   213-215
    DXCCS2                   216-218
    DXCCS3                   219-221
    DXCCS4                   222-224
    DXCCS5                   225-227
    DXCCS6                   228-230
    DXCCS7                   231-233
    DXCCS8                   234-236
    DXCCS9                   237-239
    DXCCS10                  240-242
    DXCCS11                  243-245
    DXCCS12                  246-248
    DXCCS13                  249-251
    DXCCS14                  252-254
    DXCCS15                  255-257
    DXCCS16                  258-260
    DXCCS17                  261-263
    DXCCS18                  264-266
    DXCCS19                  267-269
    DXCCS20                  270-272
    DXCCS21                  273-275
    DXCCS22                  276-278
    DXCCS23                  279-281
    DXCCS24                  282-284
    DXCCS25                  285-287
    ECODE1                   288-292 (A)
    ECODE2                   293-297 (A)
    ECODE3                   298-302 (A)
    ECODE4                   303-307 (A)
    ELECTIVE                 308-309
    E_CCS1                   310-313
    E_CCS2                   314-317
    E_CCS3                   318-321
    E_CCS4                   322-325
    FEMALE                   326-327
    HCUP_ED                  328-330
    HOSPBRTH                 331-332
    HOSPST                   333-334 (A)
    KID_STRATUM              335-338
    LOS                      339-343
    LOS_X                    344-349
    MDC                      350-351
    MDC24                    352-353
    MDC_NoPOA                354-355
    MDNUM1_R                 356-360
    MDNUM2_R                 361-365
    NCHRONIC                 366-367
    NDX                      368-369
    NECODE                   370-372
    NEOMAT                   373-374
    NPR                      375-376
    ORPROC                   377-378
    PAY1                     379-380
    PAY1_X                   381-390 (A)
    PAY2                     391-392
    PAY2_X                   393-402 (A)
    PL_NCHS2006              403-405
    PR1                      406-409 (A)
    PR2                      410-413 (A)
    PR3                      414-417 (A)
    PR4                      418-421 (A)
    PR5                      422-425 (A)
    PR6                      426-429 (A)
    PR7                      430-433 (A)
    PR8                      434-437 (A)
    PR9                      438-441 (A)
    PR10                     442-445 (A)
    PR11                     446-449 (A)
    PR12                     450-453 (A)
    PR13                     454-457 (A)
    PR14                     458-461 (A)
    PR15                     462-465 (A)
    PRCCS1                   466-468
    PRCCS2                   469-471
    PRCCS3                   472-474
    PRCCS4                   475-477
    PRCCS5                   478-480
    PRCCS6                   481-483
    PRCCS7                   484-486
    PRCCS8                   487-489
    PRCCS9                   490-492
    PRCCS10                  493-495
    PRCCS11                  496-498
    PRCCS12                  499-501
    PRCCS13                  502-504
    PRCCS14                  505-507
    PRCCS15                  508-510
    PRDAY1                   511-513
    PRDAY2                   514-516
    PRDAY3                   517-519
    PRDAY4                   520-522
    PRDAY5                   523-525
    PRDAY6                   526-528
    PRDAY7                   529-531
    PRDAY8                   532-534
    PRDAY9                   535-537
    PRDAY10                  538-540
    PRDAY11                  541-543
    PRDAY12                  544-546
    PRDAY13                  547-549
    PRDAY14                  550-552
    PRDAY15                  553-555
    PointOfOriginUB04        556     (A)
    PointOfOrigin_X          557-564 (A)
    RACE                     565-566
    TOTCHG                   567-576
    TOTCHG_X                 577-591
    TRAN_IN                  592-593
    UNCBRTH                  594-595
    YEAR                     596-599
    ZIPINC_QRTL              600-601.

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    RECNUM                   (F8.0) /
    AGE                      (F3.0) /
    AGEDAY                   (F3.0) /
    AGEMONTH                 (F3.0) /
    AMONTH                   (F2.0) /
    ASOURCE                  (F2.0) /
    ATYPE                    (F2.0) /
    AWEEKEND                 (F2.0) /
    BWT                      (F4.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUB04                 (F2.0) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DQTR_X                   (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    DXCCS16                  (F3.0) /
    DXCCS17                  (F3.0) /
    DXCCS18                  (F3.0) /
    DXCCS19                  (F3.0) /
    DXCCS20                  (F3.0) /
    DXCCS21                  (F3.0) /
    DXCCS22                  (F3.0) /
    DXCCS23                  (F3.0) /
    DXCCS24                  (F3.0) /
    DXCCS25                  (F3.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSPBRTH                 (F2.0) /
    KID_STRATUM              (F4.0) /
    LOS                      (F5.0) /
    LOS_X                    (F6.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDC_NoPOA                (F2.0) /
    MDNUM1_R                 (F5.0) /
    MDNUM2_R                 (F5.0) /
    NCHRONIC                 (F2.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NPR                      (F2.0) /
    ORPROC                   (F2.0) /
    PAY1                     (F2.0) /
    PAY2                     (F2.0) /
    PL_NCHS2006              (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TOTCHG_X                 (F15.2) /
    TRAN_IN                  (F2.0) /
    UNCBRTH                  (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    RECNUM                   "HCUP record number"
    AGE                      "Age in years at admission"
    AGEDAY                   "Age in days (when age < 1 year)"
    AGEMONTH                 "Age in months (when age < 11 years)"
    AMONTH                   "Admission month"
    ASOURCE                  "Admission source (uniform)"
    ASOURCEUB92              "Admission source (UB-92 standard coding)"
    ASOURCE_X                "Admission source (as received from source)"
    ATYPE                    "Admission type"
    AWEEKEND                 "Admission day is a weekend"
    BWT                      "Birth weight in grams"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUB04                 "Disposition of patient (UB-04 standard coding)"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DQTR_X                   "Discharge quarter (as received from source)"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DSHOSPID                 "Data source hospital identifier"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DX16                     "Diagnosis 16"
    DX17                     "Diagnosis 17"
    DX18                     "Diagnosis 18"
    DX19                     "Diagnosis 19"
    DX20                     "Diagnosis 20"
    DX21                     "Diagnosis 21"
    DX22                     "Diagnosis 22"
    DX23                     "Diagnosis 23"
    DX24                     "Diagnosis 24"
    DX25                     "Diagnosis 25"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    DXCCS16                  "CCS: diagnosis 16"
    DXCCS17                  "CCS: diagnosis 17"
    DXCCS18                  "CCS: diagnosis 18"
    DXCCS19                  "CCS: diagnosis 19"
    DXCCS20                  "CCS: diagnosis 20"
    DXCCS21                  "CCS: diagnosis 21"
    DXCCS22                  "CCS: diagnosis 22"
    DXCCS23                  "CCS: diagnosis 23"
    DXCCS24                  "CCS: diagnosis 24"
    DXCCS25                  "CCS: diagnosis 25"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSPST                   "Hospital state postal code"
    KID_STRATUM              "Stratum used to sample hospital"
    LOS                      "Length of stay (cleaned)"
    LOS_X                    "Length of stay (as received from source)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    MDNUM1_R                 "Physician 1 number (re-identified)"
    MDNUM2_R                 "Physician 2 number (re-identified)"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NPR                      "Number of procedures on this record"
    ORPROC                   "Major operating room procedure indicator"
    PAY1                     "Primary expected payer (uniform)"
    PAY1_X                   "Primary expected payer (as received from source)"
    PAY2                     "Secondary expected payer (uniform)"
    PAY2_X                   "Secondary expected payer (as received from source)"
    PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
    PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TOTCHG_X                 "Total charges (as received from source)"
    TRAN_IN                  "Transfer in indicator"
    UNCBRTH                  "Normal uncomplicated birth in hospital"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGEDAY                   (-99 -88 -66=SYSMIS).
RECODE AGEMONTH                 (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE ASOURCE                  (-9 -8 -6 -5=SYSMIS).
RECODE ATYPE                    (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE BWT                      (-999 -888 -666=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUB04                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DQTR_X                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE DXCCS16                  (-99 -88 -66=SYSMIS).
RECODE DXCCS17                  (-99 -88 -66=SYSMIS).
RECODE DXCCS18                  (-99 -88 -66=SYSMIS).
RECODE DXCCS19                  (-99 -88 -66=SYSMIS).
RECODE DXCCS20                  (-99 -88 -66=SYSMIS).
RECODE DXCCS21                  (-99 -88 -66=SYSMIS).
RECODE DXCCS22                  (-99 -88 -66=SYSMIS).
RECODE DXCCS23                  (-99 -88 -66=SYSMIS).
RECODE DXCCS24                  (-99 -88 -66=SYSMIS).
RECODE DXCCS25                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE LOS_X                    (-99999 -88888 -66666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE MDNUM1_R                 (-9999 -8888 -6666=SYSMIS).
RECODE MDNUM2_R                 (-9999 -8888 -6666=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2006              (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TOTCHG_X                 (-99999999999.99 -88888888888.88 -66666666666.66=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE UNCBRTH                  (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2009_Core.SAV' / COMPRESSED.
