/*****************************************************************************
* Stataload_KID_2009_Core.Do
* This program will load the 2009 KID ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSPID                      1-  5   ///
      long   RECNUM                      6- 13   ///
      int    AGE                        14- 16   ///
      int    AGEDAY                     17- 19   ///
      int    AGEMONTH                   20- 22   ///
      byte   AMONTH                     23- 24   ///
      byte   ASOURCE                    25- 26   ///
      str    ASOURCEUB92                27       ///
      str    ASOURCE_X                  28- 30   ///
      byte   ATYPE                      31- 32   ///
      byte   AWEEKEND                   33- 34   ///
      int    BWT                        35- 38   ///
      byte   DIED                       39- 40   ///
      double DISCWT                     41- 51   ///
      byte   DISPUB04                   52- 53   ///
      byte   DISPUNIFORM                54- 55   ///
      byte   DQTR                       56- 57   ///
      byte   DQTR_X                     58- 59   ///
      int    DRG                        60- 62   ///
      int    DRG24                      63- 65   ///
      byte   DRGVER                     66- 67   ///
      int    DRG_NoPOA                  68- 70   ///
      str    DSHOSPID                   71- 87   ///
      str    DX1                        88- 92   ///
      str    DX2                        93- 97   ///
      str    DX3                        98-102   ///
      str    DX4                       103-107   ///
      str    DX5                       108-112   ///
      str    DX6                       113-117   ///
      str    DX7                       118-122   ///
      str    DX8                       123-127   ///
      str    DX9                       128-132   ///
      str    DX10                      133-137   ///
      str    DX11                      138-142   ///
      str    DX12                      143-147   ///
      str    DX13                      148-152   ///
      str    DX14                      153-157   ///
      str    DX15                      158-162   ///
      str    DX16                      163-167   ///
      str    DX17                      168-172   ///
      str    DX18                      173-177   ///
      str    DX19                      178-182   ///
      str    DX20                      183-187   ///
      str    DX21                      188-192   ///
      str    DX22                      193-197   ///
      str    DX23                      198-202   ///
      str    DX24                      203-207   ///
      str    DX25                      208-212   ///
      int    DXCCS1                    213-215   ///
      int    DXCCS2                    216-218   ///
      int    DXCCS3                    219-221   ///
      int    DXCCS4                    222-224   ///
      int    DXCCS5                    225-227   ///
      int    DXCCS6                    228-230   ///
      int    DXCCS7                    231-233   ///
      int    DXCCS8                    234-236   ///
      int    DXCCS9                    237-239   ///
      int    DXCCS10                   240-242   ///
      int    DXCCS11                   243-245   ///
      int    DXCCS12                   246-248   ///
      int    DXCCS13                   249-251   ///
      int    DXCCS14                   252-254   ///
      int    DXCCS15                   255-257   ///
      int    DXCCS16                   258-260   ///
      int    DXCCS17                   261-263   ///
      int    DXCCS18                   264-266   ///
      int    DXCCS19                   267-269   ///
      int    DXCCS20                   270-272   ///
      int    DXCCS21                   273-275   ///
      int    DXCCS22                   276-278   ///
      int    DXCCS23                   279-281   ///
      int    DXCCS24                   282-284   ///
      int    DXCCS25                   285-287   ///
      str    ECODE1                    288-292   ///
      str    ECODE2                    293-297   ///
      str    ECODE3                    298-302   ///
      str    ECODE4                    303-307   ///
      byte   ELECTIVE                  308-309   ///
      int    E_CCS1                    310-313   ///
      int    E_CCS2                    314-317   ///
      int    E_CCS3                    318-321   ///
      int    E_CCS4                    322-325   ///
      byte   FEMALE                    326-327   ///
      int    HCUP_ED                   328-330   ///
      byte   HOSPBRTH                  331-332   ///
      str    HOSPST                    333-334   ///
      int    KID_STRATUM               335-338   ///
      long   LOS                       339-343   ///
      long   LOS_X                     344-349   ///
      byte   MDC                       350-351   ///
      byte   MDC24                     352-353   ///
      byte   MDC_NoPOA                 354-355   ///
      long   MDNUM1_R                  356-360   ///
      long   MDNUM2_R                  361-365   ///
      byte   NCHRONIC                  366-367   ///
      byte   NDX                       368-369   ///
      int    NECODE                    370-372   ///
      byte   NEOMAT                    373-374   ///
      byte   NPR                       375-376   ///
      byte   ORPROC                    377-378   ///
      byte   PAY1                      379-380   ///
      str    PAY1_X                    381-390   ///
      byte   PAY2                      391-392   ///
      str    PAY2_X                    393-402   ///
      int    PL_NCHS2006               403-405   ///
      str    PR1                       406-409   ///
      str    PR2                       410-413   ///
      str    PR3                       414-417   ///
      str    PR4                       418-421   ///
      str    PR5                       422-425   ///
      str    PR6                       426-429   ///
      str    PR7                       430-433   ///
      str    PR8                       434-437   ///
      str    PR9                       438-441   ///
      str    PR10                      442-445   ///
      str    PR11                      446-449   ///
      str    PR12                      450-453   ///
      str    PR13                      454-457   ///
      str    PR14                      458-461   ///
      str    PR15                      462-465   ///
      int    PRCCS1                    466-468   ///
      int    PRCCS2                    469-471   ///
      int    PRCCS3                    472-474   ///
      int    PRCCS4                    475-477   ///
      int    PRCCS5                    478-480   ///
      int    PRCCS6                    481-483   ///
      int    PRCCS7                    484-486   ///
      int    PRCCS8                    487-489   ///
      int    PRCCS9                    490-492   ///
      int    PRCCS10                   493-495   ///
      int    PRCCS11                   496-498   ///
      int    PRCCS12                   499-501   ///
      int    PRCCS13                   502-504   ///
      int    PRCCS14                   505-507   ///
      int    PRCCS15                   508-510   ///
      int    PRDAY1                    511-513   ///
      int    PRDAY2                    514-516   ///
      int    PRDAY3                    517-519   ///
      int    PRDAY4                    520-522   ///
      int    PRDAY5                    523-525   ///
      int    PRDAY6                    526-528   ///
      int    PRDAY7                    529-531   ///
      int    PRDAY8                    532-534   ///
      int    PRDAY9                    535-537   ///
      int    PRDAY10                   538-540   ///
      int    PRDAY11                   541-543   ///
      int    PRDAY12                   544-546   ///
      int    PRDAY13                   547-549   ///
      int    PRDAY14                   550-552   ///
      int    PRDAY15                   553-555   ///
      str    PointOfOriginUB04         556       ///
      str    PointOfOrigin_X           557-564   ///
      byte   RACE                      565-566   ///
      double TOTCHG                    567-576   ///
      double TOTCHG_X                  577-591   ///
      byte   TRAN_IN                   592-593   ///
      byte   UNCBRTH                   594-595   ///
      int    YEAR                      596-599   ///
      byte   ZIPINC_QRTL               600-601   ///
      using  "KID_2009_Core.ASC"

***  Assign labels to the data elements ***
label var HOSPID                   "HCUP hospital identification number"
label var RECNUM                   "HCUP record number"
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ASOURCE                  "Admission source (uniform)"
label var ASOURCEUB92              "Admission source (UB-92 standard coding)"
label var ASOURCE_X                "Admission source (as received from source)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BWT                      "Birth weight in grams"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "Weight to discharges in AHA universe"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DQTR_X                   "Discharge quarter (as received from source)"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var KID_STRATUM              "Stratum used to sample hospital"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var NCHRONIC                 "Number of chronic conditions"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var TRAN_IN                  "Transfer in indicator"
label var UNCBRTH                  "Normal uncomplicated birth in hospital"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode RECNUM                    (-9999999 -8888888 -6666666=.)
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ASOURCE                   (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode BWT                       (-999 -888 -666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DQTR_X                    (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode DXCCS16                   (-99 -88 -66=.)
recode DXCCS17                   (-99 -88 -66=.)
recode DXCCS18                   (-99 -88 -66=.)
recode DXCCS19                   (-99 -88 -66=.)
recode DXCCS20                   (-99 -88 -66=.)
recode DXCCS21                   (-99 -88 -66=.)
recode DXCCS22                   (-99 -88 -66=.)
recode DXCCS23                   (-99 -88 -66=.)
recode DXCCS24                   (-99 -88 -66=.)
recode DXCCS25                   (-99 -88 -66=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-9999 -8888 -6666=.)
recode MDNUM2_R                  (-9999 -8888 -6666=.)
recode NCHRONIC                  (-9 -8 -6 -5=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-9 -8 -6 -5=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_NCHS2006               (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode UNCBRTH                   (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "KID_2009_Core.dta", replace
