/*****************************************************************************
* Stataload_KID_2012_Hospital.Do
* This program will load the 2012 KID ASCII Hospital File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSP_KID                    1-  5   ///
      byte   HOSP_BEDSIZE                6-  7   ///
      byte   HOSP_DIVISION               8-  9   ///
      byte   HOSP_LOCTEACH              10- 11   ///
      byte   HOSP_REGION                12- 13   ///
      byte   H_CONTRL                   14- 15   ///
      int    KID_STRATUM                16- 19   ///
      long   N_BRTH_U                   20- 27   ///
      long   N_DISC_U                   28- 35   ///
      int    N_HOSP_U                   36- 39   ///
      long   S_BRTH_U                   40- 47   ///
      long   S_CHLD_U                   48- 55   ///
      long   S_CMPB_U                   56- 63   ///
      long   S_DISC_U                   64- 71   ///
      int    S_HOSP_U                   72- 75   ///
      long   S_UNCB_U                   76- 83   ///
      int    YEAR                       84- 87   ///
      using  "KID_2012_Hospital.ASC"

***  Assign labels to the data elements ***
label var HOSP_KID                 "KID hospital number"
label var HOSP_BEDSIZE             "Bedsize of hospital"
label var HOSP_DIVISION            "Census division of hospital"
label var HOSP_LOCTEACH            "Location/teaching status of hospital"
label var HOSP_REGION              "Region of hospital"
label var H_CONTRL                 "Control/ownership of hospital"
label var KID_STRATUM              "KID hospital stratum"
label var N_BRTH_U                 "Number of universe births in the stratum"
label var N_DISC_U                 "Number of universe discharges in the stratum"
label var N_HOSP_U                 "Number of universe hospitals in the stratum"
label var S_BRTH_U                 "Number of sample births in the stratum"
label var S_CHLD_U                 "Number of sample pediatric non-births in the stratum"
label var S_CMPB_U                 "Number of sample complicated births in the stratum"
label var S_DISC_U                 "Number of sample births and children in the stratum"
label var S_HOSP_U                 "Number of sample hospitals in the stratum"
label var S_UNCB_U                 "Number of sample uncomplicated births in the stratum"
label var YEAR                     "Calendar year"

*** Convert special values to missing values ***
recode HOSP_KID                  (-9999 -8888 -6666=.)
recode HOSP_BEDSIZE              (-9 -8 -6 -5=.)
recode HOSP_DIVISION             (-9 -8 -6 -5=.)
recode HOSP_LOCTEACH             (-9 -8 -6 -5=.)
recode HOSP_REGION               (-9 -8 -6 -5=.)
recode H_CONTRL                  (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode N_BRTH_U                  (-9999999 -8888888 -6666666=.)
recode N_DISC_U                  (-9999999 -8888888 -6666666=.)
recode N_HOSP_U                  (-999 -888 -666=.)
recode S_BRTH_U                  (-9999999 -8888888 -6666666=.)
recode S_CHLD_U                  (-9999999 -8888888 -6666666=.)
recode S_CMPB_U                  (-9999999 -8888888 -6666666=.)
recode S_DISC_U                  (-9999999 -8888888 -6666666=.)
recode S_HOSP_U                  (-999 -888 -666=.)
recode S_UNCB_U                  (-9999999 -8888888 -6666666=.)
recode YEAR                      (-999 -888 -666=.)

save "KID_2012_Hospital.dta", replace
