/*****************************************************************************/
/* SPSSload_NASS_2021_Hospital.SPS                                          */
/* This program will load the NASS 2021 Hospital csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NASS_2021_Hospital.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_NASS                F5.0
    HOSP_LOCATION            F2.0
    HOSP_LOCTEACH            F2.0
    HOSP_REGION              F2.0
    HOSP_BEDSIZE_CAT         F2.0
    DISCWT                   F11.7
    NASS_STRATUM             A2
    N_DISC_U                 F8.0
    N_HOSP_U                 F4.0
    S_DISC_U                 F8.0
    S_HOSP_U                 F4.0
    TOTAL_AS_ENCOUNTERS      F8.0
    YEAR                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_NASS                "NASS Hospital Number"
    HOSP_LOCATION            "AHA: Location of Hospital, 0:rural, 1:urban"
    HOSP_LOCTEACH            "NASS: Location/teaching status of hospital"
    HOSP_REGION              "Hospital Census Region, 1:Northeast, 2:Midwest, 3:South, 4:West"
    HOSP_BEDSIZE_CAT         "Hospital Beds 1:0-99 2:100-299 3:300+"
    DISCWT                   "Encounter Weight"
    NASS_STRATUM             "NASS sample stratum"
    N_DISC_U                 "Total Number of AS Encounters for all Hospitals in NASS_STRATUM"
    N_HOSP_U                 "Total Number of Hospitals in NASS_STRATUM"
    S_DISC_U                 "Total Number of AS Encounters for Sampled Hospitals in NASS_STRATUM"
    S_HOSP_U                 "Total Number of Sampled Hospitals in NASS_STRATUM"
    TOTAL_AS_ENCOUNTERS      "SASD encounters with >= 1 narrow surgery"
    YEAR                     "Data Year" .

/* Convert special values to system missing values */
RECODE HOSP_NASS                (-9999 -8888 -6666=SYSMIS).
RECODE HOSP_LOCATION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_BEDSIZE_CAT         (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE TOTAL_AS_ENCOUNTERS      (-9999999 -8888888 -6666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NASS_2021_Hospital.SAV' / COMPRESSED.
