/*****************************************************************************/
/* SPSSload_NEDS_2011_ED.SPS                                          */
/* This program will load the 2011 NEDS csv ED File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2011_ED.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    CPTCCS1                  F4.0
    CPTCCS2                  F4.0
    CPTCCS3                  F4.0
    CPTCCS4                  F4.0
    CPTCCS5                  F4.0
    CPTCCS6                  F4.0
    CPTCCS7                  F4.0
    CPTCCS8                  F4.0
    CPTCCS9                  F4.0
    CPTCCS10                 F4.0
    CPTCCS11                 F4.0
    CPTCCS12                 F4.0
    CPTCCS13                 F4.0
    CPTCCS14                 F4.0
    CPTCCS15                 F4.0
    NCPT                     F4.0
    NPR_ED                   F3.0
    PCLASS_ED1               F3.0
    PCLASS_ED2               F3.0
    PCLASS_ED3               F3.0
    PCLASS_ED4               F3.0
    PCLASS_ED5               F3.0
    PCLASS_ED6               F3.0
    PCLASS_ED7               F3.0
    PCLASS_ED8               F3.0
    PCLASS_ED9               F3.0
    PR_ED1                   A4
    PR_ED2                   A4
    PR_ED3                   A4
    PR_ED4                   A4
    PR_ED5                   A4
    PR_ED6                   A4
    PR_ED7                   A4
    PR_ED8                   A4
    PR_ED9                   A4
    PRCCS_ED1                F3.0
    PRCCS_ED2                F3.0
    PRCCS_ED3                F3.0
    PRCCS_ED4                F3.0
    PRCCS_ED5                F3.0
    PRCCS_ED6                F3.0
    PRCCS_ED7                F3.0
    PRCCS_ED8                F3.0
    PRCCS_ED9                F3.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    CPT1                     "CPT/HCPCS procedure code 1"
    CPT2                     "CPT/HCPCS procedure code 2"
    CPT3                     "CPT/HCPCS procedure code 3"
    CPT4                     "CPT/HCPCS procedure code 4"
    CPT5                     "CPT/HCPCS procedure code 5"
    CPT6                     "CPT/HCPCS procedure code 6"
    CPT7                     "CPT/HCPCS procedure code 7"
    CPT8                     "CPT/HCPCS procedure code 8"
    CPT9                     "CPT/HCPCS procedure code 9"
    CPT10                    "CPT/HCPCS procedure code 10"
    CPT11                    "CPT/HCPCS procedure code 11"
    CPT12                    "CPT/HCPCS procedure code 12"
    CPT13                    "CPT/HCPCS procedure code 13"
    CPT14                    "CPT/HCPCS procedure code 14"
    CPT15                    "CPT/HCPCS procedure code 15"
    CPTCCS1                  "CCS: CPT 1"
    CPTCCS2                  "CCS: CPT 2"
    CPTCCS3                  "CCS: CPT 3"
    CPTCCS4                  "CCS: CPT 4"
    CPTCCS5                  "CCS: CPT 5"
    CPTCCS6                  "CCS: CPT 6"
    CPTCCS7                  "CCS: CPT 7"
    CPTCCS8                  "CCS: CPT 8"
    CPTCCS9                  "CCS: CPT 9"
    CPTCCS10                 "CCS: CPT 10"
    CPTCCS11                 "CCS: CPT 11"
    CPTCCS12                 "CCS: CPT 12"
    CPTCCS13                 "CCS: CPT 13"
    CPTCCS14                 "CCS: CPT 14"
    CPTCCS15                 "CCS: CPT 15"
    NCPT                     "Number of CPT/HCPCS procedures on this record"
    NPR_ED                   "Number of procedures from ED"
    PCLASS_ED1               "Principal procedure class for ED procedure"
    PCLASS_ED2               "Procedure class 2 for ED procedure"
    PCLASS_ED3               "Procedure class 3 for ED procedure"
    PCLASS_ED4               "Procedure class 4 for ED procedure"
    PCLASS_ED5               "Procedure class 5 for ED procedure"
    PCLASS_ED6               "Procedure class 6 for ED procedure"
    PCLASS_ED7               "Procedure class 7 for ED procedure"
    PCLASS_ED8               "Procedure class 8 for ED procedure"
    PCLASS_ED9               "Procedure class 9 for ED procedure"
    PR_ED1                   "Principal procedure from ED"
    PR_ED2                   "Procedure 2 from ED"
    PR_ED3                   "Procedure 3 from ED"
    PR_ED4                   "Procedure 4 from ED"
    PR_ED5                   "Procedure 5 from ED"
    PR_ED6                   "Procedure 6 from ED"
    PR_ED7                   "Procedure 7 from ED"
    PR_ED8                   "Procedure 8 from ED"
    PR_ED9                   "Procedure 9 from ED"
    PRCCS_ED1                "CCS: principal procedure from ED"
    PRCCS_ED2                "CCS: procedure 2 from ED"
    PRCCS_ED3                "CCS: procedure 3 from ED"
    PRCCS_ED4                "CCS: procedure 4 from ED"
    PRCCS_ED5                "CCS: procedure 5 from ED"
    PRCCS_ED6                "CCS: procedure 6 from ED"
    PRCCS_ED7                "CCS: procedure 7 from ED"
    PRCCS_ED8                "CCS: procedure 8 from ED"
    PRCCS_ED9                "CCS: procedure 9 from ED" .

/* Convert special values to system missing values */
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE CPTCCS1                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS2                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS3                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS4                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS5                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS6                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS7                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS8                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS9                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS10                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS11                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS12                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS13                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS14                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS15                 (-999 -888 -666=SYSMIS).
RECODE NCPT                     (-999 -888 -666=SYSMIS).
RECODE NPR_ED                   (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED1               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED2               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED3               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED4               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED5               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED6               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED7               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED8               (-99 -88 -66=SYSMIS).
RECODE PCLASS_ED9               (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED1                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED2                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED3                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED4                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED5                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED6                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED7                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED8                (-99 -88 -66=SYSMIS).
RECODE PRCCS_ED9                (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NEDS_2011_ED.SAV' / COMPRESSED.
