/*****************************************************************************/
/* SPSSload_NEDS_2010_IP.SPS                                          */
/* This program will load the 2010 NEDS csv IP File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2010_IP.csv"
    /delimiters = ',' 
    /variables = 
    DISCWT                   F11.7
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    DISP_IP                  F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NOPOA                F3.0
    LOS_IP                   F5.0
    MDC                      F2.0
    MDC_NOPOA                F2.0
    NPR_IP                   F3.0
    PCLASS_IP1               F3.0
    PCLASS_IP2               F3.0
    PCLASS_IP3               F3.0
    PCLASS_IP4               F3.0
    PCLASS_IP5               F3.0
    PCLASS_IP6               F3.0
    PCLASS_IP7               F3.0
    PCLASS_IP8               F3.0
    PCLASS_IP9               F3.0
    PR_IP1                   A4
    PR_IP2                   A4
    PR_IP3                   A4
    PR_IP4                   A4
    PR_IP5                   A4
    PR_IP6                   A4
    PR_IP7                   A4
    PR_IP8                   A4
    PR_IP9                   A4
    PRCCS_IP1                F3.0
    PRCCS_IP2                F3.0
    PRCCS_IP3                F3.0
    PRCCS_IP4                F3.0
    PRCCS_IP5                F3.0
    PRCCS_IP6                F3.0
    PRCCS_IP7                F3.0
    PRCCS_IP8                F3.0
    PRCCS_IP9                F3.0
    TOTCHG_IP                F12.2
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    DISCWT                   "Weight to ED Visits in AHA universe"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    DISP_IP                  "Disposition of patient (uniform) from IP"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NOPOA                "DRG in use on discharge date, calculated without POA"
    LOS_IP                   "Length of stay (cleaned) from IP"
    MDC                      "MDC in effect on discharge date"
    MDC_NOPOA                "MDC in use on discharge date, calculated without POA"
    NPR_IP                   "Number of procedures from inpatient discharge record"
    PCLASS_IP1               "Principal procedure class for inpatient procedure"
    PCLASS_IP2               "Procedure class 2 for inpatient procedure"
    PCLASS_IP3               "Procedure class 3 for inpatient procedure"
    PCLASS_IP4               "Procedure class 4 for inpatient procedure"
    PCLASS_IP5               "Procedure class 5 for inpatient procedure"
    PCLASS_IP6               "Procedure class 6 for inpatient procedure"
    PCLASS_IP7               "Procedure class 7 for inpatient procedure"
    PCLASS_IP8               "Procedure class 8 for inpatient procedure"
    PCLASS_IP9               "Procedure class 9 for inpatient procedure"
    PR_IP1                   "Principal procedure from inpatient discharge record"
    PR_IP2                   "Procedure 2 from inpatient discharge record"
    PR_IP3                   "Procedure 3 from inpatient discharge record"
    PR_IP4                   "Procedure 4 from inpatient discharge record"
    PR_IP5                   "Procedure 5 from inpatient discharge record"
    PR_IP6                   "Procedure 6 from inpatient discharge record"
    PR_IP7                   "Procedure 7 from inpatient discharge record"
    PR_IP8                   "Procedure 8 from inpatient discharge record"
    PR_IP9                   "Procedure 9 from inpatient discharge record"
    PRCCS_IP1                "CCS: principal procedure from inpatient discharge record"
    PRCCS_IP2                "CCS: procedure 2 from inpatient discharge record"
    PRCCS_IP3                "CCS: procedure 3 from inpatient discharge record"
    PRCCS_IP4                "CCS: procedure 4 from inpatient discharge record"
    PRCCS_IP5                "CCS: procedure 5 from inpatient discharge record"
    PRCCS_IP6                "CCS: procedure 6 from inpatient discharge record"
    PRCCS_IP7                "CCS: procedure 7 from inpatient discharge record"
    PRCCS_IP8                "CCS: procedure 8 from inpatient discharge record"
    PRCCS_IP9                "CCS: procedure 9 from inpatient discharge record"
    TOTCHG_IP                "Total charge for ED and inpatient services" .

/* Convert special values to system missing values */
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE DISP_IP                  (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NOPOA                (-99 -88 -66=SYSMIS).
RECODE LOS_IP                   (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NOPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NPR_IP                   (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP1               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP2               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP3               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP4               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP5               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP6               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP7               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP8               (-99 -88 -66=SYSMIS).
RECODE PCLASS_IP9               (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP1                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP2                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP3                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP4                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP5                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP6                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP7                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP8                (-99 -88 -66=SYSMIS).
RECODE PRCCS_IP9                (-99 -88 -66=SYSMIS).
RECODE TOTCHG_IP                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).

SAVE OUTFILE = 'NEDS_2010_IP.SAV' / COMPRESSED.
