/*****************************************************************************/
/* SPSSload_NEDS_2021_IP.SPS                                          */
/* This program will load the NEDS 2021 IP csv File into SPSS.         */
/* created on 03/01/2024.                                    */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2021_IP.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    DISP_IP                  F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NoPOA                F3.0
    I10_NPR_IP               F3.0
    I10_PR_IP1               A7
    I10_PR_IP2               A7
    I10_PR_IP3               A7
    I10_PR_IP4               A7
    I10_PR_IP5               A7
    I10_PR_IP6               A7
    I10_PR_IP7               A7
    I10_PR_IP8               A7
    I10_PR_IP9               A7
    I10_PR_IP10              A7
    I10_PR_IP11              A7
    I10_PR_IP12              A7
    I10_PR_IP13              A7
    I10_PR_IP14              A7
    I10_PR_IP15              A7
    LOS_IP                   F5.0
    MDC                      F2.0
    MDC_NoPOA                F2.0
    PCLASS1                  F3.0
    PCLASS2                  F3.0
    PCLASS3                  F3.0
    PCLASS4                  F3.0
    PCLASS5                  F3.0
    PCLASS6                  F3.0
    PCLASS7                  F3.0
    PCLASS8                  F3.0
    PCLASS9                  F3.0
    PCLASS10                 F3.0
    PCLASS11                 F3.0
    PCLASS12                 F3.0
    PCLASS13                 F3.0
    PCLASS14                 F3.0
    PCLASS15                 F3.0
    PCLASS_VERSION           A6
    PRCCSR_ADM001            F2.0
    PRCCSR_ADM002            F2.0
    PRCCSR_ADM003            F2.0
    PRCCSR_ADM004            F2.0
    PRCCSR_ADM005            F2.0
    PRCCSR_ADM006            F2.0
    PRCCSR_ADM007            F2.0
    PRCCSR_ADM008            F2.0
    PRCCSR_ADM009            F2.0
    PRCCSR_ADM010            F2.0
    PRCCSR_ADM011            F2.0
    PRCCSR_ADM012            F2.0
    PRCCSR_ADM013            F2.0
    PRCCSR_ADM014            F2.0
    PRCCSR_ADM015            F2.0
    PRCCSR_ADM016            F2.0
    PRCCSR_ADM017            F2.0
    PRCCSR_ADM018            F2.0
    PRCCSR_ADM019            F2.0
    PRCCSR_ADM020            F2.0
    PRCCSR_ADM021            F2.0
    PRCCSR_ADM022            F2.0
    PRCCSR_CAR001            F2.0
    PRCCSR_CAR002            F2.0
    PRCCSR_CAR003            F2.0
    PRCCSR_CAR004            F2.0
    PRCCSR_CAR005            F2.0
    PRCCSR_CAR006            F2.0
    PRCCSR_CAR007            F2.0
    PRCCSR_CAR008            F2.0
    PRCCSR_CAR009            F2.0
    PRCCSR_CAR010            F2.0
    PRCCSR_CAR011            F2.0
    PRCCSR_CAR012            F2.0
    PRCCSR_CAR013            F2.0
    PRCCSR_CAR014            F2.0
    PRCCSR_CAR015            F2.0
    PRCCSR_CAR016            F2.0
    PRCCSR_CAR017            F2.0
    PRCCSR_CAR018            F2.0
    PRCCSR_CAR019            F2.0
    PRCCSR_CAR020            F2.0
    PRCCSR_CAR021            F2.0
    PRCCSR_CAR022            F2.0
    PRCCSR_CAR023            F2.0
    PRCCSR_CAR024            F2.0
    PRCCSR_CAR025            F2.0
    PRCCSR_CAR026            F2.0
    PRCCSR_CAR027            F2.0
    PRCCSR_CAR028            F2.0
    PRCCSR_CAR029            F2.0
    PRCCSR_CHP001            F2.0
    PRCCSR_CNS001            F2.0
    PRCCSR_CNS002            F2.0
    PRCCSR_CNS003            F2.0
    PRCCSR_CNS004            F2.0
    PRCCSR_CNS005            F2.0
    PRCCSR_CNS006            F2.0
    PRCCSR_CNS007            F2.0
    PRCCSR_CNS008            F2.0
    PRCCSR_CNS009            F2.0
    PRCCSR_CNS010            F2.0
    PRCCSR_CNS011            F2.0
    PRCCSR_CNS012            F2.0
    PRCCSR_CNS013            F2.0
    PRCCSR_CNS014            F2.0
    PRCCSR_ENP001            F2.0
    PRCCSR_ENP002            F2.0
    PRCCSR_ENP003            F2.0
    PRCCSR_ENP004            F2.0
    PRCCSR_ENP005            F2.0
    PRCCSR_ENP006            F2.0
    PRCCSR_ENT001            F2.0
    PRCCSR_ENT002            F2.0
    PRCCSR_ENT003            F2.0
    PRCCSR_ENT004            F2.0
    PRCCSR_ENT005            F2.0
    PRCCSR_ENT006            F2.0
    PRCCSR_ENT007            F2.0
    PRCCSR_ENT008            F2.0
    PRCCSR_ENT009            F2.0
    PRCCSR_ENT010            F2.0
    PRCCSR_ENT011            F2.0
    PRCCSR_ENT012            F2.0
    PRCCSR_ENT013            F2.0
    PRCCSR_ENT014            F2.0
    PRCCSR_ENT015            F2.0
    PRCCSR_ENT016            F2.0
    PRCCSR_ENT017            F2.0
    PRCCSR_ESA001            F2.0
    PRCCSR_ESA002            F2.0
    PRCCSR_ESA003            F2.0
    PRCCSR_ESA004            F2.0
    PRCCSR_ESA005            F2.0
    PRCCSR_ESA006            F2.0
    PRCCSR_ESA007            F2.0
    PRCCSR_ESA008            F2.0
    PRCCSR_ESA009            F2.0
    PRCCSR_ESA010            F2.0
    PRCCSR_ESA011            F2.0
    PRCCSR_EST001            F2.0
    PRCCSR_EST002            F2.0
    PRCCSR_EST003            F2.0
    PRCCSR_EST004            F2.0
    PRCCSR_EST005            F2.0
    PRCCSR_EYP001            F2.0
    PRCCSR_EYP002            F2.0
    PRCCSR_FRS001            F2.0
    PRCCSR_FRS002            F2.0
    PRCCSR_FRS003            F2.0
    PRCCSR_FRS004            F2.0
    PRCCSR_FRS005            F2.0
    PRCCSR_FRS006            F2.0
    PRCCSR_FRS007            F2.0
    PRCCSR_FRS008            F2.0
    PRCCSR_FRS009            F2.0
    PRCCSR_FRS010            F2.0
    PRCCSR_FRS011            F2.0
    PRCCSR_FRS012            F2.0
    PRCCSR_FRS013            F2.0
    PRCCSR_FRS014            F2.0
    PRCCSR_FRS015            F2.0
    PRCCSR_GIS001            F2.0
    PRCCSR_GIS002            F2.0
    PRCCSR_GIS003            F2.0
    PRCCSR_GIS004            F2.0
    PRCCSR_GIS005            F2.0
    PRCCSR_GIS006            F2.0
    PRCCSR_GIS007            F2.0
    PRCCSR_GIS008            F2.0
    PRCCSR_GIS009            F2.0
    PRCCSR_GIS010            F2.0
    PRCCSR_GIS011            F2.0
    PRCCSR_GIS012            F2.0
    PRCCSR_GIS013            F2.0
    PRCCSR_GIS014            F2.0
    PRCCSR_GIS015            F2.0
    PRCCSR_GIS016            F2.0
    PRCCSR_GIS017            F2.0
    PRCCSR_GIS018            F2.0
    PRCCSR_GIS019            F2.0
    PRCCSR_GIS020            F2.0
    PRCCSR_GIS021            F2.0
    PRCCSR_GIS022            F2.0
    PRCCSR_GIS023            F2.0
    PRCCSR_GIS024            F2.0
    PRCCSR_GIS025            F2.0
    PRCCSR_GIS026            F2.0
    PRCCSR_GIS027            F2.0
    PRCCSR_GIS028            F2.0
    PRCCSR_GIS029            F2.0
    PRCCSR_GNR001            F2.0
    PRCCSR_GNR002            F2.0
    PRCCSR_GNR003            F2.0
    PRCCSR_GNR004            F2.0
    PRCCSR_GNR005            F2.0
    PRCCSR_GNR006            F2.0
    PRCCSR_GNR007            F2.0
    PRCCSR_GNR008            F2.0
    PRCCSR_GNR009            F2.0
    PRCCSR_GNR010            F2.0
    PRCCSR_HEP001            F2.0
    PRCCSR_HEP002            F2.0
    PRCCSR_HEP003            F2.0
    PRCCSR_HEP004            F2.0
    PRCCSR_HEP005            F2.0
    PRCCSR_HEP006            F2.0
    PRCCSR_HEP007            F2.0
    PRCCSR_HEP008            F2.0
    PRCCSR_HEP009            F2.0
    PRCCSR_HEP010            F2.0
    PRCCSR_HEP011            F2.0
    PRCCSR_HEP012            F2.0
    PRCCSR_HEP013            F2.0
    PRCCSR_IMG001            F2.0
    PRCCSR_IMG002            F2.0
    PRCCSR_IMG003            F2.0
    PRCCSR_IMG004            F2.0
    PRCCSR_IMG005            F2.0
    PRCCSR_IMG006            F2.0
    PRCCSR_IMG007            F2.0
    PRCCSR_IMG008            F2.0
    PRCCSR_IMG009            F2.0
    PRCCSR_IMG010            F2.0
    PRCCSR_LYM001            F2.0
    PRCCSR_LYM002            F2.0
    PRCCSR_LYM003            F2.0
    PRCCSR_LYM004            F2.0
    PRCCSR_LYM005            F2.0
    PRCCSR_LYM006            F2.0
    PRCCSR_LYM007            F2.0
    PRCCSR_LYM008            F2.0
    PRCCSR_LYM009            F2.0
    PRCCSR_LYM010            F2.0
    PRCCSR_LYM011            F2.0
    PRCCSR_MAM001            F2.0
    PRCCSR_MAM002            F2.0
    PRCCSR_MAM003            F2.0
    PRCCSR_MAM004            F2.0
    PRCCSR_MAM005            F2.0
    PRCCSR_MAM006            F2.0
    PRCCSR_MAM007            F2.0
    PRCCSR_MAM008            F2.0
    PRCCSR_MAM009            F2.0
    PRCCSR_MAM010            F2.0
    PRCCSR_MAM011            F2.0
    PRCCSR_MAM012            F2.0
    PRCCSR_MAM013            F2.0
    PRCCSR_MAM014            F2.0
    PRCCSR_MAM015            F2.0
    PRCCSR_MHT001            F2.0
    PRCCSR_MHT002            F2.0
    PRCCSR_MHT003            F2.0
    PRCCSR_MHT004            F2.0
    PRCCSR_MHT005            F2.0
    PRCCSR_MRS001            F2.0
    PRCCSR_MRS002            F2.0
    PRCCSR_MRS003            F2.0
    PRCCSR_MRS004            F2.0
    PRCCSR_MRS005            F2.0
    PRCCSR_MRS006            F2.0
    PRCCSR_MRS007            F2.0
    PRCCSR_MST001            F2.0
    PRCCSR_MST002            F2.0
    PRCCSR_MST003            F2.0
    PRCCSR_MST004            F2.0
    PRCCSR_MST005            F2.0
    PRCCSR_MST006            F2.0
    PRCCSR_MST007            F2.0
    PRCCSR_MST008            F2.0
    PRCCSR_MST009            F2.0
    PRCCSR_MST010            F2.0
    PRCCSR_MST011            F2.0
    PRCCSR_MST012            F2.0
    PRCCSR_MST013            F2.0
    PRCCSR_MST014            F2.0
    PRCCSR_MST015            F2.0
    PRCCSR_MST016            F2.0
    PRCCSR_MST017            F2.0
    PRCCSR_MST018            F2.0
    PRCCSR_MST019            F2.0
    PRCCSR_MST020            F2.0
    PRCCSR_MST021            F2.0
    PRCCSR_MST022            F2.0
    PRCCSR_MST023            F2.0
    PRCCSR_MST024            F2.0
    PRCCSR_MST025            F2.0
    PRCCSR_MST026            F2.0
    PRCCSR_MST027            F2.0
    PRCCSR_MST028            F2.0
    PRCCSR_MST029            F2.0
    PRCCSR_MST030            F2.0
    PRCCSR_NCM001            F2.0
    PRCCSR_NCM002            F2.0
    PRCCSR_NCM003            F2.0
    PRCCSR_NCM004            F2.0
    PRCCSR_OST001            F2.0
    PRCCSR_OTR001            F2.0
    PRCCSR_OTR002            F2.0
    PRCCSR_OTR003            F2.0
    PRCCSR_OTR004            F2.0
    PRCCSR_OTR005            F2.0
    PRCCSR_PGN001            F2.0
    PRCCSR_PGN002            F2.0
    PRCCSR_PGN003            F2.0
    PRCCSR_PGN004            F2.0
    PRCCSR_PGN005            F2.0
    PRCCSR_PGN006            F2.0
    PRCCSR_PGN007            F2.0
    PRCCSR_PGN008            F2.0
    PRCCSR_PGN009            F2.0
    PRCCSR_PLC001            F2.0
    PRCCSR_PLC002            F2.0
    PRCCSR_PNS001            F2.0
    PRCCSR_PNS002            F2.0
    PRCCSR_PNS003            F2.0
    PRCCSR_PNS004            F2.0
    PRCCSR_PNS005            F2.0
    PRCCSR_PNS006            F2.0
    PRCCSR_RAD001            F2.0
    PRCCSR_RAD002            F2.0
    PRCCSR_RAD003            F2.0
    PRCCSR_RAD004            F2.0
    PRCCSR_RES001            F2.0
    PRCCSR_RES002            F2.0
    PRCCSR_RES003            F2.0
    PRCCSR_RES004            F2.0
    PRCCSR_RES005            F2.0
    PRCCSR_RES006            F2.0
    PRCCSR_RES007            F2.0
    PRCCSR_RES008            F2.0
    PRCCSR_RES009            F2.0
    PRCCSR_RES010            F2.0
    PRCCSR_RES011            F2.0
    PRCCSR_RES012            F2.0
    PRCCSR_RES013            F2.0
    PRCCSR_RES014            F2.0
    PRCCSR_RHB001            F2.0
    PRCCSR_RHB002            F2.0
    PRCCSR_RHB003            F2.0
    PRCCSR_RHB004            F2.0
    PRCCSR_SKB001            F2.0
    PRCCSR_SKB002            F2.0
    PRCCSR_SKB003            F2.0
    PRCCSR_SKB004            F2.0
    PRCCSR_SKB005            F2.0
    PRCCSR_SKB006            F2.0
    PRCCSR_SKB007            F2.0
    PRCCSR_SKB008            F2.0
    PRCCSR_SKB009            F2.0
    PRCCSR_SKB010            F2.0
    PRCCSR_SUD001            F2.0
    PRCCSR_SUD002            F2.0
    PRCCSR_SUD003            F2.0
    PRCCSR_SUD004            F2.0
    PRCCSR_URN001            F2.0
    PRCCSR_URN002            F2.0
    PRCCSR_URN003            F2.0
    PRCCSR_URN004            F2.0
    PRCCSR_URN005            F2.0
    PRCCSR_URN006            F2.0
    PRCCSR_URN007            F2.0
    PRCCSR_URN008            F2.0
    PRCCSR_URN009            F2.0
    PRCCSR_URN010            F2.0
    PRCCSR_URN011            F2.0
    PRCCSR_URN012            F2.0
    PRCCSR_VERSION           A6
    TOTCHG_IP                F12.2
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    DISP_IP                  "Disposition of patient (uniform) from IP"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    I10_NPR_IP               "Number of ICD-10-PCS procedures from inpatient discharge record"
    I10_PR_IP1               "ICD-10-PCS Procedure 1 from inpatient discharge record"
    I10_PR_IP2               "ICD-10-PCS Procedure 2 from inpatient discharge record"
    I10_PR_IP3               "ICD-10-PCS Procedure 3 from inpatient discharge record"
    I10_PR_IP4               "ICD-10-PCS Procedure 4 from inpatient discharge record"
    I10_PR_IP5               "ICD-10-PCS Procedure 5 from inpatient discharge record"
    I10_PR_IP6               "ICD-10-PCS Procedure 6 from inpatient discharge record"
    I10_PR_IP7               "ICD-10-PCS Procedure 7 from inpatient discharge record"
    I10_PR_IP8               "ICD-10-PCS Procedure 8 from inpatient discharge record"
    I10_PR_IP9               "ICD-10-PCS Procedure 9 from inpatient discharge record"
    I10_PR_IP10              "ICD-10-PCS Procedure 10 from inpatient discharge record"
    I10_PR_IP11              "ICD-10-PCS Procedure 11 from inpatient discharge record"
    I10_PR_IP12              "ICD-10-PCS Procedure 12 from inpatient discharge record"
    I10_PR_IP13              "ICD-10-PCS Procedure 13 from inpatient discharge record"
    I10_PR_IP14              "ICD-10-PCS Procedure 14 from inpatient discharge record"
    I10_PR_IP15              "ICD-10-PCS Procedure 15 from inpatient discharge record"
    LOS_IP                   "Length of stay (cleaned) from IP"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    PCLASS1                  "ICD-10-PCS Procedure class 1"
    PCLASS2                  "ICD-10-PCS Procedure class 2"
    PCLASS3                  "ICD-10-PCS Procedure class 3"
    PCLASS4                  "ICD-10-PCS Procedure class 4"
    PCLASS5                  "ICD-10-PCS Procedure class 5"
    PCLASS6                  "ICD-10-PCS Procedure class 6"
    PCLASS7                  "ICD-10-PCS Procedure class 7"
    PCLASS8                  "ICD-10-PCS Procedure class 8"
    PCLASS9                  "ICD-10-PCS Procedure class 9"
    PCLASS10                 "ICD-10-PCS Procedure class 10"
    PCLASS11                 "ICD-10-PCS Procedure class 11"
    PCLASS12                 "ICD-10-PCS Procedure class 12"
    PCLASS13                 "ICD-10-PCS Procedure class 13"
    PCLASS14                 "ICD-10-PCS Procedure class 14"
    PCLASS15                 "ICD-10-PCS Procedure class 15"
    PCLASS_VERSION           "Version of ICD-10-PCS Procedure class"
    PRCCSR_ADM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM001"
    PRCCSR_ADM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM002"
    PRCCSR_ADM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM003"
    PRCCSR_ADM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM004"
    PRCCSR_ADM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM005"
    PRCCSR_ADM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM006"
    PRCCSR_ADM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM007"
    PRCCSR_ADM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM008"
    PRCCSR_ADM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM009"
    PRCCSR_ADM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM010"
    PRCCSR_ADM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM011"
    PRCCSR_ADM012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM012"
    PRCCSR_ADM013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM013"
    PRCCSR_ADM014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM014"
    PRCCSR_ADM015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM015"
    PRCCSR_ADM016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM016"
    PRCCSR_ADM017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM017"
    PRCCSR_ADM018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM018"
    PRCCSR_ADM019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM019"
    PRCCSR_ADM020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM020"
    PRCCSR_ADM021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM021"
    PRCCSR_ADM022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM022"
    PRCCSR_CAR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR001"
    PRCCSR_CAR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR002"
    PRCCSR_CAR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR003"
    PRCCSR_CAR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR004"
    PRCCSR_CAR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR005"
    PRCCSR_CAR006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR006"
    PRCCSR_CAR007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR007"
    PRCCSR_CAR008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR008"
    PRCCSR_CAR009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR009"
    PRCCSR_CAR010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR010"
    PRCCSR_CAR011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR011"
    PRCCSR_CAR012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR012"
    PRCCSR_CAR013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR013"
    PRCCSR_CAR014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR014"
    PRCCSR_CAR015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR015"
    PRCCSR_CAR016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR016"
    PRCCSR_CAR017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR017"
    PRCCSR_CAR018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR018"
    PRCCSR_CAR019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR019"
    PRCCSR_CAR020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR020"
    PRCCSR_CAR021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR021"
    PRCCSR_CAR022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR022"
    PRCCSR_CAR023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR023"
    PRCCSR_CAR024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR024"
    PRCCSR_CAR025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR025"
    PRCCSR_CAR026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR026"
    PRCCSR_CAR027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR027"
    PRCCSR_CAR028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR028"
    PRCCSR_CAR029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR029"
    PRCCSR_CHP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CHP001"
    PRCCSR_CNS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS001"
    PRCCSR_CNS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS002"
    PRCCSR_CNS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS003"
    PRCCSR_CNS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS004"
    PRCCSR_CNS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS005"
    PRCCSR_CNS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS006"
    PRCCSR_CNS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS007"
    PRCCSR_CNS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS008"
    PRCCSR_CNS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS009"
    PRCCSR_CNS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS010"
    PRCCSR_CNS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS011"
    PRCCSR_CNS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS012"
    PRCCSR_CNS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS013"
    PRCCSR_CNS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS014"
    PRCCSR_ENP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP001"
    PRCCSR_ENP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP002"
    PRCCSR_ENP003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP003"
    PRCCSR_ENP004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP004"
    PRCCSR_ENP005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP005"
    PRCCSR_ENP006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP006"
    PRCCSR_ENT001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT001"
    PRCCSR_ENT002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT002"
    PRCCSR_ENT003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT003"
    PRCCSR_ENT004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT004"
    PRCCSR_ENT005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT005"
    PRCCSR_ENT006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT006"
    PRCCSR_ENT007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT007"
    PRCCSR_ENT008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT008"
    PRCCSR_ENT009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT009"
    PRCCSR_ENT010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT010"
    PRCCSR_ENT011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT011"
    PRCCSR_ENT012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT012"
    PRCCSR_ENT013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT013"
    PRCCSR_ENT014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT014"
    PRCCSR_ENT015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT015"
    PRCCSR_ENT016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT016"
    PRCCSR_ENT017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT017"
    PRCCSR_ESA001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA001"
    PRCCSR_ESA002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA002"
    PRCCSR_ESA003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA003"
    PRCCSR_ESA004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA004"
    PRCCSR_ESA005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA005"
    PRCCSR_ESA006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA006"
    PRCCSR_ESA007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA007"
    PRCCSR_ESA008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA008"
    PRCCSR_ESA009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA009"
    PRCCSR_ESA010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA010"
    PRCCSR_ESA011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA011"
    PRCCSR_EST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST001"
    PRCCSR_EST002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST002"
    PRCCSR_EST003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST003"
    PRCCSR_EST004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST004"
    PRCCSR_EST005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST005"
    PRCCSR_EYP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP001"
    PRCCSR_EYP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP002"
    PRCCSR_FRS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS001"
    PRCCSR_FRS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS002"
    PRCCSR_FRS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS003"
    PRCCSR_FRS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS004"
    PRCCSR_FRS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS005"
    PRCCSR_FRS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS006"
    PRCCSR_FRS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS007"
    PRCCSR_FRS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS008"
    PRCCSR_FRS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS009"
    PRCCSR_FRS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS010"
    PRCCSR_FRS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS011"
    PRCCSR_FRS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS012"
    PRCCSR_FRS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS013"
    PRCCSR_FRS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS014"
    PRCCSR_FRS015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS015"
    PRCCSR_GIS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS001"
    PRCCSR_GIS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS002"
    PRCCSR_GIS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS003"
    PRCCSR_GIS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS004"
    PRCCSR_GIS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS005"
    PRCCSR_GIS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS006"
    PRCCSR_GIS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS007"
    PRCCSR_GIS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS008"
    PRCCSR_GIS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS009"
    PRCCSR_GIS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS010"
    PRCCSR_GIS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS011"
    PRCCSR_GIS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS012"
    PRCCSR_GIS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS013"
    PRCCSR_GIS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS014"
    PRCCSR_GIS015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS015"
    PRCCSR_GIS016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS016"
    PRCCSR_GIS017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS017"
    PRCCSR_GIS018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS018"
    PRCCSR_GIS019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS019"
    PRCCSR_GIS020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS020"
    PRCCSR_GIS021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS021"
    PRCCSR_GIS022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS022"
    PRCCSR_GIS023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS023"
    PRCCSR_GIS024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS024"
    PRCCSR_GIS025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS025"
    PRCCSR_GIS026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS026"
    PRCCSR_GIS027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS027"
    PRCCSR_GIS028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS028"
    PRCCSR_GIS029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS029"
    PRCCSR_GNR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR001"
    PRCCSR_GNR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR002"
    PRCCSR_GNR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR003"
    PRCCSR_GNR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR004"
    PRCCSR_GNR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR005"
    PRCCSR_GNR006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR006"
    PRCCSR_GNR007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR007"
    PRCCSR_GNR008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR008"
    PRCCSR_GNR009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR009"
    PRCCSR_GNR010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR010"
    PRCCSR_HEP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP001"
    PRCCSR_HEP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP002"
    PRCCSR_HEP003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP003"
    PRCCSR_HEP004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP004"
    PRCCSR_HEP005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP005"
    PRCCSR_HEP006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP006"
    PRCCSR_HEP007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP007"
    PRCCSR_HEP008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP008"
    PRCCSR_HEP009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP009"
    PRCCSR_HEP010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP010"
    PRCCSR_HEP011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP011"
    PRCCSR_HEP012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP012"
    PRCCSR_HEP013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP013"
    PRCCSR_IMG001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG001"
    PRCCSR_IMG002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG002"
    PRCCSR_IMG003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG003"
    PRCCSR_IMG004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG004"
    PRCCSR_IMG005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG005"
    PRCCSR_IMG006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG006"
    PRCCSR_IMG007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG007"
    PRCCSR_IMG008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG008"
    PRCCSR_IMG009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG009"
    PRCCSR_IMG010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG010"
    PRCCSR_LYM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM001"
    PRCCSR_LYM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM002"
    PRCCSR_LYM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM003"
    PRCCSR_LYM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM004"
    PRCCSR_LYM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM005"
    PRCCSR_LYM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM006"
    PRCCSR_LYM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM007"
    PRCCSR_LYM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM008"
    PRCCSR_LYM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM009"
    PRCCSR_LYM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM010"
    PRCCSR_LYM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM011"
    PRCCSR_MAM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM001"
    PRCCSR_MAM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM002"
    PRCCSR_MAM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM003"
    PRCCSR_MAM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM004"
    PRCCSR_MAM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM005"
    PRCCSR_MAM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM006"
    PRCCSR_MAM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM007"
    PRCCSR_MAM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM008"
    PRCCSR_MAM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM009"
    PRCCSR_MAM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM010"
    PRCCSR_MAM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM011"
    PRCCSR_MAM012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM012"
    PRCCSR_MAM013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM013"
    PRCCSR_MAM014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM014"
    PRCCSR_MAM015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM015"
    PRCCSR_MHT001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT001"
    PRCCSR_MHT002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT002"
    PRCCSR_MHT003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT003"
    PRCCSR_MHT004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT004"
    PRCCSR_MHT005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT005"
    PRCCSR_MRS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS001"
    PRCCSR_MRS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS002"
    PRCCSR_MRS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS003"
    PRCCSR_MRS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS004"
    PRCCSR_MRS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS005"
    PRCCSR_MRS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS006"
    PRCCSR_MRS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS007"
    PRCCSR_MST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST001"
    PRCCSR_MST002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST002"
    PRCCSR_MST003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST003"
    PRCCSR_MST004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST004"
    PRCCSR_MST005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST005"
    PRCCSR_MST006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST006"
    PRCCSR_MST007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST007"
    PRCCSR_MST008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST008"
    PRCCSR_MST009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST009"
    PRCCSR_MST010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST010"
    PRCCSR_MST011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST011"
    PRCCSR_MST012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST012"
    PRCCSR_MST013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST013"
    PRCCSR_MST014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST014"
    PRCCSR_MST015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST015"
    PRCCSR_MST016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST016"
    PRCCSR_MST017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST017"
    PRCCSR_MST018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST018"
    PRCCSR_MST019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST019"
    PRCCSR_MST020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST020"
    PRCCSR_MST021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST021"
    PRCCSR_MST022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST022"
    PRCCSR_MST023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST023"
    PRCCSR_MST024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST024"
    PRCCSR_MST025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST025"
    PRCCSR_MST026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST026"
    PRCCSR_MST027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST027"
    PRCCSR_MST028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST028"
    PRCCSR_MST029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST029"
    PRCCSR_MST030            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST030"
    PRCCSR_NCM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM001"
    PRCCSR_NCM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM002"
    PRCCSR_NCM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM003"
    PRCCSR_NCM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM004"
    PRCCSR_OST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OST001"
    PRCCSR_OTR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR001"
    PRCCSR_OTR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR002"
    PRCCSR_OTR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR003"
    PRCCSR_OTR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR004"
    PRCCSR_OTR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR005"
    PRCCSR_PGN001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN001"
    PRCCSR_PGN002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN002"
    PRCCSR_PGN003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN003"
    PRCCSR_PGN004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN004"
    PRCCSR_PGN005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN005"
    PRCCSR_PGN006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN006"
    PRCCSR_PGN007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN007"
    PRCCSR_PGN008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN008"
    PRCCSR_PGN009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN009"
    PRCCSR_PLC001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC001"
    PRCCSR_PLC002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC002"
    PRCCSR_PNS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS001"
    PRCCSR_PNS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS002"
    PRCCSR_PNS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS003"
    PRCCSR_PNS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS004"
    PRCCSR_PNS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS005"
    PRCCSR_PNS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS006"
    PRCCSR_RAD001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD001"
    PRCCSR_RAD002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD002"
    PRCCSR_RAD003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD003"
    PRCCSR_RAD004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD004"
    PRCCSR_RES001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES001"
    PRCCSR_RES002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES002"
    PRCCSR_RES003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES003"
    PRCCSR_RES004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES004"
    PRCCSR_RES005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES005"
    PRCCSR_RES006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES006"
    PRCCSR_RES007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES007"
    PRCCSR_RES008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES008"
    PRCCSR_RES009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES009"
    PRCCSR_RES010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES010"
    PRCCSR_RES011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES011"
    PRCCSR_RES012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES012"
    PRCCSR_RES013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES013"
    PRCCSR_RES014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES014"
    PRCCSR_RHB001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB001"
    PRCCSR_RHB002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB002"
    PRCCSR_RHB003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB003"
    PRCCSR_RHB004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB004"
    PRCCSR_SKB001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB001"
    PRCCSR_SKB002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB002"
    PRCCSR_SKB003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB003"
    PRCCSR_SKB004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB004"
    PRCCSR_SKB005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB005"
    PRCCSR_SKB006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB006"
    PRCCSR_SKB007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB007"
    PRCCSR_SKB008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB008"
    PRCCSR_SKB009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB009"
    PRCCSR_SKB010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB010"
    PRCCSR_SUD001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD001"
    PRCCSR_SUD002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD002"
    PRCCSR_SUD003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD003"
    PRCCSR_SUD004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD004"
    PRCCSR_URN001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN001"
    PRCCSR_URN002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN002"
    PRCCSR_URN003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN003"
    PRCCSR_URN004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN004"
    PRCCSR_URN005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN005"
    PRCCSR_URN006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN006"
    PRCCSR_URN007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN007"
    PRCCSR_URN008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN008"
    PRCCSR_URN009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN009"
    PRCCSR_URN010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN010"
    PRCCSR_URN011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN011"
    PRCCSR_URN012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN012"
    PRCCSR_VERSION           "Version of CCSR for ICD-10-PCS procedures"
    TOTCHG_IP                "Total charge for ED and inpatient services" .

/* Convert special values to system missing values */
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE DISP_IP                  (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE I10_NPR_IP               (-99 -88 -66=SYSMIS).
RECODE LOS_IP                   (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).
RECODE PRCCSR_ADM001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM016            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM017            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM018            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM019            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM020            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM021            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ADM022            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR016            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR017            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR018            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR019            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR020            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR021            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR022            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR023            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR024            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR025            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR026            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR027            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR028            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CAR029            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CHP001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_CNS014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENP001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENP002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENP003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENP004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENP005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENP006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT016            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ENT017            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_ESA011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EST001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EST002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EST003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EST004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EST005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EYP001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_EYP002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_FRS015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS016            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS017            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS018            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS019            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS020            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS021            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS022            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS023            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS024            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS025            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS026            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS027            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS028            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GIS029            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_GNR010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_HEP013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_IMG010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_LYM011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MAM015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MHT001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MHT002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MHT003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MHT004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MHT005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MRS007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST015            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST016            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST017            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST018            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST019            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST020            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST021            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST022            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST023            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST024            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST025            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST026            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST027            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST028            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST029            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_MST030            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_NCM001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_NCM002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_NCM003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_NCM004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_OST001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_OTR001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_OTR002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_OTR003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_OTR004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_OTR005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PGN009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PLC001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PLC002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PNS001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PNS002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PNS003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PNS004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PNS005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_PNS006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RAD001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RAD002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RAD003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RAD004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES012            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES013            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RES014            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RHB001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RHB002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RHB003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_RHB004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SKB010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SUD001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SUD002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SUD003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_SUD004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN001            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN002            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN003            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN004            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN005            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN006            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN007            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN008            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN009            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN010            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN011            (-9 -8 -6 -5=SYSMIS).
RECODE PRCCSR_URN012            (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG_IP                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).

SAVE OUTFILE = 'NEDS_2021_IP.SAV' / COMPRESSED.
