/*****************************************************************************
 * Stataload_NEDS_2013_Hospital.Do
 * This program will load the 2013 NEDS CSV Hospital File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2013_Hospital.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      double discwt
      double hospwt
      byte   hosp_control
      long   hosp_ed
      byte   hosp_region
      byte   hosp_trauma
      byte   hosp_urcat4
      byte   hosp_ur_teach
      long   neds_stratum
      long   n_disc_u
      int    n_hosp_u
      long   s_disc_u
      long   s_hosp_u
      long   total_edvisits
      int    year
using NEDS_2013_Hospital.csv;

/*  Assign labels to the data elements */
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var hospwt                   "Weight to hospitals in AHA universe" ;
label var hosp_control             "Control/ownership of hospital" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var hosp_region              "Region of hospital" ;
label var hosp_trauma              "Trauma level designation" ;
label var hosp_urcat4              "Hospital urban-rural designation" ;
label var hosp_ur_teach            "Teaching status of hospital" ;
label var neds_stratum             "Stratum used to sample hospital" ;
label var n_disc_u                 "Number of AHA universe ED visits in NEDS_STRATUM" ;
label var n_hosp_u                 "Number of AHA universe hospitals in NEDS_STRATUM" ;
label var s_disc_u                 "Number of sample discharges in NEDS_STRATUM" ;
label var s_hosp_u                 "Number of sample hospitals in NEDS_STRATUM" ;
label var total_edvisits           "Total number of ED visits from this hospital in the NEDS" ;
label var year                     "Calendar Year" ;

/* Convert special values to missing values */
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode hospwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode hosp_control              (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode hosp_region               (-9 -8 -6 -5=.) ;
recode hosp_trauma               (-9 -8 -6 -5=.) ;
recode hosp_urcat4               (-9 -8 -6 -5=.) ;
recode hosp_ur_teach             (-9 -8 -6 -5=.) ;
recode neds_stratum              (-9999 -8888 -6666=.) ;
recode n_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode n_hosp_u                  (-999 -888 -666=.) ;
recode s_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode s_hosp_u                  (-99999 -88888 -66666=.) ;
recode total_edvisits            (-9999999 -8888888 -6666666=.) ;
recode year                      (-999 -888 -666=.) ;

describe;

save "NEDS_2013_Hospital.dta", replace;
#delimit cr
