/*****************************************************************************
 * Stataload_NEDS_2021_Core.Do
 * This program will load the NEDS 2021 Core csv File into Stata.
 * created on 03/01/2024.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2021_Core.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    age
      byte   amonth
      byte   aweekend
      byte   died_visit
      double discwt
      byte   disp_ed
      byte   dqtr
      byte   edevent
      byte   female
      str4   hcupfile
      long   hosp_ed
      str7   i10_dx1
      str7   i10_dx2
      str7   i10_dx3
      str7   i10_dx4
      str7   i10_dx5
      str7   i10_dx6
      str7   i10_dx7
      str7   i10_dx8
      str7   i10_dx9
      str7   i10_dx10
      str7   i10_dx11
      str7   i10_dx12
      str7   i10_dx13
      str7   i10_dx14
      str7   i10_dx15
      str7   i10_dx16
      str7   i10_dx17
      str7   i10_dx18
      str7   i10_dx19
      str7   i10_dx20
      str7   i10_dx21
      str7   i10_dx22
      str7   i10_dx23
      str7   i10_dx24
      str7   i10_dx25
      str7   i10_dx26
      str7   i10_dx27
      str7   i10_dx28
      str7   i10_dx29
      str7   i10_dx30
      str7   i10_dx31
      str7   i10_dx32
      str7   i10_dx33
      str7   i10_dx34
      str7   i10_dx35
      str7   i10_dx36
      str7   i10_dx37
      str7   i10_dx38
      str7   i10_dx39
      str7   i10_dx40
      byte   i10_injury
      byte   i10_injury_cut
      byte   i10_injury_drown
      byte   i10_injury_fall
      byte   i10_injury_fire
      byte   i10_injury_firearm
      byte   i10_injury_machinery
      byte   i10_injury_mvt
      byte   i10_injury_nature
      byte   i10_injury_overexertion
      byte   i10_injury_poison
      byte   i10_injury_struck
      byte   i10_injury_suffocation
      byte   i10_intent_assault
      byte   i10_intent_self_harm
      byte   i10_intent_unintentional
      byte   i10_multinjury
      int    i10_ndx
      double key_ed
      long   neds_stratum
      byte   pay1
      byte   pay2
      int    pl_nchs
      byte   race
      double totchg_ed
      int    year
      byte   zipinc_qrtl
using NEDS_2021_Core.csv;

/*  Assign labels to the data elements */
label var age                      "Age in years at admission" ;
label var amonth                   "Admission month" ;
label var aweekend                 "Admission day is a weekend" ;
label var died_visit               "Died in the ED (1), Died in the hospital (2), did not die (0)" ;
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var disp_ed                  "Disposition of patient (uniform) from ED" ;
label var dqtr                     "Discharge quarter" ;
label var edevent                  "Type of ED Event" ;
label var female                   "Indicator of sex" ;
label var hcupfile                 "Source of HCUP Record (SID or SEDD)" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var i10_dx1                  "ICD-10-CM Diagnosis 1" ;
label var i10_dx2                  "ICD-10-CM Diagnosis 2" ;
label var i10_dx3                  "ICD-10-CM Diagnosis 3" ;
label var i10_dx4                  "ICD-10-CM Diagnosis 4" ;
label var i10_dx5                  "ICD-10-CM Diagnosis 5" ;
label var i10_dx6                  "ICD-10-CM Diagnosis 6" ;
label var i10_dx7                  "ICD-10-CM Diagnosis 7" ;
label var i10_dx8                  "ICD-10-CM Diagnosis 8" ;
label var i10_dx9                  "ICD-10-CM Diagnosis 9" ;
label var i10_dx10                 "ICD-10-CM Diagnosis 10" ;
label var i10_dx11                 "ICD-10-CM Diagnosis 11" ;
label var i10_dx12                 "ICD-10-CM Diagnosis 12" ;
label var i10_dx13                 "ICD-10-CM Diagnosis 13" ;
label var i10_dx14                 "ICD-10-CM Diagnosis 14" ;
label var i10_dx15                 "ICD-10-CM Diagnosis 15" ;
label var i10_dx16                 "ICD-10-CM Diagnosis 16" ;
label var i10_dx17                 "ICD-10-CM Diagnosis 17" ;
label var i10_dx18                 "ICD-10-CM Diagnosis 18" ;
label var i10_dx19                 "ICD-10-CM Diagnosis 19" ;
label var i10_dx20                 "ICD-10-CM Diagnosis 20" ;
label var i10_dx21                 "ICD-10-CM Diagnosis 21" ;
label var i10_dx22                 "ICD-10-CM Diagnosis 22" ;
label var i10_dx23                 "ICD-10-CM Diagnosis 23" ;
label var i10_dx24                 "ICD-10-CM Diagnosis 24" ;
label var i10_dx25                 "ICD-10-CM Diagnosis 25" ;
label var i10_dx26                 "ICD-10-CM Diagnosis 26" ;
label var i10_dx27                 "ICD-10-CM Diagnosis 27" ;
label var i10_dx28                 "ICD-10-CM Diagnosis 28" ;
label var i10_dx29                 "ICD-10-CM Diagnosis 29" ;
label var i10_dx30                 "ICD-10-CM Diagnosis 30" ;
label var i10_dx31                 "ICD-10-CM Diagnosis 31" ;
label var i10_dx32                 "ICD-10-CM Diagnosis 32" ;
label var i10_dx33                 "ICD-10-CM Diagnosis 33" ;
label var i10_dx34                 "ICD-10-CM Diagnosis 34" ;
label var i10_dx35                 "ICD-10-CM Diagnosis 35" ;
label var i10_dx36                 "ICD-10-CM Diagnosis 36" ;
label var i10_dx37                 "ICD-10-CM Diagnosis 37" ;
label var i10_dx38                 "ICD-10-CM Diagnosis 38" ;
label var i10_dx39                 "ICD-10-CM Diagnosis 39" ;
label var i10_dx40                 "ICD-10-CM Diagnosis 40" ;
label var i10_injury
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)" ;
label var i10_injury_cut           "Mechanism of injury: cut or pierce" ;
label var i10_injury_drown         "Mechanism of injury: drowning or submersion" ;
label var i10_injury_fall          "Mechanism of injury: fall" ;
label var i10_injury_fire          "Mechanism of injury: fire, flame, hot object, or hot substance" ;
label var i10_injury_firearm       "Mechanism of injury: firearm" ;
label var i10_injury_machinery     "Mechanism of injury: machinery" ;
label var i10_injury_mvt
    "Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, other, or unspecified" ;
label var i10_injury_nature
    "Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings" ;
label var i10_injury_overexertion  "Mechanism of injury: overexertion" ;
label var i10_injury_poison        "Mechanism of injury: poisoning, including drugs and nondrugs" ;
label var i10_injury_struck        "Mechanism of injury: struck by or against" ;
label var i10_injury_suffocation   "Mechanism of injury: suffocation" ;
label var i10_intent_assault       "Intent of injury: assault" ;
label var i10_intent_self_harm     "Intent of injury: intentional self-harm" ;
label var i10_intent_unintentional "Intent of injury: unintentional" ;
label var i10_multinjury           "Multiple ICD-10-CM injuries reported on record" ;
label var i10_ndx                  "ICD-10-CM Number of diagnoses on this record" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var neds_stratum             "Stratum used to sample hospital" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pay2                     "Secondary expected payer (uniform)" ;
label var pl_nchs                  "Patient Location: NCHS Urban-Rural Code" ;
label var race                     "Race (uniform)" ;
label var totchg_ed                "Total charge for ED services" ;
label var year                     "Calendar year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode age                       (-99 -88 -66=.) ;
recode amonth                    (-9 -8 -6 -5=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode died_visit                (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode disp_ed                   (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode edevent                   (-9 -8 -6 -5=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode i10_injury                (-9 -8 -6 -5=.) ;
recode i10_injury_cut            (-9 -8 -6 -5=.) ;
recode i10_injury_drown          (-9 -8 -6 -5=.) ;
recode i10_injury_fall           (-9 -8 -6 -5=.) ;
recode i10_injury_fire           (-9 -8 -6 -5=.) ;
recode i10_injury_firearm        (-9 -8 -6 -5=.) ;
recode i10_injury_machinery      (-9 -8 -6 -5=.) ;
recode i10_injury_mvt            (-9 -8 -6 -5=.) ;
recode i10_injury_nature         (-9 -8 -6 -5=.) ;
recode i10_injury_overexertion   (-9 -8 -6 -5=.) ;
recode i10_injury_poison         (-9 -8 -6 -5=.) ;
recode i10_injury_struck         (-9 -8 -6 -5=.) ;
recode i10_injury_suffocation    (-9 -8 -6 -5=.) ;
recode i10_intent_assault        (-9 -8 -6 -5=.) ;
recode i10_intent_self_harm      (-9 -8 -6 -5=.) ;
recode i10_intent_unintentional  (-9 -8 -6 -5=.) ;
recode i10_multinjury            (-9 -8 -6 -5=.) ;
recode i10_ndx                   (-99 -88 -66=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode neds_stratum              (-9999 -8888 -6666=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pay2                      (-9 -8 -6 -5=.) ;
recode pl_nchs                   (-99 -88 -66=.) ;
recode race                      (-9 -8 -6 -5=.) ;
recode totchg_ed                 (-99999999.99 -88888888.88 -66666666.66=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NEDS_2021_Core.dta", replace;
#delimit cr
