/*****************************************************************************
* Stataload_NIS_2014_Core.Do
* This program will load the 2014 NIS ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                          1-   3   ///
      byte   AGE_NEONATE                  4-   5   ///
      byte   AMONTH                       6-   7   ///
      byte   AWEEKEND                     8-   9   ///
      byte   DIED                        10-  11   ///
      double DISCWT                      12-  22   ///
      byte   DISPUNIFORM                 23-  24   ///
      byte   DQTR                        25-  26   ///
      int    DRG                         27-  29   ///
      int    DRG24                       30-  32   ///
      byte   DRGVER                      33-  34   ///
      int    DRG_NoPOA                   35-  37   ///
      str    DX1                         38-  42   ///
      str    DX2                         43-  47   ///
      str    DX3                         48-  52   ///
      str    DX4                         53-  57   ///
      str    DX5                         58-  62   ///
      str    DX6                         63-  67   ///
      str    DX7                         68-  72   ///
      str    DX8                         73-  77   ///
      str    DX9                         78-  82   ///
      str    DX10                        83-  87   ///
      str    DX11                        88-  92   ///
      str    DX12                        93-  97   ///
      str    DX13                        98- 102   ///
      str    DX14                       103- 107   ///
      str    DX15                       108- 112   ///
      str    DX16                       113- 117   ///
      str    DX17                       118- 122   ///
      str    DX18                       123- 127   ///
      str    DX19                       128- 132   ///
      str    DX20                       133- 137   ///
      str    DX21                       138- 142   ///
      str    DX22                       143- 147   ///
      str    DX23                       148- 152   ///
      str    DX24                       153- 157   ///
      str    DX25                       158- 162   ///
      str    DX26                       163- 167   ///
      str    DX27                       168- 172   ///
      str    DX28                       173- 177   ///
      str    DX29                       178- 182   ///
      str    DX30                       183- 187   ///
      int    DXCCS1                     188- 190   ///
      int    DXCCS2                     191- 193   ///
      int    DXCCS3                     194- 196   ///
      int    DXCCS4                     197- 199   ///
      int    DXCCS5                     200- 202   ///
      int    DXCCS6                     203- 205   ///
      int    DXCCS7                     206- 208   ///
      int    DXCCS8                     209- 211   ///
      int    DXCCS9                     212- 214   ///
      int    DXCCS10                    215- 217   ///
      int    DXCCS11                    218- 220   ///
      int    DXCCS12                    221- 223   ///
      int    DXCCS13                    224- 226   ///
      int    DXCCS14                    227- 229   ///
      int    DXCCS15                    230- 232   ///
      int    DXCCS16                    233- 235   ///
      int    DXCCS17                    236- 238   ///
      int    DXCCS18                    239- 241   ///
      int    DXCCS19                    242- 244   ///
      int    DXCCS20                    245- 247   ///
      int    DXCCS21                    248- 250   ///
      int    DXCCS22                    251- 253   ///
      int    DXCCS23                    254- 256   ///
      int    DXCCS24                    257- 259   ///
      int    DXCCS25                    260- 262   ///
      int    DXCCS26                    263- 265   ///
      int    DXCCS27                    266- 268   ///
      int    DXCCS28                    269- 271   ///
      int    DXCCS29                    272- 274   ///
      int    DXCCS30                    275- 277   ///
      str    ECODE1                     278- 282   ///
      str    ECODE2                     283- 287   ///
      str    ECODE3                     288- 292   ///
      str    ECODE4                     293- 297   ///
      byte   ELECTIVE                   298- 299   ///
      int    E_CCS1                     300- 303   ///
      int    E_CCS2                     304- 307   ///
      int    E_CCS3                     308- 311   ///
      int    E_CCS4                     312- 315   ///
      byte   FEMALE                     316- 317   ///
      int    HCUP_ED                    318- 320   ///
      byte   HOSPBRTH                   321- 322   ///
      byte   HOSP_DIVISION              323- 324   ///
      long   HOSP_NIS                   325- 329   ///
      double KEY_NIS                    330- 339   ///
      long   LOS                        340- 344   ///
      byte   MDC                        345- 346   ///
      byte   MDC24                      347- 348   ///
      byte   MDC_NoPOA                  349- 350   ///
      byte   NCHRONIC                   351- 352   ///
      byte   NDX                        353- 354   ///
      int    NECODE                     355- 357   ///
      byte   NEOMAT                     358- 359   ///
      int    NIS_STRATUM                360- 363   ///
      byte   NPR                        364- 365   ///
      byte   ORPROC                     366- 367   ///
      byte   PAY1                       368- 369   ///
      int    PL_NCHS                    370- 372   ///
      str    PR1                        373- 376   ///
      str    PR2                        377- 380   ///
      str    PR3                        381- 384   ///
      str    PR4                        385- 388   ///
      str    PR5                        389- 392   ///
      str    PR6                        393- 396   ///
      str    PR7                        397- 400   ///
      str    PR8                        401- 404   ///
      str    PR9                        405- 408   ///
      str    PR10                       409- 412   ///
      str    PR11                       413- 416   ///
      str    PR12                       417- 420   ///
      str    PR13                       421- 424   ///
      str    PR14                       425- 428   ///
      str    PR15                       429- 432   ///
      int    PRCCS1                     433- 435   ///
      int    PRCCS2                     436- 438   ///
      int    PRCCS3                     439- 441   ///
      int    PRCCS4                     442- 444   ///
      int    PRCCS5                     445- 447   ///
      int    PRCCS6                     448- 450   ///
      int    PRCCS7                     451- 453   ///
      int    PRCCS8                     454- 456   ///
      int    PRCCS9                     457- 459   ///
      int    PRCCS10                    460- 462   ///
      int    PRCCS11                    463- 465   ///
      int    PRCCS12                    466- 468   ///
      int    PRCCS13                    469- 471   ///
      int    PRCCS14                    472- 474   ///
      int    PRCCS15                    475- 477   ///
      int    PRDAY1                     478- 480   ///
      int    PRDAY2                     481- 483   ///
      int    PRDAY3                     484- 486   ///
      int    PRDAY4                     487- 489   ///
      int    PRDAY5                     490- 492   ///
      int    PRDAY6                     493- 495   ///
      int    PRDAY7                     496- 498   ///
      int    PRDAY8                     499- 501   ///
      int    PRDAY9                     502- 504   ///
      int    PRDAY10                    505- 507   ///
      int    PRDAY11                    508- 510   ///
      int    PRDAY12                    511- 513   ///
      int    PRDAY13                    514- 516   ///
      int    PRDAY14                    517- 519   ///
      int    PRDAY15                    520- 522   ///
      byte   RACE                       523- 524   ///
      int    SERVICELINE                525- 527   ///
      double TOTCHG                     528- 537   ///
      byte   TRAN_IN                    538- 539   ///
      byte   TRAN_OUT                   540- 541   ///
      int    YEAR                       542- 545   ///
      byte   ZIPINC_QRTL                546- 547   ///
      using  "NIS_2014_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
label var AMONTH                   "Admission month"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "NIS discharge weight"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DX26                     "Diagnosis 26"
label var DX27                     "Diagnosis 27"
label var DX28                     "Diagnosis 28"
label var DX29                     "Diagnosis 29"
label var DX30                     "Diagnosis 30"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var DXCCS26                  "CCS: diagnosis 26"
label var DXCCS27                  "CCS: diagnosis 27"
label var DXCCS28                  "CCS: diagnosis 28"
label var DXCCS29                  "CCS: diagnosis 29"
label var DXCCS30                  "CCS: diagnosis 30"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSP_DIVISION            "Census Division of hospital"
label var HOSP_NIS                 "NIS hospital number"
label var KEY_NIS                  "NIS record number"
label var LOS                      "Length of stay (cleaned)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var NCHRONIC                 "Number of chronic conditions"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NIS_STRATUM              "NIS hospital stratum"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var RACE                     "Race (uniform)"
label var SERVICELINE              "Hospital Service Line"
label var TOTCHG                   "Total charges (cleaned)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGE_NEONATE               (-9 -8 -6 -5=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode DXCCS16                   (-99 -88 -66=.)
recode DXCCS17                   (-99 -88 -66=.)
recode DXCCS18                   (-99 -88 -66=.)
recode DXCCS19                   (-99 -88 -66=.)
recode DXCCS20                   (-99 -88 -66=.)
recode DXCCS21                   (-99 -88 -66=.)
recode DXCCS22                   (-99 -88 -66=.)
recode DXCCS23                   (-99 -88 -66=.)
recode DXCCS24                   (-99 -88 -66=.)
recode DXCCS25                   (-99 -88 -66=.)
recode DXCCS26                   (-99 -88 -66=.)
recode DXCCS27                   (-99 -88 -66=.)
recode DXCCS28                   (-99 -88 -66=.)
recode DXCCS29                   (-99 -88 -66=.)
recode DXCCS30                   (-99 -88 -66=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode HOSP_DIVISION             (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode NCHRONIC                  (-9 -8 -6 -5=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode NPR                       (-9 -8 -6 -5=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_NCHS                   (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode SERVICELINE               (-99 -88 -66=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "NIS_2014_Core.dta", replace
