/*****************************************************************************/
/* SPSSload_NRD_2017_Hospital.SPS                                          */
/* Created on 11/22/2019.                                       */
/* This program will load the NRD_2017_Hospital CSV File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NRD_2017_Hospital.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_BEDSIZE             F2.0
    H_CONTRL                 F2.0
    HOSP_NRD                 F5.0
    HOSP_URCAT4              F2.0
    HOSP_UR_TEACH            F2.0
    NRD_STRATUM              F5.0
    N_DISC_U                 F8.0
    N_HOSP_U                 F4.0
    S_DISC_U                 F8.0
    S_HOSP_U                 F6.0
    TOTAL_DISC               F6.0
    YEAR                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_BEDSIZE             "Bed size of hospital"
    H_CONTRL                 "Control/ownership of hospital"
    HOSP_NRD                 "NRD hospital identifier"
    HOSP_URCAT4              "Hospital urban-rural designation"
    HOSP_UR_TEACH            "Teaching status of urban hospitals"
    NRD_STRATUM              "NRD stratum used for weighting"
    N_DISC_U                 "Number of universe discharges in NRD_STRATUM"
    N_HOSP_U                 "Number of universe hospitals in NRD_STRATUM"
    S_DISC_U                 "Number of sample discharges in NRD_STRATUM"
    S_HOSP_U                 "Number of universe hospitals in NRD_STRATUM"
    TOTAL_DISC               "Total hospital discharges"
    YEAR                     "Calendar year" .

/* Convert special values to system missing values */
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NRD                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSP_URCAT4              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_UR_TEACH            (-9 -8 -6 -5=SYSMIS).
RECODE NRD_STRATUM              (-9999 -8888 -6666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-99999 -88888 -66666=SYSMIS).
RECODE TOTAL_DISC               (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NRD_2017_Hospital.SAV' / COMPRESSED.
