/*****************************************************************************
 * Stataload_NRD_2013_Severity.Do
 * This program will load the 2013 NRD CSV Severity File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2013_Severity.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    aprdrg
      byte   aprdrg_risk_mortality
      byte   aprdrg_severity
      byte   cm_aids
      byte   cm_alcohol
      byte   cm_anemdef
      byte   cm_arth
      byte   cm_bldloss
      byte   cm_chf
      byte   cm_chrnlung
      byte   cm_coag
      byte   cm_depress
      byte   cm_dm
      byte   cm_dmcx
      byte   cm_drug
      byte   cm_htn_c
      byte   cm_hypothy
      byte   cm_liver
      byte   cm_lymph
      byte   cm_lytes
      byte   cm_mets
      byte   cm_neuro
      byte   cm_obese
      byte   cm_para
      byte   cm_perivasc
      byte   cm_psych
      byte   cm_pulmcirc
      byte   cm_renlfail
      byte   cm_tumor
      byte   cm_ulcer
      byte   cm_valve
      byte   cm_wghtloss
      long   hosp_nrd
      double key_nrd
using NRD_2013_Severity.csv;

/*  Assign labels to the data elements */
label var aprdrg                   "All Patient Refined DRG" ;
label var aprdrg_risk_mortality    "All Patient Refined DRG: Risk of Mortality Subclass" ;
label var aprdrg_severity          "All Patient Refined DRG: Severity of Illness Subclass" ;
label var cm_aids                  "AHRQ comorbidity measure: Acquired immune deficiency syndrome" ;
label var cm_alcohol               "AHRQ comorbidity measure: Alcohol abuse" ;
label var cm_anemdef               "AHRQ comorbidity measure: Deficiency anemias" ;
label var cm_arth                  "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases" ;
label var cm_bldloss               "AHRQ comorbidity measure: Chronic blood loss anemia" ;
label var cm_chf                   "AHRQ comorbidity measure: Congestive heart failure" ;
label var cm_chrnlung              "AHRQ comorbidity measure: Chronic pulmonary disease" ;
label var cm_coag                  "AHRQ comorbidity measure: Coagulopathy" ;
label var cm_depress               "AHRQ comorbidity measure: Depression" ;
label var cm_dm                    "AHRQ comorbidity measure: Diabetes, uncomplicated" ;
label var cm_dmcx                  "AHRQ comorbidity measure: Diabetes with chronic complications" ;
label var cm_drug                  "AHRQ comorbidity measure: Drug abuse" ;
label var cm_htn_c                 "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)" ;
label var cm_hypothy               "AHRQ comorbidity measure: Hypothyroidism" ;
label var cm_liver                 "AHRQ comorbidity measure: Liver disease" ;
label var cm_lymph                 "AHRQ comorbidity measure: Lymphoma" ;
label var cm_lytes                 "AHRQ comorbidity measure: Fluid and electrolyte disorders" ;
label var cm_mets                  "AHRQ comorbidity measure: Metastatic cancer" ;
label var cm_neuro                 "AHRQ comorbidity measure: Other neurological disorders" ;
label var cm_obese                 "AHRQ comorbidity measure: Obesity" ;
label var cm_para                  "AHRQ comorbidity measure: Paralysis" ;
label var cm_perivasc              "AHRQ comorbidity measure: Peripheral vascular disorders" ;
label var cm_psych                 "AHRQ comorbidity measure: Psychoses" ;
label var cm_pulmcirc              "AHRQ comorbidity measure: Pulmonary circulation disorders" ;
label var cm_renlfail              "AHRQ comorbidity measure: Renal failure" ;
label var cm_tumor                 "AHRQ comorbidity measure: Solid tumor without metastasis" ;
label var cm_ulcer                 "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding" ;
label var cm_valve                 "AHRQ comorbidity measure: Valvular disease" ;
label var cm_wghtloss              "AHRQ comorbidity measure: Weight loss" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;

/* Convert special values to missing values */
recode aprdrg                    (-999 -888 -666=.) ;
recode aprdrg_risk_mortality     (-9 -8 -6 -5=.) ;
recode aprdrg_severity           (-9 -8 -6 -5=.) ;
recode cm_aids                   (-9 -8 -6 -5=.) ;
recode cm_alcohol                (-9 -8 -6 -5=.) ;
recode cm_anemdef                (-9 -8 -6 -5=.) ;
recode cm_arth                   (-9 -8 -6 -5=.) ;
recode cm_bldloss                (-9 -8 -6 -5=.) ;
recode cm_chf                    (-9 -8 -6 -5=.) ;
recode cm_chrnlung               (-9 -8 -6 -5=.) ;
recode cm_coag                   (-9 -8 -6 -5=.) ;
recode cm_depress                (-9 -8 -6 -5=.) ;
recode cm_dm                     (-9 -8 -6 -5=.) ;
recode cm_dmcx                   (-9 -8 -6 -5=.) ;
recode cm_drug                   (-9 -8 -6 -5=.) ;
recode cm_htn_c                  (-9 -8 -6 -5=.) ;
recode cm_hypothy                (-9 -8 -6 -5=.) ;
recode cm_liver                  (-9 -8 -6 -5=.) ;
recode cm_lymph                  (-9 -8 -6 -5=.) ;
recode cm_lytes                  (-9 -8 -6 -5=.) ;
recode cm_mets                   (-9 -8 -6 -5=.) ;
recode cm_neuro                  (-9 -8 -6 -5=.) ;
recode cm_obese                  (-9 -8 -6 -5=.) ;
recode cm_para                   (-9 -8 -6 -5=.) ;
recode cm_perivasc               (-9 -8 -6 -5=.) ;
recode cm_psych                  (-9 -8 -6 -5=.) ;
recode cm_pulmcirc               (-9 -8 -6 -5=.) ;
recode cm_renlfail               (-9 -8 -6 -5=.) ;
recode cm_tumor                  (-9 -8 -6 -5=.) ;
recode cm_ulcer                  (-9 -8 -6 -5=.) ;
recode cm_valve                  (-9 -8 -6 -5=.) ;
recode cm_wghtloss               (-9 -8 -6 -5=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;

describe;

save "NRD_2013_Severity.dta", replace;
#delimit cr
