/*****************************************************************************
 * Stataload_NRD_2014_DX_PR_GRPS.Do
 * This program will load the 2014 NRD CSV DX_PR_GRPS File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2014_DX_PR_GRPS.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    bodysystem1
      int    bodysystem2
      int    bodysystem3
      int    bodysystem4
      int    bodysystem5
      int    bodysystem6
      int    bodysystem7
      int    bodysystem8
      int    bodysystem9
      int    bodysystem10
      int    bodysystem11
      int    bodysystem12
      int    bodysystem13
      int    bodysystem14
      int    bodysystem15
      int    bodysystem16
      int    bodysystem17
      int    bodysystem18
      int    bodysystem19
      int    bodysystem20
      int    bodysystem21
      int    bodysystem22
      int    bodysystem23
      int    bodysystem24
      int    bodysystem25
      int    bodysystem26
      int    bodysystem27
      int    bodysystem28
      int    bodysystem29
      int    bodysystem30
      int    chron1
      int    chron2
      int    chron3
      int    chron4
      int    chron5
      int    chron6
      int    chron7
      int    chron8
      int    chron9
      int    chron10
      int    chron11
      int    chron12
      int    chron13
      int    chron14
      int    chron15
      int    chron16
      int    chron17
      int    chron18
      int    chron19
      int    chron20
      int    chron21
      int    chron22
      int    chron23
      int    chron24
      int    chron25
      int    chron26
      int    chron27
      int    chron28
      int    chron29
      int    chron30
      str11  dxmccs1
      str11  e_mccs1
      long   hosp_nrd
      double key_nrd
      int    pclass1
      int    pclass2
      int    pclass3
      int    pclass4
      int    pclass5
      int    pclass6
      int    pclass7
      int    pclass8
      int    pclass9
      int    pclass10
      int    pclass11
      int    pclass12
      int    pclass13
      int    pclass14
      int    pclass15
      str8   prmccs1
using NRD_2014_DX_PR_GRPS.csv;

/*  Assign labels to the data elements */
label var bodysystem1              "Body system 1" ;
label var bodysystem2              "Body system 2" ;
label var bodysystem3              "Body system 3" ;
label var bodysystem4              "Body system 4" ;
label var bodysystem5              "Body system 5" ;
label var bodysystem6              "Body system 6" ;
label var bodysystem7              "Body system 7" ;
label var bodysystem8              "Body system 8" ;
label var bodysystem9              "Body system 9" ;
label var bodysystem10             "Body system 10" ;
label var bodysystem11             "Body system 11" ;
label var bodysystem12             "Body system 12" ;
label var bodysystem13             "Body system 13" ;
label var bodysystem14             "Body system 14" ;
label var bodysystem15             "Body system 15" ;
label var bodysystem16             "Body system 16" ;
label var bodysystem17             "Body system 17" ;
label var bodysystem18             "Body system 18" ;
label var bodysystem19             "Body system 19" ;
label var bodysystem20             "Body system 20" ;
label var bodysystem21             "Body system 21" ;
label var bodysystem22             "Body system 22" ;
label var bodysystem23             "Body system 23" ;
label var bodysystem24             "Body system 24" ;
label var bodysystem25             "Body system 25" ;
label var bodysystem26             "Body system 26" ;
label var bodysystem27             "Body system 27" ;
label var bodysystem28             "Body system 28" ;
label var bodysystem29             "Body system 29" ;
label var bodysystem30             "Body system 30" ;
label var chron1                   "Chronic condition indicator 1" ;
label var chron2                   "Chronic condition indicator 2" ;
label var chron3                   "Chronic condition indicator 3" ;
label var chron4                   "Chronic condition indicator 4" ;
label var chron5                   "Chronic condition indicator 5" ;
label var chron6                   "Chronic condition indicator 6" ;
label var chron7                   "Chronic condition indicator 7" ;
label var chron8                   "Chronic condition indicator 8" ;
label var chron9                   "Chronic condition indicator 9" ;
label var chron10                  "Chronic condition indicator 10" ;
label var chron11                  "Chronic condition indicator 11" ;
label var chron12                  "Chronic condition indicator 12" ;
label var chron13                  "Chronic condition indicator 13" ;
label var chron14                  "Chronic condition indicator 14" ;
label var chron15                  "Chronic condition indicator 15" ;
label var chron16                  "Chronic condition indicator 16" ;
label var chron17                  "Chronic condition indicator 17" ;
label var chron18                  "Chronic condition indicator 18" ;
label var chron19                  "Chronic condition indicator 19" ;
label var chron20                  "Chronic condition indicator 20" ;
label var chron21                  "Chronic condition indicator 21" ;
label var chron22                  "Chronic condition indicator 22" ;
label var chron23                  "Chronic condition indicator 23" ;
label var chron24                  "Chronic condition indicator 24" ;
label var chron25                  "Chronic condition indicator 25" ;
label var chron26                  "Chronic condition indicator 26" ;
label var chron27                  "Chronic condition indicator 27" ;
label var chron28                  "Chronic condition indicator 28" ;
label var chron29                  "Chronic condition indicator 29" ;
label var chron30                  "Chronic condition indicator 30" ;
label var dxmccs1                  "Multi-Level CCS:  Diagnosis 1" ;
label var e_mccs1                  "Multi-Level CCS:  E Code 1" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;
label var pclass1                  "Procedure class 1" ;
label var pclass2                  "Procedure class 2" ;
label var pclass3                  "Procedure class 3" ;
label var pclass4                  "Procedure class 4" ;
label var pclass5                  "Procedure class 5" ;
label var pclass6                  "Procedure class 6" ;
label var pclass7                  "Procedure class 7" ;
label var pclass8                  "Procedure class 8" ;
label var pclass9                  "Procedure class 9" ;
label var pclass10                 "Procedure class 10" ;
label var pclass11                 "Procedure class 11" ;
label var pclass12                 "Procedure class 12" ;
label var pclass13                 "Procedure class 13" ;
label var pclass14                 "Procedure class 14" ;
label var pclass15                 "Procedure class 15" ;
label var prmccs1                  "Multi-Level CCS:  Procedure 1" ;

/* Convert special values to missing values */
recode bodysystem1               (-99 -88 -66=.) ;
recode bodysystem2               (-99 -88 -66=.) ;
recode bodysystem3               (-99 -88 -66=.) ;
recode bodysystem4               (-99 -88 -66=.) ;
recode bodysystem5               (-99 -88 -66=.) ;
recode bodysystem6               (-99 -88 -66=.) ;
recode bodysystem7               (-99 -88 -66=.) ;
recode bodysystem8               (-99 -88 -66=.) ;
recode bodysystem9               (-99 -88 -66=.) ;
recode bodysystem10              (-99 -88 -66=.) ;
recode bodysystem11              (-99 -88 -66=.) ;
recode bodysystem12              (-99 -88 -66=.) ;
recode bodysystem13              (-99 -88 -66=.) ;
recode bodysystem14              (-99 -88 -66=.) ;
recode bodysystem15              (-99 -88 -66=.) ;
recode bodysystem16              (-99 -88 -66=.) ;
recode bodysystem17              (-99 -88 -66=.) ;
recode bodysystem18              (-99 -88 -66=.) ;
recode bodysystem19              (-99 -88 -66=.) ;
recode bodysystem20              (-99 -88 -66=.) ;
recode bodysystem21              (-99 -88 -66=.) ;
recode bodysystem22              (-99 -88 -66=.) ;
recode bodysystem23              (-99 -88 -66=.) ;
recode bodysystem24              (-99 -88 -66=.) ;
recode bodysystem25              (-99 -88 -66=.) ;
recode bodysystem26              (-99 -88 -66=.) ;
recode bodysystem27              (-99 -88 -66=.) ;
recode bodysystem28              (-99 -88 -66=.) ;
recode bodysystem29              (-99 -88 -66=.) ;
recode bodysystem30              (-99 -88 -66=.) ;
recode chron1                    (-99 -88 -66=.) ;
recode chron2                    (-99 -88 -66=.) ;
recode chron3                    (-99 -88 -66=.) ;
recode chron4                    (-99 -88 -66=.) ;
recode chron5                    (-99 -88 -66=.) ;
recode chron6                    (-99 -88 -66=.) ;
recode chron7                    (-99 -88 -66=.) ;
recode chron8                    (-99 -88 -66=.) ;
recode chron9                    (-99 -88 -66=.) ;
recode chron10                   (-99 -88 -66=.) ;
recode chron11                   (-99 -88 -66=.) ;
recode chron12                   (-99 -88 -66=.) ;
recode chron13                   (-99 -88 -66=.) ;
recode chron14                   (-99 -88 -66=.) ;
recode chron15                   (-99 -88 -66=.) ;
recode chron16                   (-99 -88 -66=.) ;
recode chron17                   (-99 -88 -66=.) ;
recode chron18                   (-99 -88 -66=.) ;
recode chron19                   (-99 -88 -66=.) ;
recode chron20                   (-99 -88 -66=.) ;
recode chron21                   (-99 -88 -66=.) ;
recode chron22                   (-99 -88 -66=.) ;
recode chron23                   (-99 -88 -66=.) ;
recode chron24                   (-99 -88 -66=.) ;
recode chron25                   (-99 -88 -66=.) ;
recode chron26                   (-99 -88 -66=.) ;
recode chron27                   (-99 -88 -66=.) ;
recode chron28                   (-99 -88 -66=.) ;
recode chron29                   (-99 -88 -66=.) ;
recode chron30                   (-99 -88 -66=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;
recode pclass1                   (-99 -88 -66=.) ;
recode pclass2                   (-99 -88 -66=.) ;
recode pclass3                   (-99 -88 -66=.) ;
recode pclass4                   (-99 -88 -66=.) ;
recode pclass5                   (-99 -88 -66=.) ;
recode pclass6                   (-99 -88 -66=.) ;
recode pclass7                   (-99 -88 -66=.) ;
recode pclass8                   (-99 -88 -66=.) ;
recode pclass9                   (-99 -88 -66=.) ;
recode pclass10                  (-99 -88 -66=.) ;
recode pclass11                  (-99 -88 -66=.) ;
recode pclass12                  (-99 -88 -66=.) ;
recode pclass13                  (-99 -88 -66=.) ;
recode pclass14                  (-99 -88 -66=.) ;
recode pclass15                  (-99 -88 -66=.) ;

describe;

save "NRD_2014_DX_PR_GRPS.dta", replace;
#delimit cr
