/*****************************************************************************
 * Stataload_NRD_2015_Core.Do
 * Created on 10/31/2017.
 * This program will load the NRD_2015_Core CSV File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2015_Core.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    age
      byte   aweekend
      byte   died
      double discwt
      byte   dispuniform
      byte   dmonth
      byte   dqtr
      byte   elective
      byte   female
      byte   hcup_ed
      long   hosp_nrd
      double key_nrd
      long   los
      double nrd_daystoevent
      long   nrd_stratum
      str7   nrd_visitlink
      byte   pay1
      int    pl_nchs
      byte   rehabtransfer
      byte   resident
      str2   samedayevent
      double totchg
      int    year
      byte   zipinc_qrtl
using NRD_2015_Core.csv;

/*  Assign labels to the data elements */
label var age                      "Age in years at admission" ;
label var aweekend                 "Admission day is a weekend" ;
label var died                     "Died during hospitalization" ;
label var discwt                   "Weight to discharges in AHA universe" ;
label var dispuniform              "Disposition of patient (uniform)" ;
label var dmonth                   "Discharge month" ;
label var dqtr                     "Discharge quarter" ;
label var elective                 "Elective versus non-elective admission" ;
label var female                   "Indicator of sex" ;
label var hcup_ed                  "HCUP Emergency Department service indicator" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;
label var los                      "Length of stay (cleaned)" ;
label var nrd_daystoevent          "Timing variable used to identify days between admissions" ;
label var nrd_stratum              "NRD stratum used for weighting" ;
label var nrd_visitlink            "NRD visitlink" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pl_nchs                  "Patient Location: NCHS Urban-Rural Code" ;
label var rehabtransfer            "A combined record involving rehab transfer" ;
label var resident                 "Patient State is the same as Hospital State" ;
label var samedayevent             "Transfer flag indicating combination of discharges involve same day events" ;
label var totchg                   "Total charges (cleaned)" ;
label var year                     "Calendar year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode age                       (-99 -88 -66=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode died                      (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode dispuniform               (-9 -8 -6 -5=.) ;
recode dmonth                    (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode elective                  (-9 -8 -6 -5=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode hcup_ed                   (-9 -8 -6 -5=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;
recode los                       (-9999 -8888 -6666=.) ;
recode nrd_daystoevent           (-999999999 -888888888 -666666666=.) ;
recode nrd_stratum               (-9999 -8888 -6666=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pl_nchs                   (-99 -88 -66=.) ;
recode rehabtransfer             (-9 -8 -6 -5=.) ;
recode resident                  (-9 -8 -6 -5=.) ;
recode totchg                    (-999999999 -888888888 -666666666=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NRD_2015_Core.dta", replace;
#delimit cr
