/*******************************************************************
* Creation Date: 08/21/2020   
*   DC_SASD_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'DC_SASD_2016_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 CPT1                           24-  28 (A)
 CPT2                           29-  33 (A)
 CPT3                           34-  38 (A)
 CPT4                           39-  43 (A)
 CPT5                           44-  48 (A)
 CPT6                           49-  53 (A)
 CPT7                           54-  58 (A)
 CPT8                           59-  63 (A)
 CPT9                           64-  68 (A)
 CPT10                          69-  73 (A)
 CPT11                          74-  78 (A)
 CPT12                          79-  83 (A)
 CPT13                          84-  88 (A)
 CPT14                          89-  93 (A)
 CPT15                          94-  98 (A)
 CPT16                          99- 103 (A)
 CPT17                         104- 108 (A)
 CPT18                         109- 113 (A)
 CPT19                         114- 118 (A)
 CPT20                         119- 123 (A)
 CPT21                         124- 128 (A)
 CPT22                         129- 133 (A)
 CPT23                         134- 138 (A)
 CPT24                         139- 143 (A)
 CPT25                         144- 148 (A)
 CPT26                         149- 153 (A)
 CPT27                         154- 158 (A)
 CPT28                         159- 163 (A)
 CPT29                         164- 168 (A)
 CPT30                         169- 173 (A)
 CPT31                         174- 178 (A)
 CPT32                         179- 183 (A)
 CPT33                         184- 188 (A)
 CPT34                         189- 193 (A)
 CPT35                         194- 198 (A)
 CPT36                         199- 203 (A)
 CPT37                         204- 208 (A)
 CPT38                         209- 213 (A)
 CPT39                         214- 218 (A)
 CPT40                         219- 223 (A)
 CPT41                         224- 228 (A)
 CPT42                         229- 233 (A)
 CPT43                         234- 238 (A)
 CPT44                         239- 243 (A)
 CPT45                         244- 248 (A)
 CPT46                         249- 253 (A)
 CPT47                         254- 258 (A)
 CPT48                         259- 263 (A)
 CPT49                         264- 268 (A)
 CPT50                         269- 273 (A)
 CPTCCS1                       274- 276
 CPTCCS2                       277- 279
 CPTCCS3                       280- 282
 CPTCCS4                       283- 285
 CPTCCS5                       286- 288
 CPTCCS6                       289- 291
 CPTCCS7                       292- 294
 CPTCCS8                       295- 297
 CPTCCS9                       298- 300
 CPTCCS10                      301- 303
 CPTCCS11                      304- 306
 CPTCCS12                      307- 309
 CPTCCS13                      310- 312
 CPTCCS14                      313- 315
 CPTCCS15                      316- 318
 CPTCCS16                      319- 321
 CPTCCS17                      322- 324
 CPTCCS18                      325- 327
 CPTCCS19                      328- 330
 CPTCCS20                      331- 333
 CPTCCS21                      334- 336
 CPTCCS22                      337- 339
 CPTCCS23                      340- 342
 CPTCCS24                      343- 345
 CPTCCS25                      346- 348
 CPTCCS26                      349- 351
 CPTCCS27                      352- 354
 CPTCCS28                      355- 357
 CPTCCS29                      358- 360
 CPTCCS30                      361- 363
 CPTCCS31                      364- 366
 CPTCCS32                      367- 369
 CPTCCS33                      370- 372
 CPTCCS34                      373- 375
 CPTCCS35                      376- 378
 CPTCCS36                      379- 381
 CPTCCS37                      382- 384
 CPTCCS38                      385- 387
 CPTCCS39                      388- 390
 CPTCCS40                      391- 393
 CPTCCS41                      394- 396
 CPTCCS42                      397- 399
 CPTCCS43                      400- 402
 CPTCCS44                      403- 405
 CPTCCS45                      406- 408
 CPTCCS46                      409- 411
 CPTCCS47                      412- 414
 CPTCCS48                      415- 417
 CPTCCS49                      418- 420
 CPTCCS50                      421- 423
 CPTDAY1                       424- 426
 CPTDAY2                       427- 429
 CPTDAY3                       430- 432
 CPTDAY4                       433- 435
 CPTDAY5                       436- 438
 CPTDAY6                       439- 441
 CPTDAY7                       442- 444
 CPTDAY8                       445- 447
 CPTDAY9                       448- 450
 CPTDAY10                      451- 453
 CPTDAY11                      454- 456
 CPTDAY12                      457- 459
 CPTDAY13                      460- 462
 CPTDAY14                      463- 465
 CPTDAY15                      466- 468
 CPTDAY16                      469- 471
 CPTDAY17                      472- 474
 CPTDAY18                      475- 477
 CPTDAY19                      478- 480
 CPTDAY20                      481- 483
 CPTDAY21                      484- 486
 CPTDAY22                      487- 489
 CPTDAY23                      490- 492
 CPTDAY24                      493- 495
 CPTDAY25                      496- 498
 CPTDAY26                      499- 501
 CPTDAY27                      502- 504
 CPTDAY28                      505- 507
 CPTDAY29                      508- 510
 CPTDAY30                      511- 513
 CPTDAY31                      514- 516
 CPTDAY32                      517- 519
 CPTDAY33                      520- 522
 CPTDAY34                      523- 525
 CPTDAY35                      526- 528
 CPTDAY36                      529- 531
 CPTDAY37                      532- 534
 CPTDAY38                      535- 537
 CPTDAY39                      538- 540
 CPTDAY40                      541- 543
 CPTDAY41                      544- 546
 CPTDAY42                      547- 549
 CPTDAY43                      550- 552
 CPTDAY44                      553- 555
 CPTDAY45                      556- 558
 CPTDAY46                      559- 561
 CPTDAY47                      562- 564
 CPTDAY48                      565- 567
 CPTDAY49                      568- 570
 CPTDAY50                      571- 573
 DHOUR                         574- 577
 DIED                          578- 579
 DISP_X                        580- 581 (A)
 DISPUB04                      582- 583
 DISPUNIFORM                   584- 585
 DMONTH                        586- 587
 DQTR                          588- 589
 DURATION                      590- 595
 DXVER                         596- 598
 FEMALE                        599- 600
 HCUP_ED                       601- 602
 HCUP_OS                       603- 604
 HCUP_SURGERY_BROAD_CPT        605- 609
 HCUP_SURGERY_NARROW_CPT       610- 614
 HOSPST                        615- 616 (A)
 I10_DX_Visit_Reason1          617- 623 (A)
 I10_DX1                       624- 630 (A)
 I10_DX2                       631- 637 (A)
 I10_DX3                       638- 644 (A)
 I10_DX4                       645- 651 (A)
 I10_DX5                       652- 658 (A)
 I10_DX6                       659- 665 (A)
 I10_DX7                       666- 672 (A)
 I10_DX8                       673- 679 (A)
 I10_DX9                       680- 686 (A)
 I10_DX10                      687- 693 (A)
 I10_DX11                      694- 700 (A)
 I10_DX12                      701- 707 (A)
 I10_DX13                      708- 714 (A)
 I10_DX14                      715- 721 (A)
 I10_DX15                      722- 728 (A)
 I10_DX16                      729- 735 (A)
 I10_DX17                      736- 742 (A)
 I10_DX18                      743- 749 (A)
 I10_DX19                      750- 756 (A)
 I10_DX20                      757- 763 (A)
 I10_DX21                      764- 770 (A)
 I10_DX22                      771- 777 (A)
 I10_DX23                      778- 784 (A)
 I10_DX24                      785- 791 (A)
 I10_DX25                      792- 798 (A)
 I10_DX26                      799- 805 (A)
 I10_DX27                      806- 812 (A)
 I10_DX28                      813- 819 (A)
 I10_DX29                      820- 826 (A)
 I10_DX30                      827- 833 (A)
 I10_DX31                      834- 840 (A)
 I10_DX32                      841- 847 (A)
 I10_ECAUSE1                   848- 854 (A)
 I10_ECAUSE2                   855- 861 (A)
 I10_ECAUSE3                   862- 868 (A)
 I10_ECAUSE4                   869- 875 (A)
 I10_ECAUSE5                   876- 882 (A)
 I10_ECAUSE6                   883- 889 (A)
 I10_NDX                       890- 892
 I10_NECAUSE                   893- 894
 I10_PROCTYPE                  895- 897
 KEY                           898- 912
 LOS                           913- 917
 LOS_X                         918- 923
 MDNUM1_R                      924- 932
 MDNUM2_R                      933- 941
 MDNUM3_R                      942- 950
 MDNUM4_R                      951- 959
 MEDINCSTQ                     960- 961
 NCPT                          962- 965
 OPservice                     966     (A)
 PAY1                          967- 968
 PAY1_X                        969- 976 (A)
 PAY2                          977- 978
 PAY2_X                        979- 986 (A)
 PAY3                          987- 988
 PAY3_X                        989- 996 (A)
 PL_CBSA                       997- 999
 PL_NCHS                      1000-1001
 PL_RUCC                      1002-1003
 PL_UIC                       1004-1005
 PL_UR_CAT4                   1006-1007
 PointOfOrigin_X              1008-1010 (A)
 PointOfOriginUB04            1011     (A)
 PSTATE                       1012-1013 (A)
 PSTCO                        1014-1018
 PSTCO2                       1019-1023
 RACE_X                       1024-1026 (A)
 STATE_AS                     1027-1028
 STATE_ED                     1029-1030
 STATE_OS                     1031-1032
 TOTCHG                       1033-1042
 TOTCHG_X                     1043-1057
 YEAR                         1058-1061
 ZIP                          1062-1066 (A)
 ZIP3                         1067-1069 (A)
 ZIPINC_QRTL                  1070-1072
 HOSPID                       1073-1077
 AYEAR                        1078-1081
 BMONTH                       1082-1083
 BYEAR                        1084-1087.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OPservice                    "Indicator of outpatient service (as received from source)"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'DC_SASD_2016_CORE.SAV' /COMPRESSED.
