/*******************************************************************
* Creation Date: 05/13/2016   
*   GA_SASD_2011_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'GA_SASD_2011_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                          1-   2
 CHRON2                          3-   4
 CHRON3                          5-   6
 CHRON4                          7-   8
 CHRON5                          9-  10
 CHRON6                         11-  12
 CHRON7                         13-  14
 CHRON8                         15-  16
 CHRON9                         17-  18
 CHRON10                        19-  20
 CHRON11                        21-  22
 CHRON12                        23-  24
 CHRON13                        25-  26
 CHRON14                        27-  28
 CHRON15                        29-  30
 CHRON16                        31-  32
 CHRON17                        33-  34
 CHRON18                        35-  36
 CHRON19                        37-  38
 CHRON20                        39-  40
 CHRON21                        41-  42
 CHRON22                        43-  44
 CHRON23                        45-  46
 CHRON24                        47-  48
 CHRON25                        49-  50
 CHRON26                        51-  52
 CHRON27                        53-  54
 CHRON28                        55-  56
 CHRON29                        57-  58
 CHRON30                        59-  60
 CHRON31                        61-  62
 CHRON32                        63-  64
 CHRON33                        65-  66
 CHRON34                        67-  68
 CHRON35                        69-  70
 CHRON36                        71-  72
 CHRON37                        73-  74
 CHRON38                        75-  76
 CHRONB1                        77-  78
 CHRONB2                        79-  80
 CHRONB3                        81-  82
 CHRONB4                        83-  84
 CHRONB5                        85-  86
 CHRONB6                        87-  88
 CHRONB7                        89-  90
 CHRONB8                        91-  92
 CHRONB9                        93-  94
 CHRONB10                       95-  96
 CHRONB11                       97-  98
 CHRONB12                       99- 100
 CHRONB13                      101- 102
 CHRONB14                      103- 104
 CHRONB15                      105- 106
 CHRONB16                      107- 108
 CHRONB17                      109- 110
 CHRONB18                      111- 112
 CHRONB19                      113- 114
 CHRONB20                      115- 116
 CHRONB21                      117- 118
 CHRONB22                      119- 120
 CHRONB23                      121- 122
 CHRONB24                      123- 124
 CHRONB25                      125- 126
 CHRONB26                      127- 128
 CHRONB27                      129- 130
 CHRONB28                      131- 132
 CHRONB29                      133- 134
 CHRONB30                      135- 136
 CHRONB31                      137- 138
 CHRONB32                      139- 140
 CHRONB33                      141- 142
 CHRONB34                      143- 144
 CHRONB35                      145- 146
 CHRONB36                      147- 148
 CHRONB37                      149- 150
 CHRONB38                      151- 152
 DXMCCS1                       153- 163 (A)
 DXMCCS2                       164- 174 (A)
 DXMCCS3                       175- 185 (A)
 DXMCCS4                       186- 196 (A)
 DXMCCS5                       197- 207 (A)
 DXMCCS6                       208- 218 (A)
 DXMCCS7                       219- 229 (A)
 DXMCCS8                       230- 240 (A)
 DXMCCS9                       241- 251 (A)
 DXMCCS10                      252- 262 (A)
 DXMCCS11                      263- 273 (A)
 DXMCCS12                      274- 284 (A)
 DXMCCS13                      285- 295 (A)
 DXMCCS14                      296- 306 (A)
 DXMCCS15                      307- 317 (A)
 DXMCCS16                      318- 328 (A)
 DXMCCS17                      329- 339 (A)
 DXMCCS18                      340- 350 (A)
 DXMCCS19                      351- 361 (A)
 DXMCCS20                      362- 372 (A)
 DXMCCS21                      373- 383 (A)
 DXMCCS22                      384- 394 (A)
 DXMCCS23                      395- 405 (A)
 DXMCCS24                      406- 416 (A)
 DXMCCS25                      417- 427 (A)
 DXMCCS26                      428- 438 (A)
 DXMCCS27                      439- 449 (A)
 DXMCCS28                      450- 460 (A)
 DXMCCS29                      461- 471 (A)
 DXMCCS30                      472- 482 (A)
 DXMCCS31                      483- 493 (A)
 DXMCCS32                      494- 504 (A)
 DXMCCS33                      505- 515 (A)
 DXMCCS34                      516- 526 (A)
 DXMCCS35                      527- 537 (A)
 DXMCCS36                      538- 548 (A)
 DXMCCS37                      549- 559 (A)
 DXMCCS38                      560- 570 (A)
 E_MCCS1                       571- 581 (A)
 E_MCCS2                       582- 592 (A)
 E_MCCS3                       593- 603 (A)
 E_MCCS4                       604- 614 (A)
 E_MCCS5                       615- 625 (A)
 E_MCCS6                       626- 636 (A)
 E_MCCS7                       637- 647 (A)
 E_MCCS8                       648- 658 (A)
 E_MCCS9                       659- 669 (A)
 E_MCCS10                      670- 680 (A)
 E_MCCS11                      681- 691 (A)
 E_MCCS12                      692- 702 (A)
 E_MCCS13                      703- 713 (A)
 E_MCCS14                      714- 724 (A)
 E_MCCS15                      725- 735 (A)
 E_MCCS16                      736- 746 (A)
 INJURY                        747- 748
 INJURY_CUT                    749- 750
 INJURY_DROWN                  751- 752
 INJURY_FALL                   753- 754
 INJURY_FIRE                   755- 756
 INJURY_FIREARM                757- 758
 INJURY_MACHINERY              759- 760
 INJURY_MVT                    761- 762
 INJURY_NATURE                 763- 764
 INJURY_POISON                 765- 766
 INJURY_STRUCK                 767- 768
 INJURY_SUFFOCATION            769- 770
 INTENT_ASSAULT                771- 772
 INTENT_SELF_HARM              773- 774
 INTENT_UNINTENTIONAL          775- 776
 KEY                           777- 791
 MULTINJURY                    792- 793
 PCLASS1                       794- 795
 PCLASS2                       796- 797
 PCLASS3                       798- 799
 PCLASS4                       800- 801
 PCLASS5                       802- 803
 PCLASS6                       804- 805
 PCLASS7                       806- 807
 PCLASS8                       808- 809
 PCLASS9                       810- 811
 PCLASS10                      812- 813
 PCLASS11                      814- 815
 PCLASS12                      816- 817
 PCLASS13                      818- 819
 PCLASS14                      820- 821
 PCLASS15                      822- 823
 PCLASS16                      824- 825
 PCLASS17                      826- 827
 PCLASS18                      828- 829
 PCLASS19                      830- 831
 PCLASS20                      832- 833
 PCLASS21                      834- 835
 PCLASS22                      836- 837
 PCLASS23                      838- 839
 PCLASS24                      840- 841
 PCLASS25                      842- 843
 PRMCCS1                       844- 851 (A)
 PRMCCS2                       852- 859 (A)
 PRMCCS3                       860- 867 (A)
 PRMCCS4                       868- 875 (A)
 PRMCCS5                       876- 883 (A)
 PRMCCS6                       884- 891 (A)
 PRMCCS7                       892- 899 (A)
 PRMCCS8                       900- 907 (A)
 PRMCCS9                       908- 915 (A)
 PRMCCS10                      916- 923 (A)
 PRMCCS11                      924- 931 (A)
 PRMCCS12                      932- 939 (A)
 PRMCCS13                      940- 947 (A)
 PRMCCS14                      948- 955 (A)
 PRMCCS15                      956- 963 (A)
 PRMCCS16                      964- 971 (A)
 PRMCCS17                      972- 979 (A)
 PRMCCS18                      980- 987 (A)
 PRMCCS19                      988- 995 (A)
 PRMCCS20                      996-1003 (A)
 PRMCCS21                     1004-1011 (A)
 PRMCCS22                     1012-1019 (A)
 PRMCCS23                     1020-1027 (A)
 PRMCCS24                     1028-1035 (A)
 PRMCCS25                     1036-1043 (A)
 U_BLOOD                      1044-1045
 U_CATH                       1046-1047
 U_CCU                        1048-1049
 U_CHESTXRAY                  1050-1051
 U_CTSCAN                     1052-1053
 U_DIALYSIS                   1054-1055
 U_ECHO                       1056-1057
 U_ED                         1058-1059
 U_EEG                        1060-1061
 U_EKG                        1062-1063
 U_EPO                        1064-1065
 U_ICU                        1066-1067
 U_LITHOTRIPSY                1068-1069
 U_MHSA                       1070-1071
 U_MRT                        1072-1073
 U_NEWBN2L                    1074-1075
 U_NEWBN3L                    1076-1077
 U_NEWBN4L                    1078-1079
 U_NUCMED                     1080-1081
 U_OBSERVATION                1082-1083
 U_OCCTHERAPY                 1084-1085
 U_ORGANACQ                   1086-1087
 U_OTHIMPLANTS                1088-1089
 U_PACEMAKER                  1090-1091
 U_PHYTHERAPY                 1092-1093
 U_RADTHERAPY                 1094-1095
 U_RESPTHERAPY                1096-1097
 U_SPEECHTHERAPY              1098-1099
 U_STRESS                     1100-1101
 U_ULTRASOUND                 1102-1103.


***  Specify write formats  ***.
FORMATS
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 CHRON33                      (F3.0) /
 CHRON34                      (F3.0) /
 CHRON35                      (F3.0) /
 CHRON36                      (F3.0) /
 CHRON37                      (F3.0) /
 CHRON38                      (F3.0) /
 CHRONB1                      (F3.0) /
 CHRONB2                      (F3.0) /
 CHRONB3                      (F3.0) /
 CHRONB4                      (F3.0) /
 CHRONB5                      (F3.0) /
 CHRONB6                      (F3.0) /
 CHRONB7                      (F3.0) /
 CHRONB8                      (F3.0) /
 CHRONB9                      (F3.0) /
 CHRONB10                     (F3.0) /
 CHRONB11                     (F3.0) /
 CHRONB12                     (F3.0) /
 CHRONB13                     (F3.0) /
 CHRONB14                     (F3.0) /
 CHRONB15                     (F3.0) /
 CHRONB16                     (F3.0) /
 CHRONB17                     (F3.0) /
 CHRONB18                     (F3.0) /
 CHRONB19                     (F3.0) /
 CHRONB20                     (F3.0) /
 CHRONB21                     (F3.0) /
 CHRONB22                     (F3.0) /
 CHRONB23                     (F3.0) /
 CHRONB24                     (F3.0) /
 CHRONB25                     (F3.0) /
 CHRONB26                     (F3.0) /
 CHRONB27                     (F3.0) /
 CHRONB28                     (F3.0) /
 CHRONB29                     (F3.0) /
 CHRONB30                     (F3.0) /
 CHRONB31                     (F3.0) /
 CHRONB32                     (F3.0) /
 CHRONB33                     (F3.0) /
 CHRONB34                     (F3.0) /
 CHRONB35                     (F3.0) /
 CHRONB36                     (F3.0) /
 CHRONB37                     (F3.0) /
 CHRONB38                     (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 CHRON33                      "Chronic condition indicator 33"
 CHRON34                      "Chronic condition indicator 34"
 CHRON35                      "Chronic condition indicator 35"
 CHRON36                      "Chronic condition indicator 36"
 CHRON37                      "Chronic condition indicator 37"
 CHRON38                      "Chronic condition indicator 38"
 CHRONB1                      "Chronic condition body system 1"
 CHRONB2                      "Chronic condition body system 2"
 CHRONB3                      "Chronic condition body system 3"
 CHRONB4                      "Chronic condition body system 4"
 CHRONB5                      "Chronic condition body system 5"
 CHRONB6                      "Chronic condition body system 6"
 CHRONB7                      "Chronic condition body system 7"
 CHRONB8                      "Chronic condition body system 8"
 CHRONB9                      "Chronic condition body system 9"
 CHRONB10                     "Chronic condition body system 10"
 CHRONB11                     "Chronic condition body system 11"
 CHRONB12                     "Chronic condition body system 12"
 CHRONB13                     "Chronic condition body system 13"
 CHRONB14                     "Chronic condition body system 14"
 CHRONB15                     "Chronic condition body system 15"
 CHRONB16                     "Chronic condition body system 16"
 CHRONB17                     "Chronic condition body system 17"
 CHRONB18                     "Chronic condition body system 18"
 CHRONB19                     "Chronic condition body system 19"
 CHRONB20                     "Chronic condition body system 20"
 CHRONB21                     "Chronic condition body system 21"
 CHRONB22                     "Chronic condition body system 22"
 CHRONB23                     "Chronic condition body system 23"
 CHRONB24                     "Chronic condition body system 24"
 CHRONB25                     "Chronic condition body system 25"
 CHRONB26                     "Chronic condition body system 26"
 CHRONB27                     "Chronic condition body system 27"
 CHRONB28                     "Chronic condition body system 28"
 CHRONB29                     "Chronic condition body system 29"
 CHRONB30                     "Chronic condition body system 30"
 CHRONB31                     "Chronic condition body system 31"
 CHRONB32                     "Chronic condition body system 32"
 CHRONB33                     "Chronic condition body system 33"
 CHRONB34                     "Chronic condition body system 34"
 CHRONB35                     "Chronic condition body system 35"
 CHRONB36                     "Chronic condition body system 36"
 CHRONB37                     "Chronic condition body system 37"
 CHRONB38                     "Chronic condition body system 38"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                     "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                     "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                     "Multi-Level CCS:  Diagnosis 35"
 DXMCCS36                     "Multi-Level CCS:  Diagnosis 36"
 DXMCCS37                     "Multi-Level CCS:  Diagnosis 37"
 DXMCCS38                     "Multi-Level CCS:  Diagnosis 38"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 E_MCCS9                      "Multi-Level CCS:  E Code 9"
 E_MCCS10                     "Multi-Level CCS:  E Code 10"
 E_MCCS11                     "Multi-Level CCS:  E Code 11"
 E_MCCS12                     "Multi-Level CCS:  E Code 12"
 E_MCCS13                     "Multi-Level CCS:  E Code 13"
 E_MCCS14                     "Multi-Level CCS:  E Code 14"
 E_MCCS15                     "Multi-Level CCS:  E Code 15"
 E_MCCS16                     "Multi-Level CCS:  E Code 16"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB38
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'GA_SASD_2011_DX_PR_GRPS.SAV' /COMPRESSED.
