/*******************************************************************
* Creation Date: 05/13/2016   
*   GA_SASD_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'GA_SASD_2012_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 CPT1                           20-  24 (A)
 CPT2                           25-  29 (A)
 CPT3                           30-  34 (A)
 CPT4                           35-  39 (A)
 CPT5                           40-  44 (A)
 CPT6                           45-  49 (A)
 CPT7                           50-  54 (A)
 CPT8                           55-  59 (A)
 CPT9                           60-  64 (A)
 CPT10                          65-  69 (A)
 CPT11                          70-  74 (A)
 CPT12                          75-  79 (A)
 CPT13                          80-  84 (A)
 CPT14                          85-  89 (A)
 CPT15                          90-  94 (A)
 CPT16                          95-  99 (A)
 CPT17                         100- 104 (A)
 CPT18                         105- 109 (A)
 CPT19                         110- 114 (A)
 CPT20                         115- 119 (A)
 CPT21                         120- 124 (A)
 CPT22                         125- 129 (A)
 CPT23                         130- 134 (A)
 CPT24                         135- 139 (A)
 CPT25                         140- 144 (A)
 CPT26                         145- 149 (A)
 CPT27                         150- 154 (A)
 CPT28                         155- 159 (A)
 CPT29                         160- 164 (A)
 CPT30                         165- 169 (A)
 CPT31                         170- 174 (A)
 CPT32                         175- 179 (A)
 CPT33                         180- 184 (A)
 CPT34                         185- 189 (A)
 CPT35                         190- 194 (A)
 CPT36                         195- 199 (A)
 CPT37                         200- 204 (A)
 CPT38                         205- 209 (A)
 CPT39                         210- 214 (A)
 CPT40                         215- 219 (A)
 CPT41                         220- 224 (A)
 CPT42                         225- 229 (A)
 CPT43                         230- 234 (A)
 CPT44                         235- 239 (A)
 CPT45                         240- 244 (A)
 CPT46                         245- 249 (A)
 CPT47                         250- 254 (A)
 CPT48                         255- 259 (A)
 CPT49                         260- 264 (A)
 CPT50                         265- 269 (A)
 CPTCCS1                       270- 272
 CPTCCS2                       273- 275
 CPTCCS3                       276- 278
 CPTCCS4                       279- 281
 CPTCCS5                       282- 284
 CPTCCS6                       285- 287
 CPTCCS7                       288- 290
 CPTCCS8                       291- 293
 CPTCCS9                       294- 296
 CPTCCS10                      297- 299
 CPTCCS11                      300- 302
 CPTCCS12                      303- 305
 CPTCCS13                      306- 308
 CPTCCS14                      309- 311
 CPTCCS15                      312- 314
 CPTCCS16                      315- 317
 CPTCCS17                      318- 320
 CPTCCS18                      321- 323
 CPTCCS19                      324- 326
 CPTCCS20                      327- 329
 CPTCCS21                      330- 332
 CPTCCS22                      333- 335
 CPTCCS23                      336- 338
 CPTCCS24                      339- 341
 CPTCCS25                      342- 344
 CPTCCS26                      345- 347
 CPTCCS27                      348- 350
 CPTCCS28                      351- 353
 CPTCCS29                      354- 356
 CPTCCS30                      357- 359
 CPTCCS31                      360- 362
 CPTCCS32                      363- 365
 CPTCCS33                      366- 368
 CPTCCS34                      369- 371
 CPTCCS35                      372- 374
 CPTCCS36                      375- 377
 CPTCCS37                      378- 380
 CPTCCS38                      381- 383
 CPTCCS39                      384- 386
 CPTCCS40                      387- 389
 CPTCCS41                      390- 392
 CPTCCS42                      393- 395
 CPTCCS43                      396- 398
 CPTCCS44                      399- 401
 CPTCCS45                      402- 404
 CPTCCS46                      405- 407
 CPTCCS47                      408- 410
 CPTCCS48                      411- 413
 CPTCCS49                      414- 416
 CPTCCS50                      417- 419
 CPTDAY1                       420- 422
 CPTDAY2                       423- 425
 CPTDAY3                       426- 428
 CPTDAY4                       429- 431
 CPTDAY5                       432- 434
 CPTDAY6                       435- 437
 CPTDAY7                       438- 440
 CPTDAY8                       441- 443
 CPTDAY9                       444- 446
 CPTDAY10                      447- 449
 CPTDAY11                      450- 452
 CPTDAY12                      453- 455
 CPTDAY13                      456- 458
 CPTDAY14                      459- 461
 CPTDAY15                      462- 464
 CPTDAY16                      465- 467
 CPTDAY17                      468- 470
 CPTDAY18                      471- 473
 CPTDAY19                      474- 476
 CPTDAY20                      477- 479
 CPTDAY21                      480- 482
 CPTDAY22                      483- 485
 CPTDAY23                      486- 488
 CPTDAY24                      489- 491
 CPTDAY25                      492- 494
 CPTDAY26                      495- 497
 CPTDAY27                      498- 500
 CPTDAY28                      501- 503
 CPTDAY29                      504- 506
 CPTDAY30                      507- 509
 CPTDAY31                      510- 512
 CPTDAY32                      513- 515
 CPTDAY33                      516- 518
 CPTDAY34                      519- 521
 CPTDAY35                      522- 524
 CPTDAY36                      525- 527
 CPTDAY37                      528- 530
 CPTDAY38                      531- 533
 CPTDAY39                      534- 536
 CPTDAY40                      537- 539
 CPTDAY41                      540- 542
 CPTDAY42                      543- 545
 CPTDAY43                      546- 548
 CPTDAY44                      549- 551
 CPTDAY45                      552- 554
 CPTDAY46                      555- 557
 CPTDAY47                      558- 560
 CPTDAY48                      561- 563
 CPTDAY49                      564- 566
 CPTDAY50                      567- 569
 DIED                          570- 571
 DISPUB04                      572- 573
 DISPUNIFORM                   574- 575
 DISP_X                        576- 577 (A)
 DQTR                          578- 579
 DX1                           580- 586 (A)
 DX2                           587- 593 (A)
 DX3                           594- 600 (A)
 DX4                           601- 607 (A)
 DX5                           608- 614 (A)
 DX6                           615- 621 (A)
 DX7                           622- 628 (A)
 DX8                           629- 635 (A)
 DX9                           636- 642 (A)
 DX10                          643- 649 (A)
 DX11                          650- 656 (A)
 DX12                          657- 663 (A)
 DX13                          664- 670 (A)
 DX14                          671- 677 (A)
 DX15                          678- 684 (A)
 DX16                          685- 691 (A)
 DX17                          692- 698 (A)
 DX18                          699- 705 (A)
 DX19                          706- 712 (A)
 DX20                          713- 719 (A)
 DX21                          720- 726 (A)
 DX22                          727- 733 (A)
 DX23                          734- 740 (A)
 DX24                          741- 747 (A)
 DX25                          748- 754 (A)
 DX26                          755- 761 (A)
 DX27                          762- 768 (A)
 DX28                          769- 775 (A)
 DX29                          776- 782 (A)
 DX30                          783- 789 (A)
 DX31                          790- 796 (A)
 DX32                          797- 803 (A)
 DX33                          804- 810 (A)
 DX34                          811- 817 (A)
 DX35                          818- 824 (A)
 DXCCS1                        825- 828
 DXCCS2                        829- 832
 DXCCS3                        833- 836
 DXCCS4                        837- 840
 DXCCS5                        841- 844
 DXCCS6                        845- 848
 DXCCS7                        849- 852
 DXCCS8                        853- 856
 DXCCS9                        857- 860
 DXCCS10                       861- 864
 DXCCS11                       865- 868
 DXCCS12                       869- 872
 DXCCS13                       873- 876
 DXCCS14                       877- 880
 DXCCS15                       881- 884
 DXCCS16                       885- 888
 DXCCS17                       889- 892
 DXCCS18                       893- 896
 DXCCS19                       897- 900
 DXCCS20                       901- 904
 DXCCS21                       905- 908
 DXCCS22                       909- 912
 DXCCS23                       913- 916
 DXCCS24                       917- 920
 DXCCS25                       921- 924
 DXCCS26                       925- 928
 DXCCS27                       929- 932
 DXCCS28                       933- 936
 DXCCS29                       937- 940
 DXCCS30                       941- 944
 DXCCS31                       945- 948
 DXCCS32                       949- 952
 DXCCS33                       953- 956
 DXCCS34                       957- 960
 DXCCS35                       961- 964
 DXPOA1                        965     (A)
 DXPOA2                        966     (A)
 DXPOA3                        967     (A)
 DXPOA4                        968     (A)
 DXPOA5                        969     (A)
 DXPOA6                        970     (A)
 DXPOA7                        971     (A)
 DXPOA8                        972     (A)
 DXPOA9                        973     (A)
 DXPOA10                       974     (A)
 DXPOA11                       975     (A)
 DXPOA12                       976     (A)
 DXPOA13                       977     (A)
 DXPOA14                       978     (A)
 DXPOA15                       979     (A)
 DXPOA16                       980     (A)
 DXPOA17                       981     (A)
 DXPOA18                       982     (A)
 DXPOA19                       983     (A)
 DXPOA20                       984     (A)
 DXPOA21                       985     (A)
 DXPOA22                       986     (A)
 DXPOA23                       987     (A)
 DXPOA24                       988     (A)
 DXPOA25                       989     (A)
 DXPOA26                       990     (A)
 DXPOA27                       991     (A)
 DXPOA28                       992     (A)
 DXPOA29                       993     (A)
 DXPOA30                       994     (A)
 DXPOA31                       995     (A)
 DXPOA32                       996     (A)
 DXPOA33                       997     (A)
 DXPOA34                       998     (A)
 DXPOA35                       999     (A)
 DaysToEvent                  1000-1005
 ECODE1                       1006-1012 (A)
 ECODE2                       1013-1019 (A)
 ECODE3                       1020-1026 (A)
 ECODE4                       1027-1033 (A)
 ECODE5                       1034-1040 (A)
 ECODE6                       1041-1047 (A)
 ECODE7                       1048-1054 (A)
 ECODE8                       1055-1061 (A)
 ECODE9                       1062-1068 (A)
 ECODE10                      1069-1075 (A)
 ECODE11                      1076-1082 (A)
 ECODE12                      1083-1089 (A)
 ECODE13                      1090-1096 (A)
 ECODE14                      1097-1103 (A)
 ECODE15                      1104-1110 (A)
 ECODE16                      1111-1117 (A)
 ECODE17                      1118-1124 (A)
 ECODE18                      1125-1131 (A)
 ECODE19                      1132-1138 (A)
 ECODE20                      1139-1145 (A)
 E_CCS1                       1146-1149
 E_CCS2                       1150-1153
 E_CCS3                       1154-1157
 E_CCS4                       1158-1161
 E_CCS5                       1162-1165
 E_CCS6                       1166-1169
 E_CCS7                       1170-1173
 E_CCS8                       1174-1177
 E_CCS9                       1178-1181
 E_CCS10                      1182-1185
 E_CCS11                      1186-1189
 E_CCS12                      1190-1193
 E_CCS13                      1194-1197
 E_CCS14                      1198-1201
 E_CCS15                      1202-1205
 E_CCS16                      1206-1209
 E_CCS17                      1210-1213
 E_CCS18                      1214-1217
 E_CCS19                      1218-1221
 E_CCS20                      1222-1225
 E_POA1                       1226     (A)
 E_POA2                       1227     (A)
 E_POA3                       1228     (A)
 E_POA4                       1229     (A)
 E_POA5                       1230     (A)
 E_POA6                       1231     (A)
 E_POA7                       1232     (A)
 E_POA8                       1233     (A)
 E_POA9                       1234     (A)
 E_POA10                      1235     (A)
 E_POA11                      1236     (A)
 E_POA12                      1237     (A)
 E_POA13                      1238     (A)
 E_POA14                      1239     (A)
 E_POA15                      1240     (A)
 E_POA16                      1241     (A)
 E_POA17                      1242     (A)
 E_POA18                      1243     (A)
 E_POA19                      1244     (A)
 E_POA20                      1245     (A)
 FEMALE                       1246-1247
 HCUP_ED                      1248-1249
 HCUP_OS                      1250-1251
 HISPANIC_X                   1252     (A)
 HOSPBRTH                     1253-1255
 HOSPST                       1256-1257 (A)
 Homeless                     1258-1259
 KEY                          1260-1274
 LOS                          1275-1279
 LOS_X                        1280-1285
 MARITALSTATUSUB04            1286     (A)
 MARITALSTATUS_X              1287     (A)
 MDNUM1_R                     1288-1296
 MDNUM2_R                     1297-1305
 MDNUM3_R                     1306-1314
 MDNUM4_R                     1315-1323
 MEDINCSTQ                    1324-1325
 NCHRONIC                     1326-1328
 NCPT                         1329-1332
 NDX                          1333-1335
 NECODE                       1336-1337
 NEOMAT                       1338-1339
 NPR                          1340-1342
 OPservice                    1343-1344 (A)
 ORPROC                       1345-1346
 OS_TIME                      1347-1354
 PAY1                         1355-1356
 PAY1_X                       1357-1360 (A)
 PAY2                         1361-1362
 PAY2_X                       1363-1366 (A)
 PAY3                         1367-1368
 PAY3_X                       1369-1372 (A)
 PL_CBSA                      1373-1375
 PL_MSA1993                   1376-1378
 PL_NCHS2006                  1379-1380
 PL_RUCA10_2005               1381-1382
 PL_RUCA2005                  1383-1386
 PL_RUCA4_2005                1387-1388
 PL_RUCC2003                  1389-1390
 PL_UIC2003                   1391-1392
 PL_UR_CAT4                   1393-1394
 PR1                          1395-1401 (A)
 PR2                          1402-1408 (A)
 PR3                          1409-1415 (A)
 PR4                          1416-1422 (A)
 PR5                          1423-1429 (A)
 PR6                          1430-1436 (A)
 PR7                          1437-1443 (A)
 PR8                          1444-1450 (A)
 PR9                          1451-1457 (A)
 PR10                         1458-1464 (A)
 PR11                         1465-1471 (A)
 PR12                         1472-1478 (A)
 PR13                         1479-1485 (A)
 PR14                         1486-1492 (A)
 PR15                         1493-1499 (A)
 PR16                         1500-1506 (A)
 PR17                         1507-1513 (A)
 PR18                         1514-1520 (A)
 PR19                         1521-1527 (A)
 PR20                         1528-1534 (A)
 PR21                         1535-1541 (A)
 PR22                         1542-1548 (A)
 PR23                         1549-1555 (A)
 PR24                         1556-1562 (A)
 PR25                         1563-1569 (A)
 PRCCS1                       1570-1572
 PRCCS2                       1573-1575
 PRCCS3                       1576-1578
 PRCCS4                       1579-1581
 PRCCS5                       1582-1584
 PRCCS6                       1585-1587
 PRCCS7                       1588-1590
 PRCCS8                       1591-1593
 PRCCS9                       1594-1596
 PRCCS10                      1597-1599
 PRCCS11                      1600-1602
 PRCCS12                      1603-1605
 PRCCS13                      1606-1608
 PRCCS14                      1609-1611
 PRCCS15                      1612-1614
 PRCCS16                      1615-1617
 PRCCS17                      1618-1620
 PRCCS18                      1621-1623
 PRCCS19                      1624-1626
 PRCCS20                      1627-1629
 PRCCS21                      1630-1632
 PRCCS22                      1633-1635
 PRCCS23                      1636-1638
 PRCCS24                      1639-1641
 PRCCS25                      1642-1644
 PRDAY1                       1645-1649
 PRDAY2                       1650-1654
 PRDAY3                       1655-1659
 PRDAY4                       1660-1664
 PRDAY5                       1665-1669
 PRDAY6                       1670-1674
 PRDAY7                       1675-1679
 PRDAY8                       1680-1684
 PRDAY9                       1685-1689
 PRDAY10                      1690-1694
 PRDAY11                      1695-1699
 PRDAY12                      1700-1704
 PRDAY13                      1705-1709
 PRDAY14                      1710-1714
 PRDAY15                      1715-1719
 PRDAY16                      1720-1724
 PRDAY17                      1725-1729
 PRDAY18                      1730-1734
 PRDAY19                      1735-1739
 PRDAY20                      1740-1744
 PRDAY21                      1745-1749
 PRDAY22                      1750-1754
 PRDAY23                      1755-1759
 PRDAY24                      1760-1764
 PRDAY25                      1765-1769
 PROCTYPE                     1770-1772
 PSTATE                       1773-1774 (A)
 PSTCO                        1775-1779
 PSTCO2                       1780-1784
 PointOfOriginUB04            1785     (A)
 PointOfOrigin_X              1786     (A)
 RACE                         1787-1788
 RACE_X                       1789     (A)
 STATE_AS                     1790-1791
 STATE_ED                     1792-1793
 STATE_OS                     1794-1795
 TOTCHG                       1796-1805
 TOTCHG_X                     1806-1820
 VisitLink                    1821-1829
 YEAR                         1830-1833
 ZIP3                         1834-1836 (A)
 ZIPINC_QRTL                  1837-1839
 HOSPID                       1840-1844
 ZIP                          1845-1849 (A)
 AYEAR                        1850-1853
 DMONTH                       1854-1855
 BMONTH                       1856-1857
 BYEAR                        1858-1861
 PRMONTH1                     1862-1863
 PRMONTH2                     1864-1865
 PRMONTH3                     1866-1867
 PRMONTH4                     1868-1869
 PRMONTH5                     1870-1871
 PRMONTH6                     1872-1873
 PRMONTH7                     1874-1875
 PRMONTH8                     1876-1877
 PRMONTH9                     1878-1879
 PRMONTH10                    1880-1881
 PRMONTH11                    1882-1883
 PRMONTH12                    1884-1885
 PRMONTH13                    1886-1887
 PRMONTH14                    1888-1889
 PRMONTH15                    1890-1891
 PRMONTH16                    1892-1893
 PRMONTH17                    1894-1895
 PRMONTH18                    1896-1897
 PRMONTH19                    1898-1899
 PRMONTH20                    1900-1901
 PRMONTH21                    1902-1903
 PRMONTH22                    1904-1905
 PRMONTH23                    1906-1907
 PRMONTH24                    1908-1909
 PRMONTH25                    1910-1911
 PRYEAR1                      1912-1915
 PRYEAR2                      1916-1919
 PRYEAR3                      1920-1923
 PRYEAR4                      1924-1927
 PRYEAR5                      1928-1931
 PRYEAR6                      1932-1935
 PRYEAR7                      1936-1939
 PRYEAR8                      1940-1943
 PRYEAR9                      1944-1947
 PRYEAR10                     1948-1951
 PRYEAR11                     1952-1955
 PRYEAR12                     1956-1959
 PRYEAR13                     1960-1963
 PRYEAR14                     1964-1967
 PRYEAR15                     1968-1971
 PRYEAR16                     1972-1975
 PRYEAR17                     1976-1979
 PRYEAR18                     1980-1983
 PRYEAR19                     1984-1987
 PRYEAR20                     1988-1991
 PRYEAR21                     1992-1995
 PRYEAR22                     1996-1999
 PRYEAR23                     2000-2003
 PRYEAR24                     2004-2007
 PRYEAR25                     2008-2011.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 DXCCS31                      (F4.0) /
 DXCCS32                      (F4.0) /
 DXCCS33                      (F4.0) /
 DXCCS34                      (F4.0) /
 DXCCS35                      (F4.0) /
 DaysToEvent                  (F8.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 E_CCS9                       (F3.0) /
 E_CCS10                      (F3.0) /
 E_CCS11                      (F3.0) /
 E_CCS12                      (F3.0) /
 E_CCS13                      (F3.0) /
 E_CCS14                      (F3.0) /
 E_CCS15                      (F3.0) /
 E_CCS16                      (F3.0) /
 E_CCS17                      (F3.0) /
 E_CCS18                      (F3.0) /
 E_CCS19                      (F3.0) /
 E_CCS20                      (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 Homeless                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 OS_TIME                      (F4.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_MSA1993                   (F3.0) /
 PL_NCHS2006                  (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA2005                  (F4.1) /
 PL_RUCA4_2005                (F3.0) /
 PL_RUCC2003                  (F3.0) /
 PL_UIC2003                   (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 DMONTH                       (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "UB-92 bill type"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DQTR                         "Discharge quarter"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DX31                         "Diagnosis 31"
 DX32                         "Diagnosis 32"
 DX33                         "Diagnosis 33"
 DX34                         "Diagnosis 34"
 DX35                         "Diagnosis 35"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXCCS31                      "CCS: diagnosis 31"
 DXCCS32                      "CCS: diagnosis 32"
 DXCCS33                      "CCS: diagnosis 33"
 DXCCS34                      "CCS: diagnosis 34"
 DXCCS35                      "CCS: diagnosis 35"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DaysToEvent                  "Days from 'start date' to admission"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 ECODE9                       "E code 9"
 ECODE10                      "E code 10"
 ECODE11                      "E code 11"
 ECODE12                      "E code 12"
 ECODE13                      "E code 13"
 ECODE14                      "E code 14"
 ECODE15                      "E code 15"
 ECODE16                      "E code 16"
 ECODE17                      "E code 17"
 ECODE18                      "E code 18"
 ECODE19                      "E code 19"
 ECODE20                      "E code 20"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_CCS9                       "CCS: E Code 9"
 E_CCS10                      "CCS: E Code 10"
 E_CCS11                      "CCS: E Code 11"
 E_CCS12                      "CCS: E Code 12"
 E_CCS13                      "CCS: E Code 13"
 E_CCS14                      "CCS: E Code 14"
 E_CCS15                      "CCS: E Code 15"
 E_CCS16                      "CCS: E Code 16"
 E_CCS17                      "CCS: E Code 17"
 E_CCS18                      "CCS: E Code 18"
 E_CCS19                      "CCS: E Code 19"
 E_CCS20                      "CCS: E Code 20"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 E_POA9                       "E Code 9, present on admission indicator"
 E_POA10                      "E Code 10, present on admission indicator"
 E_POA11                      "E Code 11, present on admission indicator"
 E_POA12                      "E Code 12, present on admission indicator"
 E_POA13                      "E Code 13, present on admission indicator"
 E_POA14                      "E Code 14, present on admission indicator"
 E_POA15                      "E Code 15, present on admission indicator"
 E_POA16                      "E Code 16, present on admission indicator"
 E_POA17                      "E Code 17, present on admission indicator"
 E_POA18                      "E Code 18, present on admission indicator"
 E_POA19                      "E Code 19, present on admission indicator"
 E_POA20                      "E Code 20, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 Homeless                     "Indicator that patient is homeless"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 OPservice                    "Indicator of outpatient service (as received from source)"
 ORPROC                       "Major operating room procedure indicator"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993                   "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006                  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005                  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003                  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003                   "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PRDAY21                      "Number of days from admission to PR21"
 PRDAY22                      "Number of days from admission to PR22"
 PRDAY23                      "Number of days from admission to PR23"
 PRDAY24                      "Number of days from admission to PR24"
 PRDAY25                      "Number of days from admission to PR25"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 ZIP                          "Patient ZIP Code"
 AYEAR                        "Admission year"
 DMONTH                       "Discharge month"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'GA_SASD_2012_CORE.SAV' /COMPRESSED.
