/*******************************************************************
* Creation Date: 03/12/2018   
*   KS_SASD_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'KS_SASD_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_BODYSYSTEM10               19-  20
 I10_BODYSYSTEM11               21-  22
 I10_BODYSYSTEM12               23-  24
 I10_BODYSYSTEM13               25-  26
 I10_BODYSYSTEM14               27-  28
 I10_BODYSYSTEM15               29-  30
 I10_BODYSYSTEM16               31-  32
 I10_BODYSYSTEM17               33-  34
 I10_BODYSYSTEM18               35-  36
 I10_BODYSYSTEM19               37-  38
 I10_BODYSYSTEM20               39-  40
 I10_BODYSYSTEM21               41-  42
 I10_BODYSYSTEM22               43-  44
 I10_BODYSYSTEM23               45-  46
 I10_BODYSYSTEM24               47-  48
 I10_BODYSYSTEM25               49-  50
 I10_BODYSYSTEM26               51-  52
 I10_BODYSYSTEM27               53-  54
 I10_BODYSYSTEM28               55-  56
 I10_BODYSYSTEM29               57-  58
 I10_BODYSYSTEM30               59-  60
 I10_CHRON1                     61-  62
 I10_CHRON2                     63-  64
 I10_CHRON3                     65-  66
 I10_CHRON4                     67-  68
 I10_CHRON5                     69-  70
 I10_CHRON6                     71-  72
 I10_CHRON7                     73-  74
 I10_CHRON8                     75-  76
 I10_CHRON9                     77-  78
 I10_CHRON10                    79-  80
 I10_CHRON11                    81-  82
 I10_CHRON12                    83-  84
 I10_CHRON13                    85-  86
 I10_CHRON14                    87-  88
 I10_CHRON15                    89-  90
 I10_CHRON16                    91-  92
 I10_CHRON17                    93-  94
 I10_CHRON18                    95-  96
 I10_CHRON19                    97-  98
 I10_CHRON20                    99- 100
 I10_CHRON21                   101- 102
 I10_CHRON22                   103- 104
 I10_CHRON23                   105- 106
 I10_CHRON24                   107- 108
 I10_CHRON25                   109- 110
 I10_CHRON26                   111- 112
 I10_CHRON27                   113- 114
 I10_CHRON28                   115- 116
 I10_CHRON29                   117- 118
 I10_CHRON30                   119- 120
 I10_DXMCCS1                   121- 131 (A)
 I10_DXMCCS2                   132- 142 (A)
 I10_DXMCCS3                   143- 153 (A)
 I10_DXMCCS4                   154- 164 (A)
 I10_DXMCCS5                   165- 175 (A)
 I10_DXMCCS6                   176- 186 (A)
 I10_DXMCCS7                   187- 197 (A)
 I10_DXMCCS8                   198- 208 (A)
 I10_DXMCCS9                   209- 219 (A)
 I10_DXMCCS10                  220- 230 (A)
 I10_DXMCCS11                  231- 241 (A)
 I10_DXMCCS12                  242- 252 (A)
 I10_DXMCCS13                  253- 263 (A)
 I10_DXMCCS14                  264- 274 (A)
 I10_DXMCCS15                  275- 285 (A)
 I10_DXMCCS16                  286- 296 (A)
 I10_DXMCCS17                  297- 307 (A)
 I10_DXMCCS18                  308- 318 (A)
 I10_DXMCCS19                  319- 329 (A)
 I10_DXMCCS20                  330- 340 (A)
 I10_DXMCCS21                  341- 351 (A)
 I10_DXMCCS22                  352- 362 (A)
 I10_DXMCCS23                  363- 373 (A)
 I10_DXMCCS24                  374- 384 (A)
 I10_DXMCCS25                  385- 395 (A)
 I10_DXMCCS26                  396- 406 (A)
 I10_DXMCCS27                  407- 417 (A)
 I10_DXMCCS28                  418- 428 (A)
 I10_DXMCCS29                  429- 439 (A)
 I10_DXMCCS30                  440- 450 (A)
 I10_ECauseMCCS1               451- 461 (A)
 I10_ECauseMCCS2               462- 472 (A)
 I10_ECauseMCCS3               473- 483 (A)
 I10_ECauseMCCS4               484- 494 (A)
 I10_ECauseMCCS5               495- 505 (A)
 I10_ECauseMCCS6               506- 516 (A)
 I10_ECauseMCCS7               517- 527 (A)
 I10_ECauseMCCS8               528- 538 (A)
 I10_ECauseMCCS9               539- 549 (A)
 I10_ECauseMCCS10              550- 560 (A)
 I10_ECauseMCCS11              561- 571 (A)
 I10_ECauseMCCS12              572- 582 (A)
 I10_ECauseMCCS13              583- 593 (A)
 I10_ECauseMCCS14              594- 604 (A)
 I10_INJURY                    605- 606
 I10_MULTINJURY                607- 608
 I10_PCLASS1                   609- 610
 I10_PCLASS2                   611- 612
 I10_PCLASS3                   613- 614
 I10_PCLASS4                   615- 616
 I10_PCLASS5                   617- 618
 I10_PCLASS6                   619- 620
 I10_PCLASS7                   621- 622
 I10_PCLASS8                   623- 624
 I10_PCLASS9                   625- 626
 I10_PCLASS10                  627- 628
 I10_PCLASS11                  629- 630
 I10_PCLASS12                  631- 632
 I10_PCLASS13                  633- 634
 I10_PCLASS14                  635- 636
 I10_PCLASS15                  637- 638
 I10_PCLASS16                  639- 640
 I10_PCLASS17                  641- 642
 I10_PCLASS18                  643- 644
 I10_PCLASS19                  645- 646
 I10_PCLASS20                  647- 648
 I10_PCLASS21                  649- 650
 I10_PCLASS22                  651- 652
 I10_PCLASS23                  653- 654
 I10_PCLASS24                  655- 656
 I10_PCLASS25                  657- 658
 I10_PRMCCS1                   659- 666 (A)
 I10_PRMCCS2                   667- 674 (A)
 I10_PRMCCS3                   675- 682 (A)
 I10_PRMCCS4                   683- 690 (A)
 I10_PRMCCS5                   691- 698 (A)
 I10_PRMCCS6                   699- 706 (A)
 I10_PRMCCS7                   707- 714 (A)
 I10_PRMCCS8                   715- 722 (A)
 I10_PRMCCS9                   723- 730 (A)
 I10_PRMCCS10                  731- 738 (A)
 I10_PRMCCS11                  739- 746 (A)
 I10_PRMCCS12                  747- 754 (A)
 I10_PRMCCS13                  755- 762 (A)
 I10_PRMCCS14                  763- 770 (A)
 I10_PRMCCS15                  771- 778 (A)
 I10_PRMCCS16                  779- 786 (A)
 I10_PRMCCS17                  787- 794 (A)
 I10_PRMCCS18                  795- 802 (A)
 I10_PRMCCS19                  803- 810 (A)
 I10_PRMCCS20                  811- 818 (A)
 I10_PRMCCS21                  819- 826 (A)
 I10_PRMCCS22                  827- 834 (A)
 I10_PRMCCS23                  835- 842 (A)
 I10_PRMCCS24                  843- 850 (A)
 I10_PRMCCS25                  851- 858 (A)
 I10_U_BLOOD                   859- 860
 I10_U_CATH                    861- 862
 I10_U_CTSCAN                  863- 864
 I10_U_EKG                     865- 866
 I10_U_MHSA                    867- 868
 I10_U_MRT                     869- 870
 I10_U_PACEMAKER               871- 872
 I10_U_PHYTHERAPY              873- 874
 I10_U_RADTHERAPY              875- 876
 I10_U_STRESS                  877- 878
 KEY                           879- 893
 U_CCU                         894- 895
 U_CHESTXRAY                   896- 897
 U_DIALYSIS                    898- 899
 U_ECHO                        900- 901
 U_ED                          902- 903
 U_EEG                         904- 905
 U_EPO                         906- 907
 U_ICU                         908- 909
 U_LITHOTRIPSY                 910- 911
 U_NEWBN2L                     912- 913
 U_NEWBN3L                     914- 915
 U_NEWBN4L                     916- 917
 U_NUCMED                      918- 919
 U_OBSERVATION                 920- 921
 U_OCCTHERAPY                  922- 923
 U_ORGANACQ                    924- 925
 U_OTHIMPLANTS                 926- 927
 U_RESPTHERAPY                 928- 929
 U_SPEECHTHERAPY               930- 931
 U_ULTRASOUND                  932- 933.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_BODYSYSTEM10             (F3.0) /
 I10_BODYSYSTEM11             (F3.0) /
 I10_BODYSYSTEM12             (F3.0) /
 I10_BODYSYSTEM13             (F3.0) /
 I10_BODYSYSTEM14             (F3.0) /
 I10_BODYSYSTEM15             (F3.0) /
 I10_BODYSYSTEM16             (F3.0) /
 I10_BODYSYSTEM17             (F3.0) /
 I10_BODYSYSTEM18             (F3.0) /
 I10_BODYSYSTEM19             (F3.0) /
 I10_BODYSYSTEM20             (F3.0) /
 I10_BODYSYSTEM21             (F3.0) /
 I10_BODYSYSTEM22             (F3.0) /
 I10_BODYSYSTEM23             (F3.0) /
 I10_BODYSYSTEM24             (F3.0) /
 I10_BODYSYSTEM25             (F3.0) /
 I10_BODYSYSTEM26             (F3.0) /
 I10_BODYSYSTEM27             (F3.0) /
 I10_BODYSYSTEM28             (F3.0) /
 I10_BODYSYSTEM29             (F3.0) /
 I10_BODYSYSTEM30             (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_CHRON10                  (F3.0) /
 I10_CHRON11                  (F3.0) /
 I10_CHRON12                  (F3.0) /
 I10_CHRON13                  (F3.0) /
 I10_CHRON14                  (F3.0) /
 I10_CHRON15                  (F3.0) /
 I10_CHRON16                  (F3.0) /
 I10_CHRON17                  (F3.0) /
 I10_CHRON18                  (F3.0) /
 I10_CHRON19                  (F3.0) /
 I10_CHRON20                  (F3.0) /
 I10_CHRON21                  (F3.0) /
 I10_CHRON22                  (F3.0) /
 I10_CHRON23                  (F3.0) /
 I10_CHRON24                  (F3.0) /
 I10_CHRON25                  (F3.0) /
 I10_CHRON26                  (F3.0) /
 I10_CHRON27                  (F3.0) /
 I10_CHRON28                  (F3.0) /
 I10_CHRON29                  (F3.0) /
 I10_CHRON30                  (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 I10_PCLASS1                  (F3.0) /
 I10_PCLASS2                  (F3.0) /
 I10_PCLASS3                  (F3.0) /
 I10_PCLASS4                  (F3.0) /
 I10_PCLASS5                  (F3.0) /
 I10_PCLASS6                  (F3.0) /
 I10_PCLASS7                  (F3.0) /
 I10_PCLASS8                  (F3.0) /
 I10_PCLASS9                  (F3.0) /
 I10_PCLASS10                 (F3.0) /
 I10_PCLASS11                 (F3.0) /
 I10_PCLASS12                 (F3.0) /
 I10_PCLASS13                 (F3.0) /
 I10_PCLASS14                 (F3.0) /
 I10_PCLASS15                 (F3.0) /
 I10_PCLASS16                 (F3.0) /
 I10_PCLASS17                 (F3.0) /
 I10_PCLASS18                 (F3.0) /
 I10_PCLASS19                 (F3.0) /
 I10_PCLASS20                 (F3.0) /
 I10_PCLASS21                 (F3.0) /
 I10_PCLASS22                 (F3.0) /
 I10_PCLASS23                 (F3.0) /
 I10_PCLASS24                 (F3.0) /
 I10_PCLASS25                 (F3.0) /
 I10_U_BLOOD                  (F3.0) /
 I10_U_CATH                   (F3.0) /
 I10_U_CTSCAN                 (F3.0) /
 I10_U_EKG                    (F3.0) /
 I10_U_MHSA                   (F3.0) /
 I10_U_MRT                    (F3.0) /
 I10_U_PACEMAKER              (F3.0) /
 I10_U_PHYTHERAPY             (F3.0) /
 I10_U_RADTHERAPY             (F3.0) /
 I10_U_STRESS                 (F3.0) /
 KEY                          (F8.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_BODYSYSTEM10             "ICD-10-CM Body system 10"
 I10_BODYSYSTEM11             "ICD-10-CM Body system 11"
 I10_BODYSYSTEM12             "ICD-10-CM Body system 12"
 I10_BODYSYSTEM13             "ICD-10-CM Body system 13"
 I10_BODYSYSTEM14             "ICD-10-CM Body system 14"
 I10_BODYSYSTEM15             "ICD-10-CM Body system 15"
 I10_BODYSYSTEM16             "ICD-10-CM Body system 16"
 I10_BODYSYSTEM17             "ICD-10-CM Body system 17"
 I10_BODYSYSTEM18             "ICD-10-CM Body system 18"
 I10_BODYSYSTEM19             "ICD-10-CM Body system 19"
 I10_BODYSYSTEM20             "ICD-10-CM Body system 20"
 I10_BODYSYSTEM21             "ICD-10-CM Body system 21"
 I10_BODYSYSTEM22             "ICD-10-CM Body system 22"
 I10_BODYSYSTEM23             "ICD-10-CM Body system 23"
 I10_BODYSYSTEM24             "ICD-10-CM Body system 24"
 I10_BODYSYSTEM25             "ICD-10-CM Body system 25"
 I10_BODYSYSTEM26             "ICD-10-CM Body system 26"
 I10_BODYSYSTEM27             "ICD-10-CM Body system 27"
 I10_BODYSYSTEM28             "ICD-10-CM Body system 28"
 I10_BODYSYSTEM29             "ICD-10-CM Body system 29"
 I10_BODYSYSTEM30             "ICD-10-CM Body system 30"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_CHRON10                  "ICD-10-CM Chronic condition indicator 10"
 I10_CHRON11                  "ICD-10-CM Chronic condition indicator 11"
 I10_CHRON12                  "ICD-10-CM Chronic condition indicator 12"
 I10_CHRON13                  "ICD-10-CM Chronic condition indicator 13"
 I10_CHRON14                  "ICD-10-CM Chronic condition indicator 14"
 I10_CHRON15                  "ICD-10-CM Chronic condition indicator 15"
 I10_CHRON16                  "ICD-10-CM Chronic condition indicator 16"
 I10_CHRON17                  "ICD-10-CM Chronic condition indicator 17"
 I10_CHRON18                  "ICD-10-CM Chronic condition indicator 18"
 I10_CHRON19                  "ICD-10-CM Chronic condition indicator 19"
 I10_CHRON20                  "ICD-10-CM Chronic condition indicator 20"
 I10_CHRON21                  "ICD-10-CM Chronic condition indicator 21"
 I10_CHRON22                  "ICD-10-CM Chronic condition indicator 22"
 I10_CHRON23                  "ICD-10-CM Chronic condition indicator 23"
 I10_CHRON24                  "ICD-10-CM Chronic condition indicator 24"
 I10_CHRON25                  "ICD-10-CM Chronic condition indicator 25"
 I10_CHRON26                  "ICD-10-CM Chronic condition indicator 26"
 I10_CHRON27                  "ICD-10-CM Chronic condition indicator 27"
 I10_CHRON28                  "ICD-10-CM Chronic condition indicator 28"
 I10_CHRON29                  "ICD-10-CM Chronic condition indicator 29"
 I10_CHRON30                  "ICD-10-CM Chronic condition indicator 30"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_DXMCCS10                 "ICD-10-CM Multi-Level CCS:  Diagnosis 10"
 I10_DXMCCS11                 "ICD-10-CM Multi-Level CCS:  Diagnosis 11"
 I10_DXMCCS12                 "ICD-10-CM Multi-Level CCS:  Diagnosis 12"
 I10_DXMCCS13                 "ICD-10-CM Multi-Level CCS:  Diagnosis 13"
 I10_DXMCCS14                 "ICD-10-CM Multi-Level CCS:  Diagnosis 14"
 I10_DXMCCS15                 "ICD-10-CM Multi-Level CCS:  Diagnosis 15"
 I10_DXMCCS16                 "ICD-10-CM Multi-Level CCS:  Diagnosis 16"
 I10_DXMCCS17                 "ICD-10-CM Multi-Level CCS:  Diagnosis 17"
 I10_DXMCCS18                 "ICD-10-CM Multi-Level CCS:  Diagnosis 18"
 I10_DXMCCS19                 "ICD-10-CM Multi-Level CCS:  Diagnosis 19"
 I10_DXMCCS20                 "ICD-10-CM Multi-Level CCS:  Diagnosis 20"
 I10_DXMCCS21                 "ICD-10-CM Multi-Level CCS:  Diagnosis 21"
 I10_DXMCCS22                 "ICD-10-CM Multi-Level CCS:  Diagnosis 22"
 I10_DXMCCS23                 "ICD-10-CM Multi-Level CCS:  Diagnosis 23"
 I10_DXMCCS24                 "ICD-10-CM Multi-Level CCS:  Diagnosis 24"
 I10_DXMCCS25                 "ICD-10-CM Multi-Level CCS:  Diagnosis 25"
 I10_DXMCCS26                 "ICD-10-CM Multi-Level CCS:  Diagnosis 26"
 I10_DXMCCS27                 "ICD-10-CM Multi-Level CCS:  Diagnosis 27"
 I10_DXMCCS28                 "ICD-10-CM Multi-Level CCS:  Diagnosis 28"
 I10_DXMCCS29                 "ICD-10-CM Multi-Level CCS:  Diagnosis 29"
 I10_DXMCCS30                 "ICD-10-CM Multi-Level CCS:  Diagnosis 30"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_ECauseMCCS6              "ICD-10-CM Multi-Level CCS:  E Cause 6"
 I10_ECauseMCCS7              "ICD-10-CM Multi-Level CCS:  E Cause 7"
 I10_ECauseMCCS8              "ICD-10-CM Multi-Level CCS:  E Cause 8"
 I10_ECauseMCCS9              "ICD-10-CM Multi-Level CCS:  E Cause 9"
 I10_ECauseMCCS10             "ICD-10-CM Multi-Level CCS:  E Cause 10"
 I10_ECauseMCCS11             "ICD-10-CM Multi-Level CCS:  E Cause 11"
 I10_ECauseMCCS12             "ICD-10-CM Multi-Level CCS:  E Cause 12"
 I10_ECauseMCCS13             "ICD-10-CM Multi-Level CCS:  E Cause 13"
 I10_ECauseMCCS14             "ICD-10-CM Multi-Level CCS:  E Cause 14"
 I10_INJURY
 "ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an injury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 I10_PCLASS1                  "ICD-10-PCS Procedure class 1"
 I10_PCLASS2                  "ICD-10-PCS Procedure class 2"
 I10_PCLASS3                  "ICD-10-PCS Procedure class 3"
 I10_PCLASS4                  "ICD-10-PCS Procedure class 4"
 I10_PCLASS5                  "ICD-10-PCS Procedure class 5"
 I10_PCLASS6                  "ICD-10-PCS Procedure class 6"
 I10_PCLASS7                  "ICD-10-PCS Procedure class 7"
 I10_PCLASS8                  "ICD-10-PCS Procedure class 8"
 I10_PCLASS9                  "ICD-10-PCS Procedure class 9"
 I10_PCLASS10                 "ICD-10-PCS Procedure class 10"
 I10_PCLASS11                 "ICD-10-PCS Procedure class 11"
 I10_PCLASS12                 "ICD-10-PCS Procedure class 12"
 I10_PCLASS13                 "ICD-10-PCS Procedure class 13"
 I10_PCLASS14                 "ICD-10-PCS Procedure class 14"
 I10_PCLASS15                 "ICD-10-PCS Procedure class 15"
 I10_PCLASS16                 "ICD-10-PCS Procedure class 16"
 I10_PCLASS17                 "ICD-10-PCS Procedure class 17"
 I10_PCLASS18                 "ICD-10-PCS Procedure class 18"
 I10_PCLASS19                 "ICD-10-PCS Procedure class 19"
 I10_PCLASS20                 "ICD-10-PCS Procedure class 20"
 I10_PCLASS21                 "ICD-10-PCS Procedure class 21"
 I10_PCLASS22                 "ICD-10-PCS Procedure class 22"
 I10_PCLASS23                 "ICD-10-PCS Procedure class 23"
 I10_PCLASS24                 "ICD-10-PCS Procedure class 24"
 I10_PCLASS25                 "ICD-10-PCS Procedure class 25"
 I10_PRMCCS1                  "ICD-10-PCS Multi-Level CCS:  Procedure 1"
 I10_PRMCCS2                  "ICD-10-PCS Multi-Level CCS:  Procedure 2"
 I10_PRMCCS3                  "ICD-10-PCS Multi-Level CCS:  Procedure 3"
 I10_PRMCCS4                  "ICD-10-PCS Multi-Level CCS:  Procedure 4"
 I10_PRMCCS5                  "ICD-10-PCS Multi-Level CCS:  Procedure 5"
 I10_PRMCCS6                  "ICD-10-PCS Multi-Level CCS:  Procedure 6"
 I10_PRMCCS7                  "ICD-10-PCS Multi-Level CCS:  Procedure 7"
 I10_PRMCCS8                  "ICD-10-PCS Multi-Level CCS:  Procedure 8"
 I10_PRMCCS9                  "ICD-10-PCS Multi-Level CCS:  Procedure 9"
 I10_PRMCCS10                 "ICD-10-PCS Multi-Level CCS:  Procedure 10"
 I10_PRMCCS11                 "ICD-10-PCS Multi-Level CCS:  Procedure 11"
 I10_PRMCCS12                 "ICD-10-PCS Multi-Level CCS:  Procedure 12"
 I10_PRMCCS13                 "ICD-10-PCS Multi-Level CCS:  Procedure 13"
 I10_PRMCCS14                 "ICD-10-PCS Multi-Level CCS:  Procedure 14"
 I10_PRMCCS15                 "ICD-10-PCS Multi-Level CCS:  Procedure 15"
 I10_PRMCCS16                 "ICD-10-PCS Multi-Level CCS:  Procedure 16"
 I10_PRMCCS17                 "ICD-10-PCS Multi-Level CCS:  Procedure 17"
 I10_PRMCCS18                 "ICD-10-PCS Multi-Level CCS:  Procedure 18"
 I10_PRMCCS19                 "ICD-10-PCS Multi-Level CCS:  Procedure 19"
 I10_PRMCCS20                 "ICD-10-PCS Multi-Level CCS:  Procedure 20"
 I10_PRMCCS21                 "ICD-10-PCS Multi-Level CCS:  Procedure 21"
 I10_PRMCCS22                 "ICD-10-PCS Multi-Level CCS:  Procedure 22"
 I10_PRMCCS23                 "ICD-10-PCS Multi-Level CCS:  Procedure 23"
 I10_PRMCCS24                 "ICD-10-PCS Multi-Level CCS:  Procedure 24"
 I10_PRMCCS25                 "ICD-10-PCS Multi-Level CCS:  Procedure 25"
 I10_U_BLOOD                  "ICD-10-PCS Utilization Flag: Blood"
 I10_U_CATH                   "ICD-10-PCS Utilization Flag: Cardiac Catheterization Lab"
 I10_U_CTSCAN                 "ICD-10-PCS Utilization Flag: Computed Tomography Scan"
 I10_U_EKG                    "ICD-10-PCS Utilization Flag: Electrocardiogram"
 I10_U_MHSA                   "ICD-10-PCS Utilization Flag: Mental Health and Substance Abuse"
 I10_U_MRT                    "ICD-10-PCS Utilization Flag: Magnetic Resonance Technology"
 I10_U_PACEMAKER              "ICD-10-PCS Utilization Flag: Pacemaker"
 I10_U_PHYTHERAPY             "ICD-10-PCS Utilization Flag: Physical Therapy"
 I10_U_RADTHERAPY             "ICD-10-PCS Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 I10_U_STRESS                 "ICD-10-PCS Utilization Flag: Cardiac Stress Test"
 KEY                          "HCUP record identifier"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM26
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM27
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM28
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM29
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM30
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'KS_SASD_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
