/*******************************************************************
*   ME_SASD_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'ME_SASD_2010_CORE.ASC' FIXED / 
 AMONTH                     1-   2
 AWEEKEND                   3-   4
 BILLTYPE                   5-   8 (A)
 CPT1                       9-  13 (A)
 CPT2                      14-  18 (A)
 CPT3                      19-  23 (A)
 CPT4                      24-  28 (A)
 CPT5                      29-  33 (A)
 CPT6                      34-  38 (A)
 CPT7                      39-  43 (A)
 CPT8                      44-  48 (A)
 CPT9                      49-  53 (A)
 CPT10                     54-  58 (A)
 CPT11                     59-  63 (A)
 CPT12                     64-  68 (A)
 CPT13                     69-  73 (A)
 CPT14                     74-  78 (A)
 CPT15                     79-  83 (A)
 CPT16                     84-  88 (A)
 CPT17                     89-  93 (A)
 CPT18                     94-  98 (A)
 CPT19                     99- 103 (A)
 CPT20                    104- 108 (A)
 CPT21                    109- 113 (A)
 CPT22                    114- 118 (A)
 CPT23                    119- 123 (A)
 CPT24                    124- 128 (A)
 CPT25                    129- 133 (A)
 CPT26                    134- 138 (A)
 CPT27                    139- 143 (A)
 CPT28                    144- 148 (A)
 CPT29                    149- 153 (A)
 CPT30                    154- 158 (A)
 CPTCCS1                  159- 161
 CPTCCS2                  162- 164
 CPTCCS3                  165- 167
 CPTCCS4                  168- 170
 CPTCCS5                  171- 173
 CPTCCS6                  174- 176
 CPTCCS7                  177- 179
 CPTCCS8                  180- 182
 CPTCCS9                  183- 185
 CPTCCS10                 186- 188
 CPTCCS11                 189- 191
 CPTCCS12                 192- 194
 CPTCCS13                 195- 197
 CPTCCS14                 198- 200
 CPTCCS15                 201- 203
 CPTCCS16                 204- 206
 CPTCCS17                 207- 209
 CPTCCS18                 210- 212
 CPTCCS19                 213- 215
 CPTCCS20                 216- 218
 CPTCCS21                 219- 221
 CPTCCS22                 222- 224
 CPTCCS23                 225- 227
 CPTCCS24                 228- 230
 CPTCCS25                 231- 233
 CPTCCS26                 234- 236
 CPTCCS27                 237- 239
 CPTCCS28                 240- 242
 CPTCCS29                 243- 245
 CPTCCS30                 246- 248
 CPTDAY1                  249- 251
 CPTDAY2                  252- 254
 CPTDAY3                  255- 257
 CPTDAY4                  258- 260
 CPTDAY5                  261- 263
 CPTDAY6                  264- 266
 CPTDAY7                  267- 269
 CPTDAY8                  270- 272
 CPTDAY9                  273- 275
 CPTDAY10                 276- 278
 CPTDAY11                 279- 281
 CPTDAY12                 282- 284
 CPTDAY13                 285- 287
 CPTDAY14                 288- 290
 CPTDAY15                 291- 293
 CPTDAY16                 294- 296
 CPTDAY17                 297- 299
 CPTDAY18                 300- 302
 CPTDAY19                 303- 305
 CPTDAY20                 306- 308
 CPTDAY21                 309- 311
 CPTDAY22                 312- 314
 CPTDAY23                 315- 317
 CPTDAY24                 318- 320
 CPTDAY25                 321- 323
 CPTDAY26                 324- 326
 CPTDAY27                 327- 329
 CPTDAY28                 330- 332
 CPTDAY29                 333- 335
 CPTDAY30                 336- 338
 CPTM1_1                  339- 340 (A)
 CPTM1_2                  341- 342 (A)
 CPTM1_3                  343- 344 (A)
 CPTM1_4                  345- 346 (A)
 CPTM1_5                  347- 348 (A)
 CPTM1_6                  349- 350 (A)
 CPTM1_7                  351- 352 (A)
 CPTM1_8                  353- 354 (A)
 CPTM1_9                  355- 356 (A)
 CPTM1_10                 357- 358 (A)
 CPTM1_11                 359- 360 (A)
 CPTM1_12                 361- 362 (A)
 CPTM1_13                 363- 364 (A)
 CPTM1_14                 365- 366 (A)
 CPTM1_15                 367- 368 (A)
 CPTM1_16                 369- 370 (A)
 CPTM1_17                 371- 372 (A)
 CPTM1_18                 373- 374 (A)
 CPTM1_19                 375- 376 (A)
 CPTM1_20                 377- 378 (A)
 CPTM1_21                 379- 380 (A)
 CPTM1_22                 381- 382 (A)
 CPTM1_23                 383- 384 (A)
 CPTM1_24                 385- 386 (A)
 CPTM1_25                 387- 388 (A)
 CPTM1_26                 389- 390 (A)
 CPTM1_27                 391- 392 (A)
 CPTM1_28                 393- 394 (A)
 CPTM1_29                 395- 396 (A)
 CPTM1_30                 397- 398 (A)
 CPTM2_1                  399- 400 (A)
 CPTM2_2                  401- 402 (A)
 CPTM2_3                  403- 404 (A)
 CPTM2_4                  405- 406 (A)
 CPTM2_5                  407- 408 (A)
 CPTM2_6                  409- 410 (A)
 CPTM2_7                  411- 412 (A)
 CPTM2_8                  413- 414 (A)
 CPTM2_9                  415- 416 (A)
 CPTM2_10                 417- 418 (A)
 CPTM2_11                 419- 420 (A)
 CPTM2_12                 421- 422 (A)
 CPTM2_13                 423- 424 (A)
 CPTM2_14                 425- 426 (A)
 CPTM2_15                 427- 428 (A)
 CPTM2_16                 429- 430 (A)
 CPTM2_17                 431- 432 (A)
 CPTM2_18                 433- 434 (A)
 CPTM2_19                 435- 436 (A)
 CPTM2_20                 437- 438 (A)
 CPTM2_21                 439- 440 (A)
 CPTM2_22                 441- 442 (A)
 CPTM2_23                 443- 444 (A)
 CPTM2_24                 445- 446 (A)
 CPTM2_25                 447- 448 (A)
 CPTM2_26                 449- 450 (A)
 CPTM2_27                 451- 452 (A)
 CPTM2_28                 453- 454 (A)
 CPTM2_29                 455- 456 (A)
 CPTM2_30                 457- 458 (A)
 DIED                     459- 460
 DISPUB04                 461- 462
 DISPUNIFORM              463- 464
 DQTR                     465- 466
 DX1                      467- 471 (A)
 DX2                      472- 476 (A)
 DX3                      477- 481 (A)
 DX4                      482- 486 (A)
 DX5                      487- 491 (A)
 DX6                      492- 496 (A)
 DX7                      497- 501 (A)
 DX8                      502- 506 (A)
 DX9                      507- 511 (A)
 DXCCS1                   512- 515
 DXCCS2                   516- 519
 DXCCS3                   520- 523
 DXCCS4                   524- 527
 DXCCS5                   528- 531
 DXCCS6                   532- 535
 DXCCS7                   536- 539
 DXCCS8                   540- 543
 DXCCS9                   544- 547
 ECODE1                   548- 552 (A)
 ECODE2                   553- 557 (A)
 ECODE3                   558- 562 (A)
 ECODE4                   563- 567 (A)
 ECODE5                   568- 572 (A)
 ECODE6                   573- 577 (A)
 ECODE7                   578- 582 (A)
 E_CCS1                   583- 586
 E_CCS2                   587- 590
 E_CCS3                   591- 594
 E_CCS4                   595- 598
 E_CCS5                   599- 602
 E_CCS6                   603- 606
 E_CCS7                   607- 610
 FEMALE                   611- 612
 HCUP_AS                  613- 614
 HCUP_ED                  615- 616
 HCUP_OS                  617- 618
 HISPANIC_X               619     (A)
 HOSPBRTH                 620- 622
 HOSPST                   623- 624 (A)
 KEY                      625- 639
 LOS                      640- 644
 MDSPEC1                  645- 646 (A)
 MDSPEC2                  647- 648 (A)
 MEDINCSTQ                649- 650
 MRN_R                    651- 659
 NCHRONIC                 660- 662
 NCPT                     663- 665
 NDX                      666- 667
 NECODE                   668- 669
 NEOMAT                   670- 671
 PAY1                     672- 673
 PL_CBSA                  674- 676
 PL_MSA1993               677- 679
 PL_NCHS2006              680- 681
 PL_RUCA4_2005            682- 683
 PL_UIC2003               684- 685
 PL_UR_CAT4               686- 687
 PROCTYPE                 688- 690
 PSTATE                   691- 692 (A)
 PSTCO                    693- 697
 PSTCO2                   698- 702
 PointOfOriginUB04        703     (A)
 RACE                     704- 705
 RACE_X                   706     (A)
 STATE_AS                 707- 708
 STATE_ED                 709- 710
 STATE_OS                 711- 712
 YEAR                     713- 716
 ZIP3                     717- 719 (A)
 ZIPINC_QRTL              720- 722
 ZIP_S                    723- 727 (A)
 AGEGROUP                 728- 730
 HOSPID                   731- 735
 AYEAR                    736- 739
 DMONTH                   740- 741.


***  Specify write formats  ***.
FORMATS
 AMONTH                  (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 CPTDAY26                (F4.0) /
 CPTDAY27                (F4.0) /
 CPTDAY28                (F4.0) /
 CPTDAY29                (F4.0) /
 CPTDAY30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA4_2005           (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AGEGROUP                (F8.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AMONTH                  "Admission month"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTDAY1                 "Number of days from admission to CPT1"
 CPTDAY2                 "Number of days from admission to CPT2"
 CPTDAY3                 "Number of days from admission to CPT3"
 CPTDAY4                 "Number of days from admission to CPT4"
 CPTDAY5                 "Number of days from admission to CPT5"
 CPTDAY6                 "Number of days from admission to CPT6"
 CPTDAY7                 "Number of days from admission to CPT7"
 CPTDAY8                 "Number of days from admission to CPT8"
 CPTDAY9                 "Number of days from admission to CPT9"
 CPTDAY10                "Number of days from admission to CPT10"
 CPTDAY11                "Number of days from admission to CPT11"
 CPTDAY12                "Number of days from admission to CPT12"
 CPTDAY13                "Number of days from admission to CPT13"
 CPTDAY14                "Number of days from admission to CPT14"
 CPTDAY15                "Number of days from admission to CPT15"
 CPTDAY16                "Number of days from admission to CPT16"
 CPTDAY17                "Number of days from admission to CPT17"
 CPTDAY18                "Number of days from admission to CPT18"
 CPTDAY19                "Number of days from admission to CPT19"
 CPTDAY20                "Number of days from admission to CPT20"
 CPTDAY21                "Number of days from admission to CPT21"
 CPTDAY22                "Number of days from admission to CPT22"
 CPTDAY23                "Number of days from admission to CPT23"
 CPTDAY24                "Number of days from admission to CPT24"
 CPTDAY25                "Number of days from admission to CPT25"
 CPTDAY26                "Number of days from admission to CPT26"
 CPTDAY27                "Number of days from admission to CPT27"
 CPTDAY28                "Number of days from admission to CPT28"
 CPTDAY29                "Number of days from admission to CPT29"
 CPTDAY30                "Number of days from admission to CPT30"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DQTR                    "Discharge quarter"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 MDSPEC1                 "Physician 1 specialty (as received from source)"
 MDSPEC2                 "Physician 2 specialty (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 PAY1                    "Primary expected payer (uniform)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP_S                   "Patient ZIP Code (synthetic)"
 AGEGROUP                " "
 HOSPID                  "HCUP hospital identification number"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SASD_2010_CORE.SAV' /COMPRESSED.
