/*******************************************************************
* Creation Date: 06/11/2019   
*   KY_SASD_2017_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT AHAL FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'KY_SASD_2017_AHAL.ASC' FIXED SKIP=2 / 
 AHAID                           1-   7 (A)
 DSHOSPID                        8-  24 (A)
 HOSPID                         25-  29
 COMMUNITY_NONREHAB_NONLTAC     30-  33
 FREESTANDING                   34-  35
 HFIPSSTCO                      36-  40
 HOSPST                         41-  42 (A)
 YEAR                           43-  46.


***  Specify write formats  ***.
FORMATS
 HOSPID                       (F4.0) /
 COMMUNITY_NONREHAB_NONLTAC   (F3.0) /
 FREESTANDING                 (F3.0) /
 HFIPSSTCO                    (F4.0) /
 YEAR                         (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID                        "AHA hospital identifier with the leading 6"
 DSHOSPID                     "Data source hospital identifier"
 HOSPID                       "HCUP hospital identification number"
 COMMUNITY_NONREHAB_NONLTAC
"Indicator of U.S. community hospital that is not a rehabilitation or long-term acute care hospital (Z997)"
 FREESTANDING                 "Indicator of freestanding ambulatory surgery center"
 HFIPSSTCO                    "Hospital FIPS state/county code"
 HOSPST                       "Hospital state postal code"
 YEAR                         "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE COMMUNITY_NONREHAB_NONLTAC
 (-999,-888,-666,-555=SYSMIS).
RECODE FREESTANDING
 (-9,-8,-6,-5=SYSMIS).
RECODE HFIPSSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'KY_SASD_2017_AHAL.SAV' /COMPRESSED.
