/*******************************************************************
* Creation Date: 07/11/2019   
*   ME_SASD_2017_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'ME_SASD_2017_CORE.ASC' FIXED SKIP=2 / 
 AMONTH                          1-   2
 AWEEKEND                        3-   4
 BILLTYPE                        5-   8 (A)
 CPT1                            9-  13 (A)
 CPT2                           14-  18 (A)
 CPT3                           19-  23 (A)
 CPT4                           24-  28 (A)
 CPT5                           29-  33 (A)
 CPT6                           34-  38 (A)
 CPT7                           39-  43 (A)
 CPT8                           44-  48 (A)
 CPT9                           49-  53 (A)
 CPT10                          54-  58 (A)
 CPT11                          59-  63 (A)
 CPT12                          64-  68 (A)
 CPT13                          69-  73 (A)
 CPT14                          74-  78 (A)
 CPT15                          79-  83 (A)
 CPT16                          84-  88 (A)
 CPT17                          89-  93 (A)
 CPT18                          94-  98 (A)
 CPT19                          99- 103 (A)
 CPT20                         104- 108 (A)
 CPT21                         109- 113 (A)
 CPT22                         114- 118 (A)
 CPT23                         119- 123 (A)
 CPT24                         124- 128 (A)
 CPT25                         129- 133 (A)
 CPT26                         134- 138 (A)
 CPT27                         139- 143 (A)
 CPT28                         144- 148 (A)
 CPT29                         149- 153 (A)
 CPT30                         154- 158 (A)
 CPT31                         159- 163 (A)
 CPT32                         164- 168 (A)
 CPT33                         169- 173 (A)
 CPT34                         174- 178 (A)
 CPT35                         179- 183 (A)
 CPT36                         184- 188 (A)
 CPT37                         189- 193 (A)
 CPT38                         194- 198 (A)
 CPT39                         199- 203 (A)
 CPT40                         204- 208 (A)
 CPT41                         209- 213 (A)
 CPT42                         214- 218 (A)
 CPT43                         219- 223 (A)
 CPT44                         224- 228 (A)
 CPT45                         229- 233 (A)
 CPT46                         234- 238 (A)
 CPT47                         239- 243 (A)
 CPT48                         244- 248 (A)
 CPT49                         249- 253 (A)
 CPT50                         254- 258 (A)
 CPTCCS1                       259- 261
 CPTCCS2                       262- 264
 CPTCCS3                       265- 267
 CPTCCS4                       268- 270
 CPTCCS5                       271- 273
 CPTCCS6                       274- 276
 CPTCCS7                       277- 279
 CPTCCS8                       280- 282
 CPTCCS9                       283- 285
 CPTCCS10                      286- 288
 CPTCCS11                      289- 291
 CPTCCS12                      292- 294
 CPTCCS13                      295- 297
 CPTCCS14                      298- 300
 CPTCCS15                      301- 303
 CPTCCS16                      304- 306
 CPTCCS17                      307- 309
 CPTCCS18                      310- 312
 CPTCCS19                      313- 315
 CPTCCS20                      316- 318
 CPTCCS21                      319- 321
 CPTCCS22                      322- 324
 CPTCCS23                      325- 327
 CPTCCS24                      328- 330
 CPTCCS25                      331- 333
 CPTCCS26                      334- 336
 CPTCCS27                      337- 339
 CPTCCS28                      340- 342
 CPTCCS29                      343- 345
 CPTCCS30                      346- 348
 CPTCCS31                      349- 351
 CPTCCS32                      352- 354
 CPTCCS33                      355- 357
 CPTCCS34                      358- 360
 CPTCCS35                      361- 363
 CPTCCS36                      364- 366
 CPTCCS37                      367- 369
 CPTCCS38                      370- 372
 CPTCCS39                      373- 375
 CPTCCS40                      376- 378
 CPTCCS41                      379- 381
 CPTCCS42                      382- 384
 CPTCCS43                      385- 387
 CPTCCS44                      388- 390
 CPTCCS45                      391- 393
 CPTCCS46                      394- 396
 CPTCCS47                      397- 399
 CPTCCS48                      400- 402
 CPTCCS49                      403- 405
 CPTCCS50                      406- 408
 CPTDAY1                       409- 411
 CPTDAY2                       412- 414
 CPTDAY3                       415- 417
 CPTDAY4                       418- 420
 CPTDAY5                       421- 423
 CPTDAY6                       424- 426
 CPTDAY7                       427- 429
 CPTDAY8                       430- 432
 CPTDAY9                       433- 435
 CPTDAY10                      436- 438
 CPTDAY11                      439- 441
 CPTDAY12                      442- 444
 CPTDAY13                      445- 447
 CPTDAY14                      448- 450
 CPTDAY15                      451- 453
 CPTDAY16                      454- 456
 CPTDAY17                      457- 459
 CPTDAY18                      460- 462
 CPTDAY19                      463- 465
 CPTDAY20                      466- 468
 CPTDAY21                      469- 471
 CPTDAY22                      472- 474
 CPTDAY23                      475- 477
 CPTDAY24                      478- 480
 CPTDAY25                      481- 483
 CPTDAY26                      484- 486
 CPTDAY27                      487- 489
 CPTDAY28                      490- 492
 CPTDAY29                      493- 495
 CPTDAY30                      496- 498
 CPTDAY31                      499- 501
 CPTDAY32                      502- 504
 CPTDAY33                      505- 507
 CPTDAY34                      508- 510
 CPTDAY35                      511- 513
 CPTDAY36                      514- 516
 CPTDAY37                      517- 519
 CPTDAY38                      520- 522
 CPTDAY39                      523- 525
 CPTDAY40                      526- 528
 CPTDAY41                      529- 531
 CPTDAY42                      532- 534
 CPTDAY43                      535- 537
 CPTDAY44                      538- 540
 CPTDAY45                      541- 543
 CPTDAY46                      544- 546
 CPTDAY47                      547- 549
 CPTDAY48                      550- 552
 CPTDAY49                      553- 555
 CPTDAY50                      556- 558
 CPTM1_1                       559- 560 (A)
 CPTM1_2                       561- 562 (A)
 CPTM1_3                       563- 564 (A)
 CPTM1_4                       565- 566 (A)
 CPTM1_5                       567- 568 (A)
 CPTM1_6                       569- 570 (A)
 CPTM1_7                       571- 572 (A)
 CPTM1_8                       573- 574 (A)
 CPTM1_9                       575- 576 (A)
 CPTM1_10                      577- 578 (A)
 CPTM1_11                      579- 580 (A)
 CPTM1_12                      581- 582 (A)
 CPTM1_13                      583- 584 (A)
 CPTM1_14                      585- 586 (A)
 CPTM1_15                      587- 588 (A)
 CPTM1_16                      589- 590 (A)
 CPTM1_17                      591- 592 (A)
 CPTM1_18                      593- 594 (A)
 CPTM1_19                      595- 596 (A)
 CPTM1_20                      597- 598 (A)
 CPTM1_21                      599- 600 (A)
 CPTM1_22                      601- 602 (A)
 CPTM1_23                      603- 604 (A)
 CPTM1_24                      605- 606 (A)
 CPTM1_25                      607- 608 (A)
 CPTM1_26                      609- 610 (A)
 CPTM1_27                      611- 612 (A)
 CPTM1_28                      613- 614 (A)
 CPTM1_29                      615- 616 (A)
 CPTM1_30                      617- 618 (A)
 CPTM1_31                      619- 620 (A)
 CPTM1_32                      621- 622 (A)
 CPTM1_33                      623- 624 (A)
 CPTM1_34                      625- 626 (A)
 CPTM1_35                      627- 628 (A)
 CPTM1_36                      629- 630 (A)
 CPTM1_37                      631- 632 (A)
 CPTM1_38                      633- 634 (A)
 CPTM1_39                      635- 636 (A)
 CPTM1_40                      637- 638 (A)
 CPTM1_41                      639- 640 (A)
 CPTM1_42                      641- 642 (A)
 CPTM1_43                      643- 644 (A)
 CPTM1_44                      645- 646 (A)
 CPTM1_45                      647- 648 (A)
 CPTM1_46                      649- 650 (A)
 CPTM1_47                      651- 652 (A)
 CPTM1_48                      653- 654 (A)
 CPTM1_49                      655- 656 (A)
 CPTM1_50                      657- 658 (A)
 CPTM2_1                       659- 660 (A)
 CPTM2_2                       661- 662 (A)
 CPTM2_3                       663- 664 (A)
 CPTM2_4                       665- 666 (A)
 CPTM2_5                       667- 668 (A)
 CPTM2_6                       669- 670 (A)
 CPTM2_7                       671- 672 (A)
 CPTM2_8                       673- 674 (A)
 CPTM2_9                       675- 676 (A)
 CPTM2_10                      677- 678 (A)
 CPTM2_11                      679- 680 (A)
 CPTM2_12                      681- 682 (A)
 CPTM2_13                      683- 684 (A)
 CPTM2_14                      685- 686 (A)
 CPTM2_15                      687- 688 (A)
 CPTM2_16                      689- 690 (A)
 CPTM2_17                      691- 692 (A)
 CPTM2_18                      693- 694 (A)
 CPTM2_19                      695- 696 (A)
 CPTM2_20                      697- 698 (A)
 CPTM2_21                      699- 700 (A)
 CPTM2_22                      701- 702 (A)
 CPTM2_23                      703- 704 (A)
 CPTM2_24                      705- 706 (A)
 CPTM2_25                      707- 708 (A)
 CPTM2_26                      709- 710 (A)
 CPTM2_27                      711- 712 (A)
 CPTM2_28                      713- 714 (A)
 CPTM2_29                      715- 716 (A)
 CPTM2_30                      717- 718 (A)
 CPTM2_31                      719- 720 (A)
 CPTM2_32                      721- 722 (A)
 CPTM2_33                      723- 724 (A)
 CPTM2_34                      725- 726 (A)
 CPTM2_35                      727- 728 (A)
 CPTM2_36                      729- 730 (A)
 CPTM2_37                      731- 732 (A)
 CPTM2_38                      733- 734 (A)
 CPTM2_39                      735- 736 (A)
 CPTM2_40                      737- 738 (A)
 CPTM2_41                      739- 740 (A)
 CPTM2_42                      741- 742 (A)
 CPTM2_43                      743- 744 (A)
 CPTM2_44                      745- 746 (A)
 CPTM2_45                      747- 748 (A)
 CPTM2_46                      749- 750 (A)
 CPTM2_47                      751- 752 (A)
 CPTM2_48                      753- 754 (A)
 CPTM2_49                      755- 756 (A)
 CPTM2_50                      757- 758 (A)
 DIED                          759- 760
 DISPUB04                      761- 762
 DISPUNIFORM                   763- 764
 DMONTH                        765- 766
 DQTR                          767- 768
 DXVER                         769- 771
 FEMALE                        772- 773
 HCUP_ED                       774- 775
 HCUP_OS                       776- 777
 HCUP_SURGERY_BROAD_CPT        778- 782
 HCUP_SURGERY_NARROW_CPT       783- 787
 HOSPST                        788- 789 (A)
 I10_DX_Visit_Reason1          790- 796 (A)
 I10_DX_Visit_Reason2          797- 803 (A)
 I10_DX_Visit_Reason3          804- 810 (A)
 I10_DX1                       811- 817 (A)
 I10_DX2                       818- 824 (A)
 I10_DX3                       825- 831 (A)
 I10_DX4                       832- 838 (A)
 I10_DX5                       839- 845 (A)
 I10_DX6                       846- 852 (A)
 I10_DX7                       853- 859 (A)
 I10_DX8                       860- 866 (A)
 I10_DX9                       867- 873 (A)
 I10_DX10                      874- 880 (A)
 I10_DX11                      881- 887 (A)
 I10_DX12                      888- 894 (A)
 I10_DX13                      895- 901 (A)
 I10_DX14                      902- 908 (A)
 I10_DX15                      909- 915 (A)
 I10_DX16                      916- 922 (A)
 I10_DX17                      923- 929 (A)
 I10_DX18                      930- 936 (A)
 I10_DX19                      937- 943 (A)
 I10_DX20                      944- 950 (A)
 I10_DX21                      951- 957 (A)
 I10_DX22                      958- 964 (A)
 I10_DX23                      965- 971 (A)
 I10_DX24                      972- 978 (A)
 I10_DX25                      979- 985 (A)
 I10_DX26                      986- 992 (A)
 I10_DX27                      993- 999 (A)
 I10_DX28                     1000-1006 (A)
 I10_DX29                     1007-1013 (A)
 I10_DX30                     1014-1020 (A)
 I10_DX31                     1021-1027 (A)
 I10_DX32                     1028-1034 (A)
 I10_DX33                     1035-1041 (A)
 I10_NDX                      1042-1044
 I10_PROCTYPE                 1045-1047
 KEY                          1048-1062
 LOS                          1063-1067
 MDSPEC1                      1068-1069 (A)
 MDSPEC2                      1070-1071 (A)
 MEDINCSTQ                    1072-1073
 MRN_R                        1074-1082
 NCPT                         1083-1086
 OPservice                    1087     (A)
 OS_TIME                      1088-1098
 PAY1                         1099-1100
 PAY2                         1101-1102
 PAY3                         1103-1104
 PL_CBSA                      1105-1107
 PL_NCHS                      1108-1109
 PL_UIC                       1110-1111
 PL_UR_CAT4                   1112-1113
 PointOfOriginUB04            1114     (A)
 PSTATE                       1115-1116 (A)
 PSTCO                        1117-1121
 PSTCO2                       1122-1126
 STATE_AS                     1127-1128
 STATE_ED                     1129-1130
 STATE_OS                     1131-1132
 YEAR                         1133-1136
 ZIP3                         1137-1139 (A)
 ZIPINC_QRTL                  1140-1142
 AGEGROUP                     1143-1145
 HOSPID                       1146-1150
 AYEAR                        1151-1154.


***  Specify write formats  ***.
FORMATS
 AMONTH                       (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 I10_NDX                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AGEGROUP                     (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AMONTH                       "Admission month"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OPservice                    "Indicator of outpatient service (as received from source)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY3                         "Tertiary expected payer (uniform)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AGEGROUP                     " "
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'ME_SASD_2017_CORE.SAV' /COMPRESSED.
