/*******************************************************************
* Creation Date: 01/06/2015   
*   NC_SASD_2012_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NC_SASD_2012_CHGS.ASC' FIXED SKIP=2 / 
 CHG1                       1-  12
 CHG2                      13-  24
 CHG3                      25-  36
 CHG4                      37-  48
 CHG5                      49-  60
 CHG6                      61-  72
 CHG7                      73-  84
 CHG8                      85-  96
 CHG9                      97- 108
 CHG10                    109- 120
 KEY                      121- 135.


***  Specify write formats  ***.
FORMATS
 CHG1                    (F6.2) /
 CHG2                    (F6.2) /
 CHG3                    (F6.2) /
 CHG4                    (F6.2) /
 CHG5                    (F6.2) /
 CHG6                    (F6.2) /
 CHG7                    (F6.2) /
 CHG8                    (F6.2) /
 CHG9                    (F6.2) /
 CHG10                   (F6.2) /
 KEY                     (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHG1                    "Detailed charges 1 (as received from source)"
 CHG2                    "Detailed charges 2 (as received from source)"
 CHG3                    "Detailed charges 3 (as received from source)"
 CHG4                    "Detailed charges 4 (as received from source)"
 CHG5                    "Detailed charges 5 (as received from source)"
 CHG6                    "Detailed charges 6 (as received from source)"
 CHG7                    "Detailed charges 7 (as received from source)"
 CHG8                    "Detailed charges 8 (as received from source)"
 CHG9                    "Detailed charges 9 (as received from source)"
 CHG10                   "Detailed charges 10 (as received from source)"
 KEY                     "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'NC_SASD_2012_CHGS.SAV' /COMPRESSED.
