/*******************************************************************
*   UT_SASD_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'UT_SASD_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AMONTH                    24-  25
 APG1                      26-  29
 APG2                      30-  33
 APG3                      34-  37
 APG4                      38-  41
 APG5                      42-  45
 APG6                      46-  49
 APGCAT1                   50-  52
 APGCAT2                   53-  55
 APGCAT3                   56-  58
 APGCAT4                   59-  61
 APGCAT5                   62-  64
 APGCAT6                   65-  67
 APGTYPE1                  68-  70
 APGTYPE2                  71-  73
 APGTYPE3                  74-  76
 APGTYPE4                  77-  79
 APGTYPE5                  80-  82
 APGTYPE6                  83-  85
 ASOURCE                   86-  87
 ASOURCE_                  88     (A)
 ASOURCEU                  89     (A)
 AWEEKEND                  90-  91
 CPT1                      92-  96 (A)
 CPT2                      97- 101 (A)
 CPT3                     102- 106 (A)
 CPT4                     107- 111 (A)
 CPT5                     112- 116 (A)
 CPT6                     117- 121 (A)
 CPTM1_1                  122- 123 (A)
 CPTM1_2                  124- 125 (A)
 CPTM1_3                  126- 127 (A)
 CPTM1_4                  128- 129 (A)
 CPTM1_5                  130- 131 (A)
 CPTM1_6                  132- 133 (A)
 CPTM2_1                  134- 135 (A)
 CPTM2_2                  136- 137 (A)
 CPTM2_3                  138- 139 (A)
 CPTM2_4                  140- 141 (A)
 CPTM2_5                  142- 143 (A)
 CPTM2_6                  144- 145 (A)
 DIED                     146- 147
 DISP_X                   148- 149 (A)
 DISPUB92                 150- 151
 DISPUNIF                 152- 153
 DQTR                     154- 155
 DSHOSPID                 156- 168 (A)
 DX1                      169- 173 (A)
 DX2                      174- 178 (A)
 DX3                      179- 183 (A)
 DX4                      184- 188 (A)
 DX5                      189- 193 (A)
 DX6                      194- 198 (A)
 DX7                      199- 203 (A)
 DX8                      204- 208 (A)
 DX9                      209- 213 (A)
 DXCCS1                   214- 217
 DXCCS2                   218- 221
 DXCCS3                   222- 225
 DXCCS4                   226- 229
 DXCCS5                   230- 233
 DXCCS6                   234- 237
 DXCCS7                   238- 241
 DXCCS8                   242- 245
 DXCCS9                   246- 249
 ECODE1                   250- 254 (A)
 ECODE2                   255- 259 (A)
 ECODE3                   260- 264 (A)
 ECODE4                   265- 269 (A)
 ECODE5                   270- 274 (A)
 E_CCS1                   275- 278
 E_CCS2                   279- 282
 E_CCS3                   283- 286
 E_CCS4                   287- 290
 E_CCS5                   291- 294
 FEMALE                   295- 296
 HCUP_AS                  297- 298
 HCUP_ED                  299- 300
 HCUP_OS                  301- 302
 Homeless                 303- 304
 HOSPBRTH                 305- 307
 HOSPST                   308- 309 (A)
 LOS                      310- 314
 LOS_X                    315- 320
 MEDINCST                 321- 322
 NCPT                     323- 325
 NDX                      326- 327
 NECODE                   328- 329
 NEOMAT                   330- 331
 NPR                      332- 333
 PAY1                     334- 335
 PAY2                     336- 337
 PAY1_X                   338- 339 (A)
 PAY2_X                   340- 341 (A)
 PAY3_X                   342- 343 (A)
 PL_CBSA                  344- 346
 PL_MSA19                 347- 349
 PL_NHCS2                 350- 351
 PL_RUCA1                 352- 353
 PL_RUCA2                 354- 357
 PL_RUCA4                 358- 359
 PL_RUCC2                 360- 361
 PL_UIC20                 362- 363
 PL_UR_CA                 364- 365
 PL_UR_CA                 366- 367
 PR1                      368- 371 (A)
 PR2                      372- 375 (A)
 PR3                      376- 379 (A)
 PR4                      380- 383 (A)
 PR5                      384- 387 (A)
 PR6                      388- 391 (A)
 PRCCS1                   392- 394
 PRCCS2                   395- 397
 PRCCS3                   398- 400
 PRCCS4                   401- 403
 PRCCS5                   404- 406
 PRCCS6                   407- 409
 PRDAY1                   410- 414
 PROCTYPE                 415- 417
 PSTATE                   418- 419 (A)
 STATE_AS                 420- 421
 STATE_ED                 422- 423
 STATE_OS                 424- 425
 TOTCHG                   426- 435
 TOTCHG_X                 436- 450
 YEAR                     451- 454
 ZIPINC_Q                 455- 457
 ZIP                      458- 462 (A)
 AYEAR                    463- 466
 DMONTH                   467- 468
 BMONTH                   469- 470
 BYEAR                    471- 474
 PRMNTH1                  475- 476
 PRYEAR1                  477- 480.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 APG1                    (F3.0) /
 APG2                    (F3.0) /
 APG3                    (F3.0) /
 APG4                    (F3.0) /
 APG5                    (F3.0) /
 APG6                    (F3.0) /
 APGCAT1                 (F3.0) /
 APGCAT2                 (F3.0) /
 APGCAT3                 (F3.0) /
 APGCAT4                 (F3.0) /
 APGCAT5                 (F3.0) /
 APGCAT6                 (F3.0) /
 APGTYPE1                (F3.0) /
 APGTYPE2                (F3.0) /
 APGTYPE3                (F3.0) /
 APGTYPE4                (F3.0) /
 APGTYPE5                (F3.0) /
 APGTYPE6                (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 Homeless                (F3.0) /
 HOSPBRTH                (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 APG1      "Ambulatory Patient Group 1 (as received from source)"
 APG2      "Ambulatory Patient Group 2 (as received from source)"
 APG3      "Ambulatory Patient Group 3 (as received from source)"
 APG4      "Ambulatory Patient Group 4 (as received from source)"
 APG5      "Ambulatory Patient Group 5 (as received from source)"
 APG6      "Ambulatory Patient Group 6 (as received from source)"
 APGCAT1   "Ambulatory Patient Group Category 1 (as received from source)"
 APGCAT2   "Ambulatory Patient Group Category 2 (as received from source)"
 APGCAT3   "Ambulatory Patient Group Category 3 (as received from source)"
 APGCAT4   "Ambulatory Patient Group Category 4 (as received from source)"
 APGCAT5   "Ambulatory Patient Group Category 5 (as received from source)"
 APGCAT6   "Ambulatory Patient Group Category 6 (as received from source)"
 APGTYPE1  "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE2  "Ambulatory Patient Group Type 2 (as received from source)"
 APGTYPE3  "Ambulatory Patient Group Type 3 (as received from source)"
 APGTYPE4  "Ambulatory Patient Group Type 4 (as received from source)"
 APGTYPE5  "Ambulatory Patient Group Type 5 (as received from source)"
 APGTYPE6  "Ambulatory Patient Group Type 6 (as received from source)"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 Homeless  "Indicator that patient is homeless"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE APG1
 (-999,-888,-666,-555=SYSMIS).
RECODE APG2
 (-999,-888,-666,-555=SYSMIS).
RECODE APG3
 (-999,-888,-666,-555=SYSMIS).
RECODE APG4
 (-999,-888,-666,-555=SYSMIS).
RECODE APG5
 (-999,-888,-666,-555=SYSMIS).
RECODE APG6
 (-999,-888,-666,-555=SYSMIS).
RECODE APGCAT1
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT2
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT3
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT4
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT5
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT6
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE1
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE2
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE3
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE4
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE5
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE6
 (-99,-88,-66,-55=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2006_CORE.SAV' /COMPRESSED.
