/*******************************************************************
* Creation Date: 01/24/2018   
*   NE_SASD_2016_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NE_SASD_2016_CHGS.ASC' FIXED SKIP=2 / 
 CHARGE                          1-  12
 KEY                            13-  27
 REVCODE                        28-  31 (A)
 SERVDAY                        32-  36
 UNITS                          37-  47.


***  Specify write formats  ***.
FORMATS
 CHARGE                       (F6.2) /
 KEY                          (F8.0) /
 SERVDAY                      (F3.0) /
 UNITS                        (F4.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHARGE                       "Line item charges (as received from source)"
 KEY                          "HCUP record identifier"
 REVCODE                      "Line item revenue code (as received from source)"
 SERVDAY                      "Line item days from admission date"
 UNITS                        "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).



SAVE OUTFILE = 'NE_SASD_2016_CHGS.SAV' /COMPRESSED.
