/*****************************************************************************
* Creation Date: 01/07/2016   
* Stataload_CO_SASD_2014_CORE.Do
* This program will load the 2014 CO ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                          ///
      int    AGE                         1-  3   ///
      int    AGEMONTH                    4-  6   ///
      byte   AMONTH                      7-  8   ///
      byte   ATYPE                       9- 10   ///
      byte   AWEEKEND                   11- 12   ///
      str    CPT1                       13- 17   ///
      str    CPT2                       18- 22   ///
      str    CPT3                       23- 27   ///
      str    CPT4                       28- 32   ///
      str    CPT5                       33- 37   ///
      str    CPT6                       38- 42   ///
      str    CPT7                       43- 47   ///
      str    CPT8                       48- 52   ///
      str    CPT9                       53- 57   ///
      str    CPT10                      58- 62   ///
      str    CPT11                      63- 67   ///
      str    CPT12                      68- 72   ///
      str    CPT13                      73- 77   ///
      str    CPT14                      78- 82   ///
      str    CPT15                      83- 87   ///
      int    CPTCCS1                    88- 90   ///
      int    CPTCCS2                    91- 93   ///
      int    CPTCCS3                    94- 96   ///
      int    CPTCCS4                    97- 99   ///
      int    CPTCCS5                   100-102   ///
      int    CPTCCS6                   103-105   ///
      int    CPTCCS7                   106-108   ///
      int    CPTCCS8                   109-111   ///
      int    CPTCCS9                   112-114   ///
      int    CPTCCS10                  115-117   ///
      int    CPTCCS11                  118-120   ///
      int    CPTCCS12                  121-123   ///
      int    CPTCCS13                  124-126   ///
      int    CPTCCS14                  127-129   ///
      int    CPTCCS15                  130-132   ///
      byte   DIED                      133-134   ///
      byte   DISPUB04                  135-136   ///
      byte   DISPUNIFORM               137-138   ///
      str    DISP_X                    139-140   ///
      byte   DMONTH                    141-142   ///
      byte   DQTR                      143-144   ///
      str    DSHOSPID                  145-161   ///
      str    DX1                       162-168   ///
      str    DX2                       169-175   ///
      str    DX3                       176-182   ///
      str    DX4                       183-189   ///
      str    DX5                       190-196   ///
      str    DX6                       197-203   ///
      str    DX7                       204-210   ///
      str    DX8                       211-217   ///
      str    DX9                       218-224   ///
      str    DX10                      225-231   ///
      str    DX11                      232-238   ///
      str    DX12                      239-245   ///
      str    DX13                      246-252   ///
      str    DX14                      253-259   ///
      str    DX15                      260-266   ///
      str    DX16                      267-273   ///
      str    DX17                      274-280   ///
      str    DX18                      281-287   ///
      str    DX19                      288-294   ///
      str    DX20                      295-301   ///
      str    DX21                      302-308   ///
      str    DX22                      309-315   ///
      str    DX23                      316-322   ///
      str    DX24                      323-329   ///
      str    DX25                      330-336   ///
      str    DX26                      337-343   ///
      str    DX27                      344-350   ///
      str    DX28                      351-357   ///
      str    DX29                      358-364   ///
      str    DX30                      365-371   ///
      int    DXCCS1                    372-375   ///
      int    DXCCS2                    376-379   ///
      int    DXCCS3                    380-383   ///
      int    DXCCS4                    384-387   ///
      int    DXCCS5                    388-391   ///
      int    DXCCS6                    392-395   ///
      int    DXCCS7                    396-399   ///
      int    DXCCS8                    400-403   ///
      int    DXCCS9                    404-407   ///
      int    DXCCS10                   408-411   ///
      int    DXCCS11                   412-415   ///
      int    DXCCS12                   416-419   ///
      int    DXCCS13                   420-423   ///
      int    DXCCS14                   424-427   ///
      int    DXCCS15                   428-431   ///
      int    DXCCS16                   432-435   ///
      int    DXCCS17                   436-439   ///
      int    DXCCS18                   440-443   ///
      int    DXCCS19                   444-447   ///
      int    DXCCS20                   448-451   ///
      int    DXCCS21                   452-455   ///
      int    DXCCS22                   456-459   ///
      int    DXCCS23                   460-463   ///
      int    DXCCS24                   464-467   ///
      int    DXCCS25                   468-471   ///
      int    DXCCS26                   472-475   ///
      int    DXCCS27                   476-479   ///
      int    DXCCS28                   480-483   ///
      int    DXCCS29                   484-487   ///
      int    DXCCS30                   488-491   ///
      int    DXVER                     492-494   ///
      str    ECODE1                    495-501   ///
      str    ECODE2                    502-508   ///
      str    ECODE3                    509-515   ///
      str    ECODE4                    516-522   ///
      str    ECODE5                    523-529   ///
      str    ECODE6                    530-536   ///
      str    ECODE7                    537-543   ///
      str    ECODE8                    544-550   ///
      str    ECODE9                    551-557   ///
      int    E_CCS1                    558-561   ///
      int    E_CCS2                    562-565   ///
      int    E_CCS3                    566-569   ///
      int    E_CCS4                    570-573   ///
      int    E_CCS5                    574-577   ///
      int    E_CCS6                    578-581   ///
      int    E_CCS7                    582-585   ///
      int    E_CCS8                    586-589   ///
      int    E_CCS9                    590-593   ///
      byte   FEMALE                    594-595   ///
      byte   HCUP_ED                   596-597   ///
      byte   HCUP_OS                   598-599   ///
      int    HOSPBRTH                  600-602   ///
      str    HOSPST                    603-604   ///
      byte   Homeless                  605-606   ///
      double KEY                       607-621   ///
      long   LOS                       622-626   ///
      long   LOS_X                     627-632   ///
      long   MDNUM1_R                  633-641   ///
      long   MDNUM2_R                  642-650   ///
      byte   MEDINCSTQ                 651-652   ///
      long   MRN_R                     653-661   ///
      int    NCHRONIC                  662-664   ///
      int    NCPT                      665-668   ///
      int    NDX                       669-671   ///
      byte   NECODE                    672-673   ///
      byte   NEOMAT                    674-675   ///
      int    NPR                       676-678   ///
      byte   ORPROC                    679-680   ///
      byte   PAY1                      681-682   ///
      str    PAY1_X                    683-684   ///
      int    PL_CBSA                   685-687   ///
      byte   PL_NCHS                   688-689   ///
      byte   PL_RUCC                   690-691   ///
      byte   PL_UIC                    692-693   ///
      byte   PL_UR_CAT4                694-695   ///
      str    PR1                       696-702   ///
      str    PR2                       703-709   ///
      str    PR3                       710-716   ///
      str    PR4                       717-723   ///
      str    PR5                       724-730   ///
      str    PR6                       731-737   ///
      str    PR7                       738-744   ///
      str    PR8                       745-751   ///
      str    PR9                       752-758   ///
      str    PR10                      759-765   ///
      str    PR11                      766-772   ///
      str    PR12                      773-779   ///
      str    PR13                      780-786   ///
      str    PR14                      787-793   ///
      str    PR15                      794-800   ///
      str    PR16                      801-807   ///
      str    PR17                      808-814   ///
      str    PR18                      815-821   ///
      str    PR19                      822-828   ///
      str    PR20                      829-835   ///
      str    PR21                      836-842   ///
      str    PR22                      843-849   ///
      str    PR23                      850-856   ///
      str    PR24                      857-863   ///
      str    PR25                      864-870   ///
      str    PR26                      871-877   ///
      str    PR27                      878-884   ///
      str    PR28                      885-891   ///
      str    PR29                      892-898   ///
      str    PR30                      899-905   ///
      int    PRCCS1                    906-908   ///
      int    PRCCS2                    909-911   ///
      int    PRCCS3                    912-914   ///
      int    PRCCS4                    915-917   ///
      int    PRCCS5                    918-920   ///
      int    PRCCS6                    921-923   ///
      int    PRCCS7                    924-926   ///
      int    PRCCS8                    927-929   ///
      int    PRCCS9                    930-932   ///
      int    PRCCS10                   933-935   ///
      int    PRCCS11                   936-938   ///
      int    PRCCS12                   939-941   ///
      int    PRCCS13                   942-944   ///
      int    PRCCS14                   945-947   ///
      int    PRCCS15                   948-950   ///
      int    PRCCS16                   951-953   ///
      int    PRCCS17                   954-956   ///
      int    PRCCS18                   957-959   ///
      int    PRCCS19                   960-962   ///
      int    PRCCS20                   963-965   ///
      int    PRCCS21                   966-968   ///
      int    PRCCS22                   969-971   ///
      int    PRCCS23                   972-974   ///
      int    PRCCS24                   975-977   ///
      int    PRCCS25                   978-980   ///
      int    PRCCS26                   981-983   ///
      int    PRCCS27                   984-986   ///
      int    PRCCS28                   987-989   ///
      int    PRCCS29                   990-992   ///
      int    PRCCS30                   993-995   ///
      long   PRDAY1                   996-1000   ///
      long   PRDAY2                  1001-1005   ///
      long   PRDAY3                  1006-1010   ///
      long   PRDAY4                  1011-1015   ///
      long   PRDAY5                  1016-1020   ///
      long   PRDAY6                  1021-1025   ///
      long   PRDAY7                  1026-1030   ///
      long   PRDAY8                  1031-1035   ///
      long   PRDAY9                  1036-1040   ///
      long   PRDAY10                 1041-1045   ///
      long   PRDAY11                 1046-1050   ///
      long   PRDAY12                 1051-1055   ///
      long   PRDAY13                 1056-1060   ///
      long   PRDAY14                 1061-1065   ///
      long   PRDAY15                 1066-1070   ///
      long   PRDAY16                 1071-1075   ///
      long   PRDAY17                 1076-1080   ///
      long   PRDAY18                 1081-1085   ///
      long   PRDAY19                 1086-1090   ///
      long   PRDAY20                 1091-1095   ///
      long   PRDAY21                 1096-1100   ///
      long   PRDAY22                 1101-1105   ///
      long   PRDAY23                 1106-1110   ///
      long   PRDAY24                 1111-1115   ///
      long   PRDAY25                 1116-1120   ///
      long   PRDAY26                 1121-1125   ///
      long   PRDAY27                 1126-1130   ///
      long   PRDAY28                 1131-1135   ///
      long   PRDAY29                 1136-1140   ///
      long   PRDAY30                 1141-1145   ///
      int    PROCTYPE                1146-1148   ///
      int    PRVER                   1149-1151   ///
      str    PSTATE                  1152-1153   ///
      long   PSTCO                   1154-1158   ///
      long   PSTCO2                  1159-1163   ///
      str    PointOfOriginUB04       1164        ///
      str    PointOfOrigin_X         1165        ///
      byte   RACE                    1166-1167   ///
      str    RACE_X                  1168        ///
      byte   STATE_AS                1169-1170   ///
      byte   STATE_ED                1171-1172   ///
      byte   STATE_OS                1173-1174   ///
      double TOTCHG                  1175-1184   ///
      double TOTCHG_X                1185-1199   ///
      int    YEAR                    1200-1203   ///
      str    ZIP                     1204-1208   ///
      str    ZIP3                    1209-1211   ///
      int    ZIPINC_QRTL             1212-1214   ///
      int    AYEAR                   1215-1218   ///
      byte   BMONTH                  1219-1220   ///
      int    BYEAR                   1221-1224   ///
      byte   PRMONTH1                1225-1226   ///
      byte   PRMONTH2                1227-1228   ///
      byte   PRMONTH3                1229-1230   ///
      byte   PRMONTH4                1231-1232   ///
      byte   PRMONTH5                1233-1234   ///
      byte   PRMONTH6                1235-1236   ///
      byte   PRMONTH7                1237-1238   ///
      byte   PRMONTH8                1239-1240   ///
      byte   PRMONTH9                1241-1242   ///
      byte   PRMONTH10               1243-1244   ///
      byte   PRMONTH11               1245-1246   ///
      byte   PRMONTH12               1247-1248   ///
      byte   PRMONTH13               1249-1250   ///
      byte   PRMONTH14               1251-1252   ///
      byte   PRMONTH15               1253-1254   ///
      byte   PRMONTH16               1255-1256   ///
      byte   PRMONTH17               1257-1258   ///
      byte   PRMONTH18               1259-1260   ///
      byte   PRMONTH19               1261-1262   ///
      byte   PRMONTH20               1263-1264   ///
      byte   PRMONTH21               1265-1266   ///
      byte   PRMONTH22               1267-1268   ///
      byte   PRMONTH23               1269-1270   ///
      byte   PRMONTH24               1271-1272   ///
      byte   PRMONTH25               1273-1274   ///
      byte   PRMONTH26               1275-1276   ///
      byte   PRMONTH27               1277-1278   ///
      byte   PRMONTH28               1279-1280   ///
      byte   PRMONTH29               1281-1282   ///
      byte   PRMONTH30               1283-1284   ///
      int    PRYEAR1                 1285-1288   ///
      int    PRYEAR2                 1289-1292   ///
      int    PRYEAR3                 1293-1296   ///
      int    PRYEAR4                 1297-1300   ///
      int    PRYEAR5                 1301-1304   ///
      int    PRYEAR6                 1305-1308   ///
      int    PRYEAR7                 1309-1312   ///
      int    PRYEAR8                 1313-1316   ///
      int    PRYEAR9                 1317-1320   ///
      int    PRYEAR10                1321-1324   ///
      int    PRYEAR11                1325-1328   ///
      int    PRYEAR12                1329-1332   ///
      int    PRYEAR13                1333-1336   ///
      int    PRYEAR14                1337-1340   ///
      int    PRYEAR15                1341-1344   ///
      int    PRYEAR16                1345-1348   ///
      int    PRYEAR17                1349-1352   ///
      int    PRYEAR18                1353-1356   ///
      int    PRYEAR19                1357-1360   ///
      int    PRYEAR20                1361-1364   ///
      int    PRYEAR21                1365-1368   ///
      int    PRYEAR22                1369-1372   ///
      int    PRYEAR23                1373-1376   ///
      int    PRYEAR24                1377-1380   ///
      int    PRYEAR25                1381-1384   ///
      int    PRYEAR26                1385-1388   ///
      int    PRYEAR27                1389-1392   ///
      int    PRYEAR28                1393-1396   ///
      int    PRYEAR29                1397-1400   ///
      int    PRYEAR30                1401-1404   ///
      using  "CO_SASD_2014_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPT7                     "CPT/HCPCS procedure code 7"
label var CPT8                     "CPT/HCPCS procedure code 8"
label var CPT9                     "CPT/HCPCS procedure code 9"
label var CPT10                    "CPT/HCPCS procedure code 10"
label var CPT11                    "CPT/HCPCS procedure code 11"
label var CPT12                    "CPT/HCPCS procedure code 12"
label var CPT13                    "CPT/HCPCS procedure code 13"
label var CPT14                    "CPT/HCPCS procedure code 14"
label var CPT15                    "CPT/HCPCS procedure code 15"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTCCS7                  "CCS: CPT 7"
label var CPTCCS8                  "CCS: CPT 8"
label var CPTCCS9                  "CCS: CPT 9"
label var CPTCCS10                 "CCS: CPT 10"
label var CPTCCS11                 "CCS: CPT 11"
label var CPTCCS12                 "CCS: CPT 12"
label var CPTCCS13                 "CCS: CPT 13"
label var CPTCCS14                 "CCS: CPT 14"
label var CPTCCS15                 "CCS: CPT 15"
label var DIED                     "Died during hospitalization"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DX26                     "Diagnosis 26"
label var DX27                     "Diagnosis 27"
label var DX28                     "Diagnosis 28"
label var DX29                     "Diagnosis 29"
label var DX30                     "Diagnosis 30"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var DXCCS26                  "CCS: diagnosis 26"
label var DXCCS27                  "CCS: diagnosis 27"
label var DXCCS28                  "CCS: diagnosis 28"
label var DXCCS29                  "CCS: diagnosis 29"
label var DXCCS30                  "CCS: diagnosis 30"
label var DXVER                    "Diagnosis Version"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ECODE5                   "E code 5"
label var ECODE6                   "E code 6"
label var ECODE7                   "E code 7"
label var ECODE8                   "E code 8"
label var ECODE9                   "E code 9"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var E_CCS5                   "CCS: E Code 5"
label var E_CCS6                   "CCS: E Code 6"
label var E_CCS7                   "CCS: E Code 7"
label var E_CCS8                   "CCS: E Code 8"
label var E_CCS9                   "CCS: E Code 9"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var Homeless                 "Indicator that patient is homeless"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var MRN_R                    "Medical record number (re-identified)"
label var NCHRONIC                 "Number of chronic conditions"
label var NCPT                     "Number of CPT/HCPCS procedures on this record"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PR16                     "Procedure 16"
label var PR17                     "Procedure 17"
label var PR18                     "Procedure 18"
label var PR19                     "Procedure 19"
label var PR20                     "Procedure 20"
label var PR21                     "Procedure 21"
label var PR22                     "Procedure 22"
label var PR23                     "Procedure 23"
label var PR24                     "Procedure 24"
label var PR25                     "Procedure 25"
label var PR26                     "Procedure 26"
label var PR27                     "Procedure 27"
label var PR28                     "Procedure 28"
label var PR29                     "Procedure 29"
label var PR30                     "Procedure 30"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRCCS16                  "CCS: procedure 16"
label var PRCCS17                  "CCS: procedure 17"
label var PRCCS18                  "CCS: procedure 18"
label var PRCCS19                  "CCS: procedure 19"
label var PRCCS20                  "CCS: procedure 20"
label var PRCCS21                  "CCS: procedure 21"
label var PRCCS22                  "CCS: procedure 22"
label var PRCCS23                  "CCS: procedure 23"
label var PRCCS24                  "CCS: procedure 24"
label var PRCCS25                  "CCS: procedure 25"
label var PRCCS26                  "CCS: procedure 26"
label var PRCCS27                  "CCS: procedure 27"
label var PRCCS28                  "CCS: procedure 28"
label var PRCCS29                  "CCS: procedure 29"
label var PRCCS30                  "CCS: procedure 30"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var PRDAY16                  "Number of days from admission to PR16"
label var PRDAY17                  "Number of days from admission to PR17"
label var PRDAY18                  "Number of days from admission to PR18"
label var PRDAY19                  "Number of days from admission to PR19"
label var PRDAY20                  "Number of days from admission to PR20"
label var PRDAY21                  "Number of days from admission to PR21"
label var PRDAY22                  "Number of days from admission to PR22"
label var PRDAY23                  "Number of days from admission to PR23"
label var PRDAY24                  "Number of days from admission to PR24"
label var PRDAY25                  "Number of days from admission to PR25"
label var PRDAY26                  "Number of days from admission to PR26"
label var PRDAY27                  "Number of days from admission to PR27"
label var PRDAY28                  "Number of days from admission to PR28"
label var PRDAY29                  "Number of days from admission to PR29"
label var PRDAY30                  "Number of days from admission to PR30"
label var PROCTYPE                 "Procedure type indicator"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var RACE                     "Race (uniform)"
label var RACE_X                   "Race (as received from source)"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTCCS7                   (-99 -88 -66=.)
recode CPTCCS8                   (-99 -88 -66=.)
recode CPTCCS9                   (-99 -88 -66=.)
recode CPTCCS10                  (-99 -88 -66=.)
recode CPTCCS11                  (-99 -88 -66=.)
recode CPTCCS12                  (-99 -88 -66=.)
recode CPTCCS13                  (-99 -88 -66=.)
recode CPTCCS14                  (-99 -88 -66=.)
recode CPTCCS15                  (-99 -88 -66=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode DXCCS16                   (-999 -888 -666=.)
recode DXCCS17                   (-999 -888 -666=.)
recode DXCCS18                   (-999 -888 -666=.)
recode DXCCS19                   (-999 -888 -666=.)
recode DXCCS20                   (-999 -888 -666=.)
recode DXCCS21                   (-999 -888 -666=.)
recode DXCCS22                   (-999 -888 -666=.)
recode DXCCS23                   (-999 -888 -666=.)
recode DXCCS24                   (-999 -888 -666=.)
recode DXCCS25                   (-999 -888 -666=.)
recode DXCCS26                   (-999 -888 -666=.)
recode DXCCS27                   (-999 -888 -666=.)
recode DXCCS28                   (-999 -888 -666=.)
recode DXCCS29                   (-999 -888 -666=.)
recode DXCCS30                   (-999 -888 -666=.)
recode DXVER                     (-99 -88 -66=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode E_CCS5                    (-999 -888 -666=.)
recode E_CCS6                    (-999 -888 -666=.)
recode E_CCS7                    (-999 -888 -666=.)
recode E_CCS8                    (-999 -888 -666=.)
recode E_CCS9                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HOSPBRTH                  (-99 -88 -66=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode MRN_R                     (-99999999 -88888888 -66666666=.)
recode NCHRONIC                  (-99 -88 -66=.)
recode NCPT                      (-999 -888 -666=.)
recode NDX                       (-99 -88 -66=.)
recode NECODE                    (-9 -8 -6 -5=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-99 -88 -66=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRCCS16                   (-99 -88 -66=.)
recode PRCCS17                   (-99 -88 -66=.)
recode PRCCS18                   (-99 -88 -66=.)
recode PRCCS19                   (-99 -88 -66=.)
recode PRCCS20                   (-99 -88 -66=.)
recode PRCCS21                   (-99 -88 -66=.)
recode PRCCS22                   (-99 -88 -66=.)
recode PRCCS23                   (-99 -88 -66=.)
recode PRCCS24                   (-99 -88 -66=.)
recode PRCCS25                   (-99 -88 -66=.)
recode PRCCS26                   (-99 -88 -66=.)
recode PRCCS27                   (-99 -88 -66=.)
recode PRCCS28                   (-99 -88 -66=.)
recode PRCCS29                   (-99 -88 -66=.)
recode PRCCS30                   (-99 -88 -66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PROCTYPE                  (-99 -88 -66=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)

save "CO_SASD_2014_CORE.dta", replace
