/*****************************************************************************
* Creation Date: 03/17/2017   
* CO_SASD_2015q4_CORE.Do
* This program will load the 2015 CO ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEMONTH                     4-   6   ///
      byte   AMONTH                       7-   8   ///
      byte   ATYPE                        9-  10   ///
      byte   AWEEKEND                    11-  12   ///
      str    CPT1                        13-  17   ///
      str    CPT2                        18-  22   ///
      str    CPT3                        23-  27   ///
      str    CPT4                        28-  32   ///
      str    CPT5                        33-  37   ///
      str    CPT6                        38-  42   ///
      str    CPT7                        43-  47   ///
      str    CPT8                        48-  52   ///
      str    CPT9                        53-  57   ///
      str    CPT10                       58-  62   ///
      str    CPT11                       63-  67   ///
      str    CPT12                       68-  72   ///
      str    CPT13                       73-  77   ///
      str    CPT14                       78-  82   ///
      str    CPT15                       83-  87   ///
      int    CPTCCS1                     88-  90   ///
      int    CPTCCS2                     91-  93   ///
      int    CPTCCS3                     94-  96   ///
      int    CPTCCS4                     97-  99   ///
      int    CPTCCS5                    100- 102   ///
      int    CPTCCS6                    103- 105   ///
      int    CPTCCS7                    106- 108   ///
      int    CPTCCS8                    109- 111   ///
      int    CPTCCS9                    112- 114   ///
      int    CPTCCS10                   115- 117   ///
      int    CPTCCS11                   118- 120   ///
      int    CPTCCS12                   121- 123   ///
      int    CPTCCS13                   124- 126   ///
      int    CPTCCS14                   127- 129   ///
      int    CPTCCS15                   130- 132   ///
      byte   DIED                       133- 134   ///
      str    DISP_X                     135- 136   ///
      byte   DISPUB04                   137- 138   ///
      byte   DISPUNIFORM                139- 140   ///
      byte   DMONTH                     141- 142   ///
      byte   DQTR                       143- 144   ///
      str    DSHOSPID                   145- 161   ///
      int    DXVER                      162- 164   ///
      byte   FEMALE                     165- 166   ///
      byte   HCUP_ED                    167- 168   ///
      byte   HCUP_OS                    169- 170   ///
      long   HCUP_SURGERY_BROAD_CPT     171- 175   ///
      long   HCUP_SURGERY_NARROW_CPT    176- 180   ///
      byte   Homeless                   181- 182   ///
      str    HOSPST                     183- 184   ///
      str    I10_DX1                    185- 191   ///
      str    I10_DX2                    192- 198   ///
      str    I10_DX3                    199- 205   ///
      str    I10_DX4                    206- 212   ///
      str    I10_DX5                    213- 219   ///
      str    I10_DX6                    220- 226   ///
      str    I10_DX7                    227- 233   ///
      str    I10_DX8                    234- 240   ///
      str    I10_DX9                    241- 247   ///
      str    I10_DX10                   248- 254   ///
      str    I10_DX11                   255- 261   ///
      str    I10_DX12                   262- 268   ///
      str    I10_DX13                   269- 275   ///
      str    I10_DX14                   276- 282   ///
      str    I10_DX15                   283- 289   ///
      str    I10_DX16                   290- 296   ///
      str    I10_DX17                   297- 303   ///
      str    I10_DX18                   304- 310   ///
      str    I10_DX19                   311- 317   ///
      str    I10_DX20                   318- 324   ///
      str    I10_DX21                   325- 331   ///
      str    I10_DX22                   332- 338   ///
      str    I10_DX23                   339- 345   ///
      str    I10_DX24                   346- 352   ///
      str    I10_DX25                   353- 359   ///
      str    I10_DX26                   360- 366   ///
      str    I10_DX27                   367- 373   ///
      str    I10_DX28                   374- 380   ///
      str    I10_DX29                   381- 387   ///
      str    I10_DX30                   388- 394   ///
      int    I10_DXCCS1                 395- 398   ///
      int    I10_DXCCS2                 399- 402   ///
      int    I10_DXCCS3                 403- 406   ///
      int    I10_DXCCS4                 407- 410   ///
      int    I10_DXCCS5                 411- 414   ///
      int    I10_DXCCS6                 415- 418   ///
      int    I10_DXCCS7                 419- 422   ///
      int    I10_DXCCS8                 423- 426   ///
      int    I10_DXCCS9                 427- 430   ///
      int    I10_DXCCS10                431- 434   ///
      int    I10_DXCCS11                435- 438   ///
      int    I10_DXCCS12                439- 442   ///
      int    I10_DXCCS13                443- 446   ///
      int    I10_DXCCS14                447- 450   ///
      int    I10_DXCCS15                451- 454   ///
      int    I10_DXCCS16                455- 458   ///
      int    I10_DXCCS17                459- 462   ///
      int    I10_DXCCS18                463- 466   ///
      int    I10_DXCCS19                467- 470   ///
      int    I10_DXCCS20                471- 474   ///
      int    I10_DXCCS21                475- 478   ///
      int    I10_DXCCS22                479- 482   ///
      int    I10_DXCCS23                483- 486   ///
      int    I10_DXCCS24                487- 490   ///
      int    I10_DXCCS25                491- 494   ///
      int    I10_DXCCS26                495- 498   ///
      int    I10_DXCCS27                499- 502   ///
      int    I10_DXCCS28                503- 506   ///
      int    I10_DXCCS29                507- 510   ///
      int    I10_DXCCS30                511- 514   ///
      str    I10_ECAUSE1                515- 521   ///
      str    I10_ECAUSE2                522- 528   ///
      str    I10_ECAUSE3                529- 535   ///
      str    I10_ECAUSE4                536- 542   ///
      str    I10_ECAUSE5                543- 549   ///
      str    I10_ECAUSE6                550- 556   ///
      str    I10_ECAUSE7                557- 563   ///
      str    I10_ECAUSE8                564- 570   ///
      str    I10_ECAUSE9                571- 577   ///
      str    I10_ECAUSE10               578- 584   ///
      str    I10_ECAUSE11               585- 591   ///
      str    I10_ECAUSE12               592- 598   ///
      str    I10_ECAUSE13               599- 605   ///
      str    I10_ECAUSE14               606- 612   ///
      str    I10_ECAUSE15               613- 619   ///
      str    I10_ECAUSE16               620- 626   ///
      str    I10_ECAUSE17               627- 633   ///
      str    I10_ECAUSE18               634- 640   ///
      str    I10_ECAUSE19               641- 647   ///
      str    I10_ECAUSE20               648- 654   ///
      str    I10_ECAUSE21               655- 661   ///
      str    I10_ECAUSE22               662- 668   ///
      str    I10_ECAUSE23               669- 675   ///
      str    I10_ECAUSE24               676- 682   ///
      str    I10_ECAUSE25               683- 689   ///
      str    I10_ECAUSE26               690- 696   ///
      str    I10_ECAUSE27               697- 703   ///
      str    I10_ECAUSE28               704- 710   ///
      str    I10_ECAUSE29               711- 717   ///
      str    I10_ECAUSE30               718- 724   ///
      int    I10_ECauseCCS1             725- 728   ///
      int    I10_ECauseCCS2             729- 732   ///
      int    I10_ECauseCCS3             733- 736   ///
      int    I10_ECauseCCS4             737- 740   ///
      int    I10_ECauseCCS5             741- 744   ///
      int    I10_ECauseCCS6             745- 748   ///
      int    I10_ECauseCCS7             749- 752   ///
      int    I10_ECauseCCS8             753- 756   ///
      int    I10_ECauseCCS9             757- 760   ///
      int    I10_ECauseCCS10            761- 764   ///
      int    I10_ECauseCCS11            765- 768   ///
      int    I10_ECauseCCS12            769- 772   ///
      int    I10_ECauseCCS13            773- 776   ///
      int    I10_ECauseCCS14            777- 780   ///
      int    I10_ECauseCCS15            781- 784   ///
      int    I10_ECauseCCS16            785- 788   ///
      int    I10_ECauseCCS17            789- 792   ///
      int    I10_ECauseCCS18            793- 796   ///
      int    I10_ECauseCCS19            797- 800   ///
      int    I10_ECauseCCS20            801- 804   ///
      int    I10_ECauseCCS21            805- 808   ///
      int    I10_ECauseCCS22            809- 812   ///
      int    I10_ECauseCCS23            813- 816   ///
      int    I10_ECauseCCS24            817- 820   ///
      int    I10_ECauseCCS25            821- 824   ///
      int    I10_ECauseCCS26            825- 828   ///
      int    I10_ECauseCCS27            829- 832   ///
      int    I10_ECauseCCS28            833- 836   ///
      int    I10_ECauseCCS29            837- 840   ///
      int    I10_ECauseCCS30            841- 844   ///
      int    I10_HOSPBRTH               845- 847   ///
      int    I10_NCHRONIC               848- 850   ///
      int    I10_NDX                    851- 853   ///
      byte   I10_NECAUSE                854- 855   ///
      byte   I10_NEOMAT                 856- 857   ///
      int    I10_NPR                    858- 860   ///
      byte   I10_ORPROC                 861- 862   ///
      str    I10_PR1                    863- 869   ///
      str    I10_PR2                    870- 876   ///
      str    I10_PR3                    877- 883   ///
      str    I10_PR4                    884- 890   ///
      str    I10_PR5                    891- 897   ///
      str    I10_PR6                    898- 904   ///
      str    I10_PR7                    905- 911   ///
      str    I10_PR8                    912- 918   ///
      str    I10_PR9                    919- 925   ///
      str    I10_PR10                   926- 932   ///
      str    I10_PR11                   933- 939   ///
      str    I10_PR12                   940- 946   ///
      str    I10_PR13                   947- 953   ///
      str    I10_PR14                   954- 960   ///
      str    I10_PR15                   961- 967   ///
      str    I10_PR16                   968- 974   ///
      str    I10_PR17                   975- 981   ///
      str    I10_PR18                   982- 988   ///
      str    I10_PR19                   989- 995   ///
      str    I10_PR20                   996-1002   ///
      str    I10_PR21                  1003-1009   ///
      str    I10_PR22                  1010-1016   ///
      str    I10_PR23                  1017-1023   ///
      str    I10_PR24                  1024-1030   ///
      str    I10_PR25                  1031-1037   ///
      str    I10_PR26                  1038-1044   ///
      str    I10_PR27                  1045-1051   ///
      str    I10_PR28                  1052-1058   ///
      str    I10_PR29                  1059-1065   ///
      str    I10_PR30                  1066-1072   ///
      int    I10_PRCCS1                1073-1075   ///
      int    I10_PRCCS2                1076-1078   ///
      int    I10_PRCCS3                1079-1081   ///
      int    I10_PRCCS4                1082-1084   ///
      int    I10_PRCCS5                1085-1087   ///
      int    I10_PRCCS6                1088-1090   ///
      int    I10_PRCCS7                1091-1093   ///
      int    I10_PRCCS8                1094-1096   ///
      int    I10_PRCCS9                1097-1099   ///
      int    I10_PRCCS10               1100-1102   ///
      int    I10_PRCCS11               1103-1105   ///
      int    I10_PRCCS12               1106-1108   ///
      int    I10_PRCCS13               1109-1111   ///
      int    I10_PRCCS14               1112-1114   ///
      int    I10_PRCCS15               1115-1117   ///
      int    I10_PRCCS16               1118-1120   ///
      int    I10_PRCCS17               1121-1123   ///
      int    I10_PRCCS18               1124-1126   ///
      int    I10_PRCCS19               1127-1129   ///
      int    I10_PRCCS20               1130-1132   ///
      int    I10_PRCCS21               1133-1135   ///
      int    I10_PRCCS22               1136-1138   ///
      int    I10_PRCCS23               1139-1141   ///
      int    I10_PRCCS24               1142-1144   ///
      int    I10_PRCCS25               1145-1147   ///
      int    I10_PRCCS26               1148-1150   ///
      int    I10_PRCCS27               1151-1153   ///
      int    I10_PRCCS28               1154-1156   ///
      int    I10_PRCCS29               1157-1159   ///
      int    I10_PRCCS30               1160-1162   ///
      int    I10_PROCTYPE              1163-1165   ///
      double KEY                       1166-1180   ///
      long   LOS                       1181-1185   ///
      long   LOS_X                     1186-1191   ///
      long   MDNUM1_R                  1192-1200   ///
      long   MDNUM2_R                  1201-1209   ///
      byte   MEDINCSTQ                 1210-1211   ///
      long   MRN_R                     1212-1220   ///
      int    NCPT                      1221-1224   ///
      byte   PAY1                      1225-1226   ///
      str    PAY1_X                    1227-1228   ///
      int    PL_CBSA                   1229-1231   ///
      byte   PL_NCHS                   1232-1233   ///
      byte   PL_RUCC                   1234-1235   ///
      byte   PL_UIC                    1236-1237   ///
      byte   PL_UR_CAT4                1238-1239   ///
      str    PointOfOrigin_X           1240        ///
      str    PointOfOriginUB04         1241        ///
      long   PRDAY1                    1242-1246   ///
      long   PRDAY2                    1247-1251   ///
      long   PRDAY3                    1252-1256   ///
      long   PRDAY4                    1257-1261   ///
      long   PRDAY5                    1262-1266   ///
      long   PRDAY6                    1267-1271   ///
      long   PRDAY7                    1272-1276   ///
      long   PRDAY8                    1277-1281   ///
      long   PRDAY9                    1282-1286   ///
      long   PRDAY10                   1287-1291   ///
      long   PRDAY11                   1292-1296   ///
      long   PRDAY12                   1297-1301   ///
      long   PRDAY13                   1302-1306   ///
      long   PRDAY14                   1307-1311   ///
      long   PRDAY15                   1312-1316   ///
      long   PRDAY16                   1317-1321   ///
      long   PRDAY17                   1322-1326   ///
      long   PRDAY18                   1327-1331   ///
      long   PRDAY19                   1332-1336   ///
      long   PRDAY20                   1337-1341   ///
      long   PRDAY21                   1342-1346   ///
      long   PRDAY22                   1347-1351   ///
      long   PRDAY23                   1352-1356   ///
      long   PRDAY24                   1357-1361   ///
      long   PRDAY25                   1362-1366   ///
      long   PRDAY26                   1367-1371   ///
      long   PRDAY27                   1372-1376   ///
      long   PRDAY28                   1377-1381   ///
      long   PRDAY29                   1382-1386   ///
      long   PRDAY30                   1387-1391   ///
      int    PRVER                     1392-1394   ///
      str    PSTATE                    1395-1396   ///
      long   PSTCO                     1397-1401   ///
      long   PSTCO2                    1402-1406   ///
      byte   RACE                      1407-1408   ///
      str    RACE_X                    1409        ///
      byte   STATE_AS                  1410-1411   ///
      byte   STATE_ED                  1412-1413   ///
      byte   STATE_OS                  1414-1415   ///
      double TOTCHG                    1416-1425   ///
      double TOTCHG_X                  1426-1440   ///
      int    YEAR                      1441-1444   ///
      str    ZIP                       1445-1449   ///
      str    ZIP3                      1450-1452   ///
      int    ZIPINC_QRTL               1453-1455   ///
      int    AYEAR                     1456-1459   ///
      byte   BMONTH                    1460-1461   ///
      int    BYEAR                     1462-1465   ///
      byte   PRMONTH1                  1466-1467   ///
      byte   PRMONTH2                  1468-1469   ///
      byte   PRMONTH3                  1470-1471   ///
      byte   PRMONTH4                  1472-1473   ///
      byte   PRMONTH5                  1474-1475   ///
      byte   PRMONTH6                  1476-1477   ///
      byte   PRMONTH7                  1478-1479   ///
      byte   PRMONTH8                  1480-1481   ///
      byte   PRMONTH9                  1482-1483   ///
      byte   PRMONTH10                 1484-1485   ///
      byte   PRMONTH11                 1486-1487   ///
      byte   PRMONTH12                 1488-1489   ///
      byte   PRMONTH13                 1490-1491   ///
      byte   PRMONTH14                 1492-1493   ///
      byte   PRMONTH15                 1494-1495   ///
      byte   PRMONTH16                 1496-1497   ///
      byte   PRMONTH17                 1498-1499   ///
      byte   PRMONTH18                 1500-1501   ///
      byte   PRMONTH19                 1502-1503   ///
      byte   PRMONTH20                 1504-1505   ///
      byte   PRMONTH21                 1506-1507   ///
      byte   PRMONTH22                 1508-1509   ///
      byte   PRMONTH23                 1510-1511   ///
      byte   PRMONTH24                 1512-1513   ///
      byte   PRMONTH25                 1514-1515   ///
      byte   PRMONTH26                 1516-1517   ///
      byte   PRMONTH27                 1518-1519   ///
      byte   PRMONTH28                 1520-1521   ///
      byte   PRMONTH29                 1522-1523   ///
      byte   PRMONTH30                 1524-1525   ///
      int    PRYEAR1                   1526-1529   ///
      int    PRYEAR2                   1530-1533   ///
      int    PRYEAR3                   1534-1537   ///
      int    PRYEAR4                   1538-1541   ///
      int    PRYEAR5                   1542-1545   ///
      int    PRYEAR6                   1546-1549   ///
      int    PRYEAR7                   1550-1553   ///
      int    PRYEAR8                   1554-1557   ///
      int    PRYEAR9                   1558-1561   ///
      int    PRYEAR10                  1562-1565   ///
      int    PRYEAR11                  1566-1569   ///
      int    PRYEAR12                  1570-1573   ///
      int    PRYEAR13                  1574-1577   ///
      int    PRYEAR14                  1578-1581   ///
      int    PRYEAR15                  1582-1585   ///
      int    PRYEAR16                  1586-1589   ///
      int    PRYEAR17                  1590-1593   ///
      int    PRYEAR18                  1594-1597   ///
      int    PRYEAR19                  1598-1601   ///
      int    PRYEAR20                  1602-1605   ///
      int    PRYEAR21                  1606-1609   ///
      int    PRYEAR22                  1610-1613   ///
      int    PRYEAR23                  1614-1617   ///
      int    PRYEAR24                  1618-1621   ///
      int    PRYEAR25                  1622-1625   ///
      int    PRYEAR26                  1626-1629   ///
      int    PRYEAR27                  1630-1633   ///
      int    PRYEAR28                  1634-1637   ///
      int    PRYEAR29                  1638-1641   ///
      int    PRYEAR30                  1642-1645   ///
      using  "CO_SASD_2015q4_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPT7                     "CPT/HCPCS procedure code 7"
label var CPT8                     "CPT/HCPCS procedure code 8"
label var CPT9                     "CPT/HCPCS procedure code 9"
label var CPT10                    "CPT/HCPCS procedure code 10"
label var CPT11                    "CPT/HCPCS procedure code 11"
label var CPT12                    "CPT/HCPCS procedure code 12"
label var CPT13                    "CPT/HCPCS procedure code 13"
label var CPT14                    "CPT/HCPCS procedure code 14"
label var CPT15                    "CPT/HCPCS procedure code 15"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTCCS7                  "CCS: CPT 7"
label var CPTCCS8                  "CCS: CPT 8"
label var CPTCCS9                  "CCS: CPT 9"
label var CPTCCS10                 "CCS: CPT 10"
label var CPTCCS11                 "CCS: CPT 11"
label var CPTCCS12                 "CCS: CPT 12"
label var CPTCCS13                 "CCS: CPT 13"
label var CPTCCS14                 "CCS: CPT 14"
label var CPTCCS15                 "CCS: CPT 15"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DSHOSPID                 "Data source hospital identifier"
label var DXVER                    "Diagnosis Version"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HCUP_SURGERY_BROAD_CPT   "Number of reported CPT procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_NARROW_CPT  "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
label var Homeless                 "Indicator that patient is homeless"
label var HOSPST                   "Hospital state postal code"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DXCCS1               "ICD-10-CM CCS: diagnosis 1"
label var I10_DXCCS2               "ICD-10-CM CCS: diagnosis 2"
label var I10_DXCCS3               "ICD-10-CM CCS: diagnosis 3"
label var I10_DXCCS4               "ICD-10-CM CCS: diagnosis 4"
label var I10_DXCCS5               "ICD-10-CM CCS: diagnosis 5"
label var I10_DXCCS6               "ICD-10-CM CCS: diagnosis 6"
label var I10_DXCCS7               "ICD-10-CM CCS: diagnosis 7"
label var I10_DXCCS8               "ICD-10-CM CCS: diagnosis 8"
label var I10_DXCCS9               "ICD-10-CM CCS: diagnosis 9"
label var I10_DXCCS10              "ICD-10-CM CCS: diagnosis 10"
label var I10_DXCCS11              "ICD-10-CM CCS: diagnosis 11"
label var I10_DXCCS12              "ICD-10-CM CCS: diagnosis 12"
label var I10_DXCCS13              "ICD-10-CM CCS: diagnosis 13"
label var I10_DXCCS14              "ICD-10-CM CCS: diagnosis 14"
label var I10_DXCCS15              "ICD-10-CM CCS: diagnosis 15"
label var I10_DXCCS16              "ICD-10-CM CCS: diagnosis 16"
label var I10_DXCCS17              "ICD-10-CM CCS: diagnosis 17"
label var I10_DXCCS18              "ICD-10-CM CCS: diagnosis 18"
label var I10_DXCCS19              "ICD-10-CM CCS: diagnosis 19"
label var I10_DXCCS20              "ICD-10-CM CCS: diagnosis 20"
label var I10_DXCCS21              "ICD-10-CM CCS: diagnosis 21"
label var I10_DXCCS22              "ICD-10-CM CCS: diagnosis 22"
label var I10_DXCCS23              "ICD-10-CM CCS: diagnosis 23"
label var I10_DXCCS24              "ICD-10-CM CCS: diagnosis 24"
label var I10_DXCCS25              "ICD-10-CM CCS: diagnosis 25"
label var I10_DXCCS26              "ICD-10-CM CCS: diagnosis 26"
label var I10_DXCCS27              "ICD-10-CM CCS: diagnosis 27"
label var I10_DXCCS28              "ICD-10-CM CCS: diagnosis 28"
label var I10_DXCCS29              "ICD-10-CM CCS: diagnosis 29"
label var I10_DXCCS30              "ICD-10-CM CCS: diagnosis 30"
label var I10_ECAUSE1              "ICD-10-CM E Cause 1"
label var I10_ECAUSE2              "ICD-10-CM E Cause 2"
label var I10_ECAUSE3              "ICD-10-CM E Cause 3"
label var I10_ECAUSE4              "ICD-10-CM E Cause 4"
label var I10_ECAUSE5              "ICD-10-CM E Cause 5"
label var I10_ECAUSE6              "ICD-10-CM E Cause 6"
label var I10_ECAUSE7              "ICD-10-CM E Cause 7"
label var I10_ECAUSE8              "ICD-10-CM E Cause 8"
label var I10_ECAUSE9              "ICD-10-CM E Cause 9"
label var I10_ECAUSE10             "ICD-10-CM E Cause 10"
label var I10_ECAUSE11             "ICD-10-CM E Cause 11"
label var I10_ECAUSE12             "ICD-10-CM E Cause 12"
label var I10_ECAUSE13             "ICD-10-CM E Cause 13"
label var I10_ECAUSE14             "ICD-10-CM E Cause 14"
label var I10_ECAUSE15             "ICD-10-CM E Cause 15"
label var I10_ECAUSE16             "ICD-10-CM E Cause 16"
label var I10_ECAUSE17             "ICD-10-CM E Cause 17"
label var I10_ECAUSE18             "ICD-10-CM E Cause 18"
label var I10_ECAUSE19             "ICD-10-CM E Cause 19"
label var I10_ECAUSE20             "ICD-10-CM E Cause 20"
label var I10_ECAUSE21             "ICD-10-CM E Cause 21"
label var I10_ECAUSE22             "ICD-10-CM E Cause 22"
label var I10_ECAUSE23             "ICD-10-CM E Cause 23"
label var I10_ECAUSE24             "ICD-10-CM E Cause 24"
label var I10_ECAUSE25             "ICD-10-CM E Cause 25"
label var I10_ECAUSE26             "ICD-10-CM E Cause 26"
label var I10_ECAUSE27             "ICD-10-CM E Cause 27"
label var I10_ECAUSE28             "ICD-10-CM E Cause 28"
label var I10_ECAUSE29             "ICD-10-CM E Cause 29"
label var I10_ECAUSE30             "ICD-10-CM E Cause 30"
label var I10_ECauseCCS1           "ICD-10-CM CCS: E Cause 1"
label var I10_ECauseCCS2           "ICD-10-CM CCS: E Cause 2"
label var I10_ECauseCCS3           "ICD-10-CM CCS: E Cause 3"
label var I10_ECauseCCS4           "ICD-10-CM CCS: E Cause 4"
label var I10_ECauseCCS5           "ICD-10-CM CCS: E Cause 5"
label var I10_ECauseCCS6           "ICD-10-CM CCS: E Cause 6"
label var I10_ECauseCCS7           "ICD-10-CM CCS: E Cause 7"
label var I10_ECauseCCS8           "ICD-10-CM CCS: E Cause 8"
label var I10_ECauseCCS9           "ICD-10-CM CCS: E Cause 9"
label var I10_ECauseCCS10          "ICD-10-CM CCS: E Cause 10"
label var I10_ECauseCCS11          "ICD-10-CM CCS: E Cause 11"
label var I10_ECauseCCS12          "ICD-10-CM CCS: E Cause 12"
label var I10_ECauseCCS13          "ICD-10-CM CCS: E Cause 13"
label var I10_ECauseCCS14          "ICD-10-CM CCS: E Cause 14"
label var I10_ECauseCCS15          "ICD-10-CM CCS: E Cause 15"
label var I10_ECauseCCS16          "ICD-10-CM CCS: E Cause 16"
label var I10_ECauseCCS17          "ICD-10-CM CCS: E Cause 17"
label var I10_ECauseCCS18          "ICD-10-CM CCS: E Cause 18"
label var I10_ECauseCCS19          "ICD-10-CM CCS: E Cause 19"
label var I10_ECauseCCS20          "ICD-10-CM CCS: E Cause 20"
label var I10_ECauseCCS21          "ICD-10-CM CCS: E Cause 21"
label var I10_ECauseCCS22          "ICD-10-CM CCS: E Cause 22"
label var I10_ECauseCCS23          "ICD-10-CM CCS: E Cause 23"
label var I10_ECauseCCS24          "ICD-10-CM CCS: E Cause 24"
label var I10_ECauseCCS25          "ICD-10-CM CCS: E Cause 25"
label var I10_ECauseCCS26          "ICD-10-CM CCS: E Cause 26"
label var I10_ECauseCCS27          "ICD-10-CM CCS: E Cause 27"
label var I10_ECauseCCS28          "ICD-10-CM CCS: E Cause 28"
label var I10_ECauseCCS29          "ICD-10-CM CCS: E Cause 29"
label var I10_ECauseCCS30          "ICD-10-CM CCS: E Cause 30"
label var I10_HOSPBRTH             "ICD-10-CM Indicator of birth in this hospital"
label var I10_NCHRONIC             "ICD-10-CM Number of chronic conditions"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NECAUSE              "ICD-10-CM Number of E Causes on this record"
label var I10_NEOMAT               "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_ORPROC               "ICD-10-PCS Major operating room procedure indicator"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var I10_PR16                 "ICD-10-PCS Procedure 16"
label var I10_PR17                 "ICD-10-PCS Procedure 17"
label var I10_PR18                 "ICD-10-PCS Procedure 18"
label var I10_PR19                 "ICD-10-PCS Procedure 19"
label var I10_PR20                 "ICD-10-PCS Procedure 20"
label var I10_PR21                 "ICD-10-PCS Procedure 21"
label var I10_PR22                 "ICD-10-PCS Procedure 22"
label var I10_PR23                 "ICD-10-PCS Procedure 23"
label var I10_PR24                 "ICD-10-PCS Procedure 24"
label var I10_PR25                 "ICD-10-PCS Procedure 25"
label var I10_PR26                 "ICD-10-PCS Procedure 26"
label var I10_PR27                 "ICD-10-PCS Procedure 27"
label var I10_PR28                 "ICD-10-PCS Procedure 28"
label var I10_PR29                 "ICD-10-PCS Procedure 29"
label var I10_PR30                 "ICD-10-PCS Procedure 30"
label var I10_PRCCS1               "ICD-10-PCS CCS: procedure 1"
label var I10_PRCCS2               "ICD-10-PCS CCS: procedure 2"
label var I10_PRCCS3               "ICD-10-PCS CCS: procedure 3"
label var I10_PRCCS4               "ICD-10-PCS CCS: procedure 4"
label var I10_PRCCS5               "ICD-10-PCS CCS: procedure 5"
label var I10_PRCCS6               "ICD-10-PCS CCS: procedure 6"
label var I10_PRCCS7               "ICD-10-PCS CCS: procedure 7"
label var I10_PRCCS8               "ICD-10-PCS CCS: procedure 8"
label var I10_PRCCS9               "ICD-10-PCS CCS: procedure 9"
label var I10_PRCCS10              "ICD-10-PCS CCS: procedure 10"
label var I10_PRCCS11              "ICD-10-PCS CCS: procedure 11"
label var I10_PRCCS12              "ICD-10-PCS CCS: procedure 12"
label var I10_PRCCS13              "ICD-10-PCS CCS: procedure 13"
label var I10_PRCCS14              "ICD-10-PCS CCS: procedure 14"
label var I10_PRCCS15              "ICD-10-PCS CCS: procedure 15"
label var I10_PRCCS16              "ICD-10-PCS CCS: procedure 16"
label var I10_PRCCS17              "ICD-10-PCS CCS: procedure 17"
label var I10_PRCCS18              "ICD-10-PCS CCS: procedure 18"
label var I10_PRCCS19              "ICD-10-PCS CCS: procedure 19"
label var I10_PRCCS20              "ICD-10-PCS CCS: procedure 20"
label var I10_PRCCS21              "ICD-10-PCS CCS: procedure 21"
label var I10_PRCCS22              "ICD-10-PCS CCS: procedure 22"
label var I10_PRCCS23              "ICD-10-PCS CCS: procedure 23"
label var I10_PRCCS24              "ICD-10-PCS CCS: procedure 24"
label var I10_PRCCS25              "ICD-10-PCS CCS: procedure 25"
label var I10_PRCCS26              "ICD-10-PCS CCS: procedure 26"
label var I10_PRCCS27              "ICD-10-PCS CCS: procedure 27"
label var I10_PRCCS28              "ICD-10-PCS CCS: procedure 28"
label var I10_PRCCS29              "ICD-10-PCS CCS: procedure 29"
label var I10_PRCCS30              "ICD-10-PCS CCS: procedure 30"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var MRN_R                    "Medical record number (re-identified)"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRDAY16                  "Number of days from admission to I10_PR16"
label var PRDAY17                  "Number of days from admission to I10_PR17"
label var PRDAY18                  "Number of days from admission to I10_PR18"
label var PRDAY19                  "Number of days from admission to I10_PR19"
label var PRDAY20                  "Number of days from admission to I10_PR20"
label var PRDAY21                  "Number of days from admission to I10_PR21"
label var PRDAY22                  "Number of days from admission to I10_PR22"
label var PRDAY23                  "Number of days from admission to I10_PR23"
label var PRDAY24                  "Number of days from admission to I10_PR24"
label var PRDAY25                  "Number of days from admission to I10_PR25"
label var PRDAY26                  "Number of days from admission to I10_PR26"
label var PRDAY27                  "Number of days from admission to I10_PR27"
label var PRDAY28                  "Number of days from admission to I10_PR28"
label var PRDAY29                  "Number of days from admission to I10_PR29"
label var PRDAY30                  "Number of days from admission to I10_PR30"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var RACE                     "Race (uniform)"
label var RACE_X                   "Race (as received from source)"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTCCS7                   (-99 -88 -66=.)
recode CPTCCS8                   (-99 -88 -66=.)
recode CPTCCS9                   (-99 -88 -66=.)
recode CPTCCS10                  (-99 -88 -66=.)
recode CPTCCS11                  (-99 -88 -66=.)
recode CPTCCS12                  (-99 -88 -66=.)
recode CPTCCS13                  (-99 -88 -66=.)
recode CPTCCS14                  (-99 -88 -66=.)
recode CPTCCS15                  (-99 -88 -66=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DXVER                     (-99 -88 -66=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HCUP_SURGERY_BROAD_CPT    (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_CPT   (-9999 -8888 -6666=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode I10_DXCCS1                (-999 -888 -666=.)
recode I10_DXCCS2                (-999 -888 -666=.)
recode I10_DXCCS3                (-999 -888 -666=.)
recode I10_DXCCS4                (-999 -888 -666=.)
recode I10_DXCCS5                (-999 -888 -666=.)
recode I10_DXCCS6                (-999 -888 -666=.)
recode I10_DXCCS7                (-999 -888 -666=.)
recode I10_DXCCS8                (-999 -888 -666=.)
recode I10_DXCCS9                (-999 -888 -666=.)
recode I10_DXCCS10               (-999 -888 -666=.)
recode I10_DXCCS11               (-999 -888 -666=.)
recode I10_DXCCS12               (-999 -888 -666=.)
recode I10_DXCCS13               (-999 -888 -666=.)
recode I10_DXCCS14               (-999 -888 -666=.)
recode I10_DXCCS15               (-999 -888 -666=.)
recode I10_DXCCS16               (-999 -888 -666=.)
recode I10_DXCCS17               (-999 -888 -666=.)
recode I10_DXCCS18               (-999 -888 -666=.)
recode I10_DXCCS19               (-999 -888 -666=.)
recode I10_DXCCS20               (-999 -888 -666=.)
recode I10_DXCCS21               (-999 -888 -666=.)
recode I10_DXCCS22               (-999 -888 -666=.)
recode I10_DXCCS23               (-999 -888 -666=.)
recode I10_DXCCS24               (-999 -888 -666=.)
recode I10_DXCCS25               (-999 -888 -666=.)
recode I10_DXCCS26               (-999 -888 -666=.)
recode I10_DXCCS27               (-999 -888 -666=.)
recode I10_DXCCS28               (-999 -888 -666=.)
recode I10_DXCCS29               (-999 -888 -666=.)
recode I10_DXCCS30               (-999 -888 -666=.)
recode I10_ECauseCCS1            (-999 -888 -666=.)
recode I10_ECauseCCS2            (-999 -888 -666=.)
recode I10_ECauseCCS3            (-999 -888 -666=.)
recode I10_ECauseCCS4            (-999 -888 -666=.)
recode I10_ECauseCCS5            (-999 -888 -666=.)
recode I10_ECauseCCS6            (-999 -888 -666=.)
recode I10_ECauseCCS7            (-999 -888 -666=.)
recode I10_ECauseCCS8            (-999 -888 -666=.)
recode I10_ECauseCCS9            (-999 -888 -666=.)
recode I10_ECauseCCS10           (-999 -888 -666=.)
recode I10_ECauseCCS11           (-999 -888 -666=.)
recode I10_ECauseCCS12           (-999 -888 -666=.)
recode I10_ECauseCCS13           (-999 -888 -666=.)
recode I10_ECauseCCS14           (-999 -888 -666=.)
recode I10_ECauseCCS15           (-999 -888 -666=.)
recode I10_ECauseCCS16           (-999 -888 -666=.)
recode I10_ECauseCCS17           (-999 -888 -666=.)
recode I10_ECauseCCS18           (-999 -888 -666=.)
recode I10_ECauseCCS19           (-999 -888 -666=.)
recode I10_ECauseCCS20           (-999 -888 -666=.)
recode I10_ECauseCCS21           (-999 -888 -666=.)
recode I10_ECauseCCS22           (-999 -888 -666=.)
recode I10_ECauseCCS23           (-999 -888 -666=.)
recode I10_ECauseCCS24           (-999 -888 -666=.)
recode I10_ECauseCCS25           (-999 -888 -666=.)
recode I10_ECauseCCS26           (-999 -888 -666=.)
recode I10_ECauseCCS27           (-999 -888 -666=.)
recode I10_ECauseCCS28           (-999 -888 -666=.)
recode I10_ECauseCCS29           (-999 -888 -666=.)
recode I10_ECauseCCS30           (-999 -888 -666=.)
recode I10_HOSPBRTH              (-99 -88 -66=.)
recode I10_NCHRONIC              (-99 -88 -66=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_NECAUSE               (-9 -8 -6 -5=.)
recode I10_NEOMAT                (-9 -8 -6 -5=.)
recode I10_NPR                   (-99 -88 -66=.)
recode I10_ORPROC                (-9 -8 -6 -5=.)
recode I10_PRCCS1                (-99 -88 -66=.)
recode I10_PRCCS2                (-99 -88 -66=.)
recode I10_PRCCS3                (-99 -88 -66=.)
recode I10_PRCCS4                (-99 -88 -66=.)
recode I10_PRCCS5                (-99 -88 -66=.)
recode I10_PRCCS6                (-99 -88 -66=.)
recode I10_PRCCS7                (-99 -88 -66=.)
recode I10_PRCCS8                (-99 -88 -66=.)
recode I10_PRCCS9                (-99 -88 -66=.)
recode I10_PRCCS10               (-99 -88 -66=.)
recode I10_PRCCS11               (-99 -88 -66=.)
recode I10_PRCCS12               (-99 -88 -66=.)
recode I10_PRCCS13               (-99 -88 -66=.)
recode I10_PRCCS14               (-99 -88 -66=.)
recode I10_PRCCS15               (-99 -88 -66=.)
recode I10_PRCCS16               (-99 -88 -66=.)
recode I10_PRCCS17               (-99 -88 -66=.)
recode I10_PRCCS18               (-99 -88 -66=.)
recode I10_PRCCS19               (-99 -88 -66=.)
recode I10_PRCCS20               (-99 -88 -66=.)
recode I10_PRCCS21               (-99 -88 -66=.)
recode I10_PRCCS22               (-99 -88 -66=.)
recode I10_PRCCS23               (-99 -88 -66=.)
recode I10_PRCCS24               (-99 -88 -66=.)
recode I10_PRCCS25               (-99 -88 -66=.)
recode I10_PRCCS26               (-99 -88 -66=.)
recode I10_PRCCS27               (-99 -88 -66=.)
recode I10_PRCCS28               (-99 -88 -66=.)
recode I10_PRCCS29               (-99 -88 -66=.)
recode I10_PRCCS30               (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode MRN_R                     (-99999999 -88888888 -66666666=.)
recode NCPT                      (-999 -888 -666=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)

save "CO_SASD_2015q4_CORE.dta", replace
