/*****************************************************************************
* Creation Date: 07/15/2024   
* DC_SASD_2022_CORE.Do
* This program will load the 2022 DC ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEDAY                       4-   6   ///
      int    AGEMONTH                     7-   9   ///
      int    AHOUR                       10-  13   ///
      byte   AMONTH                      14-  15   ///
      byte   ATYPE                       16-  17   ///
      byte   AWEEKEND                    18-  19   ///
      str    BILLTYPE                    20-  23   ///
      str    CPT1                        24-  28   ///
      str    CPT2                        29-  33   ///
      str    CPT3                        34-  38   ///
      str    CPT4                        39-  43   ///
      str    CPT5                        44-  48   ///
      str    CPT6                        49-  53   ///
      str    CPT7                        54-  58   ///
      str    CPT8                        59-  63   ///
      str    CPT9                        64-  68   ///
      str    CPT10                       69-  73   ///
      str    CPT11                       74-  78   ///
      str    CPT12                       79-  83   ///
      str    CPT13                       84-  88   ///
      str    CPT14                       89-  93   ///
      str    CPT15                       94-  98   ///
      str    CPT16                       99- 103   ///
      str    CPT17                      104- 108   ///
      str    CPT18                      109- 113   ///
      str    CPT19                      114- 118   ///
      str    CPT20                      119- 123   ///
      str    CPT21                      124- 128   ///
      str    CPT22                      129- 133   ///
      str    CPT23                      134- 138   ///
      str    CPT24                      139- 143   ///
      str    CPT25                      144- 148   ///
      str    CPT26                      149- 153   ///
      str    CPT27                      154- 158   ///
      str    CPT28                      159- 163   ///
      str    CPT29                      164- 168   ///
      str    CPT30                      169- 173   ///
      str    CPT31                      174- 178   ///
      str    CPT32                      179- 183   ///
      str    CPT33                      184- 188   ///
      str    CPT34                      189- 193   ///
      str    CPT35                      194- 198   ///
      str    CPT36                      199- 203   ///
      str    CPT37                      204- 208   ///
      str    CPT38                      209- 213   ///
      str    CPT39                      214- 218   ///
      str    CPT40                      219- 223   ///
      str    CPT41                      224- 228   ///
      str    CPT42                      229- 233   ///
      str    CPT43                      234- 238   ///
      str    CPT44                      239- 243   ///
      str    CPT45                      244- 248   ///
      str    CPT46                      249- 253   ///
      str    CPT47                      254- 258   ///
      str    CPT48                      259- 263   ///
      str    CPT49                      264- 268   ///
      str    CPT50                      269- 273   ///
      str    CPT51                      274- 278   ///
      str    CPT52                      279- 283   ///
      str    CPT53                      284- 288   ///
      str    CPT54                      289- 293   ///
      str    CPT55                      294- 298   ///
      str    CPT56                      299- 303   ///
      str    CPT57                      304- 308   ///
      str    CPT58                      309- 313   ///
      str    CPT59                      314- 318   ///
      str    CPT60                      319- 323   ///
      str    CPT61                      324- 328   ///
      str    CPT62                      329- 333   ///
      str    CPT63                      334- 338   ///
      str    CPT64                      339- 343   ///
      str    CPT65                      344- 348   ///
      str    CPT66                      349- 353   ///
      str    CPT67                      354- 358   ///
      str    CPT68                      359- 363   ///
      str    CPT69                      364- 368   ///
      str    CPT70                      369- 373   ///
      str    CPT71                      374- 378   ///
      str    CPT72                      379- 383   ///
      str    CPT73                      384- 388   ///
      str    CPT74                      389- 393   ///
      str    CPT75                      394- 398   ///
      str    CPT76                      399- 403   ///
      str    CPT77                      404- 408   ///
      str    CPT78                      409- 413   ///
      str    CPT79                      414- 418   ///
      str    CPT80                      419- 423   ///
      str    CPT81                      424- 428   ///
      str    CPT82                      429- 433   ///
      str    CPT83                      434- 438   ///
      str    CPT84                      439- 443   ///
      str    CPT85                      444- 448   ///
      str    CPT86                      449- 453   ///
      str    CPT87                      454- 458   ///
      str    CPT88                      459- 463   ///
      str    CPT89                      464- 468   ///
      str    CPT90                      469- 473   ///
      str    CPT91                      474- 478   ///
      str    CPT92                      479- 483   ///
      str    CPT93                      484- 488   ///
      str    CPT94                      489- 493   ///
      str    CPT95                      494- 498   ///
      str    CPT96                      499- 503   ///
      str    CPT97                      504- 508   ///
      str    CPT98                      509- 513   ///
      str    CPT99                      514- 518   ///
      str    CPT100                     519- 523   ///
      str    CPT101                     524- 528   ///
      str    CPT102                     529- 533   ///
      str    CPT103                     534- 538   ///
      str    CPT104                     539- 543   ///
      str    CPT105                     544- 548   ///
      str    CPT106                     549- 553   ///
      str    CPT107                     554- 558   ///
      str    CPT108                     559- 563   ///
      str    CPT109                     564- 568   ///
      str    CPT110                     569- 573   ///
      str    CPT111                     574- 578   ///
      str    CPT112                     579- 583   ///
      str    CPT113                     584- 588   ///
      str    CPT114                     589- 593   ///
      str    CPT115                     594- 598   ///
      str    CPT116                     599- 603   ///
      str    CPT117                     604- 608   ///
      str    CPT118                     609- 613   ///
      str    CPT119                     614- 618   ///
      str    CPT120                     619- 623   ///
      str    CPT121                     624- 628   ///
      str    CPT122                     629- 633   ///
      str    CPT123                     634- 638   ///
      str    CPT124                     639- 643   ///
      str    CPT125                     644- 648   ///
      str    CPT126                     649- 653   ///
      str    CPT127                     654- 658   ///
      str    CPT128                     659- 663   ///
      str    CPT129                     664- 668   ///
      int    CPTCCS1                    669- 671   ///
      int    CPTCCS2                    672- 674   ///
      int    CPTCCS3                    675- 677   ///
      int    CPTCCS4                    678- 680   ///
      int    CPTCCS5                    681- 683   ///
      int    CPTCCS6                    684- 686   ///
      int    CPTCCS7                    687- 689   ///
      int    CPTCCS8                    690- 692   ///
      int    CPTCCS9                    693- 695   ///
      int    CPTCCS10                   696- 698   ///
      int    CPTCCS11                   699- 701   ///
      int    CPTCCS12                   702- 704   ///
      int    CPTCCS13                   705- 707   ///
      int    CPTCCS14                   708- 710   ///
      int    CPTCCS15                   711- 713   ///
      int    CPTCCS16                   714- 716   ///
      int    CPTCCS17                   717- 719   ///
      int    CPTCCS18                   720- 722   ///
      int    CPTCCS19                   723- 725   ///
      int    CPTCCS20                   726- 728   ///
      int    CPTCCS21                   729- 731   ///
      int    CPTCCS22                   732- 734   ///
      int    CPTCCS23                   735- 737   ///
      int    CPTCCS24                   738- 740   ///
      int    CPTCCS25                   741- 743   ///
      int    CPTCCS26                   744- 746   ///
      int    CPTCCS27                   747- 749   ///
      int    CPTCCS28                   750- 752   ///
      int    CPTCCS29                   753- 755   ///
      int    CPTCCS30                   756- 758   ///
      int    CPTCCS31                   759- 761   ///
      int    CPTCCS32                   762- 764   ///
      int    CPTCCS33                   765- 767   ///
      int    CPTCCS34                   768- 770   ///
      int    CPTCCS35                   771- 773   ///
      int    CPTCCS36                   774- 776   ///
      int    CPTCCS37                   777- 779   ///
      int    CPTCCS38                   780- 782   ///
      int    CPTCCS39                   783- 785   ///
      int    CPTCCS40                   786- 788   ///
      int    CPTCCS41                   789- 791   ///
      int    CPTCCS42                   792- 794   ///
      int    CPTCCS43                   795- 797   ///
      int    CPTCCS44                   798- 800   ///
      int    CPTCCS45                   801- 803   ///
      int    CPTCCS46                   804- 806   ///
      int    CPTCCS47                   807- 809   ///
      int    CPTCCS48                   810- 812   ///
      int    CPTCCS49                   813- 815   ///
      int    CPTCCS50                   816- 818   ///
      int    CPTCCS51                   819- 821   ///
      int    CPTCCS52                   822- 824   ///
      int    CPTCCS53                   825- 827   ///
      int    CPTCCS54                   828- 830   ///
      int    CPTCCS55                   831- 833   ///
      int    CPTCCS56                   834- 836   ///
      int    CPTCCS57                   837- 839   ///
      int    CPTCCS58                   840- 842   ///
      int    CPTCCS59                   843- 845   ///
      int    CPTCCS60                   846- 848   ///
      int    CPTCCS61                   849- 851   ///
      int    CPTCCS62                   852- 854   ///
      int    CPTCCS63                   855- 857   ///
      int    CPTCCS64                   858- 860   ///
      int    CPTCCS65                   861- 863   ///
      int    CPTCCS66                   864- 866   ///
      int    CPTCCS67                   867- 869   ///
      int    CPTCCS68                   870- 872   ///
      int    CPTCCS69                   873- 875   ///
      int    CPTCCS70                   876- 878   ///
      int    CPTCCS71                   879- 881   ///
      int    CPTCCS72                   882- 884   ///
      int    CPTCCS73                   885- 887   ///
      int    CPTCCS74                   888- 890   ///
      int    CPTCCS75                   891- 893   ///
      int    CPTCCS76                   894- 896   ///
      int    CPTCCS77                   897- 899   ///
      int    CPTCCS78                   900- 902   ///
      int    CPTCCS79                   903- 905   ///
      int    CPTCCS80                   906- 908   ///
      int    CPTCCS81                   909- 911   ///
      int    CPTCCS82                   912- 914   ///
      int    CPTCCS83                   915- 917   ///
      int    CPTCCS84                   918- 920   ///
      int    CPTCCS85                   921- 923   ///
      int    CPTCCS86                   924- 926   ///
      int    CPTCCS87                   927- 929   ///
      int    CPTCCS88                   930- 932   ///
      int    CPTCCS89                   933- 935   ///
      int    CPTCCS90                   936- 938   ///
      int    CPTCCS91                   939- 941   ///
      int    CPTCCS92                   942- 944   ///
      int    CPTCCS93                   945- 947   ///
      int    CPTCCS94                   948- 950   ///
      int    CPTCCS95                   951- 953   ///
      int    CPTCCS96                   954- 956   ///
      int    CPTCCS97                   957- 959   ///
      int    CPTCCS98                   960- 962   ///
      int    CPTCCS99                   963- 965   ///
      int    CPTCCS100                  966- 968   ///
      int    CPTCCS101                  969- 971   ///
      int    CPTCCS102                  972- 974   ///
      int    CPTCCS103                  975- 977   ///
      int    CPTCCS104                  978- 980   ///
      int    CPTCCS105                  981- 983   ///
      int    CPTCCS106                  984- 986   ///
      int    CPTCCS107                  987- 989   ///
      int    CPTCCS108                  990- 992   ///
      int    CPTCCS109                  993- 995   ///
      int    CPTCCS110                  996- 998   ///
      int    CPTCCS111                  999-1001   ///
      int    CPTCCS112                 1002-1004   ///
      int    CPTCCS113                 1005-1007   ///
      int    CPTCCS114                 1008-1010   ///
      int    CPTCCS115                 1011-1013   ///
      int    CPTCCS116                 1014-1016   ///
      int    CPTCCS117                 1017-1019   ///
      int    CPTCCS118                 1020-1022   ///
      int    CPTCCS119                 1023-1025   ///
      int    CPTCCS120                 1026-1028   ///
      int    CPTCCS121                 1029-1031   ///
      int    CPTCCS122                 1032-1034   ///
      int    CPTCCS123                 1035-1037   ///
      int    CPTCCS124                 1038-1040   ///
      int    CPTCCS125                 1041-1043   ///
      int    CPTCCS126                 1044-1046   ///
      int    CPTCCS127                 1047-1049   ///
      int    CPTCCS128                 1050-1052   ///
      int    CPTCCS129                 1053-1055   ///
      int    CPTDAY1                   1056-1058   ///
      int    CPTDAY2                   1059-1061   ///
      int    CPTDAY3                   1062-1064   ///
      int    CPTDAY4                   1065-1067   ///
      int    CPTDAY5                   1068-1070   ///
      int    CPTDAY6                   1071-1073   ///
      int    CPTDAY7                   1074-1076   ///
      int    CPTDAY8                   1077-1079   ///
      int    CPTDAY9                   1080-1082   ///
      int    CPTDAY10                  1083-1085   ///
      int    CPTDAY11                  1086-1088   ///
      int    CPTDAY12                  1089-1091   ///
      int    CPTDAY13                  1092-1094   ///
      int    CPTDAY14                  1095-1097   ///
      int    CPTDAY15                  1098-1100   ///
      int    CPTDAY16                  1101-1103   ///
      int    CPTDAY17                  1104-1106   ///
      int    CPTDAY18                  1107-1109   ///
      int    CPTDAY19                  1110-1112   ///
      int    CPTDAY20                  1113-1115   ///
      int    CPTDAY21                  1116-1118   ///
      int    CPTDAY22                  1119-1121   ///
      int    CPTDAY23                  1122-1124   ///
      int    CPTDAY24                  1125-1127   ///
      int    CPTDAY25                  1128-1130   ///
      int    CPTDAY26                  1131-1133   ///
      int    CPTDAY27                  1134-1136   ///
      int    CPTDAY28                  1137-1139   ///
      int    CPTDAY29                  1140-1142   ///
      int    CPTDAY30                  1143-1145   ///
      int    CPTDAY31                  1146-1148   ///
      int    CPTDAY32                  1149-1151   ///
      int    CPTDAY33                  1152-1154   ///
      int    CPTDAY34                  1155-1157   ///
      int    CPTDAY35                  1158-1160   ///
      int    CPTDAY36                  1161-1163   ///
      int    CPTDAY37                  1164-1166   ///
      int    CPTDAY38                  1167-1169   ///
      int    CPTDAY39                  1170-1172   ///
      int    CPTDAY40                  1173-1175   ///
      int    CPTDAY41                  1176-1178   ///
      int    CPTDAY42                  1179-1181   ///
      int    CPTDAY43                  1182-1184   ///
      int    CPTDAY44                  1185-1187   ///
      int    CPTDAY45                  1188-1190   ///
      int    CPTDAY46                  1191-1193   ///
      int    CPTDAY47                  1194-1196   ///
      int    CPTDAY48                  1197-1199   ///
      int    CPTDAY49                  1200-1202   ///
      int    CPTDAY50                  1203-1205   ///
      int    CPTDAY51                  1206-1208   ///
      int    CPTDAY52                  1209-1211   ///
      int    CPTDAY53                  1212-1214   ///
      int    CPTDAY54                  1215-1217   ///
      int    CPTDAY55                  1218-1220   ///
      int    CPTDAY56                  1221-1223   ///
      int    CPTDAY57                  1224-1226   ///
      int    CPTDAY58                  1227-1229   ///
      int    CPTDAY59                  1230-1232   ///
      int    CPTDAY60                  1233-1235   ///
      int    CPTDAY61                  1236-1238   ///
      int    CPTDAY62                  1239-1241   ///
      int    CPTDAY63                  1242-1244   ///
      int    CPTDAY64                  1245-1247   ///
      int    CPTDAY65                  1248-1250   ///
      int    CPTDAY66                  1251-1253   ///
      int    CPTDAY67                  1254-1256   ///
      int    CPTDAY68                  1257-1259   ///
      int    CPTDAY69                  1260-1262   ///
      int    CPTDAY70                  1263-1265   ///
      int    CPTDAY71                  1266-1268   ///
      int    CPTDAY72                  1269-1271   ///
      int    CPTDAY73                  1272-1274   ///
      int    CPTDAY74                  1275-1277   ///
      int    CPTDAY75                  1278-1280   ///
      int    CPTDAY76                  1281-1283   ///
      int    CPTDAY77                  1284-1286   ///
      int    CPTDAY78                  1287-1289   ///
      int    CPTDAY79                  1290-1292   ///
      int    CPTDAY80                  1293-1295   ///
      int    CPTDAY81                  1296-1298   ///
      int    CPTDAY82                  1299-1301   ///
      int    CPTDAY83                  1302-1304   ///
      int    CPTDAY84                  1305-1307   ///
      int    CPTDAY85                  1308-1310   ///
      int    CPTDAY86                  1311-1313   ///
      int    CPTDAY87                  1314-1316   ///
      int    CPTDAY88                  1317-1319   ///
      int    CPTDAY89                  1320-1322   ///
      int    CPTDAY90                  1323-1325   ///
      int    CPTDAY91                  1326-1328   ///
      int    CPTDAY92                  1329-1331   ///
      int    CPTDAY93                  1332-1334   ///
      int    CPTDAY94                  1335-1337   ///
      int    CPTDAY95                  1338-1340   ///
      int    CPTDAY96                  1341-1343   ///
      int    CPTDAY97                  1344-1346   ///
      int    CPTDAY98                  1347-1349   ///
      int    CPTDAY99                  1350-1352   ///
      int    CPTDAY100                 1353-1355   ///
      int    CPTDAY101                 1356-1358   ///
      int    CPTDAY102                 1359-1361   ///
      int    CPTDAY103                 1362-1364   ///
      int    CPTDAY104                 1365-1367   ///
      int    CPTDAY105                 1368-1370   ///
      int    CPTDAY106                 1371-1373   ///
      int    CPTDAY107                 1374-1376   ///
      int    CPTDAY108                 1377-1379   ///
      int    CPTDAY109                 1380-1382   ///
      int    CPTDAY110                 1383-1385   ///
      int    CPTDAY111                 1386-1388   ///
      int    CPTDAY112                 1389-1391   ///
      int    CPTDAY113                 1392-1394   ///
      int    CPTDAY114                 1395-1397   ///
      int    CPTDAY115                 1398-1400   ///
      int    CPTDAY116                 1401-1403   ///
      int    CPTDAY117                 1404-1406   ///
      int    CPTDAY118                 1407-1409   ///
      int    CPTDAY119                 1410-1412   ///
      int    CPTDAY120                 1413-1415   ///
      int    CPTDAY121                 1416-1418   ///
      int    CPTDAY122                 1419-1421   ///
      int    CPTDAY123                 1422-1424   ///
      int    CPTDAY124                 1425-1427   ///
      int    CPTDAY125                 1428-1430   ///
      int    CPTDAY126                 1431-1433   ///
      int    CPTDAY127                 1434-1436   ///
      int    CPTDAY128                 1437-1439   ///
      int    CPTDAY129                 1440-1442   ///
      str    CPTM1_1                   1443-1444   ///
      str    CPTM1_2                   1445-1446   ///
      str    CPTM1_3                   1447-1448   ///
      str    CPTM1_4                   1449-1450   ///
      str    CPTM1_5                   1451-1452   ///
      str    CPTM1_6                   1453-1454   ///
      str    CPTM1_7                   1455-1456   ///
      str    CPTM1_8                   1457-1458   ///
      str    CPTM1_9                   1459-1460   ///
      str    CPTM1_10                  1461-1462   ///
      str    CPTM1_11                  1463-1464   ///
      str    CPTM1_12                  1465-1466   ///
      str    CPTM1_13                  1467-1468   ///
      str    CPTM1_14                  1469-1470   ///
      str    CPTM1_15                  1471-1472   ///
      str    CPTM1_16                  1473-1474   ///
      str    CPTM1_17                  1475-1476   ///
      str    CPTM1_18                  1477-1478   ///
      str    CPTM1_19                  1479-1480   ///
      str    CPTM1_20                  1481-1482   ///
      str    CPTM1_21                  1483-1484   ///
      str    CPTM1_22                  1485-1486   ///
      str    CPTM1_23                  1487-1488   ///
      str    CPTM1_24                  1489-1490   ///
      str    CPTM1_25                  1491-1492   ///
      str    CPTM1_26                  1493-1494   ///
      str    CPTM1_27                  1495-1496   ///
      str    CPTM1_28                  1497-1498   ///
      str    CPTM1_29                  1499-1500   ///
      str    CPTM1_30                  1501-1502   ///
      str    CPTM1_31                  1503-1504   ///
      str    CPTM1_32                  1505-1506   ///
      str    CPTM1_33                  1507-1508   ///
      str    CPTM1_34                  1509-1510   ///
      str    CPTM1_35                  1511-1512   ///
      str    CPTM1_36                  1513-1514   ///
      str    CPTM1_37                  1515-1516   ///
      str    CPTM1_38                  1517-1518   ///
      str    CPTM1_39                  1519-1520   ///
      str    CPTM1_40                  1521-1522   ///
      str    CPTM1_41                  1523-1524   ///
      str    CPTM1_42                  1525-1526   ///
      str    CPTM1_43                  1527-1528   ///
      str    CPTM1_44                  1529-1530   ///
      str    CPTM1_45                  1531-1532   ///
      str    CPTM1_46                  1533-1534   ///
      str    CPTM1_47                  1535-1536   ///
      str    CPTM1_48                  1537-1538   ///
      str    CPTM1_49                  1539-1540   ///
      str    CPTM1_50                  1541-1542   ///
      str    CPTM1_51                  1543-1544   ///
      str    CPTM1_52                  1545-1546   ///
      str    CPTM1_53                  1547-1548   ///
      str    CPTM1_54                  1549-1550   ///
      str    CPTM1_55                  1551-1552   ///
      str    CPTM1_56                  1553-1554   ///
      str    CPTM1_57                  1555-1556   ///
      str    CPTM1_58                  1557-1558   ///
      str    CPTM1_59                  1559-1560   ///
      str    CPTM1_60                  1561-1562   ///
      str    CPTM1_61                  1563-1564   ///
      str    CPTM1_62                  1565-1566   ///
      str    CPTM1_63                  1567-1568   ///
      str    CPTM1_64                  1569-1570   ///
      str    CPTM1_65                  1571-1572   ///
      str    CPTM1_66                  1573-1574   ///
      str    CPTM1_67                  1575-1576   ///
      str    CPTM1_68                  1577-1578   ///
      str    CPTM1_69                  1579-1580   ///
      str    CPTM1_70                  1581-1582   ///
      str    CPTM1_71                  1583-1584   ///
      str    CPTM1_72                  1585-1586   ///
      str    CPTM1_73                  1587-1588   ///
      str    CPTM1_74                  1589-1590   ///
      str    CPTM1_75                  1591-1592   ///
      str    CPTM1_76                  1593-1594   ///
      str    CPTM1_77                  1595-1596   ///
      str    CPTM1_78                  1597-1598   ///
      str    CPTM1_79                  1599-1600   ///
      str    CPTM1_80                  1601-1602   ///
      str    CPTM1_81                  1603-1604   ///
      str    CPTM1_82                  1605-1606   ///
      str    CPTM1_83                  1607-1608   ///
      str    CPTM1_84                  1609-1610   ///
      str    CPTM1_85                  1611-1612   ///
      str    CPTM1_86                  1613-1614   ///
      str    CPTM1_87                  1615-1616   ///
      str    CPTM1_88                  1617-1618   ///
      str    CPTM1_89                  1619-1620   ///
      str    CPTM1_90                  1621-1622   ///
      str    CPTM1_91                  1623-1624   ///
      str    CPTM1_92                  1625-1626   ///
      str    CPTM1_93                  1627-1628   ///
      str    CPTM1_94                  1629-1630   ///
      str    CPTM1_95                  1631-1632   ///
      str    CPTM1_96                  1633-1634   ///
      str    CPTM1_97                  1635-1636   ///
      str    CPTM1_98                  1637-1638   ///
      str    CPTM1_99                  1639-1640   ///
      str    CPTM1_100                 1641-1642   ///
      str    CPTM1_101                 1643-1644   ///
      str    CPTM1_102                 1645-1646   ///
      str    CPTM1_103                 1647-1648   ///
      str    CPTM1_104                 1649-1650   ///
      str    CPTM1_105                 1651-1652   ///
      str    CPTM1_106                 1653-1654   ///
      str    CPTM1_107                 1655-1656   ///
      str    CPTM1_108                 1657-1658   ///
      str    CPTM1_109                 1659-1660   ///
      str    CPTM1_110                 1661-1662   ///
      str    CPTM1_111                 1663-1664   ///
      str    CPTM1_112                 1665-1666   ///
      str    CPTM1_113                 1667-1668   ///
      str    CPTM1_114                 1669-1670   ///
      str    CPTM1_115                 1671-1672   ///
      str    CPTM1_116                 1673-1674   ///
      str    CPTM1_117                 1675-1676   ///
      str    CPTM1_118                 1677-1678   ///
      str    CPTM1_119                 1679-1680   ///
      str    CPTM1_120                 1681-1682   ///
      str    CPTM1_121                 1683-1684   ///
      str    CPTM1_122                 1685-1686   ///
      str    CPTM1_123                 1687-1688   ///
      str    CPTM1_124                 1689-1690   ///
      str    CPTM1_125                 1691-1692   ///
      str    CPTM1_126                 1693-1694   ///
      str    CPTM1_127                 1695-1696   ///
      str    CPTM1_128                 1697-1698   ///
      str    CPTM1_129                 1699-1700   ///
      str    CPTM2_1                   1701-1702   ///
      str    CPTM2_2                   1703-1704   ///
      str    CPTM2_3                   1705-1706   ///
      str    CPTM2_4                   1707-1708   ///
      str    CPTM2_5                   1709-1710   ///
      str    CPTM2_6                   1711-1712   ///
      str    CPTM2_7                   1713-1714   ///
      str    CPTM2_8                   1715-1716   ///
      str    CPTM2_9                   1717-1718   ///
      str    CPTM2_10                  1719-1720   ///
      str    CPTM2_11                  1721-1722   ///
      str    CPTM2_12                  1723-1724   ///
      str    CPTM2_13                  1725-1726   ///
      str    CPTM2_14                  1727-1728   ///
      str    CPTM2_15                  1729-1730   ///
      str    CPTM2_16                  1731-1732   ///
      str    CPTM2_17                  1733-1734   ///
      str    CPTM2_18                  1735-1736   ///
      str    CPTM2_19                  1737-1738   ///
      str    CPTM2_20                  1739-1740   ///
      str    CPTM2_21                  1741-1742   ///
      str    CPTM2_22                  1743-1744   ///
      str    CPTM2_23                  1745-1746   ///
      str    CPTM2_24                  1747-1748   ///
      str    CPTM2_25                  1749-1750   ///
      str    CPTM2_26                  1751-1752   ///
      str    CPTM2_27                  1753-1754   ///
      str    CPTM2_28                  1755-1756   ///
      str    CPTM2_29                  1757-1758   ///
      str    CPTM2_30                  1759-1760   ///
      str    CPTM2_31                  1761-1762   ///
      str    CPTM2_32                  1763-1764   ///
      str    CPTM2_33                  1765-1766   ///
      str    CPTM2_34                  1767-1768   ///
      str    CPTM2_35                  1769-1770   ///
      str    CPTM2_36                  1771-1772   ///
      str    CPTM2_37                  1773-1774   ///
      str    CPTM2_38                  1775-1776   ///
      str    CPTM2_39                  1777-1778   ///
      str    CPTM2_40                  1779-1780   ///
      str    CPTM2_41                  1781-1782   ///
      str    CPTM2_42                  1783-1784   ///
      str    CPTM2_43                  1785-1786   ///
      str    CPTM2_44                  1787-1788   ///
      str    CPTM2_45                  1789-1790   ///
      str    CPTM2_46                  1791-1792   ///
      str    CPTM2_47                  1793-1794   ///
      str    CPTM2_48                  1795-1796   ///
      str    CPTM2_49                  1797-1798   ///
      str    CPTM2_50                  1799-1800   ///
      str    CPTM2_51                  1801-1802   ///
      str    CPTM2_52                  1803-1804   ///
      str    CPTM2_53                  1805-1806   ///
      str    CPTM2_54                  1807-1808   ///
      str    CPTM2_55                  1809-1810   ///
      str    CPTM2_56                  1811-1812   ///
      str    CPTM2_57                  1813-1814   ///
      str    CPTM2_58                  1815-1816   ///
      str    CPTM2_59                  1817-1818   ///
      str    CPTM2_60                  1819-1820   ///
      str    CPTM2_61                  1821-1822   ///
      str    CPTM2_62                  1823-1824   ///
      str    CPTM2_63                  1825-1826   ///
      str    CPTM2_64                  1827-1828   ///
      str    CPTM2_65                  1829-1830   ///
      str    CPTM2_66                  1831-1832   ///
      str    CPTM2_67                  1833-1834   ///
      str    CPTM2_68                  1835-1836   ///
      str    CPTM2_69                  1837-1838   ///
      str    CPTM2_70                  1839-1840   ///
      str    CPTM2_71                  1841-1842   ///
      str    CPTM2_72                  1843-1844   ///
      str    CPTM2_73                  1845-1846   ///
      str    CPTM2_74                  1847-1848   ///
      str    CPTM2_75                  1849-1850   ///
      str    CPTM2_76                  1851-1852   ///
      str    CPTM2_77                  1853-1854   ///
      str    CPTM2_78                  1855-1856   ///
      str    CPTM2_79                  1857-1858   ///
      str    CPTM2_80                  1859-1860   ///
      str    CPTM2_81                  1861-1862   ///
      str    CPTM2_82                  1863-1864   ///
      str    CPTM2_83                  1865-1866   ///
      str    CPTM2_84                  1867-1868   ///
      str    CPTM2_85                  1869-1870   ///
      str    CPTM2_86                  1871-1872   ///
      str    CPTM2_87                  1873-1874   ///
      str    CPTM2_88                  1875-1876   ///
      str    CPTM2_89                  1877-1878   ///
      str    CPTM2_90                  1879-1880   ///
      str    CPTM2_91                  1881-1882   ///
      str    CPTM2_92                  1883-1884   ///
      str    CPTM2_93                  1885-1886   ///
      str    CPTM2_94                  1887-1888   ///
      str    CPTM2_95                  1889-1890   ///
      str    CPTM2_96                  1891-1892   ///
      str    CPTM2_97                  1893-1894   ///
      str    CPTM2_98                  1895-1896   ///
      str    CPTM2_99                  1897-1898   ///
      str    CPTM2_100                 1899-1900   ///
      str    CPTM2_101                 1901-1902   ///
      str    CPTM2_102                 1903-1904   ///
      str    CPTM2_103                 1905-1906   ///
      str    CPTM2_104                 1907-1908   ///
      str    CPTM2_105                 1909-1910   ///
      str    CPTM2_106                 1911-1912   ///
      str    CPTM2_107                 1913-1914   ///
      str    CPTM2_108                 1915-1916   ///
      str    CPTM2_109                 1917-1918   ///
      str    CPTM2_110                 1919-1920   ///
      str    CPTM2_111                 1921-1922   ///
      str    CPTM2_112                 1923-1924   ///
      str    CPTM2_113                 1925-1926   ///
      str    CPTM2_114                 1927-1928   ///
      str    CPTM2_115                 1929-1930   ///
      str    CPTM2_116                 1931-1932   ///
      str    CPTM2_117                 1933-1934   ///
      str    CPTM2_118                 1935-1936   ///
      str    CPTM2_119                 1937-1938   ///
      str    CPTM2_120                 1939-1940   ///
      str    CPTM2_121                 1941-1942   ///
      str    CPTM2_122                 1943-1944   ///
      str    CPTM2_123                 1945-1946   ///
      str    CPTM2_124                 1947-1948   ///
      str    CPTM2_125                 1949-1950   ///
      str    CPTM2_126                 1951-1952   ///
      str    CPTM2_127                 1953-1954   ///
      str    CPTM2_128                 1955-1956   ///
      str    CPTM2_129                 1957-1958   ///
      int    DHOUR                     1959-1962   ///
      byte   DIED                      1963-1964   ///
      str    DISP_X                    1965-1966   ///
      byte   DISPUB04                  1967-1968   ///
      byte   DISPUNIFORM               1969-1970   ///
      byte   DMONTH                    1971-1972   ///
      byte   DQTR                      1973-1974   ///
      long   DURATION                  1975-1980   ///
      byte   FEMALE                    1981-1982   ///
      byte   HCUP_ED                   1983-1984   ///
      byte   HCUP_OS                   1985-1986   ///
      long   HCUP_SURGERY_BROAD_CPT    1987-1991   ///
      long   HCUP_SURGERY_NARROW_CPT   1992-1996   ///
      str    HOSPST                    1997-1998   ///
      str    I10_DX_Visit_Reason1      1999-2005   ///
      str    I10_DX_Visit_Reason2      2006-2012   ///
      str    I10_DX_Visit_Reason3      2013-2019   ///
      str    I10_DX1                   2020-2026   ///
      str    I10_DX2                   2027-2033   ///
      str    I10_DX3                   2034-2040   ///
      str    I10_DX4                   2041-2047   ///
      str    I10_DX5                   2048-2054   ///
      str    I10_DX6                   2055-2061   ///
      str    I10_DX7                   2062-2068   ///
      str    I10_DX8                   2069-2075   ///
      str    I10_DX9                   2076-2082   ///
      str    I10_DX10                  2083-2089   ///
      str    I10_DX11                  2090-2096   ///
      str    I10_DX12                  2097-2103   ///
      str    I10_DX13                  2104-2110   ///
      str    I10_DX14                  2111-2117   ///
      str    I10_DX15                  2118-2124   ///
      str    I10_DX16                  2125-2131   ///
      str    I10_DX17                  2132-2138   ///
      str    I10_DX18                  2139-2145   ///
      str    I10_DX19                  2146-2152   ///
      str    I10_DX20                  2153-2159   ///
      str    I10_DX21                  2160-2166   ///
      str    I10_DX22                  2167-2173   ///
      str    I10_DX23                  2174-2180   ///
      str    I10_DX24                  2181-2187   ///
      str    I10_DX25                  2188-2194   ///
      str    I10_DX26                  2195-2201   ///
      str    I10_DX27                  2202-2208   ///
      str    I10_DX28                  2209-2215   ///
      str    I10_DX29                  2216-2222   ///
      str    I10_DX30                  2223-2229   ///
      str    I10_DX31                  2230-2236   ///
      str    I10_DX32                  2237-2243   ///
      str    I10_DX33                  2244-2250   ///
      str    I10_DX34                  2251-2257   ///
      str    I10_DX35                  2258-2264   ///
      int    I10_NDX                   2265-2267   ///
      int    I10_PROCTYPE              2268-2270   ///
      double KEY                       2271-2285   ///
      long   LOS                       2286-2290   ///
      long   LOS_X                     2291-2296   ///
      long   MDNUM1_R                  2297-2305   ///
      long   MDNUM2_R                  2306-2314   ///
      byte   MEDINCSTQ                 2315-2316   ///
      int    NCPT                      2317-2320   ///
      double OS_TIME                   2321-2331   ///
      byte   PAY1                      2332-2333   ///
      str    PAY1_X                    2334-2337   ///
      byte   PAY2                      2338-2339   ///
      str    PAY2_X                    2340-2343   ///
      int    PL_CBSA                   2344-2346   ///
      byte   PL_NCHS                   2347-2348   ///
      byte   PL_RUCC                   2349-2350   ///
      byte   PL_UIC                    2351-2352   ///
      byte   PL_UR_CAT4                2353-2354   ///
      str    PointOfOrigin_X           2355        ///
      str    PointOfOriginUB04         2356        ///
      str    PSTATE                    2357-2358   ///
      str    PSTATE_GEO                2359-2360   ///
      long   PSTCO                     2361-2365   ///
      long   PSTCO_GEO                 2366-2370   ///
      byte   RACE                      2371-2372   ///
      float  RACE_PCT_MISS_HOSP        2373-2379   ///
      str    RACE_X                    2380        ///
      byte   SASD_SEDD                 2381-2382   ///
      byte   STATE_AS                  2383-2384   ///
      byte   STATE_ED                  2385-2386   ///
      byte   STATE_OS                  2387-2388   ///
      double TOTCHG                    2389-2398   ///
      double TOTCHG_X                  2399-2413   ///
      int    YEAR                      2414-2417   ///
      str    ZIP                       2418-2422   ///
      str    ZIP3                      2423-2425   ///
      int    ZIPINC_QRTL               2426-2428   ///
      long   HOSPID                    2429-2433   ///
      int    AYEAR                     2434-2437   ///
      byte   BMONTH                    2438-2439   ///
      int    BYEAR                     2440-2443   ///
      using  "DC_SASD_2022_CORE.asc"

/***  Assign labels to the data elements ***/
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AHOUR                    "Admission Hour"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BILLTYPE                 "Type of bill, UB-04 coding"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPT7                     "CPT/HCPCS procedure code 7"
label var CPT8                     "CPT/HCPCS procedure code 8"
label var CPT9                     "CPT/HCPCS procedure code 9"
label var CPT10                    "CPT/HCPCS procedure code 10"
label var CPT11                    "CPT/HCPCS procedure code 11"
label var CPT12                    "CPT/HCPCS procedure code 12"
label var CPT13                    "CPT/HCPCS procedure code 13"
label var CPT14                    "CPT/HCPCS procedure code 14"
label var CPT15                    "CPT/HCPCS procedure code 15"
label var CPT16                    "CPT/HCPCS procedure code 16"
label var CPT17                    "CPT/HCPCS procedure code 17"
label var CPT18                    "CPT/HCPCS procedure code 18"
label var CPT19                    "CPT/HCPCS procedure code 19"
label var CPT20                    "CPT/HCPCS procedure code 20"
label var CPT21                    "CPT/HCPCS procedure code 21"
label var CPT22                    "CPT/HCPCS procedure code 22"
label var CPT23                    "CPT/HCPCS procedure code 23"
label var CPT24                    "CPT/HCPCS procedure code 24"
label var CPT25                    "CPT/HCPCS procedure code 25"
label var CPT26                    "CPT/HCPCS procedure code 26"
label var CPT27                    "CPT/HCPCS procedure code 27"
label var CPT28                    "CPT/HCPCS procedure code 28"
label var CPT29                    "CPT/HCPCS procedure code 29"
label var CPT30                    "CPT/HCPCS procedure code 30"
label var CPT31                    "CPT/HCPCS procedure code 31"
label var CPT32                    "CPT/HCPCS procedure code 32"
label var CPT33                    "CPT/HCPCS procedure code 33"
label var CPT34                    "CPT/HCPCS procedure code 34"
label var CPT35                    "CPT/HCPCS procedure code 35"
label var CPT36                    "CPT/HCPCS procedure code 36"
label var CPT37                    "CPT/HCPCS procedure code 37"
label var CPT38                    "CPT/HCPCS procedure code 38"
label var CPT39                    "CPT/HCPCS procedure code 39"
label var CPT40                    "CPT/HCPCS procedure code 40"
label var CPT41                    "CPT/HCPCS procedure code 41"
label var CPT42                    "CPT/HCPCS procedure code 42"
label var CPT43                    "CPT/HCPCS procedure code 43"
label var CPT44                    "CPT/HCPCS procedure code 44"
label var CPT45                    "CPT/HCPCS procedure code 45"
label var CPT46                    "CPT/HCPCS procedure code 46"
label var CPT47                    "CPT/HCPCS procedure code 47"
label var CPT48                    "CPT/HCPCS procedure code 48"
label var CPT49                    "CPT/HCPCS procedure code 49"
label var CPT50                    "CPT/HCPCS procedure code 50"
label var CPT51                    "CPT/HCPCS procedure code 51"
label var CPT52                    "CPT/HCPCS procedure code 52"
label var CPT53                    "CPT/HCPCS procedure code 53"
label var CPT54                    "CPT/HCPCS procedure code 54"
label var CPT55                    "CPT/HCPCS procedure code 55"
label var CPT56                    "CPT/HCPCS procedure code 56"
label var CPT57                    "CPT/HCPCS procedure code 57"
label var CPT58                    "CPT/HCPCS procedure code 58"
label var CPT59                    "CPT/HCPCS procedure code 59"
label var CPT60                    "CPT/HCPCS procedure code 60"
label var CPT61                    "CPT/HCPCS procedure code 61"
label var CPT62                    "CPT/HCPCS procedure code 62"
label var CPT63                    "CPT/HCPCS procedure code 63"
label var CPT64                    "CPT/HCPCS procedure code 64"
label var CPT65                    "CPT/HCPCS procedure code 65"
label var CPT66                    "CPT/HCPCS procedure code 66"
label var CPT67                    "CPT/HCPCS procedure code 67"
label var CPT68                    "CPT/HCPCS procedure code 68"
label var CPT69                    "CPT/HCPCS procedure code 69"
label var CPT70                    "CPT/HCPCS procedure code 70"
label var CPT71                    "CPT/HCPCS procedure code 71"
label var CPT72                    "CPT/HCPCS procedure code 72"
label var CPT73                    "CPT/HCPCS procedure code 73"
label var CPT74                    "CPT/HCPCS procedure code 74"
label var CPT75                    "CPT/HCPCS procedure code 75"
label var CPT76                    "CPT/HCPCS procedure code 76"
label var CPT77                    "CPT/HCPCS procedure code 77"
label var CPT78                    "CPT/HCPCS procedure code 78"
label var CPT79                    "CPT/HCPCS procedure code 79"
label var CPT80                    "CPT/HCPCS procedure code 80"
label var CPT81                    "CPT/HCPCS procedure code 81"
label var CPT82                    "CPT/HCPCS procedure code 82"
label var CPT83                    "CPT/HCPCS procedure code 83"
label var CPT84                    "CPT/HCPCS procedure code 84"
label var CPT85                    "CPT/HCPCS procedure code 85"
label var CPT86                    "CPT/HCPCS procedure code 86"
label var CPT87                    "CPT/HCPCS procedure code 87"
label var CPT88                    "CPT/HCPCS procedure code 88"
label var CPT89                    "CPT/HCPCS procedure code 89"
label var CPT90                    "CPT/HCPCS procedure code 90"
label var CPT91                    "CPT/HCPCS procedure code 91"
label var CPT92                    "CPT/HCPCS procedure code 92"
label var CPT93                    "CPT/HCPCS procedure code 93"
label var CPT94                    "CPT/HCPCS procedure code 94"
label var CPT95                    "CPT/HCPCS procedure code 95"
label var CPT96                    "CPT/HCPCS procedure code 96"
label var CPT97                    "CPT/HCPCS procedure code 97"
label var CPT98                    "CPT/HCPCS procedure code 98"
label var CPT99                    "CPT/HCPCS procedure code 99"
label var CPT100                   "CPT/HCPCS procedure code 100"
label var CPT101                   "CPT/HCPCS procedure code 101"
label var CPT102                   "CPT/HCPCS procedure code 102"
label var CPT103                   "CPT/HCPCS procedure code 103"
label var CPT104                   "CPT/HCPCS procedure code 104"
label var CPT105                   "CPT/HCPCS procedure code 105"
label var CPT106                   "CPT/HCPCS procedure code 106"
label var CPT107                   "CPT/HCPCS procedure code 107"
label var CPT108                   "CPT/HCPCS procedure code 108"
label var CPT109                   "CPT/HCPCS procedure code 109"
label var CPT110                   "CPT/HCPCS procedure code 110"
label var CPT111                   "CPT/HCPCS procedure code 111"
label var CPT112                   "CPT/HCPCS procedure code 112"
label var CPT113                   "CPT/HCPCS procedure code 113"
label var CPT114                   "CPT/HCPCS procedure code 114"
label var CPT115                   "CPT/HCPCS procedure code 115"
label var CPT116                   "CPT/HCPCS procedure code 116"
label var CPT117                   "CPT/HCPCS procedure code 117"
label var CPT118                   "CPT/HCPCS procedure code 118"
label var CPT119                   "CPT/HCPCS procedure code 119"
label var CPT120                   "CPT/HCPCS procedure code 120"
label var CPT121                   "CPT/HCPCS procedure code 121"
label var CPT122                   "CPT/HCPCS procedure code 122"
label var CPT123                   "CPT/HCPCS procedure code 123"
label var CPT124                   "CPT/HCPCS procedure code 124"
label var CPT125                   "CPT/HCPCS procedure code 125"
label var CPT126                   "CPT/HCPCS procedure code 126"
label var CPT127                   "CPT/HCPCS procedure code 127"
label var CPT128                   "CPT/HCPCS procedure code 128"
label var CPT129                   "CPT/HCPCS procedure code 129"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTCCS7                  "CCS: CPT 7"
label var CPTCCS8                  "CCS: CPT 8"
label var CPTCCS9                  "CCS: CPT 9"
label var CPTCCS10                 "CCS: CPT 10"
label var CPTCCS11                 "CCS: CPT 11"
label var CPTCCS12                 "CCS: CPT 12"
label var CPTCCS13                 "CCS: CPT 13"
label var CPTCCS14                 "CCS: CPT 14"
label var CPTCCS15                 "CCS: CPT 15"
label var CPTCCS16                 "CCS: CPT 16"
label var CPTCCS17                 "CCS: CPT 17"
label var CPTCCS18                 "CCS: CPT 18"
label var CPTCCS19                 "CCS: CPT 19"
label var CPTCCS20                 "CCS: CPT 20"
label var CPTCCS21                 "CCS: CPT 21"
label var CPTCCS22                 "CCS: CPT 22"
label var CPTCCS23                 "CCS: CPT 23"
label var CPTCCS24                 "CCS: CPT 24"
label var CPTCCS25                 "CCS: CPT 25"
label var CPTCCS26                 "CCS: CPT 26"
label var CPTCCS27                 "CCS: CPT 27"
label var CPTCCS28                 "CCS: CPT 28"
label var CPTCCS29                 "CCS: CPT 29"
label var CPTCCS30                 "CCS: CPT 30"
label var CPTCCS31                 "CCS: CPT 31"
label var CPTCCS32                 "CCS: CPT 32"
label var CPTCCS33                 "CCS: CPT 33"
label var CPTCCS34                 "CCS: CPT 34"
label var CPTCCS35                 "CCS: CPT 35"
label var CPTCCS36                 "CCS: CPT 36"
label var CPTCCS37                 "CCS: CPT 37"
label var CPTCCS38                 "CCS: CPT 38"
label var CPTCCS39                 "CCS: CPT 39"
label var CPTCCS40                 "CCS: CPT 40"
label var CPTCCS41                 "CCS: CPT 41"
label var CPTCCS42                 "CCS: CPT 42"
label var CPTCCS43                 "CCS: CPT 43"
label var CPTCCS44                 "CCS: CPT 44"
label var CPTCCS45                 "CCS: CPT 45"
label var CPTCCS46                 "CCS: CPT 46"
label var CPTCCS47                 "CCS: CPT 47"
label var CPTCCS48                 "CCS: CPT 48"
label var CPTCCS49                 "CCS: CPT 49"
label var CPTCCS50                 "CCS: CPT 50"
label var CPTCCS51                 "CCS: CPT 51"
label var CPTCCS52                 "CCS: CPT 52"
label var CPTCCS53                 "CCS: CPT 53"
label var CPTCCS54                 "CCS: CPT 54"
label var CPTCCS55                 "CCS: CPT 55"
label var CPTCCS56                 "CCS: CPT 56"
label var CPTCCS57                 "CCS: CPT 57"
label var CPTCCS58                 "CCS: CPT 58"
label var CPTCCS59                 "CCS: CPT 59"
label var CPTCCS60                 "CCS: CPT 60"
label var CPTCCS61                 "CCS: CPT 61"
label var CPTCCS62                 "CCS: CPT 62"
label var CPTCCS63                 "CCS: CPT 63"
label var CPTCCS64                 "CCS: CPT 64"
label var CPTCCS65                 "CCS: CPT 65"
label var CPTCCS66                 "CCS: CPT 66"
label var CPTCCS67                 "CCS: CPT 67"
label var CPTCCS68                 "CCS: CPT 68"
label var CPTCCS69                 "CCS: CPT 69"
label var CPTCCS70                 "CCS: CPT 70"
label var CPTCCS71                 "CCS: CPT 71"
label var CPTCCS72                 "CCS: CPT 72"
label var CPTCCS73                 "CCS: CPT 73"
label var CPTCCS74                 "CCS: CPT 74"
label var CPTCCS75                 "CCS: CPT 75"
label var CPTCCS76                 "CCS: CPT 76"
label var CPTCCS77                 "CCS: CPT 77"
label var CPTCCS78                 "CCS: CPT 78"
label var CPTCCS79                 "CCS: CPT 79"
label var CPTCCS80                 "CCS: CPT 80"
label var CPTCCS81                 "CCS: CPT 81"
label var CPTCCS82                 "CCS: CPT 82"
label var CPTCCS83                 "CCS: CPT 83"
label var CPTCCS84                 "CCS: CPT 84"
label var CPTCCS85                 "CCS: CPT 85"
label var CPTCCS86                 "CCS: CPT 86"
label var CPTCCS87                 "CCS: CPT 87"
label var CPTCCS88                 "CCS: CPT 88"
label var CPTCCS89                 "CCS: CPT 89"
label var CPTCCS90                 "CCS: CPT 90"
label var CPTCCS91                 "CCS: CPT 91"
label var CPTCCS92                 "CCS: CPT 92"
label var CPTCCS93                 "CCS: CPT 93"
label var CPTCCS94                 "CCS: CPT 94"
label var CPTCCS95                 "CCS: CPT 95"
label var CPTCCS96                 "CCS: CPT 96"
label var CPTCCS97                 "CCS: CPT 97"
label var CPTCCS98                 "CCS: CPT 98"
label var CPTCCS99                 "CCS: CPT 99"
label var CPTCCS100                "CCS: CPT 100"
label var CPTCCS101                "CCS: CPT 101"
label var CPTCCS102                "CCS: CPT 102"
label var CPTCCS103                "CCS: CPT 103"
label var CPTCCS104                "CCS: CPT 104"
label var CPTCCS105                "CCS: CPT 105"
label var CPTCCS106                "CCS: CPT 106"
label var CPTCCS107                "CCS: CPT 107"
label var CPTCCS108                "CCS: CPT 108"
label var CPTCCS109                "CCS: CPT 109"
label var CPTCCS110                "CCS: CPT 110"
label var CPTCCS111                "CCS: CPT 111"
label var CPTCCS112                "CCS: CPT 112"
label var CPTCCS113                "CCS: CPT 113"
label var CPTCCS114                "CCS: CPT 114"
label var CPTCCS115                "CCS: CPT 115"
label var CPTCCS116                "CCS: CPT 116"
label var CPTCCS117                "CCS: CPT 117"
label var CPTCCS118                "CCS: CPT 118"
label var CPTCCS119                "CCS: CPT 119"
label var CPTCCS120                "CCS: CPT 120"
label var CPTCCS121                "CCS: CPT 121"
label var CPTCCS122                "CCS: CPT 122"
label var CPTCCS123                "CCS: CPT 123"
label var CPTCCS124                "CCS: CPT 124"
label var CPTCCS125                "CCS: CPT 125"
label var CPTCCS126                "CCS: CPT 126"
label var CPTCCS127                "CCS: CPT 127"
label var CPTCCS128                "CCS: CPT 128"
label var CPTCCS129                "CCS: CPT 129"
label var CPTDAY1                  "Number of days from admission to CPT1"
label var CPTDAY2                  "Number of days from admission to CPT2"
label var CPTDAY3                  "Number of days from admission to CPT3"
label var CPTDAY4                  "Number of days from admission to CPT4"
label var CPTDAY5                  "Number of days from admission to CPT5"
label var CPTDAY6                  "Number of days from admission to CPT6"
label var CPTDAY7                  "Number of days from admission to CPT7"
label var CPTDAY8                  "Number of days from admission to CPT8"
label var CPTDAY9                  "Number of days from admission to CPT9"
label var CPTDAY10                 "Number of days from admission to CPT10"
label var CPTDAY11                 "Number of days from admission to CPT11"
label var CPTDAY12                 "Number of days from admission to CPT12"
label var CPTDAY13                 "Number of days from admission to CPT13"
label var CPTDAY14                 "Number of days from admission to CPT14"
label var CPTDAY15                 "Number of days from admission to CPT15"
label var CPTDAY16                 "Number of days from admission to CPT16"
label var CPTDAY17                 "Number of days from admission to CPT17"
label var CPTDAY18                 "Number of days from admission to CPT18"
label var CPTDAY19                 "Number of days from admission to CPT19"
label var CPTDAY20                 "Number of days from admission to CPT20"
label var CPTDAY21                 "Number of days from admission to CPT21"
label var CPTDAY22                 "Number of days from admission to CPT22"
label var CPTDAY23                 "Number of days from admission to CPT23"
label var CPTDAY24                 "Number of days from admission to CPT24"
label var CPTDAY25                 "Number of days from admission to CPT25"
label var CPTDAY26                 "Number of days from admission to CPT26"
label var CPTDAY27                 "Number of days from admission to CPT27"
label var CPTDAY28                 "Number of days from admission to CPT28"
label var CPTDAY29                 "Number of days from admission to CPT29"
label var CPTDAY30                 "Number of days from admission to CPT30"
label var CPTDAY31                 "Number of days from admission to CPT31"
label var CPTDAY32                 "Number of days from admission to CPT32"
label var CPTDAY33                 "Number of days from admission to CPT33"
label var CPTDAY34                 "Number of days from admission to CPT34"
label var CPTDAY35                 "Number of days from admission to CPT35"
label var CPTDAY36                 "Number of days from admission to CPT36"
label var CPTDAY37                 "Number of days from admission to CPT37"
label var CPTDAY38                 "Number of days from admission to CPT38"
label var CPTDAY39                 "Number of days from admission to CPT39"
label var CPTDAY40                 "Number of days from admission to CPT40"
label var CPTDAY41                 "Number of days from admission to CPT41"
label var CPTDAY42                 "Number of days from admission to CPT42"
label var CPTDAY43                 "Number of days from admission to CPT43"
label var CPTDAY44                 "Number of days from admission to CPT44"
label var CPTDAY45                 "Number of days from admission to CPT45"
label var CPTDAY46                 "Number of days from admission to CPT46"
label var CPTDAY47                 "Number of days from admission to CPT47"
label var CPTDAY48                 "Number of days from admission to CPT48"
label var CPTDAY49                 "Number of days from admission to CPT49"
label var CPTDAY50                 "Number of days from admission to CPT50"
label var CPTDAY51                 "Number of days from admission to CPT51"
label var CPTDAY52                 "Number of days from admission to CPT52"
label var CPTDAY53                 "Number of days from admission to CPT53"
label var CPTDAY54                 "Number of days from admission to CPT54"
label var CPTDAY55                 "Number of days from admission to CPT55"
label var CPTDAY56                 "Number of days from admission to CPT56"
label var CPTDAY57                 "Number of days from admission to CPT57"
label var CPTDAY58                 "Number of days from admission to CPT58"
label var CPTDAY59                 "Number of days from admission to CPT59"
label var CPTDAY60                 "Number of days from admission to CPT60"
label var CPTDAY61                 "Number of days from admission to CPT61"
label var CPTDAY62                 "Number of days from admission to CPT62"
label var CPTDAY63                 "Number of days from admission to CPT63"
label var CPTDAY64                 "Number of days from admission to CPT64"
label var CPTDAY65                 "Number of days from admission to CPT65"
label var CPTDAY66                 "Number of days from admission to CPT66"
label var CPTDAY67                 "Number of days from admission to CPT67"
label var CPTDAY68                 "Number of days from admission to CPT68"
label var CPTDAY69                 "Number of days from admission to CPT69"
label var CPTDAY70                 "Number of days from admission to CPT70"
label var CPTDAY71                 "Number of days from admission to CPT71"
label var CPTDAY72                 "Number of days from admission to CPT72"
label var CPTDAY73                 "Number of days from admission to CPT73"
label var CPTDAY74                 "Number of days from admission to CPT74"
label var CPTDAY75                 "Number of days from admission to CPT75"
label var CPTDAY76                 "Number of days from admission to CPT76"
label var CPTDAY77                 "Number of days from admission to CPT77"
label var CPTDAY78                 "Number of days from admission to CPT78"
label var CPTDAY79                 "Number of days from admission to CPT79"
label var CPTDAY80                 "Number of days from admission to CPT80"
label var CPTDAY81                 "Number of days from admission to CPT81"
label var CPTDAY82                 "Number of days from admission to CPT82"
label var CPTDAY83                 "Number of days from admission to CPT83"
label var CPTDAY84                 "Number of days from admission to CPT84"
label var CPTDAY85                 "Number of days from admission to CPT85"
label var CPTDAY86                 "Number of days from admission to CPT86"
label var CPTDAY87                 "Number of days from admission to CPT87"
label var CPTDAY88                 "Number of days from admission to CPT88"
label var CPTDAY89                 "Number of days from admission to CPT89"
label var CPTDAY90                 "Number of days from admission to CPT90"
label var CPTDAY91                 "Number of days from admission to CPT91"
label var CPTDAY92                 "Number of days from admission to CPT92"
label var CPTDAY93                 "Number of days from admission to CPT93"
label var CPTDAY94                 "Number of days from admission to CPT94"
label var CPTDAY95                 "Number of days from admission to CPT95"
label var CPTDAY96                 "Number of days from admission to CPT96"
label var CPTDAY97                 "Number of days from admission to CPT97"
label var CPTDAY98                 "Number of days from admission to CPT98"
label var CPTDAY99                 "Number of days from admission to CPT99"
label var CPTDAY100                "Number of days from admission to CPT100"
label var CPTDAY101                "Number of days from admission to CPT101"
label var CPTDAY102                "Number of days from admission to CPT102"
label var CPTDAY103                "Number of days from admission to CPT103"
label var CPTDAY104                "Number of days from admission to CPT104"
label var CPTDAY105                "Number of days from admission to CPT105"
label var CPTDAY106                "Number of days from admission to CPT106"
label var CPTDAY107                "Number of days from admission to CPT107"
label var CPTDAY108                "Number of days from admission to CPT108"
label var CPTDAY109                "Number of days from admission to CPT109"
label var CPTDAY110                "Number of days from admission to CPT110"
label var CPTDAY111                "Number of days from admission to CPT111"
label var CPTDAY112                "Number of days from admission to CPT112"
label var CPTDAY113                "Number of days from admission to CPT113"
label var CPTDAY114                "Number of days from admission to CPT114"
label var CPTDAY115                "Number of days from admission to CPT115"
label var CPTDAY116                "Number of days from admission to CPT116"
label var CPTDAY117                "Number of days from admission to CPT117"
label var CPTDAY118                "Number of days from admission to CPT118"
label var CPTDAY119                "Number of days from admission to CPT119"
label var CPTDAY120                "Number of days from admission to CPT120"
label var CPTDAY121                "Number of days from admission to CPT121"
label var CPTDAY122                "Number of days from admission to CPT122"
label var CPTDAY123                "Number of days from admission to CPT123"
label var CPTDAY124                "Number of days from admission to CPT124"
label var CPTDAY125                "Number of days from admission to CPT125"
label var CPTDAY126                "Number of days from admission to CPT126"
label var CPTDAY127                "Number of days from admission to CPT127"
label var CPTDAY128                "Number of days from admission to CPT128"
label var CPTDAY129                "Number of days from admission to CPT129"
label var CPTM1_1                  "First CPT-4/HCPCS modifier 1"
label var CPTM1_2                  "First CPT-4/HCPCS modifier 2"
label var CPTM1_3                  "First CPT-4/HCPCS modifier 3"
label var CPTM1_4                  "First CPT-4/HCPCS modifier 4"
label var CPTM1_5                  "First CPT-4/HCPCS modifier 5"
label var CPTM1_6                  "First CPT-4/HCPCS modifier 6"
label var CPTM1_7                  "First CPT-4/HCPCS modifier 7"
label var CPTM1_8                  "First CPT-4/HCPCS modifier 8"
label var CPTM1_9                  "First CPT-4/HCPCS modifier 9"
label var CPTM1_10                 "First CPT-4/HCPCS modifier 10"
label var CPTM1_11                 "First CPT-4/HCPCS modifier 11"
label var CPTM1_12                 "First CPT-4/HCPCS modifier 12"
label var CPTM1_13                 "First CPT-4/HCPCS modifier 13"
label var CPTM1_14                 "First CPT-4/HCPCS modifier 14"
label var CPTM1_15                 "First CPT-4/HCPCS modifier 15"
label var CPTM1_16                 "First CPT-4/HCPCS modifier 16"
label var CPTM1_17                 "First CPT-4/HCPCS modifier 17"
label var CPTM1_18                 "First CPT-4/HCPCS modifier 18"
label var CPTM1_19                 "First CPT-4/HCPCS modifier 19"
label var CPTM1_20                 "First CPT-4/HCPCS modifier 20"
label var CPTM1_21                 "First CPT-4/HCPCS modifier 21"
label var CPTM1_22                 "First CPT-4/HCPCS modifier 22"
label var CPTM1_23                 "First CPT-4/HCPCS modifier 23"
label var CPTM1_24                 "First CPT-4/HCPCS modifier 24"
label var CPTM1_25                 "First CPT-4/HCPCS modifier 25"
label var CPTM1_26                 "First CPT-4/HCPCS modifier 26"
label var CPTM1_27                 "First CPT-4/HCPCS modifier 27"
label var CPTM1_28                 "First CPT-4/HCPCS modifier 28"
label var CPTM1_29                 "First CPT-4/HCPCS modifier 29"
label var CPTM1_30                 "First CPT-4/HCPCS modifier 30"
label var CPTM1_31                 "First CPT-4/HCPCS modifier 31"
label var CPTM1_32                 "First CPT-4/HCPCS modifier 32"
label var CPTM1_33                 "First CPT-4/HCPCS modifier 33"
label var CPTM1_34                 "First CPT-4/HCPCS modifier 34"
label var CPTM1_35                 "First CPT-4/HCPCS modifier 35"
label var CPTM1_36                 "First CPT-4/HCPCS modifier 36"
label var CPTM1_37                 "First CPT-4/HCPCS modifier 37"
label var CPTM1_38                 "First CPT-4/HCPCS modifier 38"
label var CPTM1_39                 "First CPT-4/HCPCS modifier 39"
label var CPTM1_40                 "First CPT-4/HCPCS modifier 40"
label var CPTM1_41                 "First CPT-4/HCPCS modifier 41"
label var CPTM1_42                 "First CPT-4/HCPCS modifier 42"
label var CPTM1_43                 "First CPT-4/HCPCS modifier 43"
label var CPTM1_44                 "First CPT-4/HCPCS modifier 44"
label var CPTM1_45                 "First CPT-4/HCPCS modifier 45"
label var CPTM1_46                 "First CPT-4/HCPCS modifier 46"
label var CPTM1_47                 "First CPT-4/HCPCS modifier 47"
label var CPTM1_48                 "First CPT-4/HCPCS modifier 48"
label var CPTM1_49                 "First CPT-4/HCPCS modifier 49"
label var CPTM1_50                 "First CPT-4/HCPCS modifier 50"
label var CPTM1_51                 "First CPT-4/HCPCS modifier 51"
label var CPTM1_52                 "First CPT-4/HCPCS modifier 52"
label var CPTM1_53                 "First CPT-4/HCPCS modifier 53"
label var CPTM1_54                 "First CPT-4/HCPCS modifier 54"
label var CPTM1_55                 "First CPT-4/HCPCS modifier 55"
label var CPTM1_56                 "First CPT-4/HCPCS modifier 56"
label var CPTM1_57                 "First CPT-4/HCPCS modifier 57"
label var CPTM1_58                 "First CPT-4/HCPCS modifier 58"
label var CPTM1_59                 "First CPT-4/HCPCS modifier 59"
label var CPTM1_60                 "First CPT-4/HCPCS modifier 60"
label var CPTM1_61                 "First CPT-4/HCPCS modifier 61"
label var CPTM1_62                 "First CPT-4/HCPCS modifier 62"
label var CPTM1_63                 "First CPT-4/HCPCS modifier 63"
label var CPTM1_64                 "First CPT-4/HCPCS modifier 64"
label var CPTM1_65                 "First CPT-4/HCPCS modifier 65"
label var CPTM1_66                 "First CPT-4/HCPCS modifier 66"
label var CPTM1_67                 "First CPT-4/HCPCS modifier 67"
label var CPTM1_68                 "First CPT-4/HCPCS modifier 68"
label var CPTM1_69                 "First CPT-4/HCPCS modifier 69"
label var CPTM1_70                 "First CPT-4/HCPCS modifier 70"
label var CPTM1_71                 "First CPT-4/HCPCS modifier 71"
label var CPTM1_72                 "First CPT-4/HCPCS modifier 72"
label var CPTM1_73                 "First CPT-4/HCPCS modifier 73"
label var CPTM1_74                 "First CPT-4/HCPCS modifier 74"
label var CPTM1_75                 "First CPT-4/HCPCS modifier 75"
label var CPTM1_76                 "First CPT-4/HCPCS modifier 76"
label var CPTM1_77                 "First CPT-4/HCPCS modifier 77"
label var CPTM1_78                 "First CPT-4/HCPCS modifier 78"
label var CPTM1_79                 "First CPT-4/HCPCS modifier 79"
label var CPTM1_80                 "First CPT-4/HCPCS modifier 80"
label var CPTM1_81                 "First CPT-4/HCPCS modifier 81"
label var CPTM1_82                 "First CPT-4/HCPCS modifier 82"
label var CPTM1_83                 "First CPT-4/HCPCS modifier 83"
label var CPTM1_84                 "First CPT-4/HCPCS modifier 84"
label var CPTM1_85                 "First CPT-4/HCPCS modifier 85"
label var CPTM1_86                 "First CPT-4/HCPCS modifier 86"
label var CPTM1_87                 "First CPT-4/HCPCS modifier 87"
label var CPTM1_88                 "First CPT-4/HCPCS modifier 88"
label var CPTM1_89                 "First CPT-4/HCPCS modifier 89"
label var CPTM1_90                 "First CPT-4/HCPCS modifier 90"
label var CPTM1_91                 "First CPT-4/HCPCS modifier 91"
label var CPTM1_92                 "First CPT-4/HCPCS modifier 92"
label var CPTM1_93                 "First CPT-4/HCPCS modifier 93"
label var CPTM1_94                 "First CPT-4/HCPCS modifier 94"
label var CPTM1_95                 "First CPT-4/HCPCS modifier 95"
label var CPTM1_96                 "First CPT-4/HCPCS modifier 96"
label var CPTM1_97                 "First CPT-4/HCPCS modifier 97"
label var CPTM1_98                 "First CPT-4/HCPCS modifier 98"
label var CPTM1_99                 "First CPT-4/HCPCS modifier 99"
label var CPTM1_100                "First CPT-4/HCPCS modifier 100"
label var CPTM1_101                "First CPT-4/HCPCS modifier 101"
label var CPTM1_102                "First CPT-4/HCPCS modifier 102"
label var CPTM1_103                "First CPT-4/HCPCS modifier 103"
label var CPTM1_104                "First CPT-4/HCPCS modifier 104"
label var CPTM1_105                "First CPT-4/HCPCS modifier 105"
label var CPTM1_106                "First CPT-4/HCPCS modifier 106"
label var CPTM1_107                "First CPT-4/HCPCS modifier 107"
label var CPTM1_108                "First CPT-4/HCPCS modifier 108"
label var CPTM1_109                "First CPT-4/HCPCS modifier 109"
label var CPTM1_110                "First CPT-4/HCPCS modifier 110"
label var CPTM1_111                "First CPT-4/HCPCS modifier 111"
label var CPTM1_112                "First CPT-4/HCPCS modifier 112"
label var CPTM1_113                "First CPT-4/HCPCS modifier 113"
label var CPTM1_114                "First CPT-4/HCPCS modifier 114"
label var CPTM1_115                "First CPT-4/HCPCS modifier 115"
label var CPTM1_116                "First CPT-4/HCPCS modifier 116"
label var CPTM1_117                "First CPT-4/HCPCS modifier 117"
label var CPTM1_118                "First CPT-4/HCPCS modifier 118"
label var CPTM1_119                "First CPT-4/HCPCS modifier 119"
label var CPTM1_120                "First CPT-4/HCPCS modifier 120"
label var CPTM1_121                "First CPT-4/HCPCS modifier 121"
label var CPTM1_122                "First CPT-4/HCPCS modifier 122"
label var CPTM1_123                "First CPT-4/HCPCS modifier 123"
label var CPTM1_124                "First CPT-4/HCPCS modifier 124"
label var CPTM1_125                "First CPT-4/HCPCS modifier 125"
label var CPTM1_126                "First CPT-4/HCPCS modifier 126"
label var CPTM1_127                "First CPT-4/HCPCS modifier 127"
label var CPTM1_128                "First CPT-4/HCPCS modifier 128"
label var CPTM1_129                "First CPT-4/HCPCS modifier 129"
label var CPTM2_1                  "Second CPT-4/HCPCS modifier 1"
label var CPTM2_2                  "Second CPT-4/HCPCS modifier 2"
label var CPTM2_3                  "Second CPT-4/HCPCS modifier 3"
label var CPTM2_4                  "Second CPT-4/HCPCS modifier 4"
label var CPTM2_5                  "Second CPT-4/HCPCS modifier 5"
label var CPTM2_6                  "Second CPT-4/HCPCS modifier 6"
label var CPTM2_7                  "Second CPT-4/HCPCS modifier 7"
label var CPTM2_8                  "Second CPT-4/HCPCS modifier 8"
label var CPTM2_9                  "Second CPT-4/HCPCS modifier 9"
label var CPTM2_10                 "Second CPT-4/HCPCS modifier 10"
label var CPTM2_11                 "Second CPT-4/HCPCS modifier 11"
label var CPTM2_12                 "Second CPT-4/HCPCS modifier 12"
label var CPTM2_13                 "Second CPT-4/HCPCS modifier 13"
label var CPTM2_14                 "Second CPT-4/HCPCS modifier 14"
label var CPTM2_15                 "Second CPT-4/HCPCS modifier 15"
label var CPTM2_16                 "Second CPT-4/HCPCS modifier 16"
label var CPTM2_17                 "Second CPT-4/HCPCS modifier 17"
label var CPTM2_18                 "Second CPT-4/HCPCS modifier 18"
label var CPTM2_19                 "Second CPT-4/HCPCS modifier 19"
label var CPTM2_20                 "Second CPT-4/HCPCS modifier 20"
label var CPTM2_21                 "Second CPT-4/HCPCS modifier 21"
label var CPTM2_22                 "Second CPT-4/HCPCS modifier 22"
label var CPTM2_23                 "Second CPT-4/HCPCS modifier 23"
label var CPTM2_24                 "Second CPT-4/HCPCS modifier 24"
label var CPTM2_25                 "Second CPT-4/HCPCS modifier 25"
label var CPTM2_26                 "Second CPT-4/HCPCS modifier 26"
label var CPTM2_27                 "Second CPT-4/HCPCS modifier 27"
label var CPTM2_28                 "Second CPT-4/HCPCS modifier 28"
label var CPTM2_29                 "Second CPT-4/HCPCS modifier 29"
label var CPTM2_30                 "Second CPT-4/HCPCS modifier 30"
label var CPTM2_31                 "Second CPT-4/HCPCS modifier 31"
label var CPTM2_32                 "Second CPT-4/HCPCS modifier 32"
label var CPTM2_33                 "Second CPT-4/HCPCS modifier 33"
label var CPTM2_34                 "Second CPT-4/HCPCS modifier 34"
label var CPTM2_35                 "Second CPT-4/HCPCS modifier 35"
label var CPTM2_36                 "Second CPT-4/HCPCS modifier 36"
label var CPTM2_37                 "Second CPT-4/HCPCS modifier 37"
label var CPTM2_38                 "Second CPT-4/HCPCS modifier 38"
label var CPTM2_39                 "Second CPT-4/HCPCS modifier 39"
label var CPTM2_40                 "Second CPT-4/HCPCS modifier 40"
label var CPTM2_41                 "Second CPT-4/HCPCS modifier 41"
label var CPTM2_42                 "Second CPT-4/HCPCS modifier 42"
label var CPTM2_43                 "Second CPT-4/HCPCS modifier 43"
label var CPTM2_44                 "Second CPT-4/HCPCS modifier 44"
label var CPTM2_45                 "Second CPT-4/HCPCS modifier 45"
label var CPTM2_46                 "Second CPT-4/HCPCS modifier 46"
label var CPTM2_47                 "Second CPT-4/HCPCS modifier 47"
label var CPTM2_48                 "Second CPT-4/HCPCS modifier 48"
label var CPTM2_49                 "Second CPT-4/HCPCS modifier 49"
label var CPTM2_50                 "Second CPT-4/HCPCS modifier 50"
label var CPTM2_51                 "Second CPT-4/HCPCS modifier 51"
label var CPTM2_52                 "Second CPT-4/HCPCS modifier 52"
label var CPTM2_53                 "Second CPT-4/HCPCS modifier 53"
label var CPTM2_54                 "Second CPT-4/HCPCS modifier 54"
label var CPTM2_55                 "Second CPT-4/HCPCS modifier 55"
label var CPTM2_56                 "Second CPT-4/HCPCS modifier 56"
label var CPTM2_57                 "Second CPT-4/HCPCS modifier 57"
label var CPTM2_58                 "Second CPT-4/HCPCS modifier 58"
label var CPTM2_59                 "Second CPT-4/HCPCS modifier 59"
label var CPTM2_60                 "Second CPT-4/HCPCS modifier 60"
label var CPTM2_61                 "Second CPT-4/HCPCS modifier 61"
label var CPTM2_62                 "Second CPT-4/HCPCS modifier 62"
label var CPTM2_63                 "Second CPT-4/HCPCS modifier 63"
label var CPTM2_64                 "Second CPT-4/HCPCS modifier 64"
label var CPTM2_65                 "Second CPT-4/HCPCS modifier 65"
label var CPTM2_66                 "Second CPT-4/HCPCS modifier 66"
label var CPTM2_67                 "Second CPT-4/HCPCS modifier 67"
label var CPTM2_68                 "Second CPT-4/HCPCS modifier 68"
label var CPTM2_69                 "Second CPT-4/HCPCS modifier 69"
label var CPTM2_70                 "Second CPT-4/HCPCS modifier 70"
label var CPTM2_71                 "Second CPT-4/HCPCS modifier 71"
label var CPTM2_72                 "Second CPT-4/HCPCS modifier 72"
label var CPTM2_73                 "Second CPT-4/HCPCS modifier 73"
label var CPTM2_74                 "Second CPT-4/HCPCS modifier 74"
label var CPTM2_75                 "Second CPT-4/HCPCS modifier 75"
label var CPTM2_76                 "Second CPT-4/HCPCS modifier 76"
label var CPTM2_77                 "Second CPT-4/HCPCS modifier 77"
label var CPTM2_78                 "Second CPT-4/HCPCS modifier 78"
label var CPTM2_79                 "Second CPT-4/HCPCS modifier 79"
label var CPTM2_80                 "Second CPT-4/HCPCS modifier 80"
label var CPTM2_81                 "Second CPT-4/HCPCS modifier 81"
label var CPTM2_82                 "Second CPT-4/HCPCS modifier 82"
label var CPTM2_83                 "Second CPT-4/HCPCS modifier 83"
label var CPTM2_84                 "Second CPT-4/HCPCS modifier 84"
label var CPTM2_85                 "Second CPT-4/HCPCS modifier 85"
label var CPTM2_86                 "Second CPT-4/HCPCS modifier 86"
label var CPTM2_87                 "Second CPT-4/HCPCS modifier 87"
label var CPTM2_88                 "Second CPT-4/HCPCS modifier 88"
label var CPTM2_89                 "Second CPT-4/HCPCS modifier 89"
label var CPTM2_90                 "Second CPT-4/HCPCS modifier 90"
label var CPTM2_91                 "Second CPT-4/HCPCS modifier 91"
label var CPTM2_92                 "Second CPT-4/HCPCS modifier 92"
label var CPTM2_93                 "Second CPT-4/HCPCS modifier 93"
label var CPTM2_94                 "Second CPT-4/HCPCS modifier 94"
label var CPTM2_95                 "Second CPT-4/HCPCS modifier 95"
label var CPTM2_96                 "Second CPT-4/HCPCS modifier 96"
label var CPTM2_97                 "Second CPT-4/HCPCS modifier 97"
label var CPTM2_98                 "Second CPT-4/HCPCS modifier 98"
label var CPTM2_99                 "Second CPT-4/HCPCS modifier 99"
label var CPTM2_100                "Second CPT-4/HCPCS modifier 100"
label var CPTM2_101                "Second CPT-4/HCPCS modifier 101"
label var CPTM2_102                "Second CPT-4/HCPCS modifier 102"
label var CPTM2_103                "Second CPT-4/HCPCS modifier 103"
label var CPTM2_104                "Second CPT-4/HCPCS modifier 104"
label var CPTM2_105                "Second CPT-4/HCPCS modifier 105"
label var CPTM2_106                "Second CPT-4/HCPCS modifier 106"
label var CPTM2_107                "Second CPT-4/HCPCS modifier 107"
label var CPTM2_108                "Second CPT-4/HCPCS modifier 108"
label var CPTM2_109                "Second CPT-4/HCPCS modifier 109"
label var CPTM2_110                "Second CPT-4/HCPCS modifier 110"
label var CPTM2_111                "Second CPT-4/HCPCS modifier 111"
label var CPTM2_112                "Second CPT-4/HCPCS modifier 112"
label var CPTM2_113                "Second CPT-4/HCPCS modifier 113"
label var CPTM2_114                "Second CPT-4/HCPCS modifier 114"
label var CPTM2_115                "Second CPT-4/HCPCS modifier 115"
label var CPTM2_116                "Second CPT-4/HCPCS modifier 116"
label var CPTM2_117                "Second CPT-4/HCPCS modifier 117"
label var CPTM2_118                "Second CPT-4/HCPCS modifier 118"
label var CPTM2_119                "Second CPT-4/HCPCS modifier 119"
label var CPTM2_120                "Second CPT-4/HCPCS modifier 120"
label var CPTM2_121                "Second CPT-4/HCPCS modifier 121"
label var CPTM2_122                "Second CPT-4/HCPCS modifier 122"
label var CPTM2_123                "Second CPT-4/HCPCS modifier 123"
label var CPTM2_124                "Second CPT-4/HCPCS modifier 124"
label var CPTM2_125                "Second CPT-4/HCPCS modifier 125"
label var CPTM2_126                "Second CPT-4/HCPCS modifier 126"
label var CPTM2_127                "Second CPT-4/HCPCS modifier 127"
label var CPTM2_128                "Second CPT-4/HCPCS modifier 128"
label var CPTM2_129                "Second CPT-4/HCPCS modifier 129"
label var DHOUR                    "Discharge Hour"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DURATION                 "Elapsed time for hospital care in hours and minutes"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HCUP_SURGERY_BROAD_CPT   "Number of reported CPT procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_NARROW_CPT  "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
label var HOSPST                   "Hospital state postal code"
label var I10_DX_Visit_Reason1     "ICD-10-CM Reason for visit diagnosis 1"
label var I10_DX_Visit_Reason2     "ICD-10-CM Reason for visit diagnosis 2"
label var I10_DX_Visit_Reason3     "ICD-10-CM Reason for visit diagnosis 3"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DX31                 "ICD-10-CM Diagnosis 31"
label var I10_DX32                 "ICD-10-CM Diagnosis 32"
label var I10_DX33                 "ICD-10-CM Diagnosis 33"
label var I10_DX34                 "ICD-10-CM Diagnosis 34"
label var I10_DX35                 "ICD-10-CM Diagnosis 35"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var OS_TIME                  "Observation stay time summed from UNITS"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes (RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PSTATE                   "Patient State postal code"
label var PSTATE_GEO               "Patient State postal code assigned from ZIP Code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO_GEO                "Counties assigned based on ZIP Code geographic centroids"
label var RACE                     "Race (uniform)"
label var RACE_PCT_MISS_HOSP       "Hospital percentage of missing or invalid race values"
label var RACE_X                   "Race (as received from source)"
label var SASD_SEDD                "SASD and SEDD indicator"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var HOSPID                   "HCUP hospital identification number"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"

/*** Convert special values to missing values ***/
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AHOUR                     (-999 -888 -666=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTCCS7                   (-99 -88 -66=.)
recode CPTCCS8                   (-99 -88 -66=.)
recode CPTCCS9                   (-99 -88 -66=.)
recode CPTCCS10                  (-99 -88 -66=.)
recode CPTCCS11                  (-99 -88 -66=.)
recode CPTCCS12                  (-99 -88 -66=.)
recode CPTCCS13                  (-99 -88 -66=.)
recode CPTCCS14                  (-99 -88 -66=.)
recode CPTCCS15                  (-99 -88 -66=.)
recode CPTCCS16                  (-99 -88 -66=.)
recode CPTCCS17                  (-99 -88 -66=.)
recode CPTCCS18                  (-99 -88 -66=.)
recode CPTCCS19                  (-99 -88 -66=.)
recode CPTCCS20                  (-99 -88 -66=.)
recode CPTCCS21                  (-99 -88 -66=.)
recode CPTCCS22                  (-99 -88 -66=.)
recode CPTCCS23                  (-99 -88 -66=.)
recode CPTCCS24                  (-99 -88 -66=.)
recode CPTCCS25                  (-99 -88 -66=.)
recode CPTCCS26                  (-99 -88 -66=.)
recode CPTCCS27                  (-99 -88 -66=.)
recode CPTCCS28                  (-99 -88 -66=.)
recode CPTCCS29                  (-99 -88 -66=.)
recode CPTCCS30                  (-99 -88 -66=.)
recode CPTCCS31                  (-99 -88 -66=.)
recode CPTCCS32                  (-99 -88 -66=.)
recode CPTCCS33                  (-99 -88 -66=.)
recode CPTCCS34                  (-99 -88 -66=.)
recode CPTCCS35                  (-99 -88 -66=.)
recode CPTCCS36                  (-99 -88 -66=.)
recode CPTCCS37                  (-99 -88 -66=.)
recode CPTCCS38                  (-99 -88 -66=.)
recode CPTCCS39                  (-99 -88 -66=.)
recode CPTCCS40                  (-99 -88 -66=.)
recode CPTCCS41                  (-99 -88 -66=.)
recode CPTCCS42                  (-99 -88 -66=.)
recode CPTCCS43                  (-99 -88 -66=.)
recode CPTCCS44                  (-99 -88 -66=.)
recode CPTCCS45                  (-99 -88 -66=.)
recode CPTCCS46                  (-99 -88 -66=.)
recode CPTCCS47                  (-99 -88 -66=.)
recode CPTCCS48                  (-99 -88 -66=.)
recode CPTCCS49                  (-99 -88 -66=.)
recode CPTCCS50                  (-99 -88 -66=.)
recode CPTCCS51                  (-99 -88 -66=.)
recode CPTCCS52                  (-99 -88 -66=.)
recode CPTCCS53                  (-99 -88 -66=.)
recode CPTCCS54                  (-99 -88 -66=.)
recode CPTCCS55                  (-99 -88 -66=.)
recode CPTCCS56                  (-99 -88 -66=.)
recode CPTCCS57                  (-99 -88 -66=.)
recode CPTCCS58                  (-99 -88 -66=.)
recode CPTCCS59                  (-99 -88 -66=.)
recode CPTCCS60                  (-99 -88 -66=.)
recode CPTCCS61                  (-99 -88 -66=.)
recode CPTCCS62                  (-99 -88 -66=.)
recode CPTCCS63                  (-99 -88 -66=.)
recode CPTCCS64                  (-99 -88 -66=.)
recode CPTCCS65                  (-99 -88 -66=.)
recode CPTCCS66                  (-99 -88 -66=.)
recode CPTCCS67                  (-99 -88 -66=.)
recode CPTCCS68                  (-99 -88 -66=.)
recode CPTCCS69                  (-99 -88 -66=.)
recode CPTCCS70                  (-99 -88 -66=.)
recode CPTCCS71                  (-99 -88 -66=.)
recode CPTCCS72                  (-99 -88 -66=.)
recode CPTCCS73                  (-99 -88 -66=.)
recode CPTCCS74                  (-99 -88 -66=.)
recode CPTCCS75                  (-99 -88 -66=.)
recode CPTCCS76                  (-99 -88 -66=.)
recode CPTCCS77                  (-99 -88 -66=.)
recode CPTCCS78                  (-99 -88 -66=.)
recode CPTCCS79                  (-99 -88 -66=.)
recode CPTCCS80                  (-99 -88 -66=.)
recode CPTCCS81                  (-99 -88 -66=.)
recode CPTCCS82                  (-99 -88 -66=.)
recode CPTCCS83                  (-99 -88 -66=.)
recode CPTCCS84                  (-99 -88 -66=.)
recode CPTCCS85                  (-99 -88 -66=.)
recode CPTCCS86                  (-99 -88 -66=.)
recode CPTCCS87                  (-99 -88 -66=.)
recode CPTCCS88                  (-99 -88 -66=.)
recode CPTCCS89                  (-99 -88 -66=.)
recode CPTCCS90                  (-99 -88 -66=.)
recode CPTCCS91                  (-99 -88 -66=.)
recode CPTCCS92                  (-99 -88 -66=.)
recode CPTCCS93                  (-99 -88 -66=.)
recode CPTCCS94                  (-99 -88 -66=.)
recode CPTCCS95                  (-99 -88 -66=.)
recode CPTCCS96                  (-99 -88 -66=.)
recode CPTCCS97                  (-99 -88 -66=.)
recode CPTCCS98                  (-99 -88 -66=.)
recode CPTCCS99                  (-99 -88 -66=.)
recode CPTCCS100                 (-99 -88 -66=.)
recode CPTCCS101                 (-99 -88 -66=.)
recode CPTCCS102                 (-99 -88 -66=.)
recode CPTCCS103                 (-99 -88 -66=.)
recode CPTCCS104                 (-99 -88 -66=.)
recode CPTCCS105                 (-99 -88 -66=.)
recode CPTCCS106                 (-99 -88 -66=.)
recode CPTCCS107                 (-99 -88 -66=.)
recode CPTCCS108                 (-99 -88 -66=.)
recode CPTCCS109                 (-99 -88 -66=.)
recode CPTCCS110                 (-99 -88 -66=.)
recode CPTCCS111                 (-99 -88 -66=.)
recode CPTCCS112                 (-99 -88 -66=.)
recode CPTCCS113                 (-99 -88 -66=.)
recode CPTCCS114                 (-99 -88 -66=.)
recode CPTCCS115                 (-99 -88 -66=.)
recode CPTCCS116                 (-99 -88 -66=.)
recode CPTCCS117                 (-99 -88 -66=.)
recode CPTCCS118                 (-99 -88 -66=.)
recode CPTCCS119                 (-99 -88 -66=.)
recode CPTCCS120                 (-99 -88 -66=.)
recode CPTCCS121                 (-99 -88 -66=.)
recode CPTCCS122                 (-99 -88 -66=.)
recode CPTCCS123                 (-99 -88 -66=.)
recode CPTCCS124                 (-99 -88 -66=.)
recode CPTCCS125                 (-99 -88 -66=.)
recode CPTCCS126                 (-99 -88 -66=.)
recode CPTCCS127                 (-99 -88 -66=.)
recode CPTCCS128                 (-99 -88 -66=.)
recode CPTCCS129                 (-99 -88 -66=.)
recode CPTDAY1                   (-99 -88 -66=.)
recode CPTDAY2                   (-99 -88 -66=.)
recode CPTDAY3                   (-99 -88 -66=.)
recode CPTDAY4                   (-99 -88 -66=.)
recode CPTDAY5                   (-99 -88 -66=.)
recode CPTDAY6                   (-99 -88 -66=.)
recode CPTDAY7                   (-99 -88 -66=.)
recode CPTDAY8                   (-99 -88 -66=.)
recode CPTDAY9                   (-99 -88 -66=.)
recode CPTDAY10                  (-99 -88 -66=.)
recode CPTDAY11                  (-99 -88 -66=.)
recode CPTDAY12                  (-99 -88 -66=.)
recode CPTDAY13                  (-99 -88 -66=.)
recode CPTDAY14                  (-99 -88 -66=.)
recode CPTDAY15                  (-99 -88 -66=.)
recode CPTDAY16                  (-99 -88 -66=.)
recode CPTDAY17                  (-99 -88 -66=.)
recode CPTDAY18                  (-99 -88 -66=.)
recode CPTDAY19                  (-99 -88 -66=.)
recode CPTDAY20                  (-99 -88 -66=.)
recode CPTDAY21                  (-99 -88 -66=.)
recode CPTDAY22                  (-99 -88 -66=.)
recode CPTDAY23                  (-99 -88 -66=.)
recode CPTDAY24                  (-99 -88 -66=.)
recode CPTDAY25                  (-99 -88 -66=.)
recode CPTDAY26                  (-99 -88 -66=.)
recode CPTDAY27                  (-99 -88 -66=.)
recode CPTDAY28                  (-99 -88 -66=.)
recode CPTDAY29                  (-99 -88 -66=.)
recode CPTDAY30                  (-99 -88 -66=.)
recode CPTDAY31                  (-99 -88 -66=.)
recode CPTDAY32                  (-99 -88 -66=.)
recode CPTDAY33                  (-99 -88 -66=.)
recode CPTDAY34                  (-99 -88 -66=.)
recode CPTDAY35                  (-99 -88 -66=.)
recode CPTDAY36                  (-99 -88 -66=.)
recode CPTDAY37                  (-99 -88 -66=.)
recode CPTDAY38                  (-99 -88 -66=.)
recode CPTDAY39                  (-99 -88 -66=.)
recode CPTDAY40                  (-99 -88 -66=.)
recode CPTDAY41                  (-99 -88 -66=.)
recode CPTDAY42                  (-99 -88 -66=.)
recode CPTDAY43                  (-99 -88 -66=.)
recode CPTDAY44                  (-99 -88 -66=.)
recode CPTDAY45                  (-99 -88 -66=.)
recode CPTDAY46                  (-99 -88 -66=.)
recode CPTDAY47                  (-99 -88 -66=.)
recode CPTDAY48                  (-99 -88 -66=.)
recode CPTDAY49                  (-99 -88 -66=.)
recode CPTDAY50                  (-99 -88 -66=.)
recode CPTDAY51                  (-99 -88 -66=.)
recode CPTDAY52                  (-99 -88 -66=.)
recode CPTDAY53                  (-99 -88 -66=.)
recode CPTDAY54                  (-99 -88 -66=.)
recode CPTDAY55                  (-99 -88 -66=.)
recode CPTDAY56                  (-99 -88 -66=.)
recode CPTDAY57                  (-99 -88 -66=.)
recode CPTDAY58                  (-99 -88 -66=.)
recode CPTDAY59                  (-99 -88 -66=.)
recode CPTDAY60                  (-99 -88 -66=.)
recode CPTDAY61                  (-99 -88 -66=.)
recode CPTDAY62                  (-99 -88 -66=.)
recode CPTDAY63                  (-99 -88 -66=.)
recode CPTDAY64                  (-99 -88 -66=.)
recode CPTDAY65                  (-99 -88 -66=.)
recode CPTDAY66                  (-99 -88 -66=.)
recode CPTDAY67                  (-99 -88 -66=.)
recode CPTDAY68                  (-99 -88 -66=.)
recode CPTDAY69                  (-99 -88 -66=.)
recode CPTDAY70                  (-99 -88 -66=.)
recode CPTDAY71                  (-99 -88 -66=.)
recode CPTDAY72                  (-99 -88 -66=.)
recode CPTDAY73                  (-99 -88 -66=.)
recode CPTDAY74                  (-99 -88 -66=.)
recode CPTDAY75                  (-99 -88 -66=.)
recode CPTDAY76                  (-99 -88 -66=.)
recode CPTDAY77                  (-99 -88 -66=.)
recode CPTDAY78                  (-99 -88 -66=.)
recode CPTDAY79                  (-99 -88 -66=.)
recode CPTDAY80                  (-99 -88 -66=.)
recode CPTDAY81                  (-99 -88 -66=.)
recode CPTDAY82                  (-99 -88 -66=.)
recode CPTDAY83                  (-99 -88 -66=.)
recode CPTDAY84                  (-99 -88 -66=.)
recode CPTDAY85                  (-99 -88 -66=.)
recode CPTDAY86                  (-99 -88 -66=.)
recode CPTDAY87                  (-99 -88 -66=.)
recode CPTDAY88                  (-99 -88 -66=.)
recode CPTDAY89                  (-99 -88 -66=.)
recode CPTDAY90                  (-99 -88 -66=.)
recode CPTDAY91                  (-99 -88 -66=.)
recode CPTDAY92                  (-99 -88 -66=.)
recode CPTDAY93                  (-99 -88 -66=.)
recode CPTDAY94                  (-99 -88 -66=.)
recode CPTDAY95                  (-99 -88 -66=.)
recode CPTDAY96                  (-99 -88 -66=.)
recode CPTDAY97                  (-99 -88 -66=.)
recode CPTDAY98                  (-99 -88 -66=.)
recode CPTDAY99                  (-99 -88 -66=.)
recode CPTDAY100                 (-99 -88 -66=.)
recode CPTDAY101                 (-99 -88 -66=.)
recode CPTDAY102                 (-99 -88 -66=.)
recode CPTDAY103                 (-99 -88 -66=.)
recode CPTDAY104                 (-99 -88 -66=.)
recode CPTDAY105                 (-99 -88 -66=.)
recode CPTDAY106                 (-99 -88 -66=.)
recode CPTDAY107                 (-99 -88 -66=.)
recode CPTDAY108                 (-99 -88 -66=.)
recode CPTDAY109                 (-99 -88 -66=.)
recode CPTDAY110                 (-99 -88 -66=.)
recode CPTDAY111                 (-99 -88 -66=.)
recode CPTDAY112                 (-99 -88 -66=.)
recode CPTDAY113                 (-99 -88 -66=.)
recode CPTDAY114                 (-99 -88 -66=.)
recode CPTDAY115                 (-99 -88 -66=.)
recode CPTDAY116                 (-99 -88 -66=.)
recode CPTDAY117                 (-99 -88 -66=.)
recode CPTDAY118                 (-99 -88 -66=.)
recode CPTDAY119                 (-99 -88 -66=.)
recode CPTDAY120                 (-99 -88 -66=.)
recode CPTDAY121                 (-99 -88 -66=.)
recode CPTDAY122                 (-99 -88 -66=.)
recode CPTDAY123                 (-99 -88 -66=.)
recode CPTDAY124                 (-99 -88 -66=.)
recode CPTDAY125                 (-99 -88 -66=.)
recode CPTDAY126                 (-99 -88 -66=.)
recode CPTDAY127                 (-99 -88 -66=.)
recode CPTDAY128                 (-99 -88 -66=.)
recode CPTDAY129                 (-99 -88 -66=.)
recode DHOUR                     (-999 -888 -666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DURATION                  (-99999 -88888 -66666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HCUP_SURGERY_BROAD_CPT    (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_CPT   (-9999 -8888 -6666=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode NCPT                      (-999 -888 -666=.)
recode OS_TIME                   (-9999999.99 -8888888.88 -6666666.66=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO_GEO                 (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode RACE_PCT_MISS_HOSP        (-999.99 -888.88 -666.66=.)
recode SASD_SEDD                 (-9 -8 -6 -5=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)

save "DC_SASD_2022_CORE.dta", replace
