/*****************************************************************************
* Creation Date: 04/10/2025   
* SC_SASD_2023_CORE.Do
* This program will load the 2023 SC ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      byte   AMONTH                       1-   2   ///
      byte   ATYPE                        3-   4   ///
      byte   AWEEKEND                     5-   6   ///
      str    CPT1                         7-  11   ///
      str    CPT2                        12-  16   ///
      str    CPT3                        17-  21   ///
      str    CPT4                        22-  26   ///
      str    CPT5                        27-  31   ///
      str    CPT6                        32-  36   ///
      str    CPT7                        37-  41   ///
      str    CPT8                        42-  46   ///
      str    CPT9                        47-  51   ///
      str    CPT10                       52-  56   ///
      str    CPT11                       57-  61   ///
      str    CPT12                       62-  66   ///
      str    CPT13                       67-  71   ///
      str    CPT14                       72-  76   ///
      str    CPT15                       77-  81   ///
      str    CPT16                       82-  86   ///
      str    CPT17                       87-  91   ///
      str    CPT18                       92-  96   ///
      str    CPT19                       97- 101   ///
      str    CPT20                      102- 106   ///
      str    CPT21                      107- 111   ///
      str    CPT22                      112- 116   ///
      str    CPT23                      117- 121   ///
      str    CPT24                      122- 126   ///
      str    CPT25                      127- 131   ///
      str    CPT26                      132- 136   ///
      str    CPT27                      137- 141   ///
      str    CPT28                      142- 146   ///
      str    CPT29                      147- 151   ///
      str    CPT30                      152- 156   ///
      str    CPT31                      157- 161   ///
      str    CPT32                      162- 166   ///
      str    CPT33                      167- 171   ///
      str    CPT34                      172- 176   ///
      str    CPT35                      177- 181   ///
      str    CPT36                      182- 186   ///
      str    CPT37                      187- 191   ///
      str    CPT38                      192- 196   ///
      str    CPT39                      197- 201   ///
      str    CPT40                      202- 206   ///
      str    CPT41                      207- 211   ///
      str    CPT42                      212- 216   ///
      str    CPT43                      217- 221   ///
      str    CPT44                      222- 226   ///
      str    CPT45                      227- 231   ///
      str    CPT46                      232- 236   ///
      str    CPT47                      237- 241   ///
      str    CPT48                      242- 246   ///
      str    CPT49                      247- 251   ///
      str    CPT50                      252- 256   ///
      str    CPT51                      257- 261   ///
      str    CPT52                      262- 266   ///
      str    CPT53                      267- 271   ///
      str    CPT54                      272- 276   ///
      str    CPT55                      277- 281   ///
      str    CPT56                      282- 286   ///
      str    CPT57                      287- 291   ///
      str    CPT58                      292- 296   ///
      str    CPT59                      297- 301   ///
      str    CPT60                      302- 306   ///
      str    CPT61                      307- 311   ///
      str    CPT62                      312- 316   ///
      str    CPT63                      317- 321   ///
      str    CPT64                      322- 326   ///
      str    CPT65                      327- 331   ///
      str    CPT66                      332- 336   ///
      str    CPT67                      337- 341   ///
      str    CPT68                      342- 346   ///
      str    CPT69                      347- 351   ///
      str    CPT70                      352- 356   ///
      str    CPT71                      357- 361   ///
      str    CPT72                      362- 366   ///
      str    CPT73                      367- 371   ///
      str    CPT74                      372- 376   ///
      str    CPT75                      377- 381   ///
      str    CPT76                      382- 386   ///
      str    CPT77                      387- 391   ///
      str    CPT78                      392- 396   ///
      str    CPT79                      397- 401   ///
      str    CPT80                      402- 406   ///
      str    CPT81                      407- 411   ///
      str    CPT82                      412- 416   ///
      str    CPT83                      417- 421   ///
      str    CPT84                      422- 426   ///
      str    CPT85                      427- 431   ///
      str    CPT86                      432- 436   ///
      str    CPT87                      437- 441   ///
      str    CPT88                      442- 446   ///
      str    CPT89                      447- 451   ///
      str    CPT90                      452- 456   ///
      str    CPT91                      457- 461   ///
      str    CPT92                      462- 466   ///
      str    CPT93                      467- 471   ///
      str    CPT94                      472- 476   ///
      str    CPT95                      477- 481   ///
      str    CPT96                      482- 486   ///
      str    CPT97                      487- 491   ///
      str    CPT98                      492- 496   ///
      str    CPT99                      497- 501   ///
      str    CPT100                     502- 506   ///
      str    CPT101                     507- 511   ///
      str    CPT102                     512- 516   ///
      str    CPT103                     517- 521   ///
      str    CPT104                     522- 526   ///
      str    CPT105                     527- 531   ///
      str    CPT106                     532- 536   ///
      str    CPT107                     537- 541   ///
      str    CPT108                     542- 546   ///
      str    CPT109                     547- 551   ///
      str    CPT110                     552- 556   ///
      str    CPT111                     557- 561   ///
      str    CPT112                     562- 566   ///
      str    CPT113                     567- 571   ///
      str    CPT114                     572- 576   ///
      str    CPT115                     577- 581   ///
      str    CPT116                     582- 586   ///
      str    CPT117                     587- 591   ///
      str    CPT118                     592- 596   ///
      str    CPT119                     597- 601   ///
      str    CPT120                     602- 606   ///
      str    CPT121                     607- 611   ///
      str    CPT122                     612- 616   ///
      str    CPT123                     617- 621   ///
      str    CPT124                     622- 626   ///
      str    CPT125                     627- 631   ///
      str    CPT126                     632- 636   ///
      str    CPT127                     637- 641   ///
      str    CPT128                     642- 646   ///
      str    CPT129                     647- 651   ///
      str    CPT130                     652- 656   ///
      str    CPT131                     657- 661   ///
      str    CPT132                     662- 666   ///
      str    CPT133                     667- 671   ///
      str    CPT134                     672- 676   ///
      str    CPT135                     677- 681   ///
      str    CPT136                     682- 686   ///
      str    CPT137                     687- 691   ///
      str    CPT138                     692- 696   ///
      str    CPT139                     697- 701   ///
      str    CPT140                     702- 706   ///
      str    CPT141                     707- 711   ///
      str    CPT142                     712- 716   ///
      str    CPT143                     717- 721   ///
      str    CPT144                     722- 726   ///
      str    CPT145                     727- 731   ///
      str    CPT146                     732- 736   ///
      str    CPT147                     737- 741   ///
      str    CPT148                     742- 746   ///
      str    CPT149                     747- 751   ///
      str    CPT150                     752- 756   ///
      str    CPT151                     757- 761   ///
      str    CPT152                     762- 766   ///
      str    CPT153                     767- 771   ///
      str    CPT154                     772- 776   ///
      str    CPT155                     777- 781   ///
      str    CPT156                     782- 786   ///
      str    CPT157                     787- 791   ///
      str    CPT158                     792- 796   ///
      str    CPT159                     797- 801   ///
      str    CPT160                     802- 806   ///
      str    CPT161                     807- 811   ///
      str    CPT162                     812- 816   ///
      str    CPT163                     817- 821   ///
      str    CPT164                     822- 826   ///
      str    CPT165                     827- 831   ///
      str    CPT166                     832- 836   ///
      str    CPT167                     837- 841   ///
      str    CPT168                     842- 846   ///
      str    CPT169                     847- 851   ///
      str    CPT170                     852- 856   ///
      str    CPT171                     857- 861   ///
      str    CPT172                     862- 866   ///
      str    CPT173                     867- 871   ///
      str    CPT174                     872- 876   ///
      str    CPT175                     877- 881   ///
      str    CPT176                     882- 886   ///
      str    CPT177                     887- 891   ///
      str    CPT178                     892- 896   ///
      str    CPT179                     897- 901   ///
      str    CPT180                     902- 906   ///
      str    CPT181                     907- 911   ///
      str    CPT182                     912- 916   ///
      str    CPT183                     917- 921   ///
      str    CPT184                     922- 926   ///
      str    CPT185                     927- 931   ///
      str    CPT186                     932- 936   ///
      str    CPT187                     937- 941   ///
      str    CPT188                     942- 946   ///
      str    CPT189                     947- 951   ///
      str    CPT190                     952- 956   ///
      str    CPT191                     957- 961   ///
      str    CPT192                     962- 966   ///
      str    CPT193                     967- 971   ///
      str    CPT194                     972- 976   ///
      str    CPT195                     977- 981   ///
      str    CPT196                     982- 986   ///
      str    CPT197                     987- 991   ///
      str    CPT198                     992- 996   ///
      str    CPT199                     997-1001   ///
      str    CPT200                    1002-1006   ///
      int    CPTCCS1                   1007-1009   ///
      int    CPTCCS2                   1010-1012   ///
      int    CPTCCS3                   1013-1015   ///
      int    CPTCCS4                   1016-1018   ///
      int    CPTCCS5                   1019-1021   ///
      int    CPTCCS6                   1022-1024   ///
      int    CPTCCS7                   1025-1027   ///
      int    CPTCCS8                   1028-1030   ///
      int    CPTCCS9                   1031-1033   ///
      int    CPTCCS10                  1034-1036   ///
      int    CPTCCS11                  1037-1039   ///
      int    CPTCCS12                  1040-1042   ///
      int    CPTCCS13                  1043-1045   ///
      int    CPTCCS14                  1046-1048   ///
      int    CPTCCS15                  1049-1051   ///
      int    CPTCCS16                  1052-1054   ///
      int    CPTCCS17                  1055-1057   ///
      int    CPTCCS18                  1058-1060   ///
      int    CPTCCS19                  1061-1063   ///
      int    CPTCCS20                  1064-1066   ///
      int    CPTCCS21                  1067-1069   ///
      int    CPTCCS22                  1070-1072   ///
      int    CPTCCS23                  1073-1075   ///
      int    CPTCCS24                  1076-1078   ///
      int    CPTCCS25                  1079-1081   ///
      int    CPTCCS26                  1082-1084   ///
      int    CPTCCS27                  1085-1087   ///
      int    CPTCCS28                  1088-1090   ///
      int    CPTCCS29                  1091-1093   ///
      int    CPTCCS30                  1094-1096   ///
      int    CPTCCS31                  1097-1099   ///
      int    CPTCCS32                  1100-1102   ///
      int    CPTCCS33                  1103-1105   ///
      int    CPTCCS34                  1106-1108   ///
      int    CPTCCS35                  1109-1111   ///
      int    CPTCCS36                  1112-1114   ///
      int    CPTCCS37                  1115-1117   ///
      int    CPTCCS38                  1118-1120   ///
      int    CPTCCS39                  1121-1123   ///
      int    CPTCCS40                  1124-1126   ///
      int    CPTCCS41                  1127-1129   ///
      int    CPTCCS42                  1130-1132   ///
      int    CPTCCS43                  1133-1135   ///
      int    CPTCCS44                  1136-1138   ///
      int    CPTCCS45                  1139-1141   ///
      int    CPTCCS46                  1142-1144   ///
      int    CPTCCS47                  1145-1147   ///
      int    CPTCCS48                  1148-1150   ///
      int    CPTCCS49                  1151-1153   ///
      int    CPTCCS50                  1154-1156   ///
      int    CPTCCS51                  1157-1159   ///
      int    CPTCCS52                  1160-1162   ///
      int    CPTCCS53                  1163-1165   ///
      int    CPTCCS54                  1166-1168   ///
      int    CPTCCS55                  1169-1171   ///
      int    CPTCCS56                  1172-1174   ///
      int    CPTCCS57                  1175-1177   ///
      int    CPTCCS58                  1178-1180   ///
      int    CPTCCS59                  1181-1183   ///
      int    CPTCCS60                  1184-1186   ///
      int    CPTCCS61                  1187-1189   ///
      int    CPTCCS62                  1190-1192   ///
      int    CPTCCS63                  1193-1195   ///
      int    CPTCCS64                  1196-1198   ///
      int    CPTCCS65                  1199-1201   ///
      int    CPTCCS66                  1202-1204   ///
      int    CPTCCS67                  1205-1207   ///
      int    CPTCCS68                  1208-1210   ///
      int    CPTCCS69                  1211-1213   ///
      int    CPTCCS70                  1214-1216   ///
      int    CPTCCS71                  1217-1219   ///
      int    CPTCCS72                  1220-1222   ///
      int    CPTCCS73                  1223-1225   ///
      int    CPTCCS74                  1226-1228   ///
      int    CPTCCS75                  1229-1231   ///
      int    CPTCCS76                  1232-1234   ///
      int    CPTCCS77                  1235-1237   ///
      int    CPTCCS78                  1238-1240   ///
      int    CPTCCS79                  1241-1243   ///
      int    CPTCCS80                  1244-1246   ///
      int    CPTCCS81                  1247-1249   ///
      int    CPTCCS82                  1250-1252   ///
      int    CPTCCS83                  1253-1255   ///
      int    CPTCCS84                  1256-1258   ///
      int    CPTCCS85                  1259-1261   ///
      int    CPTCCS86                  1262-1264   ///
      int    CPTCCS87                  1265-1267   ///
      int    CPTCCS88                  1268-1270   ///
      int    CPTCCS89                  1271-1273   ///
      int    CPTCCS90                  1274-1276   ///
      int    CPTCCS91                  1277-1279   ///
      int    CPTCCS92                  1280-1282   ///
      int    CPTCCS93                  1283-1285   ///
      int    CPTCCS94                  1286-1288   ///
      int    CPTCCS95                  1289-1291   ///
      int    CPTCCS96                  1292-1294   ///
      int    CPTCCS97                  1295-1297   ///
      int    CPTCCS98                  1298-1300   ///
      int    CPTCCS99                  1301-1303   ///
      int    CPTCCS100                 1304-1306   ///
      int    CPTCCS101                 1307-1309   ///
      int    CPTCCS102                 1310-1312   ///
      int    CPTCCS103                 1313-1315   ///
      int    CPTCCS104                 1316-1318   ///
      int    CPTCCS105                 1319-1321   ///
      int    CPTCCS106                 1322-1324   ///
      int    CPTCCS107                 1325-1327   ///
      int    CPTCCS108                 1328-1330   ///
      int    CPTCCS109                 1331-1333   ///
      int    CPTCCS110                 1334-1336   ///
      int    CPTCCS111                 1337-1339   ///
      int    CPTCCS112                 1340-1342   ///
      int    CPTCCS113                 1343-1345   ///
      int    CPTCCS114                 1346-1348   ///
      int    CPTCCS115                 1349-1351   ///
      int    CPTCCS116                 1352-1354   ///
      int    CPTCCS117                 1355-1357   ///
      int    CPTCCS118                 1358-1360   ///
      int    CPTCCS119                 1361-1363   ///
      int    CPTCCS120                 1364-1366   ///
      int    CPTCCS121                 1367-1369   ///
      int    CPTCCS122                 1370-1372   ///
      int    CPTCCS123                 1373-1375   ///
      int    CPTCCS124                 1376-1378   ///
      int    CPTCCS125                 1379-1381   ///
      int    CPTCCS126                 1382-1384   ///
      int    CPTCCS127                 1385-1387   ///
      int    CPTCCS128                 1388-1390   ///
      int    CPTCCS129                 1391-1393   ///
      int    CPTCCS130                 1394-1396   ///
      int    CPTCCS131                 1397-1399   ///
      int    CPTCCS132                 1400-1402   ///
      int    CPTCCS133                 1403-1405   ///
      int    CPTCCS134                 1406-1408   ///
      int    CPTCCS135                 1409-1411   ///
      int    CPTCCS136                 1412-1414   ///
      int    CPTCCS137                 1415-1417   ///
      int    CPTCCS138                 1418-1420   ///
      int    CPTCCS139                 1421-1423   ///
      int    CPTCCS140                 1424-1426   ///
      int    CPTCCS141                 1427-1429   ///
      int    CPTCCS142                 1430-1432   ///
      int    CPTCCS143                 1433-1435   ///
      int    CPTCCS144                 1436-1438   ///
      int    CPTCCS145                 1439-1441   ///
      int    CPTCCS146                 1442-1444   ///
      int    CPTCCS147                 1445-1447   ///
      int    CPTCCS148                 1448-1450   ///
      int    CPTCCS149                 1451-1453   ///
      int    CPTCCS150                 1454-1456   ///
      int    CPTCCS151                 1457-1459   ///
      int    CPTCCS152                 1460-1462   ///
      int    CPTCCS153                 1463-1465   ///
      int    CPTCCS154                 1466-1468   ///
      int    CPTCCS155                 1469-1471   ///
      int    CPTCCS156                 1472-1474   ///
      int    CPTCCS157                 1475-1477   ///
      int    CPTCCS158                 1478-1480   ///
      int    CPTCCS159                 1481-1483   ///
      int    CPTCCS160                 1484-1486   ///
      int    CPTCCS161                 1487-1489   ///
      int    CPTCCS162                 1490-1492   ///
      int    CPTCCS163                 1493-1495   ///
      int    CPTCCS164                 1496-1498   ///
      int    CPTCCS165                 1499-1501   ///
      int    CPTCCS166                 1502-1504   ///
      int    CPTCCS167                 1505-1507   ///
      int    CPTCCS168                 1508-1510   ///
      int    CPTCCS169                 1511-1513   ///
      int    CPTCCS170                 1514-1516   ///
      int    CPTCCS171                 1517-1519   ///
      int    CPTCCS172                 1520-1522   ///
      int    CPTCCS173                 1523-1525   ///
      int    CPTCCS174                 1526-1528   ///
      int    CPTCCS175                 1529-1531   ///
      int    CPTCCS176                 1532-1534   ///
      int    CPTCCS177                 1535-1537   ///
      int    CPTCCS178                 1538-1540   ///
      int    CPTCCS179                 1541-1543   ///
      int    CPTCCS180                 1544-1546   ///
      int    CPTCCS181                 1547-1549   ///
      int    CPTCCS182                 1550-1552   ///
      int    CPTCCS183                 1553-1555   ///
      int    CPTCCS184                 1556-1558   ///
      int    CPTCCS185                 1559-1561   ///
      int    CPTCCS186                 1562-1564   ///
      int    CPTCCS187                 1565-1567   ///
      int    CPTCCS188                 1568-1570   ///
      int    CPTCCS189                 1571-1573   ///
      int    CPTCCS190                 1574-1576   ///
      int    CPTCCS191                 1577-1579   ///
      int    CPTCCS192                 1580-1582   ///
      int    CPTCCS193                 1583-1585   ///
      int    CPTCCS194                 1586-1588   ///
      int    CPTCCS195                 1589-1591   ///
      int    CPTCCS196                 1592-1594   ///
      int    CPTCCS197                 1595-1597   ///
      int    CPTCCS198                 1598-1600   ///
      int    CPTCCS199                 1601-1603   ///
      int    CPTCCS200                 1604-1606   ///
      byte   DIED                      1607-1608   ///
      str    DISP_X                    1609-1610   ///
      byte   DISPUB04                  1611-1612   ///
      byte   DISPUNIFORM               1613-1614   ///
      byte   DMONTH                    1615-1616   ///
      byte   DQTR                      1617-1618   ///
      byte   FEMALE                    1619-1620   ///
      byte   HCUP_ED                   1621-1622   ///
      byte   HCUP_OS                   1623-1624   ///
      long   HCUP_SURGERY_BROAD_CPT    1625-1629   ///
      long   HCUP_SURGERY_NARROW_CPT   1630-1634   ///
      str    HOSPST                    1635-1636   ///
      str    I10_DX_Visit_Reason1      1637-1643   ///
      str    I10_DX_Visit_Reason2      1644-1650   ///
      str    I10_DX_Visit_Reason3      1651-1657   ///
      str    I10_DX1                   1658-1664   ///
      str    I10_DX2                   1665-1671   ///
      str    I10_DX3                   1672-1678   ///
      str    I10_DX4                   1679-1685   ///
      str    I10_DX5                   1686-1692   ///
      str    I10_DX6                   1693-1699   ///
      str    I10_DX7                   1700-1706   ///
      str    I10_DX8                   1707-1713   ///
      str    I10_DX9                   1714-1720   ///
      str    I10_DX10                  1721-1727   ///
      str    I10_DX11                  1728-1734   ///
      str    I10_DX12                  1735-1741   ///
      str    I10_DX13                  1742-1748   ///
      str    I10_DX14                  1749-1755   ///
      str    I10_DX15                  1756-1762   ///
      str    I10_DX16                  1763-1769   ///
      str    I10_DX17                  1770-1776   ///
      int    I10_NDX                   1777-1779   ///
      int    I10_PROCTYPE              1780-1782   ///
      double KEY                       1783-1797   ///
      str    MDSPEC1                   1798-1800   ///
      str    MDSPEC2                   1801-1803   ///
      byte   MEDINCSTQ                 1804-1805   ///
      int    NCPT                      1806-1809   ///
      byte   PAY1                      1810-1811   ///
      str    PAY1_X                    1812-1813   ///
      byte   PL_NCHS                   1814-1815   ///
      str    PointOfOrigin_X           1816        ///
      str    PointOfOriginUB04         1817        ///
      str    PSTATE                    1818-1819   ///
      str    PSTATE_GEO                1820-1821   ///
      long   PSTCO                     1822-1826   ///
      byte   RACE                      1827-1828   ///
      str    RACE_X                    1829        ///
      byte   SASD_SEDD                 1830-1831   ///
      byte   STATE_AS                  1832-1833   ///
      byte   STATE_ED                  1834-1835   ///
      byte   STATE_OS                  1836-1837   ///
      double TOTCHG                    1838-1847   ///
      double TOTCHG_X                  1848-1862   ///
      int    YEAR                      1863-1866   ///
      int    ZIPINC_QRTL               1867-1869   ///
      int    AGEGROUP                  1870-1872   ///
      int    AYEAR                     1873-1876   ///
      using  "SC_SASD_2023_CORE.asc"

/***  Assign labels to the data elements ***/
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPT7                     "CPT/HCPCS procedure code 7"
label var CPT8                     "CPT/HCPCS procedure code 8"
label var CPT9                     "CPT/HCPCS procedure code 9"
label var CPT10                    "CPT/HCPCS procedure code 10"
label var CPT11                    "CPT/HCPCS procedure code 11"
label var CPT12                    "CPT/HCPCS procedure code 12"
label var CPT13                    "CPT/HCPCS procedure code 13"
label var CPT14                    "CPT/HCPCS procedure code 14"
label var CPT15                    "CPT/HCPCS procedure code 15"
label var CPT16                    "CPT/HCPCS procedure code 16"
label var CPT17                    "CPT/HCPCS procedure code 17"
label var CPT18                    "CPT/HCPCS procedure code 18"
label var CPT19                    "CPT/HCPCS procedure code 19"
label var CPT20                    "CPT/HCPCS procedure code 20"
label var CPT21                    "CPT/HCPCS procedure code 21"
label var CPT22                    "CPT/HCPCS procedure code 22"
label var CPT23                    "CPT/HCPCS procedure code 23"
label var CPT24                    "CPT/HCPCS procedure code 24"
label var CPT25                    "CPT/HCPCS procedure code 25"
label var CPT26                    "CPT/HCPCS procedure code 26"
label var CPT27                    "CPT/HCPCS procedure code 27"
label var CPT28                    "CPT/HCPCS procedure code 28"
label var CPT29                    "CPT/HCPCS procedure code 29"
label var CPT30                    "CPT/HCPCS procedure code 30"
label var CPT31                    "CPT/HCPCS procedure code 31"
label var CPT32                    "CPT/HCPCS procedure code 32"
label var CPT33                    "CPT/HCPCS procedure code 33"
label var CPT34                    "CPT/HCPCS procedure code 34"
label var CPT35                    "CPT/HCPCS procedure code 35"
label var CPT36                    "CPT/HCPCS procedure code 36"
label var CPT37                    "CPT/HCPCS procedure code 37"
label var CPT38                    "CPT/HCPCS procedure code 38"
label var CPT39                    "CPT/HCPCS procedure code 39"
label var CPT40                    "CPT/HCPCS procedure code 40"
label var CPT41                    "CPT/HCPCS procedure code 41"
label var CPT42                    "CPT/HCPCS procedure code 42"
label var CPT43                    "CPT/HCPCS procedure code 43"
label var CPT44                    "CPT/HCPCS procedure code 44"
label var CPT45                    "CPT/HCPCS procedure code 45"
label var CPT46                    "CPT/HCPCS procedure code 46"
label var CPT47                    "CPT/HCPCS procedure code 47"
label var CPT48                    "CPT/HCPCS procedure code 48"
label var CPT49                    "CPT/HCPCS procedure code 49"
label var CPT50                    "CPT/HCPCS procedure code 50"
label var CPT51                    "CPT/HCPCS procedure code 51"
label var CPT52                    "CPT/HCPCS procedure code 52"
label var CPT53                    "CPT/HCPCS procedure code 53"
label var CPT54                    "CPT/HCPCS procedure code 54"
label var CPT55                    "CPT/HCPCS procedure code 55"
label var CPT56                    "CPT/HCPCS procedure code 56"
label var CPT57                    "CPT/HCPCS procedure code 57"
label var CPT58                    "CPT/HCPCS procedure code 58"
label var CPT59                    "CPT/HCPCS procedure code 59"
label var CPT60                    "CPT/HCPCS procedure code 60"
label var CPT61                    "CPT/HCPCS procedure code 61"
label var CPT62                    "CPT/HCPCS procedure code 62"
label var CPT63                    "CPT/HCPCS procedure code 63"
label var CPT64                    "CPT/HCPCS procedure code 64"
label var CPT65                    "CPT/HCPCS procedure code 65"
label var CPT66                    "CPT/HCPCS procedure code 66"
label var CPT67                    "CPT/HCPCS procedure code 67"
label var CPT68                    "CPT/HCPCS procedure code 68"
label var CPT69                    "CPT/HCPCS procedure code 69"
label var CPT70                    "CPT/HCPCS procedure code 70"
label var CPT71                    "CPT/HCPCS procedure code 71"
label var CPT72                    "CPT/HCPCS procedure code 72"
label var CPT73                    "CPT/HCPCS procedure code 73"
label var CPT74                    "CPT/HCPCS procedure code 74"
label var CPT75                    "CPT/HCPCS procedure code 75"
label var CPT76                    "CPT/HCPCS procedure code 76"
label var CPT77                    "CPT/HCPCS procedure code 77"
label var CPT78                    "CPT/HCPCS procedure code 78"
label var CPT79                    "CPT/HCPCS procedure code 79"
label var CPT80                    "CPT/HCPCS procedure code 80"
label var CPT81                    "CPT/HCPCS procedure code 81"
label var CPT82                    "CPT/HCPCS procedure code 82"
label var CPT83                    "CPT/HCPCS procedure code 83"
label var CPT84                    "CPT/HCPCS procedure code 84"
label var CPT85                    "CPT/HCPCS procedure code 85"
label var CPT86                    "CPT/HCPCS procedure code 86"
label var CPT87                    "CPT/HCPCS procedure code 87"
label var CPT88                    "CPT/HCPCS procedure code 88"
label var CPT89                    "CPT/HCPCS procedure code 89"
label var CPT90                    "CPT/HCPCS procedure code 90"
label var CPT91                    "CPT/HCPCS procedure code 91"
label var CPT92                    "CPT/HCPCS procedure code 92"
label var CPT93                    "CPT/HCPCS procedure code 93"
label var CPT94                    "CPT/HCPCS procedure code 94"
label var CPT95                    "CPT/HCPCS procedure code 95"
label var CPT96                    "CPT/HCPCS procedure code 96"
label var CPT97                    "CPT/HCPCS procedure code 97"
label var CPT98                    "CPT/HCPCS procedure code 98"
label var CPT99                    "CPT/HCPCS procedure code 99"
label var CPT100                   "CPT/HCPCS procedure code 100"
label var CPT101                   "CPT/HCPCS procedure code 101"
label var CPT102                   "CPT/HCPCS procedure code 102"
label var CPT103                   "CPT/HCPCS procedure code 103"
label var CPT104                   "CPT/HCPCS procedure code 104"
label var CPT105                   "CPT/HCPCS procedure code 105"
label var CPT106                   "CPT/HCPCS procedure code 106"
label var CPT107                   "CPT/HCPCS procedure code 107"
label var CPT108                   "CPT/HCPCS procedure code 108"
label var CPT109                   "CPT/HCPCS procedure code 109"
label var CPT110                   "CPT/HCPCS procedure code 110"
label var CPT111                   "CPT/HCPCS procedure code 111"
label var CPT112                   "CPT/HCPCS procedure code 112"
label var CPT113                   "CPT/HCPCS procedure code 113"
label var CPT114                   "CPT/HCPCS procedure code 114"
label var CPT115                   "CPT/HCPCS procedure code 115"
label var CPT116                   "CPT/HCPCS procedure code 116"
label var CPT117                   "CPT/HCPCS procedure code 117"
label var CPT118                   "CPT/HCPCS procedure code 118"
label var CPT119                   "CPT/HCPCS procedure code 119"
label var CPT120                   "CPT/HCPCS procedure code 120"
label var CPT121                   "CPT/HCPCS procedure code 121"
label var CPT122                   "CPT/HCPCS procedure code 122"
label var CPT123                   "CPT/HCPCS procedure code 123"
label var CPT124                   "CPT/HCPCS procedure code 124"
label var CPT125                   "CPT/HCPCS procedure code 125"
label var CPT126                   "CPT/HCPCS procedure code 126"
label var CPT127                   "CPT/HCPCS procedure code 127"
label var CPT128                   "CPT/HCPCS procedure code 128"
label var CPT129                   "CPT/HCPCS procedure code 129"
label var CPT130                   "CPT/HCPCS procedure code 130"
label var CPT131                   "CPT/HCPCS procedure code 131"
label var CPT132                   "CPT/HCPCS procedure code 132"
label var CPT133                   "CPT/HCPCS procedure code 133"
label var CPT134                   "CPT/HCPCS procedure code 134"
label var CPT135                   "CPT/HCPCS procedure code 135"
label var CPT136                   "CPT/HCPCS procedure code 136"
label var CPT137                   "CPT/HCPCS procedure code 137"
label var CPT138                   "CPT/HCPCS procedure code 138"
label var CPT139                   "CPT/HCPCS procedure code 139"
label var CPT140                   "CPT/HCPCS procedure code 140"
label var CPT141                   "CPT/HCPCS procedure code 141"
label var CPT142                   "CPT/HCPCS procedure code 142"
label var CPT143                   "CPT/HCPCS procedure code 143"
label var CPT144                   "CPT/HCPCS procedure code 144"
label var CPT145                   "CPT/HCPCS procedure code 145"
label var CPT146                   "CPT/HCPCS procedure code 146"
label var CPT147                   "CPT/HCPCS procedure code 147"
label var CPT148                   "CPT/HCPCS procedure code 148"
label var CPT149                   "CPT/HCPCS procedure code 149"
label var CPT150                   "CPT/HCPCS procedure code 150"
label var CPT151                   "CPT/HCPCS procedure code 151"
label var CPT152                   "CPT/HCPCS procedure code 152"
label var CPT153                   "CPT/HCPCS procedure code 153"
label var CPT154                   "CPT/HCPCS procedure code 154"
label var CPT155                   "CPT/HCPCS procedure code 155"
label var CPT156                   "CPT/HCPCS procedure code 156"
label var CPT157                   "CPT/HCPCS procedure code 157"
label var CPT158                   "CPT/HCPCS procedure code 158"
label var CPT159                   "CPT/HCPCS procedure code 159"
label var CPT160                   "CPT/HCPCS procedure code 160"
label var CPT161                   "CPT/HCPCS procedure code 161"
label var CPT162                   "CPT/HCPCS procedure code 162"
label var CPT163                   "CPT/HCPCS procedure code 163"
label var CPT164                   "CPT/HCPCS procedure code 164"
label var CPT165                   "CPT/HCPCS procedure code 165"
label var CPT166                   "CPT/HCPCS procedure code 166"
label var CPT167                   "CPT/HCPCS procedure code 167"
label var CPT168                   "CPT/HCPCS procedure code 168"
label var CPT169                   "CPT/HCPCS procedure code 169"
label var CPT170                   "CPT/HCPCS procedure code 170"
label var CPT171                   "CPT/HCPCS procedure code 171"
label var CPT172                   "CPT/HCPCS procedure code 172"
label var CPT173                   "CPT/HCPCS procedure code 173"
label var CPT174                   "CPT/HCPCS procedure code 174"
label var CPT175                   "CPT/HCPCS procedure code 175"
label var CPT176                   "CPT/HCPCS procedure code 176"
label var CPT177                   "CPT/HCPCS procedure code 177"
label var CPT178                   "CPT/HCPCS procedure code 178"
label var CPT179                   "CPT/HCPCS procedure code 179"
label var CPT180                   "CPT/HCPCS procedure code 180"
label var CPT181                   "CPT/HCPCS procedure code 181"
label var CPT182                   "CPT/HCPCS procedure code 182"
label var CPT183                   "CPT/HCPCS procedure code 183"
label var CPT184                   "CPT/HCPCS procedure code 184"
label var CPT185                   "CPT/HCPCS procedure code 185"
label var CPT186                   "CPT/HCPCS procedure code 186"
label var CPT187                   "CPT/HCPCS procedure code 187"
label var CPT188                   "CPT/HCPCS procedure code 188"
label var CPT189                   "CPT/HCPCS procedure code 189"
label var CPT190                   "CPT/HCPCS procedure code 190"
label var CPT191                   "CPT/HCPCS procedure code 191"
label var CPT192                   "CPT/HCPCS procedure code 192"
label var CPT193                   "CPT/HCPCS procedure code 193"
label var CPT194                   "CPT/HCPCS procedure code 194"
label var CPT195                   "CPT/HCPCS procedure code 195"
label var CPT196                   "CPT/HCPCS procedure code 196"
label var CPT197                   "CPT/HCPCS procedure code 197"
label var CPT198                   "CPT/HCPCS procedure code 198"
label var CPT199                   "CPT/HCPCS procedure code 199"
label var CPT200                   "CPT/HCPCS procedure code 200"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTCCS7                  "CCS: CPT 7"
label var CPTCCS8                  "CCS: CPT 8"
label var CPTCCS9                  "CCS: CPT 9"
label var CPTCCS10                 "CCS: CPT 10"
label var CPTCCS11                 "CCS: CPT 11"
label var CPTCCS12                 "CCS: CPT 12"
label var CPTCCS13                 "CCS: CPT 13"
label var CPTCCS14                 "CCS: CPT 14"
label var CPTCCS15                 "CCS: CPT 15"
label var CPTCCS16                 "CCS: CPT 16"
label var CPTCCS17                 "CCS: CPT 17"
label var CPTCCS18                 "CCS: CPT 18"
label var CPTCCS19                 "CCS: CPT 19"
label var CPTCCS20                 "CCS: CPT 20"
label var CPTCCS21                 "CCS: CPT 21"
label var CPTCCS22                 "CCS: CPT 22"
label var CPTCCS23                 "CCS: CPT 23"
label var CPTCCS24                 "CCS: CPT 24"
label var CPTCCS25                 "CCS: CPT 25"
label var CPTCCS26                 "CCS: CPT 26"
label var CPTCCS27                 "CCS: CPT 27"
label var CPTCCS28                 "CCS: CPT 28"
label var CPTCCS29                 "CCS: CPT 29"
label var CPTCCS30                 "CCS: CPT 30"
label var CPTCCS31                 "CCS: CPT 31"
label var CPTCCS32                 "CCS: CPT 32"
label var CPTCCS33                 "CCS: CPT 33"
label var CPTCCS34                 "CCS: CPT 34"
label var CPTCCS35                 "CCS: CPT 35"
label var CPTCCS36                 "CCS: CPT 36"
label var CPTCCS37                 "CCS: CPT 37"
label var CPTCCS38                 "CCS: CPT 38"
label var CPTCCS39                 "CCS: CPT 39"
label var CPTCCS40                 "CCS: CPT 40"
label var CPTCCS41                 "CCS: CPT 41"
label var CPTCCS42                 "CCS: CPT 42"
label var CPTCCS43                 "CCS: CPT 43"
label var CPTCCS44                 "CCS: CPT 44"
label var CPTCCS45                 "CCS: CPT 45"
label var CPTCCS46                 "CCS: CPT 46"
label var CPTCCS47                 "CCS: CPT 47"
label var CPTCCS48                 "CCS: CPT 48"
label var CPTCCS49                 "CCS: CPT 49"
label var CPTCCS50                 "CCS: CPT 50"
label var CPTCCS51                 "CCS: CPT 51"
label var CPTCCS52                 "CCS: CPT 52"
label var CPTCCS53                 "CCS: CPT 53"
label var CPTCCS54                 "CCS: CPT 54"
label var CPTCCS55                 "CCS: CPT 55"
label var CPTCCS56                 "CCS: CPT 56"
label var CPTCCS57                 "CCS: CPT 57"
label var CPTCCS58                 "CCS: CPT 58"
label var CPTCCS59                 "CCS: CPT 59"
label var CPTCCS60                 "CCS: CPT 60"
label var CPTCCS61                 "CCS: CPT 61"
label var CPTCCS62                 "CCS: CPT 62"
label var CPTCCS63                 "CCS: CPT 63"
label var CPTCCS64                 "CCS: CPT 64"
label var CPTCCS65                 "CCS: CPT 65"
label var CPTCCS66                 "CCS: CPT 66"
label var CPTCCS67                 "CCS: CPT 67"
label var CPTCCS68                 "CCS: CPT 68"
label var CPTCCS69                 "CCS: CPT 69"
label var CPTCCS70                 "CCS: CPT 70"
label var CPTCCS71                 "CCS: CPT 71"
label var CPTCCS72                 "CCS: CPT 72"
label var CPTCCS73                 "CCS: CPT 73"
label var CPTCCS74                 "CCS: CPT 74"
label var CPTCCS75                 "CCS: CPT 75"
label var CPTCCS76                 "CCS: CPT 76"
label var CPTCCS77                 "CCS: CPT 77"
label var CPTCCS78                 "CCS: CPT 78"
label var CPTCCS79                 "CCS: CPT 79"
label var CPTCCS80                 "CCS: CPT 80"
label var CPTCCS81                 "CCS: CPT 81"
label var CPTCCS82                 "CCS: CPT 82"
label var CPTCCS83                 "CCS: CPT 83"
label var CPTCCS84                 "CCS: CPT 84"
label var CPTCCS85                 "CCS: CPT 85"
label var CPTCCS86                 "CCS: CPT 86"
label var CPTCCS87                 "CCS: CPT 87"
label var CPTCCS88                 "CCS: CPT 88"
label var CPTCCS89                 "CCS: CPT 89"
label var CPTCCS90                 "CCS: CPT 90"
label var CPTCCS91                 "CCS: CPT 91"
label var CPTCCS92                 "CCS: CPT 92"
label var CPTCCS93                 "CCS: CPT 93"
label var CPTCCS94                 "CCS: CPT 94"
label var CPTCCS95                 "CCS: CPT 95"
label var CPTCCS96                 "CCS: CPT 96"
label var CPTCCS97                 "CCS: CPT 97"
label var CPTCCS98                 "CCS: CPT 98"
label var CPTCCS99                 "CCS: CPT 99"
label var CPTCCS100                "CCS: CPT 100"
label var CPTCCS101                "CCS: CPT 101"
label var CPTCCS102                "CCS: CPT 102"
label var CPTCCS103                "CCS: CPT 103"
label var CPTCCS104                "CCS: CPT 104"
label var CPTCCS105                "CCS: CPT 105"
label var CPTCCS106                "CCS: CPT 106"
label var CPTCCS107                "CCS: CPT 107"
label var CPTCCS108                "CCS: CPT 108"
label var CPTCCS109                "CCS: CPT 109"
label var CPTCCS110                "CCS: CPT 110"
label var CPTCCS111                "CCS: CPT 111"
label var CPTCCS112                "CCS: CPT 112"
label var CPTCCS113                "CCS: CPT 113"
label var CPTCCS114                "CCS: CPT 114"
label var CPTCCS115                "CCS: CPT 115"
label var CPTCCS116                "CCS: CPT 116"
label var CPTCCS117                "CCS: CPT 117"
label var CPTCCS118                "CCS: CPT 118"
label var CPTCCS119                "CCS: CPT 119"
label var CPTCCS120                "CCS: CPT 120"
label var CPTCCS121                "CCS: CPT 121"
label var CPTCCS122                "CCS: CPT 122"
label var CPTCCS123                "CCS: CPT 123"
label var CPTCCS124                "CCS: CPT 124"
label var CPTCCS125                "CCS: CPT 125"
label var CPTCCS126                "CCS: CPT 126"
label var CPTCCS127                "CCS: CPT 127"
label var CPTCCS128                "CCS: CPT 128"
label var CPTCCS129                "CCS: CPT 129"
label var CPTCCS130                "CCS: CPT 130"
label var CPTCCS131                "CCS: CPT 131"
label var CPTCCS132                "CCS: CPT 132"
label var CPTCCS133                "CCS: CPT 133"
label var CPTCCS134                "CCS: CPT 134"
label var CPTCCS135                "CCS: CPT 135"
label var CPTCCS136                "CCS: CPT 136"
label var CPTCCS137                "CCS: CPT 137"
label var CPTCCS138                "CCS: CPT 138"
label var CPTCCS139                "CCS: CPT 139"
label var CPTCCS140                "CCS: CPT 140"
label var CPTCCS141                "CCS: CPT 141"
label var CPTCCS142                "CCS: CPT 142"
label var CPTCCS143                "CCS: CPT 143"
label var CPTCCS144                "CCS: CPT 144"
label var CPTCCS145                "CCS: CPT 145"
label var CPTCCS146                "CCS: CPT 146"
label var CPTCCS147                "CCS: CPT 147"
label var CPTCCS148                "CCS: CPT 148"
label var CPTCCS149                "CCS: CPT 149"
label var CPTCCS150                "CCS: CPT 150"
label var CPTCCS151                "CCS: CPT 151"
label var CPTCCS152                "CCS: CPT 152"
label var CPTCCS153                "CCS: CPT 153"
label var CPTCCS154                "CCS: CPT 154"
label var CPTCCS155                "CCS: CPT 155"
label var CPTCCS156                "CCS: CPT 156"
label var CPTCCS157                "CCS: CPT 157"
label var CPTCCS158                "CCS: CPT 158"
label var CPTCCS159                "CCS: CPT 159"
label var CPTCCS160                "CCS: CPT 160"
label var CPTCCS161                "CCS: CPT 161"
label var CPTCCS162                "CCS: CPT 162"
label var CPTCCS163                "CCS: CPT 163"
label var CPTCCS164                "CCS: CPT 164"
label var CPTCCS165                "CCS: CPT 165"
label var CPTCCS166                "CCS: CPT 166"
label var CPTCCS167                "CCS: CPT 167"
label var CPTCCS168                "CCS: CPT 168"
label var CPTCCS169                "CCS: CPT 169"
label var CPTCCS170                "CCS: CPT 170"
label var CPTCCS171                "CCS: CPT 171"
label var CPTCCS172                "CCS: CPT 172"
label var CPTCCS173                "CCS: CPT 173"
label var CPTCCS174                "CCS: CPT 174"
label var CPTCCS175                "CCS: CPT 175"
label var CPTCCS176                "CCS: CPT 176"
label var CPTCCS177                "CCS: CPT 177"
label var CPTCCS178                "CCS: CPT 178"
label var CPTCCS179                "CCS: CPT 179"
label var CPTCCS180                "CCS: CPT 180"
label var CPTCCS181                "CCS: CPT 181"
label var CPTCCS182                "CCS: CPT 182"
label var CPTCCS183                "CCS: CPT 183"
label var CPTCCS184                "CCS: CPT 184"
label var CPTCCS185                "CCS: CPT 185"
label var CPTCCS186                "CCS: CPT 186"
label var CPTCCS187                "CCS: CPT 187"
label var CPTCCS188                "CCS: CPT 188"
label var CPTCCS189                "CCS: CPT 189"
label var CPTCCS190                "CCS: CPT 190"
label var CPTCCS191                "CCS: CPT 191"
label var CPTCCS192                "CCS: CPT 192"
label var CPTCCS193                "CCS: CPT 193"
label var CPTCCS194                "CCS: CPT 194"
label var CPTCCS195                "CCS: CPT 195"
label var CPTCCS196                "CCS: CPT 196"
label var CPTCCS197                "CCS: CPT 197"
label var CPTCCS198                "CCS: CPT 198"
label var CPTCCS199                "CCS: CPT 199"
label var CPTCCS200                "CCS: CPT 200"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HCUP_SURGERY_BROAD_CPT   "Number of reported CPT procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_NARROW_CPT  "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
label var HOSPST                   "Hospital state postal code"
label var I10_DX_Visit_Reason1     "ICD-10-CM Reason for visit diagnosis 1"
label var I10_DX_Visit_Reason2     "ICD-10-CM Reason for visit diagnosis 2"
label var I10_DX_Visit_Reason3     "ICD-10-CM Reason for visit diagnosis 3"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var KEY                      "HCUP record identifier"
label var MDSPEC1                  "Physician 1 specialty (as received from source)"
label var MDSPEC2                  "Physician 2 specialty (as received from source)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PSTATE                   "Patient State postal code"
label var PSTATE_GEO               "Patient State postal code assigned from ZIP Code"
label var PSTCO                    "Patient state/county FIPS code"
label var RACE                     "Race (uniform)"
label var RACE_X                   "Race (as received from source)"
label var SASD_SEDD                "SASD and SEDD indicator"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AGEGROUP                 "Age Group"
label var AYEAR                    "Admission year"

/*** Convert special values to missing values ***/
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTCCS7                   (-99 -88 -66=.)
recode CPTCCS8                   (-99 -88 -66=.)
recode CPTCCS9                   (-99 -88 -66=.)
recode CPTCCS10                  (-99 -88 -66=.)
recode CPTCCS11                  (-99 -88 -66=.)
recode CPTCCS12                  (-99 -88 -66=.)
recode CPTCCS13                  (-99 -88 -66=.)
recode CPTCCS14                  (-99 -88 -66=.)
recode CPTCCS15                  (-99 -88 -66=.)
recode CPTCCS16                  (-99 -88 -66=.)
recode CPTCCS17                  (-99 -88 -66=.)
recode CPTCCS18                  (-99 -88 -66=.)
recode CPTCCS19                  (-99 -88 -66=.)
recode CPTCCS20                  (-99 -88 -66=.)
recode CPTCCS21                  (-99 -88 -66=.)
recode CPTCCS22                  (-99 -88 -66=.)
recode CPTCCS23                  (-99 -88 -66=.)
recode CPTCCS24                  (-99 -88 -66=.)
recode CPTCCS25                  (-99 -88 -66=.)
recode CPTCCS26                  (-99 -88 -66=.)
recode CPTCCS27                  (-99 -88 -66=.)
recode CPTCCS28                  (-99 -88 -66=.)
recode CPTCCS29                  (-99 -88 -66=.)
recode CPTCCS30                  (-99 -88 -66=.)
recode CPTCCS31                  (-99 -88 -66=.)
recode CPTCCS32                  (-99 -88 -66=.)
recode CPTCCS33                  (-99 -88 -66=.)
recode CPTCCS34                  (-99 -88 -66=.)
recode CPTCCS35                  (-99 -88 -66=.)
recode CPTCCS36                  (-99 -88 -66=.)
recode CPTCCS37                  (-99 -88 -66=.)
recode CPTCCS38                  (-99 -88 -66=.)
recode CPTCCS39                  (-99 -88 -66=.)
recode CPTCCS40                  (-99 -88 -66=.)
recode CPTCCS41                  (-99 -88 -66=.)
recode CPTCCS42                  (-99 -88 -66=.)
recode CPTCCS43                  (-99 -88 -66=.)
recode CPTCCS44                  (-99 -88 -66=.)
recode CPTCCS45                  (-99 -88 -66=.)
recode CPTCCS46                  (-99 -88 -66=.)
recode CPTCCS47                  (-99 -88 -66=.)
recode CPTCCS48                  (-99 -88 -66=.)
recode CPTCCS49                  (-99 -88 -66=.)
recode CPTCCS50                  (-99 -88 -66=.)
recode CPTCCS51                  (-99 -88 -66=.)
recode CPTCCS52                  (-99 -88 -66=.)
recode CPTCCS53                  (-99 -88 -66=.)
recode CPTCCS54                  (-99 -88 -66=.)
recode CPTCCS55                  (-99 -88 -66=.)
recode CPTCCS56                  (-99 -88 -66=.)
recode CPTCCS57                  (-99 -88 -66=.)
recode CPTCCS58                  (-99 -88 -66=.)
recode CPTCCS59                  (-99 -88 -66=.)
recode CPTCCS60                  (-99 -88 -66=.)
recode CPTCCS61                  (-99 -88 -66=.)
recode CPTCCS62                  (-99 -88 -66=.)
recode CPTCCS63                  (-99 -88 -66=.)
recode CPTCCS64                  (-99 -88 -66=.)
recode CPTCCS65                  (-99 -88 -66=.)
recode CPTCCS66                  (-99 -88 -66=.)
recode CPTCCS67                  (-99 -88 -66=.)
recode CPTCCS68                  (-99 -88 -66=.)
recode CPTCCS69                  (-99 -88 -66=.)
recode CPTCCS70                  (-99 -88 -66=.)
recode CPTCCS71                  (-99 -88 -66=.)
recode CPTCCS72                  (-99 -88 -66=.)
recode CPTCCS73                  (-99 -88 -66=.)
recode CPTCCS74                  (-99 -88 -66=.)
recode CPTCCS75                  (-99 -88 -66=.)
recode CPTCCS76                  (-99 -88 -66=.)
recode CPTCCS77                  (-99 -88 -66=.)
recode CPTCCS78                  (-99 -88 -66=.)
recode CPTCCS79                  (-99 -88 -66=.)
recode CPTCCS80                  (-99 -88 -66=.)
recode CPTCCS81                  (-99 -88 -66=.)
recode CPTCCS82                  (-99 -88 -66=.)
recode CPTCCS83                  (-99 -88 -66=.)
recode CPTCCS84                  (-99 -88 -66=.)
recode CPTCCS85                  (-99 -88 -66=.)
recode CPTCCS86                  (-99 -88 -66=.)
recode CPTCCS87                  (-99 -88 -66=.)
recode CPTCCS88                  (-99 -88 -66=.)
recode CPTCCS89                  (-99 -88 -66=.)
recode CPTCCS90                  (-99 -88 -66=.)
recode CPTCCS91                  (-99 -88 -66=.)
recode CPTCCS92                  (-99 -88 -66=.)
recode CPTCCS93                  (-99 -88 -66=.)
recode CPTCCS94                  (-99 -88 -66=.)
recode CPTCCS95                  (-99 -88 -66=.)
recode CPTCCS96                  (-99 -88 -66=.)
recode CPTCCS97                  (-99 -88 -66=.)
recode CPTCCS98                  (-99 -88 -66=.)
recode CPTCCS99                  (-99 -88 -66=.)
recode CPTCCS100                 (-99 -88 -66=.)
recode CPTCCS101                 (-99 -88 -66=.)
recode CPTCCS102                 (-99 -88 -66=.)
recode CPTCCS103                 (-99 -88 -66=.)
recode CPTCCS104                 (-99 -88 -66=.)
recode CPTCCS105                 (-99 -88 -66=.)
recode CPTCCS106                 (-99 -88 -66=.)
recode CPTCCS107                 (-99 -88 -66=.)
recode CPTCCS108                 (-99 -88 -66=.)
recode CPTCCS109                 (-99 -88 -66=.)
recode CPTCCS110                 (-99 -88 -66=.)
recode CPTCCS111                 (-99 -88 -66=.)
recode CPTCCS112                 (-99 -88 -66=.)
recode CPTCCS113                 (-99 -88 -66=.)
recode CPTCCS114                 (-99 -88 -66=.)
recode CPTCCS115                 (-99 -88 -66=.)
recode CPTCCS116                 (-99 -88 -66=.)
recode CPTCCS117                 (-99 -88 -66=.)
recode CPTCCS118                 (-99 -88 -66=.)
recode CPTCCS119                 (-99 -88 -66=.)
recode CPTCCS120                 (-99 -88 -66=.)
recode CPTCCS121                 (-99 -88 -66=.)
recode CPTCCS122                 (-99 -88 -66=.)
recode CPTCCS123                 (-99 -88 -66=.)
recode CPTCCS124                 (-99 -88 -66=.)
recode CPTCCS125                 (-99 -88 -66=.)
recode CPTCCS126                 (-99 -88 -66=.)
recode CPTCCS127                 (-99 -88 -66=.)
recode CPTCCS128                 (-99 -88 -66=.)
recode CPTCCS129                 (-99 -88 -66=.)
recode CPTCCS130                 (-99 -88 -66=.)
recode CPTCCS131                 (-99 -88 -66=.)
recode CPTCCS132                 (-99 -88 -66=.)
recode CPTCCS133                 (-99 -88 -66=.)
recode CPTCCS134                 (-99 -88 -66=.)
recode CPTCCS135                 (-99 -88 -66=.)
recode CPTCCS136                 (-99 -88 -66=.)
recode CPTCCS137                 (-99 -88 -66=.)
recode CPTCCS138                 (-99 -88 -66=.)
recode CPTCCS139                 (-99 -88 -66=.)
recode CPTCCS140                 (-99 -88 -66=.)
recode CPTCCS141                 (-99 -88 -66=.)
recode CPTCCS142                 (-99 -88 -66=.)
recode CPTCCS143                 (-99 -88 -66=.)
recode CPTCCS144                 (-99 -88 -66=.)
recode CPTCCS145                 (-99 -88 -66=.)
recode CPTCCS146                 (-99 -88 -66=.)
recode CPTCCS147                 (-99 -88 -66=.)
recode CPTCCS148                 (-99 -88 -66=.)
recode CPTCCS149                 (-99 -88 -66=.)
recode CPTCCS150                 (-99 -88 -66=.)
recode CPTCCS151                 (-99 -88 -66=.)
recode CPTCCS152                 (-99 -88 -66=.)
recode CPTCCS153                 (-99 -88 -66=.)
recode CPTCCS154                 (-99 -88 -66=.)
recode CPTCCS155                 (-99 -88 -66=.)
recode CPTCCS156                 (-99 -88 -66=.)
recode CPTCCS157                 (-99 -88 -66=.)
recode CPTCCS158                 (-99 -88 -66=.)
recode CPTCCS159                 (-99 -88 -66=.)
recode CPTCCS160                 (-99 -88 -66=.)
recode CPTCCS161                 (-99 -88 -66=.)
recode CPTCCS162                 (-99 -88 -66=.)
recode CPTCCS163                 (-99 -88 -66=.)
recode CPTCCS164                 (-99 -88 -66=.)
recode CPTCCS165                 (-99 -88 -66=.)
recode CPTCCS166                 (-99 -88 -66=.)
recode CPTCCS167                 (-99 -88 -66=.)
recode CPTCCS168                 (-99 -88 -66=.)
recode CPTCCS169                 (-99 -88 -66=.)
recode CPTCCS170                 (-99 -88 -66=.)
recode CPTCCS171                 (-99 -88 -66=.)
recode CPTCCS172                 (-99 -88 -66=.)
recode CPTCCS173                 (-99 -88 -66=.)
recode CPTCCS174                 (-99 -88 -66=.)
recode CPTCCS175                 (-99 -88 -66=.)
recode CPTCCS176                 (-99 -88 -66=.)
recode CPTCCS177                 (-99 -88 -66=.)
recode CPTCCS178                 (-99 -88 -66=.)
recode CPTCCS179                 (-99 -88 -66=.)
recode CPTCCS180                 (-99 -88 -66=.)
recode CPTCCS181                 (-99 -88 -66=.)
recode CPTCCS182                 (-99 -88 -66=.)
recode CPTCCS183                 (-99 -88 -66=.)
recode CPTCCS184                 (-99 -88 -66=.)
recode CPTCCS185                 (-99 -88 -66=.)
recode CPTCCS186                 (-99 -88 -66=.)
recode CPTCCS187                 (-99 -88 -66=.)
recode CPTCCS188                 (-99 -88 -66=.)
recode CPTCCS189                 (-99 -88 -66=.)
recode CPTCCS190                 (-99 -88 -66=.)
recode CPTCCS191                 (-99 -88 -66=.)
recode CPTCCS192                 (-99 -88 -66=.)
recode CPTCCS193                 (-99 -88 -66=.)
recode CPTCCS194                 (-99 -88 -66=.)
recode CPTCCS195                 (-99 -88 -66=.)
recode CPTCCS196                 (-99 -88 -66=.)
recode CPTCCS197                 (-99 -88 -66=.)
recode CPTCCS198                 (-99 -88 -66=.)
recode CPTCCS199                 (-99 -88 -66=.)
recode CPTCCS200                 (-99 -88 -66=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HCUP_SURGERY_BROAD_CPT    (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_CPT   (-9999 -8888 -6666=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode NCPT                      (-999 -888 -666=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode SASD_SEDD                 (-9 -8 -6 -5=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AGEGROUP                  (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)

save "SC_SASD_2023_CORE.dta", replace
