/*******************************************************************
* Creation Date: 02/07/2024   
*   AK_SEDD_2021_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'AK_SEDD_2021_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEMONTH                        4-   6
 AHOUR                           7-  10
 AMONTH                         11-  12
 ATYPE                          13-  14
 AWEEKEND                       15-  16
 BILLTYPE                       17-  20 (A)
 CPT1                           21-  25 (A)
 CPT2                           26-  30 (A)
 CPT3                           31-  35 (A)
 CPT4                           36-  40 (A)
 CPT5                           41-  45 (A)
 CPT6                           46-  50 (A)
 CPT7                           51-  55 (A)
 CPT8                           56-  60 (A)
 CPT9                           61-  65 (A)
 CPT10                          66-  70 (A)
 CPT11                          71-  75 (A)
 CPT12                          76-  80 (A)
 CPT13                          81-  85 (A)
 CPT14                          86-  90 (A)
 CPT15                          91-  95 (A)
 CPT16                          96- 100 (A)
 CPT17                         101- 105 (A)
 CPT18                         106- 110 (A)
 CPT19                         111- 115 (A)
 CPT20                         116- 120 (A)
 CPT21                         121- 125 (A)
 CPT22                         126- 130 (A)
 CPT23                         131- 135 (A)
 CPT24                         136- 140 (A)
 CPT25                         141- 145 (A)
 CPT26                         146- 150 (A)
 CPT27                         151- 155 (A)
 CPT28                         156- 160 (A)
 CPT29                         161- 165 (A)
 CPT30                         166- 170 (A)
 CPT31                         171- 175 (A)
 CPT32                         176- 180 (A)
 CPT33                         181- 185 (A)
 CPT34                         186- 190 (A)
 CPT35                         191- 195 (A)
 CPT36                         196- 200 (A)
 CPT37                         201- 205 (A)
 CPT38                         206- 210 (A)
 CPT39                         211- 215 (A)
 CPT40                         216- 220 (A)
 CPT41                         221- 225 (A)
 CPT42                         226- 230 (A)
 CPT43                         231- 235 (A)
 CPT44                         236- 240 (A)
 CPT45                         241- 245 (A)
 CPT46                         246- 250 (A)
 CPT47                         251- 255 (A)
 CPT48                         256- 260 (A)
 CPT49                         261- 265 (A)
 CPT50                         266- 270 (A)
 CPT51                         271- 275 (A)
 CPT52                         276- 280 (A)
 CPT53                         281- 285 (A)
 CPT54                         286- 290 (A)
 CPT55                         291- 295 (A)
 CPT56                         296- 300 (A)
 CPT57                         301- 305 (A)
 CPT58                         306- 310 (A)
 CPT59                         311- 315 (A)
 CPT60                         316- 320 (A)
 CPT61                         321- 325 (A)
 CPT62                         326- 330 (A)
 CPT63                         331- 335 (A)
 CPT64                         336- 340 (A)
 CPT65                         341- 345 (A)
 CPT66                         346- 350 (A)
 CPT67                         351- 355 (A)
 CPT68                         356- 360 (A)
 CPT69                         361- 365 (A)
 CPT70                         366- 370 (A)
 CPT71                         371- 375 (A)
 CPT72                         376- 380 (A)
 CPT73                         381- 385 (A)
 CPT74                         386- 390 (A)
 CPT75                         391- 395 (A)
 CPT76                         396- 400 (A)
 CPT77                         401- 405 (A)
 CPT78                         406- 410 (A)
 CPT79                         411- 415 (A)
 CPT80                         416- 420 (A)
 CPT81                         421- 425 (A)
 CPT82                         426- 430 (A)
 CPT83                         431- 435 (A)
 CPT84                         436- 440 (A)
 CPT85                         441- 445 (A)
 CPT86                         446- 450 (A)
 CPT87                         451- 455 (A)
 CPT88                         456- 460 (A)
 CPT89                         461- 465 (A)
 CPT90                         466- 470 (A)
 CPT91                         471- 475 (A)
 CPT92                         476- 480 (A)
 CPT93                         481- 485 (A)
 CPT94                         486- 490 (A)
 CPT95                         491- 495 (A)
 CPT96                         496- 500 (A)
 CPT97                         501- 505 (A)
 CPT98                         506- 510 (A)
 CPT99                         511- 515 (A)
 CPT100                        516- 520 (A)
 CPT101                        521- 525 (A)
 CPT102                        526- 530 (A)
 CPT103                        531- 535 (A)
 CPT104                        536- 540 (A)
 CPT105                        541- 545 (A)
 CPT106                        546- 550 (A)
 CPT107                        551- 555 (A)
 CPT108                        556- 560 (A)
 CPT109                        561- 565 (A)
 CPT110                        566- 570 (A)
 CPT111                        571- 575 (A)
 CPT112                        576- 580 (A)
 CPT113                        581- 585 (A)
 CPT114                        586- 590 (A)
 CPT115                        591- 595 (A)
 CPT116                        596- 600 (A)
 CPT117                        601- 605 (A)
 CPT118                        606- 610 (A)
 CPTCCS1                       611- 613
 CPTCCS2                       614- 616
 CPTCCS3                       617- 619
 CPTCCS4                       620- 622
 CPTCCS5                       623- 625
 CPTCCS6                       626- 628
 CPTCCS7                       629- 631
 CPTCCS8                       632- 634
 CPTCCS9                       635- 637
 CPTCCS10                      638- 640
 CPTCCS11                      641- 643
 CPTCCS12                      644- 646
 CPTCCS13                      647- 649
 CPTCCS14                      650- 652
 CPTCCS15                      653- 655
 CPTCCS16                      656- 658
 CPTCCS17                      659- 661
 CPTCCS18                      662- 664
 CPTCCS19                      665- 667
 CPTCCS20                      668- 670
 CPTCCS21                      671- 673
 CPTCCS22                      674- 676
 CPTCCS23                      677- 679
 CPTCCS24                      680- 682
 CPTCCS25                      683- 685
 CPTCCS26                      686- 688
 CPTCCS27                      689- 691
 CPTCCS28                      692- 694
 CPTCCS29                      695- 697
 CPTCCS30                      698- 700
 CPTCCS31                      701- 703
 CPTCCS32                      704- 706
 CPTCCS33                      707- 709
 CPTCCS34                      710- 712
 CPTCCS35                      713- 715
 CPTCCS36                      716- 718
 CPTCCS37                      719- 721
 CPTCCS38                      722- 724
 CPTCCS39                      725- 727
 CPTCCS40                      728- 730
 CPTCCS41                      731- 733
 CPTCCS42                      734- 736
 CPTCCS43                      737- 739
 CPTCCS44                      740- 742
 CPTCCS45                      743- 745
 CPTCCS46                      746- 748
 CPTCCS47                      749- 751
 CPTCCS48                      752- 754
 CPTCCS49                      755- 757
 CPTCCS50                      758- 760
 CPTCCS51                      761- 763
 CPTCCS52                      764- 766
 CPTCCS53                      767- 769
 CPTCCS54                      770- 772
 CPTCCS55                      773- 775
 CPTCCS56                      776- 778
 CPTCCS57                      779- 781
 CPTCCS58                      782- 784
 CPTCCS59                      785- 787
 CPTCCS60                      788- 790
 CPTCCS61                      791- 793
 CPTCCS62                      794- 796
 CPTCCS63                      797- 799
 CPTCCS64                      800- 802
 CPTCCS65                      803- 805
 CPTCCS66                      806- 808
 CPTCCS67                      809- 811
 CPTCCS68                      812- 814
 CPTCCS69                      815- 817
 CPTCCS70                      818- 820
 CPTCCS71                      821- 823
 CPTCCS72                      824- 826
 CPTCCS73                      827- 829
 CPTCCS74                      830- 832
 CPTCCS75                      833- 835
 CPTCCS76                      836- 838
 CPTCCS77                      839- 841
 CPTCCS78                      842- 844
 CPTCCS79                      845- 847
 CPTCCS80                      848- 850
 CPTCCS81                      851- 853
 CPTCCS82                      854- 856
 CPTCCS83                      857- 859
 CPTCCS84                      860- 862
 CPTCCS85                      863- 865
 CPTCCS86                      866- 868
 CPTCCS87                      869- 871
 CPTCCS88                      872- 874
 CPTCCS89                      875- 877
 CPTCCS90                      878- 880
 CPTCCS91                      881- 883
 CPTCCS92                      884- 886
 CPTCCS93                      887- 889
 CPTCCS94                      890- 892
 CPTCCS95                      893- 895
 CPTCCS96                      896- 898
 CPTCCS97                      899- 901
 CPTCCS98                      902- 904
 CPTCCS99                      905- 907
 CPTCCS100                     908- 910
 CPTCCS101                     911- 913
 CPTCCS102                     914- 916
 CPTCCS103                     917- 919
 CPTCCS104                     920- 922
 CPTCCS105                     923- 925
 CPTCCS106                     926- 928
 CPTCCS107                     929- 931
 CPTCCS108                     932- 934
 CPTCCS109                     935- 937
 CPTCCS110                     938- 940
 CPTCCS111                     941- 943
 CPTCCS112                     944- 946
 CPTCCS113                     947- 949
 CPTCCS114                     950- 952
 CPTCCS115                     953- 955
 CPTCCS116                     956- 958
 CPTCCS117                     959- 961
 CPTCCS118                     962- 964
 CPTDAY1                       965- 967
 CPTDAY2                       968- 970
 CPTDAY3                       971- 973
 CPTDAY4                       974- 976
 CPTDAY5                       977- 979
 CPTDAY6                       980- 982
 CPTDAY7                       983- 985
 CPTDAY8                       986- 988
 CPTDAY9                       989- 991
 CPTDAY10                      992- 994
 CPTDAY11                      995- 997
 CPTDAY12                      998-1000
 CPTDAY13                     1001-1003
 CPTDAY14                     1004-1006
 CPTDAY15                     1007-1009
 CPTDAY16                     1010-1012
 CPTDAY17                     1013-1015
 CPTDAY18                     1016-1018
 CPTDAY19                     1019-1021
 CPTDAY20                     1022-1024
 CPTDAY21                     1025-1027
 CPTDAY22                     1028-1030
 CPTDAY23                     1031-1033
 CPTDAY24                     1034-1036
 CPTDAY25                     1037-1039
 CPTDAY26                     1040-1042
 CPTDAY27                     1043-1045
 CPTDAY28                     1046-1048
 CPTDAY29                     1049-1051
 CPTDAY30                     1052-1054
 CPTDAY31                     1055-1057
 CPTDAY32                     1058-1060
 CPTDAY33                     1061-1063
 CPTDAY34                     1064-1066
 CPTDAY35                     1067-1069
 CPTDAY36                     1070-1072
 CPTDAY37                     1073-1075
 CPTDAY38                     1076-1078
 CPTDAY39                     1079-1081
 CPTDAY40                     1082-1084
 CPTDAY41                     1085-1087
 CPTDAY42                     1088-1090
 CPTDAY43                     1091-1093
 CPTDAY44                     1094-1096
 CPTDAY45                     1097-1099
 CPTDAY46                     1100-1102
 CPTDAY47                     1103-1105
 CPTDAY48                     1106-1108
 CPTDAY49                     1109-1111
 CPTDAY50                     1112-1114
 CPTDAY51                     1115-1117
 CPTDAY52                     1118-1120
 CPTDAY53                     1121-1123
 CPTDAY54                     1124-1126
 CPTDAY55                     1127-1129
 CPTDAY56                     1130-1132
 CPTDAY57                     1133-1135
 CPTDAY58                     1136-1138
 CPTDAY59                     1139-1141
 CPTDAY60                     1142-1144
 CPTDAY61                     1145-1147
 CPTDAY62                     1148-1150
 CPTDAY63                     1151-1153
 CPTDAY64                     1154-1156
 CPTDAY65                     1157-1159
 CPTDAY66                     1160-1162
 CPTDAY67                     1163-1165
 CPTDAY68                     1166-1168
 CPTDAY69                     1169-1171
 CPTDAY70                     1172-1174
 CPTDAY71                     1175-1177
 CPTDAY72                     1178-1180
 CPTDAY73                     1181-1183
 CPTDAY74                     1184-1186
 CPTDAY75                     1187-1189
 CPTDAY76                     1190-1192
 CPTDAY77                     1193-1195
 CPTDAY78                     1196-1198
 CPTDAY79                     1199-1201
 CPTDAY80                     1202-1204
 CPTDAY81                     1205-1207
 CPTDAY82                     1208-1210
 CPTDAY83                     1211-1213
 CPTDAY84                     1214-1216
 CPTDAY85                     1217-1219
 CPTDAY86                     1220-1222
 CPTDAY87                     1223-1225
 CPTDAY88                     1226-1228
 CPTDAY89                     1229-1231
 CPTDAY90                     1232-1234
 CPTDAY91                     1235-1237
 CPTDAY92                     1238-1240
 CPTDAY93                     1241-1243
 CPTDAY94                     1244-1246
 CPTDAY95                     1247-1249
 CPTDAY96                     1250-1252
 CPTDAY97                     1253-1255
 CPTDAY98                     1256-1258
 CPTDAY99                     1259-1261
 CPTDAY100                    1262-1264
 CPTDAY101                    1265-1267
 CPTDAY102                    1268-1270
 CPTDAY103                    1271-1273
 CPTDAY104                    1274-1276
 CPTDAY105                    1277-1279
 CPTDAY106                    1280-1282
 CPTDAY107                    1283-1285
 CPTDAY108                    1286-1288
 CPTDAY109                    1289-1291
 CPTDAY110                    1292-1294
 CPTDAY111                    1295-1297
 CPTDAY112                    1298-1300
 CPTDAY113                    1301-1303
 CPTDAY114                    1304-1306
 CPTDAY115                    1307-1309
 CPTDAY116                    1310-1312
 CPTDAY117                    1313-1315
 CPTDAY118                    1316-1318
 DaysToEvent                  1319-1324
 DHOUR                        1325-1328
 DIED                         1329-1330
 DISP_X                       1331-1332 (A)
 DISPUB04                     1333-1334
 DISPUNIFORM                  1335-1336
 DMONTH                       1337-1338
 DQTR                         1339-1340
 DURATION                     1341-1346
 DXPOA1                       1347     (A)
 DXPOA2                       1348     (A)
 DXPOA3                       1349     (A)
 DXPOA4                       1350     (A)
 DXPOA5                       1351     (A)
 DXPOA6                       1352     (A)
 DXPOA7                       1353     (A)
 DXPOA8                       1354     (A)
 DXPOA9                       1355     (A)
 DXPOA10                      1356     (A)
 DXPOA11                      1357     (A)
 DXPOA12                      1358     (A)
 DXPOA13                      1359     (A)
 DXPOA14                      1360     (A)
 DXPOA15                      1361     (A)
 DXPOA16                      1362     (A)
 DXPOA17                      1363     (A)
 DXPOA18                      1364     (A)
 DXPOA19                      1365     (A)
 DXPOA20                      1366     (A)
 DXPOA21                      1367     (A)
 DXPOA22                      1368     (A)
 DXPOA23                      1369     (A)
 DXPOA24                      1370     (A)
 DXPOA25                      1371     (A)
 DXPOA26                      1372     (A)
 DXPOA27                      1373     (A)
 DXPOA28                      1374     (A)
 DXPOA29                      1375     (A)
 DXPOA30                      1376     (A)
 FEMALE                       1377-1378
 HCUP_ED                      1379-1380
 HCUP_OS                      1381-1382
 HCUP_SURGERY_BROAD_CPT       1383-1387
 HCUP_SURGERY_NARROW_CPT      1388-1392
 HISPANIC                     1393-1394
 HISPANIC_X                   1395     (A)
 HOSPST                       1396-1397 (A)
 I10_DX_Visit_Reason1         1398-1404 (A)
 I10_DX_Visit_Reason2         1405-1411 (A)
 I10_DX_Visit_Reason3         1412-1418 (A)
 I10_DX1                      1419-1425 (A)
 I10_DX2                      1426-1432 (A)
 I10_DX3                      1433-1439 (A)
 I10_DX4                      1440-1446 (A)
 I10_DX5                      1447-1453 (A)
 I10_DX6                      1454-1460 (A)
 I10_DX7                      1461-1467 (A)
 I10_DX8                      1468-1474 (A)
 I10_DX9                      1475-1481 (A)
 I10_DX10                     1482-1488 (A)
 I10_DX11                     1489-1495 (A)
 I10_DX12                     1496-1502 (A)
 I10_DX13                     1503-1509 (A)
 I10_DX14                     1510-1516 (A)
 I10_DX15                     1517-1523 (A)
 I10_DX16                     1524-1530 (A)
 I10_DX17                     1531-1537 (A)
 I10_DX18                     1538-1544 (A)
 I10_DX19                     1545-1551 (A)
 I10_DX20                     1552-1558 (A)
 I10_DX21                     1559-1565 (A)
 I10_DX22                     1566-1572 (A)
 I10_DX23                     1573-1579 (A)
 I10_DX24                     1580-1586 (A)
 I10_DX25                     1587-1593 (A)
 I10_DX26                     1594-1600 (A)
 I10_DX27                     1601-1607 (A)
 I10_DX28                     1608-1614 (A)
 I10_DX29                     1615-1621 (A)
 I10_DX30                     1622-1628 (A)
 I10_NDX                      1629-1631
 I10_NPR                      1632-1634
 I10_PR1                      1635-1641 (A)
 I10_PR2                      1642-1648 (A)
 I10_PR3                      1649-1655 (A)
 I10_PR4                      1656-1662 (A)
 I10_PR5                      1663-1669 (A)
 I10_PR6                      1670-1676 (A)
 I10_PR7                      1677-1683 (A)
 I10_PR8                      1684-1690 (A)
 I10_PR9                      1691-1697 (A)
 I10_PR10                     1698-1704 (A)
 I10_PR11                     1705-1711 (A)
 I10_PROCTYPE                 1712-1714
 KEY                          1715-1729
 LOS                          1730-1734
 LOS_X                        1735-1740
 MEDINCSTQ                    1741-1742
 NCPT                         1743-1746
 OBSERVATION                  1747-1750
 OPservice                    1751     (A)
 OS_TIME                      1752-1762
 PAY1                         1763-1764
 PAY1_X                       1765-1766 (A)
 PAY2                         1767-1768
 PAY2_X                       1769-1770 (A)
 PAY3                         1771-1772
 PAY3_X                       1773-1774 (A)
 PL_CBSA                      1775-1777
 PL_NCHS                      1778-1779
 POA_Disch_Edit1              1780-1781
 POA_Disch_Edit2              1782-1783
 POA_Hosp_Edit1               1784-1785
 POA_Hosp_Edit2               1786-1787
 POA_Hosp_Edit3               1788-1789
 POA_Hosp_Edit3_Value         1790-1797
 PointOfOrigin_X              1798     (A)
 PointOfOriginUB04            1799     (A)
 PRDAY1                       1800-1804
 PRDAY2                       1805-1809
 PRDAY3                       1810-1814
 PRDAY4                       1815-1819
 PRDAY5                       1820-1824
 PRDAY6                       1825-1829
 PRDAY7                       1830-1834
 PRDAY8                       1835-1839
 PRDAY9                       1840-1844
 PRDAY10                      1845-1849
 PRDAY11                      1850-1854
 PSTATE                       1855-1856 (A)
 PSTATE_GEO                   1857-1858 (A)
 RACE                         1859-1860
 RACE_PCT_MISS_HOSP           1861-1867
 RACE_X                       1868     (A)
 SASD_SEDD                    1869-1870
 STATE_AS                     1871-1872
 STATE_ED                     1873-1874
 STATE_OS                     1875-1876
 TOTCHG                       1877-1886
 TOTCHG_X                     1887-1901
 VisitLink                    1902-1910
 YEAR                         1911-1914
 ZIPINC_QRTL                  1915-1917
 HOSPID                       1918-1922
 AYEAR                        1923-1926
 BMONTH                       1927-1928
 BYEAR                        1929-1932
 PRMONTH1                     1933-1934
 PRMONTH2                     1935-1936
 PRMONTH3                     1937-1938
 PRMONTH4                     1939-1940
 PRMONTH5                     1941-1942
 PRMONTH6                     1943-1944
 PRMONTH7                     1945-1946
 PRMONTH8                     1947-1948
 PRMONTH9                     1949-1950
 PRMONTH10                    1951-1952
 PRMONTH11                    1953-1954
 PRYEAR1                      1955-1958
 PRYEAR2                      1959-1962
 PRYEAR3                      1963-1966
 PRYEAR4                      1967-1970
 PRYEAR5                      1971-1974
 PRYEAR6                      1975-1978
 PRYEAR7                      1979-1982
 PRYEAR8                      1983-1986
 PRYEAR9                      1987-1990
 PRYEAR10                     1991-1994
 PRYEAR11                     1995-1998.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 CPTCCS111                    (F4.0) /
 CPTCCS112                    (F4.0) /
 CPTCCS113                    (F4.0) /
 CPTCCS114                    (F4.0) /
 CPTCCS115                    (F4.0) /
 CPTCCS116                    (F4.0) /
 CPTCCS117                    (F4.0) /
 CPTCCS118                    (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 CPTDAY51                     (F4.0) /
 CPTDAY52                     (F4.0) /
 CPTDAY53                     (F4.0) /
 CPTDAY54                     (F4.0) /
 CPTDAY55                     (F4.0) /
 CPTDAY56                     (F4.0) /
 CPTDAY57                     (F4.0) /
 CPTDAY58                     (F4.0) /
 CPTDAY59                     (F4.0) /
 CPTDAY60                     (F4.0) /
 CPTDAY61                     (F4.0) /
 CPTDAY62                     (F4.0) /
 CPTDAY63                     (F4.0) /
 CPTDAY64                     (F4.0) /
 CPTDAY65                     (F4.0) /
 CPTDAY66                     (F4.0) /
 CPTDAY67                     (F4.0) /
 CPTDAY68                     (F4.0) /
 CPTDAY69                     (F4.0) /
 CPTDAY70                     (F4.0) /
 CPTDAY71                     (F4.0) /
 CPTDAY72                     (F4.0) /
 CPTDAY73                     (F4.0) /
 CPTDAY74                     (F4.0) /
 CPTDAY75                     (F4.0) /
 CPTDAY76                     (F4.0) /
 CPTDAY77                     (F4.0) /
 CPTDAY78                     (F4.0) /
 CPTDAY79                     (F4.0) /
 CPTDAY80                     (F4.0) /
 CPTDAY81                     (F4.0) /
 CPTDAY82                     (F4.0) /
 CPTDAY83                     (F4.0) /
 CPTDAY84                     (F4.0) /
 CPTDAY85                     (F4.0) /
 CPTDAY86                     (F4.0) /
 CPTDAY87                     (F4.0) /
 CPTDAY88                     (F4.0) /
 CPTDAY89                     (F4.0) /
 CPTDAY90                     (F4.0) /
 CPTDAY91                     (F4.0) /
 CPTDAY92                     (F4.0) /
 CPTDAY93                     (F4.0) /
 CPTDAY94                     (F4.0) /
 CPTDAY95                     (F4.0) /
 CPTDAY96                     (F4.0) /
 CPTDAY97                     (F4.0) /
 CPTDAY98                     (F4.0) /
 CPTDAY99                     (F4.0) /
 CPTDAY100                    (F4.0) /
 CPTDAY101                    (F4.0) /
 CPTDAY102                    (F4.0) /
 CPTDAY103                    (F4.0) /
 CPTDAY104                    (F4.0) /
 CPTDAY105                    (F4.0) /
 CPTDAY106                    (F4.0) /
 CPTDAY107                    (F4.0) /
 CPTDAY108                    (F4.0) /
 CPTDAY109                    (F4.0) /
 CPTDAY110                    (F4.0) /
 CPTDAY111                    (F4.0) /
 CPTDAY112                    (F4.0) /
 CPTDAY113                    (F4.0) /
 CPTDAY114                    (F4.0) /
 CPTDAY115                    (F4.0) /
 CPTDAY116                    (F4.0) /
 CPTDAY117                    (F4.0) /
 CPTDAY118                    (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 OBSERVATION                  (F4.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 SASD_SEDD                    (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPT111                       "CPT/HCPCS procedure code 111"
 CPT112                       "CPT/HCPCS procedure code 112"
 CPT113                       "CPT/HCPCS procedure code 113"
 CPT114                       "CPT/HCPCS procedure code 114"
 CPT115                       "CPT/HCPCS procedure code 115"
 CPT116                       "CPT/HCPCS procedure code 116"
 CPT117                       "CPT/HCPCS procedure code 117"
 CPT118                       "CPT/HCPCS procedure code 118"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 CPTCCS111                    "CCS: CPT 111"
 CPTCCS112                    "CCS: CPT 112"
 CPTCCS113                    "CCS: CPT 113"
 CPTCCS114                    "CCS: CPT 114"
 CPTCCS115                    "CCS: CPT 115"
 CPTCCS116                    "CCS: CPT 116"
 CPTCCS117                    "CCS: CPT 117"
 CPTCCS118                    "CCS: CPT 118"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 CPTDAY51                     "Number of days from admission to CPT51"
 CPTDAY52                     "Number of days from admission to CPT52"
 CPTDAY53                     "Number of days from admission to CPT53"
 CPTDAY54                     "Number of days from admission to CPT54"
 CPTDAY55                     "Number of days from admission to CPT55"
 CPTDAY56                     "Number of days from admission to CPT56"
 CPTDAY57                     "Number of days from admission to CPT57"
 CPTDAY58                     "Number of days from admission to CPT58"
 CPTDAY59                     "Number of days from admission to CPT59"
 CPTDAY60                     "Number of days from admission to CPT60"
 CPTDAY61                     "Number of days from admission to CPT61"
 CPTDAY62                     "Number of days from admission to CPT62"
 CPTDAY63                     "Number of days from admission to CPT63"
 CPTDAY64                     "Number of days from admission to CPT64"
 CPTDAY65                     "Number of days from admission to CPT65"
 CPTDAY66                     "Number of days from admission to CPT66"
 CPTDAY67                     "Number of days from admission to CPT67"
 CPTDAY68                     "Number of days from admission to CPT68"
 CPTDAY69                     "Number of days from admission to CPT69"
 CPTDAY70                     "Number of days from admission to CPT70"
 CPTDAY71                     "Number of days from admission to CPT71"
 CPTDAY72                     "Number of days from admission to CPT72"
 CPTDAY73                     "Number of days from admission to CPT73"
 CPTDAY74                     "Number of days from admission to CPT74"
 CPTDAY75                     "Number of days from admission to CPT75"
 CPTDAY76                     "Number of days from admission to CPT76"
 CPTDAY77                     "Number of days from admission to CPT77"
 CPTDAY78                     "Number of days from admission to CPT78"
 CPTDAY79                     "Number of days from admission to CPT79"
 CPTDAY80                     "Number of days from admission to CPT80"
 CPTDAY81                     "Number of days from admission to CPT81"
 CPTDAY82                     "Number of days from admission to CPT82"
 CPTDAY83                     "Number of days from admission to CPT83"
 CPTDAY84                     "Number of days from admission to CPT84"
 CPTDAY85                     "Number of days from admission to CPT85"
 CPTDAY86                     "Number of days from admission to CPT86"
 CPTDAY87                     "Number of days from admission to CPT87"
 CPTDAY88                     "Number of days from admission to CPT88"
 CPTDAY89                     "Number of days from admission to CPT89"
 CPTDAY90                     "Number of days from admission to CPT90"
 CPTDAY91                     "Number of days from admission to CPT91"
 CPTDAY92                     "Number of days from admission to CPT92"
 CPTDAY93                     "Number of days from admission to CPT93"
 CPTDAY94                     "Number of days from admission to CPT94"
 CPTDAY95                     "Number of days from admission to CPT95"
 CPTDAY96                     "Number of days from admission to CPT96"
 CPTDAY97                     "Number of days from admission to CPT97"
 CPTDAY98                     "Number of days from admission to CPT98"
 CPTDAY99                     "Number of days from admission to CPT99"
 CPTDAY100                    "Number of days from admission to CPT100"
 CPTDAY101                    "Number of days from admission to CPT101"
 CPTDAY102                    "Number of days from admission to CPT102"
 CPTDAY103                    "Number of days from admission to CPT103"
 CPTDAY104                    "Number of days from admission to CPT104"
 CPTDAY105                    "Number of days from admission to CPT105"
 CPTDAY106                    "Number of days from admission to CPT106"
 CPTDAY107                    "Number of days from admission to CPT107"
 CPTDAY108                    "Number of days from admission to CPT108"
 CPTDAY109                    "Number of days from admission to CPT109"
 CPTDAY110                    "Number of days from admission to CPT110"
 CPTDAY111                    "Number of days from admission to CPT111"
 CPTDAY112                    "Number of days from admission to CPT112"
 CPTDAY113                    "Number of days from admission to CPT113"
 CPTDAY114                    "Number of days from admission to CPT114"
 CPTDAY115                    "Number of days from admission to CPT115"
 CPTDAY116                    "Number of days from admission to CPT116"
 CPTDAY117                    "Number of days from admission to CPT117"
 CPTDAY118                    "Number of days from admission to CPT118"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OBSERVATION                  "Time for observation services (as received from source)"
 OPservice                    "Indicator of outpatient service (as received from source)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 SASD_SEDD                    "SASD and SEDD indicator"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS118
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY118
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OBSERVATION
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE SASD_SEDD
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AK_SEDD_2021_CORE.sav' /COMPRESSED.
