/*******************************************************************
*   MA_SEDD_2007_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'MA_SEDD_2007_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRONB1                   13-  14
 CHRONB2                   15-  16
 CHRONB3                   17-  18
 CHRONB4                   19-  20
 CHRONB5                   21-  22
 CHRONB6                   23-  24
 DXMCCS1                   25-  35 (A)
 DXMCCS2                   36-  46 (A)
 DXMCCS3                   47-  57 (A)
 DXMCCS4                   58-  68 (A)
 DXMCCS5                   69-  79 (A)
 DXMCCS6                   80-  90 (A)
 E_MCCS1                   91- 101 (A)
 E_MCCS2                  102- 112 (A)
 E_MCCS3                  113- 123 (A)
 E_MCCS4                  124- 134 (A)
 E_MCCS5                  135- 145 (A)
 KEY                      146- 159
 PCLASS1                  160- 161
 PCLASS2                  162- 163
 PCLASS3                  164- 165
 PCLASS4                  166- 167
 PRMCCS1                  168- 175 (A)
 PRMCCS2                  176- 183 (A)
 PRMCCS3                  184- 191 (A)
 PRMCCS4                  192- 199 (A).


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 KEY                     (F8.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 DXMCCS1   "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2   "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3   "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4   "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5   "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6   "Multi-Level CCS:  Diagnosis 6"
 E_MCCS1   "Multi-Level CCS:  E Code 1"
 E_MCCS2   "Multi-Level CCS:  E Code 2"
 E_MCCS3   "Multi-Level CCS:  E Code 3"
 E_MCCS4   "Multi-Level CCS:  E Code 4"
 E_MCCS5   "Multi-Level CCS:  E Code 5"
 KEY       "HCUP record identifier"
 PCLASS1   "Procedure class 1"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PRMCCS1   "Multi-Level CCS:  Procedure 1"
 PRMCCS2   "Multi-Level CCS:  Procedure 2"
 PRMCCS3   "Multi-Level CCS:  Procedure 3"
 PRMCCS4   "Multi-Level CCS:  Procedure 4" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2007_DX_PR_GRPS.SAV' /COMPRESSED.
