/*******************************************************************
*   MD_SEDD_2000_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SEDD_2000_CHGS.ASC' FIXED / 
 KEY                   1-  14
 CHG1                 15-  26
 CHG2                 27-  38
 CHG3                 39-  50
 CHG4                 51-  62
 CHG5                 63-  74
 CHG6                 75-  86
 CHG7                 87-  98
 CHG8                 99- 110
 CHG9                111- 122
 CHG10               123- 134
 CHG11               135- 146
 CHG12               147- 158
 CHG13               159- 170
 CHG14               171- 182
 CHG15               183- 194
 CHG16               195- 206
 REVCD1              207- 210 (A)
 REVCD2              211- 214 (A)
 REVCD3              215- 218 (A)
 REVCD4              219- 222 (A)
 REVCD5              223- 226 (A)
 REVCD6              227- 230 (A)
 REVCD7              231- 234 (A)
 REVCD8              235- 238 (A)
 REVCD9              239- 242 (A)
 REVCD10             243- 246 (A)
 REVCD11             247- 250 (A)
 REVCD12             251- 254 (A)
 REVCD13             255- 258 (A)
 REVCD14             259- 262 (A)
 REVCD15             263- 266 (A)
 REVCD16             267- 270 (A)
 UNIT1               271- 278
 UNIT2               279- 286
 UNIT3               287- 294
 UNIT4               295- 302
 UNIT5               303- 310
 UNIT6               311- 318
 UNIT7               319- 326
 UNIT8               327- 334
 UNIT9               335- 342
 UNIT10              343- 350
 UNIT11              351- 358
 UNIT12              359- 366
 UNIT13              367- 374
 UNIT14              375- 382
 UNIT15              383- 390
 UNIT16              391- 398.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 CHG1                (F6.2) /
 CHG2                (F6.2) /
 CHG3                (F6.2) /
 CHG4                (F6.2) /
 CHG5                (F6.2) /
 CHG6                (F6.2) /
 CHG7                (F6.2) /
 CHG8                (F6.2) /
 CHG9                (F6.2) /
 CHG10               (F6.2) /
 CHG11               (F6.2) /
 CHG12               (F6.2) /
 CHG13               (F6.2) /
 CHG14               (F6.2) /
 CHG15               (F6.2) /
 CHG16               (F6.2) /
 UNIT1               (F4.0) /
 UNIT2               (F4.0) /
 UNIT3               (F4.0) /
 UNIT4               (F4.0) /
 UNIT5               (F4.0) /
 UNIT6               (F4.0) /
 UNIT7               (F4.0) /
 UNIT8               (F4.0) /
 UNIT9               (F4.0) /
 UNIT10              (F4.0) /
 UNIT11              (F4.0) /
 UNIT12              (F4.0) /
 UNIT13              (F4.0) /
 UNIT14              (F4.0) /
 UNIT15              (F4.0) /
 UNIT16              (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CHG1      "Detailed charges 1 (as received from source)"
 CHG2      "Detailed charges 2 (as received from source)"
 CHG3      "Detailed charges 3 (as received from source)"
 CHG4      "Detailed charges 4 (as received from source)"
 CHG5      "Detailed charges 5 (as received from source)"
 CHG6      "Detailed charges 6 (as received from source)"
 CHG7      "Detailed charges 7 (as received from source)"
 CHG8      "Detailed charges 8 (as received from source)"
 CHG9      "Detailed charges 9 (as received from source)"
 CHG10     "Detailed charges 10 (as received from source)"
 CHG11     "Detailed charges 11 (as received from source)"
 CHG12     "Detailed charges 12 (as received from source)"
 CHG13     "Detailed charges 13 (as received from source)"
 CHG14     "Detailed charges 14 (as received from source)"
 CHG15     "Detailed charges 15 (as received from source)"
 CHG16     "Detailed charges 16 (as received from source)"
 REVCD1    "Revenue code 1 (as received from source)"
 REVCD2    "Revenue code 2 (as received from source)"
 REVCD3    "Revenue code 3 (as received from source)"
 REVCD4    "Revenue code 4 (as received from source)"
 REVCD5    "Revenue code 5 (as received from source)"
 REVCD6    "Revenue code 6 (as received from source)"
 REVCD7    "Revenue code 7 (as received from source)"
 REVCD8    "Revenue code 8 (as received from source)"
 REVCD9    "Revenue code 9 (as received from source)"
 REVCD10   "Revenue code 10 (as received from source)"
 REVCD11   "Revenue code 11 (as received from source)"
 REVCD12   "Revenue code 12 (as received from source)"
 REVCD13   "Revenue code 13 (as received from source)"
 REVCD14   "Revenue code 14 (as received from source)"
 REVCD15   "Revenue code 15 (as received from source)"
 REVCD16   "Revenue code 16 (as received from source)"
 UNIT1     "Units of service 1 (as received from source)"
 UNIT2     "Units of service 2 (as received from source)"
 UNIT3     "Units of service 3 (as received from source)"
 UNIT4     "Units of service 4 (as received from source)"
 UNIT5     "Units of service 5 (as received from source)"
 UNIT6     "Units of service 6 (as received from source)"
 UNIT7     "Units of service 7 (as received from source)"
 UNIT8     "Units of service 8 (as received from source)"
 UNIT9     "Units of service 9 (as received from source)"
 UNIT10    "Units of service 10 (as received from source)"
 UNIT11    "Units of service 11 (as received from source)"
 UNIT12    "Units of service 12 (as received from source)"
 UNIT13    "Units of service 13 (as received from source)"
 UNIT14    "Units of service 14 (as received from source)"
 UNIT15    "Units of service 15 (as received from source)"
 UNIT16    "Units of service 16 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG13
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG14
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG15
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG16
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE UNIT1
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT2
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT3
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT4
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT5
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT6
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT7
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT8
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT9
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT10
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT11
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT12
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT13
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT14
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT15
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT16
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'MD_SEDD_2000_CHGS.SAV' /COMPRESSED.
