/*******************************************************************
* Creation Date: 09/20/2021   
*   MO_SEDD_2019_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MO_SEDD_2019_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_INJURY                      1-   2
 I10_INJURY_CUT                  3-   4
 I10_INJURY_DROWN                5-   6
 I10_INJURY_FALL                 7-   8
 I10_INJURY_FIRE                 9-  10
 I10_INJURY_FIREARM             11-  12
 I10_INJURY_MACHINERY           13-  14
 I10_INJURY_MVT                 15-  16
 I10_INJURY_NATURE              17-  18
 I10_INJURY_OVEREXERTION        19-  20
 I10_INJURY_POISON              21-  22
 I10_INJURY_STRUCK              23-  24
 I10_INJURY_SUFFOCATION         25-  26
 I10_INTENT_ASSAULT             27-  28
 I10_INTENT_SELF_HARM           29-  30
 I10_INTENT_UNINTENTIONAL       31-  32
 I10_MULTINJURY                 33-  34
 KEY                            35-  49.


***  Specify write formats  ***.
FORMATS
 I10_INJURY                   (F3.0) /
 I10_INJURY_CUT               (F3.0) /
 I10_INJURY_DROWN             (F3.0) /
 I10_INJURY_FALL              (F3.0) /
 I10_INJURY_FIRE              (F3.0) /
 I10_INJURY_FIREARM           (F3.0) /
 I10_INJURY_MACHINERY         (F3.0) /
 I10_INJURY_MVT               (F3.0) /
 I10_INJURY_NATURE            (F3.0) /
 I10_INJURY_OVEREXERTION      (F3.0) /
 I10_INJURY_POISON            (F3.0) /
 I10_INJURY_STRUCK            (F3.0) /
 I10_INJURY_SUFFOCATION       (F3.0) /
 I10_INTENT_ASSAULT           (F3.0) /
 I10_INTENT_SELF_HARM         (F3.0) /
 I10_INTENT_UNINTENTIONAL     (F3.0) /
 I10_MULTINJURY               (F3.0) /
 KEY                          (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_INJURY

"Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)
"
 I10_INJURY_CUT               "Mechanism of injury: cut or pierce"
 I10_INJURY_DROWN             "Mechanism of injury: drowning or submersion"
 I10_INJURY_FALL              "Mechanism of injury: fall"
 I10_INJURY_FIRE              "Mechanism of injury: fire, flame, hot object, or hot substance"
 I10_INJURY_FIREARM           "Mechanism of injury: firearm"
 I10_INJURY_MACHINERY         "Mechanism of injury: machinery"
 I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, o
ther, or unspecified"
 I10_INJURY_NATURE
"Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
 I10_INJURY_OVEREXERTION      "Mechanism of injury: overexertion"
 I10_INJURY_POISON            "Mechanism of injury: poisoning, including drugs and nondrugs"
 I10_INJURY_STRUCK            "Mechanism of injury: struck by or against"
 I10_INJURY_SUFFOCATION       "Mechanism of injury: suffocation"
 I10_INTENT_ASSAULT           "Intent of injury: assault"
 I10_INTENT_SELF_HARM         "Intent of injury: intentional self-harm"
 I10_INTENT_UNINTENTIONAL     "Intent of injury: unintentional"
 I10_MULTINJURY               "Multiple ICD-10-CM injuries reported on record"
 KEY                          "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_OVEREXERTION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MO_SEDD_2019_DX_PR_GRPS.SAV' /COMPRESSED.
