/*******************************************************************
* Creation Date: 11/13/2017   
*   RI_SEDD_2015q1q3_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'RI_SEDD_2015q1q3_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 CHRON1                         23-  24
 CHRON2                         25-  26
 CHRON3                         27-  28
 CHRON4                         29-  30
 CHRON5                         31-  32
 CHRON6                         33-  34
 CHRON7                         35-  36
 CHRON8                         37-  38
 CHRON9                         39-  40
 CHRON10                        41-  42
 CHRON11                        43-  44
 DXMCCS1                        45-  55 (A)
 DXMCCS2                        56-  66 (A)
 DXMCCS3                        67-  77 (A)
 DXMCCS4                        78-  88 (A)
 DXMCCS5                        89-  99 (A)
 DXMCCS6                       100- 110 (A)
 DXMCCS7                       111- 121 (A)
 DXMCCS8                       122- 132 (A)
 DXMCCS9                       133- 143 (A)
 DXMCCS10                      144- 154 (A)
 DXMCCS11                      155- 165 (A)
 E_MCCS1                       166- 176 (A)
 E_MCCS2                       177- 187 (A)
 E_MCCS3                       188- 198 (A)
 E_MCCS4                       199- 209 (A)
 E_MCCS5                       210- 220 (A)
 E_MCCS6                       221- 231 (A)
 E_MCCS7                       232- 242 (A)
 E_MCCS8                       243- 253 (A)
 E_MCCS9                       254- 264 (A)
 E_MCCS10                      265- 275 (A)
 INJURY                        276- 277
 INJURY_CUT                    278- 279
 INJURY_DROWN                  280- 281
 INJURY_FALL                   282- 283
 INJURY_FIRE                   284- 285
 INJURY_FIREARM                286- 287
 INJURY_MACHINERY              288- 289
 INJURY_MVT                    290- 291
 INJURY_NATURE                 292- 293
 INJURY_POISON                 294- 295
 INJURY_STRUCK                 296- 297
 INJURY_SUFFOCATION            298- 299
 INTENT_ASSAULT                300- 301
 INTENT_SELF_HARM              302- 303
 INTENT_UNINTENTIONAL          304- 305
 KEY                           306- 320
 MULTINJURY                    321- 322.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 E_MCCS9                      "Multi-Level CCS:  E Code 9"
 E_MCCS10                     "Multi-Level CCS:  E Code 10"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE                "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM             "Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'RI_SEDD_2015q1q3_DX_PR_GRPS.SAV' /COMPRESSED.
