/*******************************************************************
* Creation Date: 08/06/2014   
*   NJ_SEDD_2013_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NJ_SEDD_2013_CORE.ASC' FIXED SKIP=2 / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 BILLTYPE                  20-  23 (A)
 CPT1                      24-  28 (A)
 CPT2                      29-  33 (A)
 CPT3                      34-  38 (A)
 CPT4                      39-  43 (A)
 CPT5                      44-  48 (A)
 CPT6                      49-  53 (A)
 CPT7                      54-  58 (A)
 CPT8                      59-  63 (A)
 CPT9                      64-  68 (A)
 CPT10                     69-  73 (A)
 CPT11                     74-  78 (A)
 CPT12                     79-  83 (A)
 CPT13                     84-  88 (A)
 CPT14                     89-  93 (A)
 CPT15                     94-  98 (A)
 CPT16                     99- 103 (A)
 CPT17                    104- 108 (A)
 CPT18                    109- 113 (A)
 CPT19                    114- 118 (A)
 CPT20                    119- 123 (A)
 CPT21                    124- 128 (A)
 CPT22                    129- 133 (A)
 CPT23                    134- 138 (A)
 CPT24                    139- 143 (A)
 CPT25                    144- 148 (A)
 CPT26                    149- 153 (A)
 CPT27                    154- 158 (A)
 CPT28                    159- 163 (A)
 CPT29                    164- 168 (A)
 CPT30                    169- 173 (A)
 CPT31                    174- 178 (A)
 CPT32                    179- 183 (A)
 CPT33                    184- 188 (A)
 CPT34                    189- 193 (A)
 CPT35                    194- 198 (A)
 CPT36                    199- 203 (A)
 CPT37                    204- 208 (A)
 CPT38                    209- 213 (A)
 CPT39                    214- 218 (A)
 CPT40                    219- 223 (A)
 CPT41                    224- 228 (A)
 CPT42                    229- 233 (A)
 CPT43                    234- 238 (A)
 CPT44                    239- 243 (A)
 CPT45                    244- 248 (A)
 CPT46                    249- 253 (A)
 CPT47                    254- 258 (A)
 CPT48                    259- 263 (A)
 CPT49                    264- 268 (A)
 CPT50                    269- 273 (A)
 CPTCCS1                  274- 276
 CPTCCS2                  277- 279
 CPTCCS3                  280- 282
 CPTCCS4                  283- 285
 CPTCCS5                  286- 288
 CPTCCS6                  289- 291
 CPTCCS7                  292- 294
 CPTCCS8                  295- 297
 CPTCCS9                  298- 300
 CPTCCS10                 301- 303
 CPTCCS11                 304- 306
 CPTCCS12                 307- 309
 CPTCCS13                 310- 312
 CPTCCS14                 313- 315
 CPTCCS15                 316- 318
 CPTCCS16                 319- 321
 CPTCCS17                 322- 324
 CPTCCS18                 325- 327
 CPTCCS19                 328- 330
 CPTCCS20                 331- 333
 CPTCCS21                 334- 336
 CPTCCS22                 337- 339
 CPTCCS23                 340- 342
 CPTCCS24                 343- 345
 CPTCCS25                 346- 348
 CPTCCS26                 349- 351
 CPTCCS27                 352- 354
 CPTCCS28                 355- 357
 CPTCCS29                 358- 360
 CPTCCS30                 361- 363
 CPTCCS31                 364- 366
 CPTCCS32                 367- 369
 CPTCCS33                 370- 372
 CPTCCS34                 373- 375
 CPTCCS35                 376- 378
 CPTCCS36                 379- 381
 CPTCCS37                 382- 384
 CPTCCS38                 385- 387
 CPTCCS39                 388- 390
 CPTCCS40                 391- 393
 CPTCCS41                 394- 396
 CPTCCS42                 397- 399
 CPTCCS43                 400- 402
 CPTCCS44                 403- 405
 CPTCCS45                 406- 408
 CPTCCS46                 409- 411
 CPTCCS47                 412- 414
 CPTCCS48                 415- 417
 CPTCCS49                 418- 420
 CPTCCS50                 421- 423
 CPTM1_1                  424- 425 (A)
 CPTM1_2                  426- 427 (A)
 CPTM1_3                  428- 429 (A)
 CPTM1_4                  430- 431 (A)
 CPTM1_5                  432- 433 (A)
 CPTM1_6                  434- 435 (A)
 CPTM1_7                  436- 437 (A)
 CPTM1_8                  438- 439 (A)
 CPTM1_9                  440- 441 (A)
 CPTM1_10                 442- 443 (A)
 CPTM1_11                 444- 445 (A)
 CPTM1_12                 446- 447 (A)
 CPTM1_13                 448- 449 (A)
 CPTM1_14                 450- 451 (A)
 CPTM1_15                 452- 453 (A)
 CPTM1_16                 454- 455 (A)
 CPTM1_17                 456- 457 (A)
 CPTM1_18                 458- 459 (A)
 CPTM1_19                 460- 461 (A)
 CPTM1_20                 462- 463 (A)
 CPTM1_21                 464- 465 (A)
 CPTM1_22                 466- 467 (A)
 CPTM1_23                 468- 469 (A)
 CPTM1_24                 470- 471 (A)
 CPTM1_25                 472- 473 (A)
 CPTM1_26                 474- 475 (A)
 CPTM1_27                 476- 477 (A)
 CPTM1_28                 478- 479 (A)
 CPTM1_29                 480- 481 (A)
 CPTM1_30                 482- 483 (A)
 CPTM1_31                 484- 485 (A)
 CPTM1_32                 486- 487 (A)
 CPTM1_33                 488- 489 (A)
 CPTM1_34                 490- 491 (A)
 CPTM1_35                 492- 493 (A)
 CPTM1_36                 494- 495 (A)
 CPTM1_37                 496- 497 (A)
 CPTM1_38                 498- 499 (A)
 CPTM1_39                 500- 501 (A)
 CPTM1_40                 502- 503 (A)
 CPTM1_41                 504- 505 (A)
 CPTM1_42                 506- 507 (A)
 CPTM1_43                 508- 509 (A)
 CPTM1_44                 510- 511 (A)
 CPTM1_45                 512- 513 (A)
 CPTM1_46                 514- 515 (A)
 CPTM1_47                 516- 517 (A)
 CPTM1_48                 518- 519 (A)
 CPTM1_49                 520- 521 (A)
 CPTM1_50                 522- 523 (A)
 CPTM2_1                  524- 525 (A)
 CPTM2_2                  526- 527 (A)
 CPTM2_3                  528- 529 (A)
 CPTM2_4                  530- 531 (A)
 CPTM2_5                  532- 533 (A)
 CPTM2_6                  534- 535 (A)
 CPTM2_7                  536- 537 (A)
 CPTM2_8                  538- 539 (A)
 CPTM2_9                  540- 541 (A)
 CPTM2_10                 542- 543 (A)
 CPTM2_11                 544- 545 (A)
 CPTM2_12                 546- 547 (A)
 CPTM2_13                 548- 549 (A)
 CPTM2_14                 550- 551 (A)
 CPTM2_15                 552- 553 (A)
 CPTM2_16                 554- 555 (A)
 CPTM2_17                 556- 557 (A)
 CPTM2_18                 558- 559 (A)
 CPTM2_19                 560- 561 (A)
 CPTM2_20                 562- 563 (A)
 CPTM2_21                 564- 565 (A)
 CPTM2_22                 566- 567 (A)
 CPTM2_23                 568- 569 (A)
 CPTM2_24                 570- 571 (A)
 CPTM2_25                 572- 573 (A)
 CPTM2_26                 574- 575 (A)
 CPTM2_27                 576- 577 (A)
 CPTM2_28                 578- 579 (A)
 CPTM2_29                 580- 581 (A)
 CPTM2_30                 582- 583 (A)
 CPTM2_31                 584- 585 (A)
 CPTM2_32                 586- 587 (A)
 CPTM2_33                 588- 589 (A)
 CPTM2_34                 590- 591 (A)
 CPTM2_35                 592- 593 (A)
 CPTM2_36                 594- 595 (A)
 CPTM2_37                 596- 597 (A)
 CPTM2_38                 598- 599 (A)
 CPTM2_39                 600- 601 (A)
 CPTM2_40                 602- 603 (A)
 CPTM2_41                 604- 605 (A)
 CPTM2_42                 606- 607 (A)
 CPTM2_43                 608- 609 (A)
 CPTM2_44                 610- 611 (A)
 CPTM2_45                 612- 613 (A)
 CPTM2_46                 614- 615 (A)
 CPTM2_47                 616- 617 (A)
 CPTM2_48                 618- 619 (A)
 CPTM2_49                 620- 621 (A)
 CPTM2_50                 622- 623 (A)
 DHOUR                    624- 627
 DIED                     628- 629
 DISPUB04                 630- 631
 DISPUNIFORM              632- 633
 DISP_X                   634- 635 (A)
 DMONTH                   636- 637
 DQTR                     638- 639
 DSHOSPID                 640- 656 (A)
 DURATION                 657- 662
 DX1                      663- 667 (A)
 DX2                      668- 672 (A)
 DX3                      673- 677 (A)
 DX4                      678- 682 (A)
 DX5                      683- 687 (A)
 DX6                      688- 692 (A)
 DX7                      693- 697 (A)
 DX8                      698- 702 (A)
 DX9                      703- 707 (A)
 DX10                     708- 712 (A)
 DX11                     713- 717 (A)
 DX12                     718- 722 (A)
 DX13                     723- 727 (A)
 DX14                     728- 732 (A)
 DX15                     733- 737 (A)
 DX16                     738- 742 (A)
 DX17                     743- 747 (A)
 DX18                     748- 752 (A)
 DX19                     753- 757 (A)
 DX20                     758- 762 (A)
 DX21                     763- 767 (A)
 DX22                     768- 772 (A)
 DX23                     773- 777 (A)
 DX24                     778- 782 (A)
 DXCCS1                   783- 786
 DXCCS2                   787- 790
 DXCCS3                   791- 794
 DXCCS4                   795- 798
 DXCCS5                   799- 802
 DXCCS6                   803- 806
 DXCCS7                   807- 810
 DXCCS8                   811- 814
 DXCCS9                   815- 818
 DXCCS10                  819- 822
 DXCCS11                  823- 826
 DXCCS12                  827- 830
 DXCCS13                  831- 834
 DXCCS14                  835- 838
 DXCCS15                  839- 842
 DXCCS16                  843- 846
 DXCCS17                  847- 850
 DXCCS18                  851- 854
 DXCCS19                  855- 858
 DXCCS20                  859- 862
 DXCCS21                  863- 866
 DXCCS22                  867- 870
 DXCCS23                  871- 874
 DXCCS24                  875- 878
 DXPOA1                   879     (A)
 DXPOA2                   880     (A)
 DXPOA3                   881     (A)
 DXPOA4                   882     (A)
 DXPOA5                   883     (A)
 DXPOA6                   884     (A)
 DXPOA7                   885     (A)
 DXPOA8                   886     (A)
 DXPOA9                   887     (A)
 DXPOA10                  888     (A)
 DXPOA11                  889     (A)
 DXPOA12                  890     (A)
 DXPOA13                  891     (A)
 DXPOA14                  892     (A)
 DXPOA15                  893     (A)
 DXPOA16                  894     (A)
 DXPOA17                  895     (A)
 DXPOA18                  896     (A)
 DXPOA19                  897     (A)
 DXPOA20                  898     (A)
 DXPOA21                  899     (A)
 DXPOA22                  900     (A)
 DXPOA23                  901     (A)
 DXPOA24                  902     (A)
 DX_Visit_Reason1         903- 907 (A)
 DX_Visit_Reason2         908- 912 (A)
 DX_Visit_Reason3         913- 917 (A)
 ECODE1                   918- 922 (A)
 ECODE2                   923- 927 (A)
 ECODE3                   928- 932 (A)
 ECODE4                   933- 937 (A)
 ECODE5                   938- 942 (A)
 ECODE6                   943- 947 (A)
 ECODE7                   948- 952 (A)
 ECODE8                   953- 957 (A)
 ECODE9                   958- 962 (A)
 ECODE10                  963- 967 (A)
 E_CCS1                   968- 971
 E_CCS2                   972- 975
 E_CCS3                   976- 979
 E_CCS4                   980- 983
 E_CCS5                   984- 987
 E_CCS6                   988- 991
 E_CCS7                   992- 995
 E_CCS8                   996- 999
 E_CCS9                  1000-1003
 E_CCS10                 1004-1007
 E_POA1                  1008     (A)
 E_POA2                  1009     (A)
 E_POA3                  1010     (A)
 E_POA4                  1011     (A)
 E_POA5                  1012     (A)
 E_POA6                  1013     (A)
 E_POA7                  1014     (A)
 E_POA8                  1015     (A)
 E_POA9                  1016     (A)
 E_POA10                 1017     (A)
 FEMALE                  1018-1019
 HCUP_ED                 1020-1021
 HCUP_OS                 1022-1023
 HISPANIC_X              1024-1028 (A)
 HOSPBRTH                1029-1031
 HOSPST                  1032-1033 (A)
 KEY                     1034-1048
 LOS                     1049-1053
 LOS_X                   1054-1059
 MARITALSTATUSUB04       1060     (A)
 MDNUM1_R                1061-1069
 MDNUM2_R                1070-1078
 MEDINCSTQ               1079-1080
 MOMNUM_R                1081-1089
 MRN_R                   1090-1098
 NCHRONIC                1099-1101
 NCPT                    1102-1104
 NDX                     1105-1106
 NECODE                  1107-1108
 NEOMAT                  1109-1110
 NPR                     1111-1112
 OPservice               1113     (A)
 ORPROC                  1114-1115
 OS_TIME                 1116-1123
 PAY1                    1124-1125
 PAY1_X                  1126-1128 (A)
 PAY2                    1129-1130
 PAY2_X                  1131-1133 (A)
 PAY3                    1134-1135
 PAY3_X                  1136-1138 (A)
 PL_CBSA                 1139-1141
 PL_NCHS                 1142-1143
 PL_RUCA10_2005          1144-1145
 PL_RUCA2005             1146-1149
 PL_RUCA4_2005           1150-1151
 PL_RUCC                 1152-1153
 PL_UIC                  1154-1155
 PL_UR_CAT4              1156-1157
 PR1                     1158-1161 (A)
 PR2                     1162-1165 (A)
 PR3                     1166-1169 (A)
 PR4                     1170-1173 (A)
 PR5                     1174-1177 (A)
 PR6                     1178-1181 (A)
 PR7                     1182-1185 (A)
 PR8                     1186-1189 (A)
 PR9                     1190-1193 (A)
 PR10                    1194-1197 (A)
 PR11                    1198-1201 (A)
 PR12                    1202-1205 (A)
 PR13                    1206-1209 (A)
 PR14                    1210-1213 (A)
 PR15                    1214-1217 (A)
 PR16                    1218-1221 (A)
 PR17                    1222-1225 (A)
 PR18                    1226-1229 (A)
 PR19                    1230-1233 (A)
 PR20                    1234-1237 (A)
 PR21                    1238-1241 (A)
 PR22                    1242-1245 (A)
 PR23                    1246-1249 (A)
 PRCCS1                  1250-1252
 PRCCS2                  1253-1255
 PRCCS3                  1256-1258
 PRCCS4                  1259-1261
 PRCCS5                  1262-1264
 PRCCS6                  1265-1267
 PRCCS7                  1268-1270
 PRCCS8                  1271-1273
 PRCCS9                  1274-1276
 PRCCS10                 1277-1279
 PRCCS11                 1280-1282
 PRCCS12                 1283-1285
 PRCCS13                 1286-1288
 PRCCS14                 1289-1291
 PRCCS15                 1292-1294
 PRCCS16                 1295-1297
 PRCCS17                 1298-1300
 PRCCS18                 1301-1303
 PRCCS19                 1304-1306
 PRCCS20                 1307-1309
 PRCCS21                 1310-1312
 PRCCS22                 1313-1315
 PRCCS23                 1316-1318
 PRDAY1                  1319-1323
 PRDAY2                  1324-1328
 PRDAY3                  1329-1333
 PRDAY4                  1334-1338
 PRDAY5                  1339-1343
 PRDAY6                  1344-1348
 PRDAY7                  1349-1353
 PRDAY8                  1354-1358
 PRDAY9                  1359-1363
 PRDAY10                 1364-1368
 PRDAY11                 1369-1373
 PRDAY12                 1374-1378
 PRDAY13                 1379-1383
 PRDAY14                 1384-1388
 PRDAY15                 1389-1393
 PRDAY16                 1394-1398
 PRDAY17                 1399-1403
 PRDAY18                 1404-1408
 PRDAY19                 1409-1413
 PRDAY20                 1414-1418
 PRDAY21                 1419-1423
 PRDAY22                 1424-1428
 PRDAY23                 1429-1433
 PROCTYPE                1434-1436
 PSTATE                  1437-1438 (A)
 PSTCO                   1439-1443
 PSTCO2                  1444-1448
 PointOfOriginUB04       1449     (A)
 PointOfOrigin_X         1450     (A)
 PrimLang                1451-1453 (A)
 RACE                    1454-1455
 RACE_X                  1456-1460 (A)
 READMIT                 1461-1462
 STATE_AS                1463-1464
 STATE_ED                1465-1466
 STATE_OS                1467-1468
 TOTCHG                  1469-1478
 TOTCHG_X                1479-1493
 YEAR                    1494-1497
 ZIP3                    1498-1500 (A)
 ZIPINC_QRTL             1501-1503
 TOWN                    1504-1507 (A)
 ZIP                     1508-1512 (A)
 AYEAR                   1513-1516
 BMONTH                  1517-1518
 BYEAR                   1519-1522
 PRMONTH1                1523-1524
 PRMONTH2                1525-1526
 PRMONTH3                1527-1528
 PRMONTH4                1529-1530
 PRMONTH5                1531-1532
 PRMONTH6                1533-1534
 PRMONTH7                1535-1536
 PRMONTH8                1537-1538
 PRMONTH9                1539-1540
 PRMONTH10               1541-1542
 PRMONTH11               1543-1544
 PRMONTH12               1545-1546
 PRMONTH13               1547-1548
 PRMONTH14               1549-1550
 PRMONTH15               1551-1552
 PRMONTH16               1553-1554
 PRMONTH17               1555-1556
 PRMONTH18               1557-1558
 PRMONTH19               1559-1560
 PRMONTH20               1561-1562
 PRMONTH21               1563-1564
 PRMONTH22               1565-1566
 PRMONTH23               1567-1568
 PRYEAR1                 1569-1572
 PRYEAR2                 1573-1576
 PRYEAR3                 1577-1580
 PRYEAR4                 1581-1584
 PRYEAR5                 1585-1588
 PRYEAR6                 1589-1592
 PRYEAR7                 1593-1596
 PRYEAR8                 1597-1600
 PRYEAR9                 1601-1604
 PRYEAR10                1605-1608
 PRYEAR11                1609-1612
 PRYEAR12                1613-1616
 PRYEAR13                1617-1620
 PRYEAR14                1621-1624
 PRYEAR15                1625-1628
 PRYEAR16                1629-1632
 PRYEAR17                1633-1636
 PRYEAR18                1637-1640
 PRYEAR19                1641-1644
 PRYEAR20                1645-1648
 PRYEAR21                1649-1652
 PRYEAR22                1653-1656
 PRYEAR23                1657-1660.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTCCS31                (F4.0) /
 CPTCCS32                (F4.0) /
 CPTCCS33                (F4.0) /
 CPTCCS34                (F4.0) /
 CPTCCS35                (F4.0) /
 CPTCCS36                (F4.0) /
 CPTCCS37                (F4.0) /
 CPTCCS38                (F4.0) /
 CPTCCS39                (F4.0) /
 CPTCCS40                (F4.0) /
 CPTCCS41                (F4.0) /
 CPTCCS42                (F4.0) /
 CPTCCS43                (F4.0) /
 CPTCCS44                (F4.0) /
 CPTCCS45                (F4.0) /
 CPTCCS46                (F4.0) /
 CPTCCS47                (F4.0) /
 CPTCCS48                (F4.0) /
 CPTCCS49                (F4.0) /
 CPTCCS50                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DMONTH                  (F3.0) /
 DQTR                    (F3.0) /
 DURATION                (F4.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 E_CCS10                 (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MOMNUM_R                (F5.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 OS_TIME                 (F4.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PAY3                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_NCHS                 (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC                 (F3.0) /
 PL_UIC                  (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 READMIT                 (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRMONTH22               (F3.0) /
 PRMONTH23               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "Type of bill, UB-04 coding"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPT31                   "CPT/HCPCS procedure code 31"
 CPT32                   "CPT/HCPCS procedure code 32"
 CPT33                   "CPT/HCPCS procedure code 33"
 CPT34                   "CPT/HCPCS procedure code 34"
 CPT35                   "CPT/HCPCS procedure code 35"
 CPT36                   "CPT/HCPCS procedure code 36"
 CPT37                   "CPT/HCPCS procedure code 37"
 CPT38                   "CPT/HCPCS procedure code 38"
 CPT39                   "CPT/HCPCS procedure code 39"
 CPT40                   "CPT/HCPCS procedure code 40"
 CPT41                   "CPT/HCPCS procedure code 41"
 CPT42                   "CPT/HCPCS procedure code 42"
 CPT43                   "CPT/HCPCS procedure code 43"
 CPT44                   "CPT/HCPCS procedure code 44"
 CPT45                   "CPT/HCPCS procedure code 45"
 CPT46                   "CPT/HCPCS procedure code 46"
 CPT47                   "CPT/HCPCS procedure code 47"
 CPT48                   "CPT/HCPCS procedure code 48"
 CPT49                   "CPT/HCPCS procedure code 49"
 CPT50                   "CPT/HCPCS procedure code 50"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTCCS31                "CCS: CPT 31"
 CPTCCS32                "CCS: CPT 32"
 CPTCCS33                "CCS: CPT 33"
 CPTCCS34                "CCS: CPT 34"
 CPTCCS35                "CCS: CPT 35"
 CPTCCS36                "CCS: CPT 36"
 CPTCCS37                "CCS: CPT 37"
 CPTCCS38                "CCS: CPT 38"
 CPTCCS39                "CCS: CPT 39"
 CPTCCS40                "CCS: CPT 40"
 CPTCCS41                "CCS: CPT 41"
 CPTCCS42                "CCS: CPT 42"
 CPTCCS43                "CCS: CPT 43"
 CPTCCS44                "CCS: CPT 44"
 CPTCCS45                "CCS: CPT 45"
 CPTCCS46                "CCS: CPT 46"
 CPTCCS47                "CCS: CPT 47"
 CPTCCS48                "CCS: CPT 48"
 CPTCCS49                "CCS: CPT 49"
 CPTCCS50                "CCS: CPT 50"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM1_31                "First CPT-4/HCPCS modifier 31"
 CPTM1_32                "First CPT-4/HCPCS modifier 32"
 CPTM1_33                "First CPT-4/HCPCS modifier 33"
 CPTM1_34                "First CPT-4/HCPCS modifier 34"
 CPTM1_35                "First CPT-4/HCPCS modifier 35"
 CPTM1_36                "First CPT-4/HCPCS modifier 36"
 CPTM1_37                "First CPT-4/HCPCS modifier 37"
 CPTM1_38                "First CPT-4/HCPCS modifier 38"
 CPTM1_39                "First CPT-4/HCPCS modifier 39"
 CPTM1_40                "First CPT-4/HCPCS modifier 40"
 CPTM1_41                "First CPT-4/HCPCS modifier 41"
 CPTM1_42                "First CPT-4/HCPCS modifier 42"
 CPTM1_43                "First CPT-4/HCPCS modifier 43"
 CPTM1_44                "First CPT-4/HCPCS modifier 44"
 CPTM1_45                "First CPT-4/HCPCS modifier 45"
 CPTM1_46                "First CPT-4/HCPCS modifier 46"
 CPTM1_47                "First CPT-4/HCPCS modifier 47"
 CPTM1_48                "First CPT-4/HCPCS modifier 48"
 CPTM1_49                "First CPT-4/HCPCS modifier 49"
 CPTM1_50                "First CPT-4/HCPCS modifier 50"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                "Second CPT-4/HCPCS modifier 50"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DMONTH                  "Discharge month"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DURATION                "Elapsed time for hospital care in hours"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DX_Visit_Reason1        "Reason for visit diagnosis 1"
 DX_Visit_Reason2        "Reason for visit diagnosis 2"
 DX_Visit_Reason3        "Reason for visit diagnosis 3"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 ECODE10                 "E code 10"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 E_CCS10                 "CCS: E Code 10"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 E_POA9                  "E Code 9, present on admission indicator"
 E_POA10                 "E Code 10, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MARITALSTATUSUB04       "Patient's marital status, UB-04 standard coding"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MOMNUM_R                "Mother's number (re-identified)"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 OPservice               "Indicator of outpatient service (as received from source)"
 ORPROC                  "Major operating room procedure indicator"
 OS_TIME                 "Observation stay time summed from UNITS"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3                    "Tertiary expected payer (uniform)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                 "Patient Location: NCHS Urban-Rural Code"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC                 "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                  "Patient location: Urban Influence Codes"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PRDAY22                 "Number of days from admission to PR22"
 PRDAY23                 "Number of days from admission to PR23"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 PrimLang                "Primary language of patient"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 READMIT                 "Readmission"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 TOWN                    "Patient town of residence (as received from source)"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRMONTH22               "Month of procedure 22"
 PRMONTH23               "Month of procedure 23"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21"
 PRYEAR22                "Year of procedure 22"
 PRYEAR23                "Year of procedure 23" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NJ_SEDD_2013_CORE.SAV' /COMPRESSED.
