/*******************************************************************
* Creation Date: 04/01/2019   
*   MN_SID_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MN_SID_2010_CORE.ASC' FIXED SKIP=2 / 
 ADRG                            1-   3
 ADRGRISKMORTALITY               4-   5
 ADRGSEV                         6-   7
 AGE                             8-  10
 AGEDAY                         11-  13
 AGEMONTH                       14-  16
 AHOUR                          17-  20
 AMDC                           21-  22
 AMONTH                         23-  24
 ATYPE                          25-  26
 AWEEKEND                       27-  28
 DHOUR                          29-  32
 DIED                           33-  34
 DISPUB04                       35-  36
 DISPUNIFORM                    37-  38
 DISP_X                         39-  40 (A)
 DQTR                           41-  42
 DRG                            43-  45
 DRG24                          46-  48
 DRGVER                         49-  50
 DRG_NoPOA                      51-  53
 DX1                            54-  60 (A)
 DX2                            61-  67 (A)
 DX3                            68-  74 (A)
 DX4                            75-  81 (A)
 DX5                            82-  88 (A)
 DX6                            89-  95 (A)
 DX7                            96- 102 (A)
 DX8                           103- 109 (A)
 DX9                           110- 116 (A)
 DX10                          117- 123 (A)
 DX11                          124- 130 (A)
 DX12                          131- 137 (A)
 DX13                          138- 144 (A)
 DX14                          145- 151 (A)
 DX15                          152- 158 (A)
 DX16                          159- 165 (A)
 DX17                          166- 172 (A)
 DX18                          173- 179 (A)
 DX19                          180- 186 (A)
 DX20                          187- 193 (A)
 DX21                          194- 200 (A)
 DX22                          201- 207 (A)
 DX23                          208- 214 (A)
 DX24                          215- 221 (A)
 DX25                          222- 228 (A)
 DX26                          229- 235 (A)
 DX27                          236- 242 (A)
 DX28                          243- 249 (A)
 DX29                          250- 256 (A)
 DX30                          257- 263 (A)
 DXCCS1                        264- 267
 DXCCS2                        268- 271
 DXCCS3                        272- 275
 DXCCS4                        276- 279
 DXCCS5                        280- 283
 DXCCS6                        284- 287
 DXCCS7                        288- 291
 DXCCS8                        292- 295
 DXCCS9                        296- 299
 DXCCS10                       300- 303
 DXCCS11                       304- 307
 DXCCS12                       308- 311
 DXCCS13                       312- 315
 DXCCS14                       316- 319
 DXCCS15                       320- 323
 DXCCS16                       324- 327
 DXCCS17                       328- 331
 DXCCS18                       332- 335
 DXCCS19                       336- 339
 DXCCS20                       340- 343
 DXCCS21                       344- 347
 DXCCS22                       348- 351
 DXCCS23                       352- 355
 DXCCS24                       356- 359
 DXCCS25                       360- 363
 DXCCS26                       364- 367
 DXCCS27                       368- 371
 DXCCS28                       372- 375
 DXCCS29                       376- 379
 DXCCS30                       380- 383
 DXPOA1                        384     (A)
 DXPOA2                        385     (A)
 DXPOA3                        386     (A)
 DXPOA4                        387     (A)
 DXPOA5                        388     (A)
 DXPOA6                        389     (A)
 DXPOA7                        390     (A)
 DXPOA8                        391     (A)
 DXPOA9                        392     (A)
 DXPOA10                       393     (A)
 DXPOA11                       394     (A)
 DXPOA12                       395     (A)
 DXPOA13                       396     (A)
 DXPOA14                       397     (A)
 DXPOA15                       398     (A)
 DXPOA16                       399     (A)
 DXPOA17                       400     (A)
 DXPOA18                       401     (A)
 DXPOA19                       402     (A)
 DXPOA20                       403     (A)
 DXPOA21                       404     (A)
 DXPOA22                       405     (A)
 DXPOA23                       406     (A)
 DXPOA24                       407     (A)
 DXPOA25                       408     (A)
 DXPOA26                       409     (A)
 DXPOA27                       410     (A)
 DXPOA28                       411     (A)
 DXPOA29                       412     (A)
 DXPOA30                       413     (A)
 ECODE1                        414- 420 (A)
 ECODE2                        421- 427 (A)
 ECODE3                        428- 434 (A)
 ECODE4                        435- 441 (A)
 ECODE5                        442- 448 (A)
 ECODE6                        449- 455 (A)
 ECODE7                        456- 462 (A)
 ECODE8                        463- 469 (A)
 ECODE9                        470- 476 (A)
 E_CCS1                        477- 480
 E_CCS2                        481- 484
 E_CCS3                        485- 488
 E_CCS4                        489- 492
 E_CCS5                        493- 496
 E_CCS6                        497- 500
 E_CCS7                        501- 504
 E_CCS8                        505- 508
 E_CCS9                        509- 512
 E_POA1                        513     (A)
 E_POA2                        514     (A)
 E_POA3                        515     (A)
 E_POA4                        516     (A)
 E_POA5                        517     (A)
 E_POA6                        518     (A)
 E_POA7                        519     (A)
 E_POA8                        520     (A)
 E_POA9                        521     (A)
 FEMALE                        522- 523
 HCUP_ED                       524- 525
 HCUP_OS                       526- 527
 HOSPBRTH                      528- 530
 HOSPST                        531- 532 (A)
 KEY                           533- 547
 LOS                           548- 552
 LOS_X                         553- 558
 MARITALSTATUSUB04             559     (A)
 MARITALSTATUS_X               560     (A)
 MDC                           561- 562
 MDC24                         563- 564
 MDC_NoPOA                     565- 566
 MEDINCSTQ                     567- 568
 MRN_R                         569- 577
 NCHRONIC                      578- 580
 NDX                           581- 583
 NECODE                        584- 585
 NEOMAT                        586- 587
 NPR                           588- 590
 ORPROC                        591- 592
 PAY1                          593- 594
 PAY1_X                        595- 601 (A)
 PAY2                          602- 603
 PAY2_X                        604- 610 (A)
 PAY3                          611- 612
 PAY3_X                        613- 619 (A)
 PL_CBSA                       620- 622
 PL_MSA1993                    623- 625
 PL_NCHS2006                   626- 627
 PL_RUCA10_2005                628- 629
 PL_RUCA2005                   630- 633
 PL_RUCA4_2005                 634- 635
 PL_RUCC2003                   636- 637
 PL_UIC2003                    638- 639
 PL_UR_CAT4                    640- 641
 PR1                           642- 648 (A)
 PR2                           649- 655 (A)
 PR3                           656- 662 (A)
 PR4                           663- 669 (A)
 PR5                           670- 676 (A)
 PR6                           677- 683 (A)
 PR7                           684- 690 (A)
 PR8                           691- 697 (A)
 PR9                           698- 704 (A)
 PR10                          705- 711 (A)
 PR11                          712- 718 (A)
 PR12                          719- 725 (A)
 PR13                          726- 732 (A)
 PR14                          733- 739 (A)
 PR15                          740- 746 (A)
 PR16                          747- 753 (A)
 PR17                          754- 760 (A)
 PR18                          761- 767 (A)
 PR19                          768- 774 (A)
 PR20                          775- 781 (A)
 PR21                          782- 788 (A)
 PR22                          789- 795 (A)
 PR23                          796- 802 (A)
 PR24                          803- 809 (A)
 PR25                          810- 816 (A)
 PR26                          817- 823 (A)
 PR27                          824- 830 (A)
 PR28                          831- 837 (A)
 PR29                          838- 844 (A)
 PR30                          845- 851 (A)
 PR31                          852- 858 (A)
 PR32                          859- 865 (A)
 PR33                          866- 872 (A)
 PR34                          873- 879 (A)
 PRCCS1                        880- 882
 PRCCS2                        883- 885
 PRCCS3                        886- 888
 PRCCS4                        889- 891
 PRCCS5                        892- 894
 PRCCS6                        895- 897
 PRCCS7                        898- 900
 PRCCS8                        901- 903
 PRCCS9                        904- 906
 PRCCS10                       907- 909
 PRCCS11                       910- 912
 PRCCS12                       913- 915
 PRCCS13                       916- 918
 PRCCS14                       919- 921
 PRCCS15                       922- 924
 PRCCS16                       925- 927
 PRCCS17                       928- 930
 PRCCS18                       931- 933
 PRCCS19                       934- 936
 PRCCS20                       937- 939
 PRCCS21                       940- 942
 PRCCS22                       943- 945
 PRCCS23                       946- 948
 PRCCS24                       949- 951
 PRCCS25                       952- 954
 PRCCS26                       955- 957
 PRCCS27                       958- 960
 PRCCS28                       961- 963
 PRCCS29                       964- 966
 PRCCS30                       967- 969
 PRCCS31                       970- 972
 PRCCS32                       973- 975
 PRCCS33                       976- 978
 PRCCS34                       979- 981
 PRDAY1                        982- 986
 PRDAY2                        987- 991
 PRDAY3                        992- 996
 PRDAY4                        997-1001
 PRDAY5                       1002-1006
 PRDAY6                       1007-1011
 PRDAY7                       1012-1016
 PRDAY8                       1017-1021
 PRDAY9                       1022-1026
 PRDAY10                      1027-1031
 PRDAY11                      1032-1036
 PRDAY12                      1037-1041
 PRDAY13                      1042-1046
 PRDAY14                      1047-1051
 PRDAY15                      1052-1056
 PRDAY16                      1057-1061
 PRDAY17                      1062-1066
 PRDAY18                      1067-1071
 PRDAY19                      1072-1076
 PRDAY20                      1077-1081
 PRDAY21                      1082-1086
 PRDAY22                      1087-1091
 PRDAY23                      1092-1096
 PRDAY24                      1097-1101
 PRDAY25                      1102-1106
 PRDAY26                      1107-1111
 PRDAY27                      1112-1116
 PRDAY28                      1117-1121
 PRDAY29                      1122-1126
 PRDAY30                      1127-1131
 PRDAY31                      1132-1136
 PRDAY32                      1137-1141
 PRDAY33                      1142-1146
 PRDAY34                      1147-1151
 PROCTYPE                     1152-1154
 PSTATE                       1155-1156 (A)
 PSTCO2                       1157-1161
 PointOfOriginUB04            1162     (A)
 PointOfOrigin_X              1163     (A)
 TOTCHG                       1164-1173
 TOTCHG_X                     1174-1188
 TRAN_IN                      1189-1190
 TRAN_OUT                     1191-1192
 YEAR                         1193-1196
 ZIP3                         1197-1199 (A)
 ZIPINC_QRTL                  1200-1202
 ZIP                          1203-1207 (A)
 AYEAR                        1208-1211
 DMONTH                       1212-1213
 BMONTH                       1214-1215
 BYEAR                        1216-1219
 PRMONTH1                     1220-1221
 PRMONTH2                     1222-1223
 PRMONTH3                     1224-1225
 PRMONTH4                     1226-1227
 PRMONTH5                     1228-1229
 PRMONTH6                     1230-1231
 PRMONTH7                     1232-1233
 PRMONTH8                     1234-1235
 PRMONTH9                     1236-1237
 PRMONTH10                    1238-1239
 PRMONTH11                    1240-1241
 PRMONTH12                    1242-1243
 PRMONTH13                    1244-1245
 PRMONTH14                    1246-1247
 PRMONTH15                    1248-1249
 PRMONTH16                    1250-1251
 PRMONTH17                    1252-1253
 PRMONTH18                    1254-1255
 PRMONTH19                    1256-1257
 PRMONTH20                    1258-1259
 PRMONTH21                    1260-1261
 PRMONTH22                    1262-1263
 PRMONTH23                    1264-1265
 PRMONTH24                    1266-1267
 PRMONTH25                    1268-1269
 PRMONTH26                    1270-1271
 PRMONTH27                    1272-1273
 PRMONTH28                    1274-1275
 PRMONTH29                    1276-1277
 PRMONTH30                    1278-1279
 PRMONTH31                    1280-1281
 PRMONTH32                    1282-1283
 PRMONTH33                    1284-1285
 PRMONTH34                    1286-1287
 PRYEAR1                      1288-1291
 PRYEAR2                      1292-1295
 PRYEAR3                      1296-1299
 PRYEAR4                      1300-1303
 PRYEAR5                      1304-1307
 PRYEAR6                      1308-1311
 PRYEAR7                      1312-1315
 PRYEAR8                      1316-1319
 PRYEAR9                      1320-1323
 PRYEAR10                     1324-1327
 PRYEAR11                     1328-1331
 PRYEAR12                     1332-1335
 PRYEAR13                     1336-1339
 PRYEAR14                     1340-1343
 PRYEAR15                     1344-1347
 PRYEAR16                     1348-1351
 PRYEAR17                     1352-1355
 PRYEAR18                     1356-1359
 PRYEAR19                     1360-1363
 PRYEAR20                     1364-1367
 PRYEAR21                     1368-1371
 PRYEAR22                     1372-1375
 PRYEAR23                     1376-1379
 PRYEAR24                     1380-1383
 PRYEAR25                     1384-1387
 PRYEAR26                     1388-1391
 PRYEAR27                     1392-1395
 PRYEAR28                     1396-1399
 PRYEAR29                     1400-1403
 PRYEAR30                     1404-1407
 PRYEAR31                     1408-1411
 PRYEAR32                     1412-1415
 PRYEAR33                     1416-1419
 PRYEAR34                     1420-1423.


***  Specify write formats  ***.
FORMATS
 ADRG                         (F3.0) /
 ADRGRISKMORTALITY            (F3.0) /
 ADRGSEV                      (F3.0) /
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMDC                         (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG24                        (F3.0) /
 DRGVER                       (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 E_CCS9                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC24                        (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_MSA1993                   (F3.0) /
 PL_NCHS2006                  (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA2005                  (F4.1) /
 PL_RUCA4_2005                (F3.0) /
 PL_RUCC2003                  (F3.0) /
 PL_UIC2003                   (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRCCS26                      (F3.0) /
 PRCCS27                      (F3.0) /
 PRCCS28                      (F3.0) /
 PRCCS29                      (F3.0) /
 PRCCS30                      (F3.0) /
 PRCCS31                      (F3.0) /
 PRCCS32                      (F3.0) /
 PRCCS33                      (F3.0) /
 PRCCS34                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PSTCO2                       (F4.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 DMONTH                       (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 ADRG                         "All Patient Refined DRG"
 ADRGRISKMORTALITY            "All Patient Refined DRG mortality risk"
 ADRGSEV                      "All Patient Refined DRG severity level"
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMDC                         "All Patient Refined MDC"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG24                        "DRG, version 24"
 DRGVER                       "DRG grouper version used on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 ECODE9                       "E code 9"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_CCS9                       "CCS: E Code 9"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 E_POA9                       "E Code 9, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC24                        "MDC, version 24"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993                   "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006                  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005               "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005                  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005                "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003                  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003                   "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PR26                         "Procedure 26"
 PR27                         "Procedure 27"
 PR28                         "Procedure 28"
 PR29                         "Procedure 29"
 PR30                         "Procedure 30"
 PR31                         "Procedure 31"
 PR32                         "Procedure 32"
 PR33                         "Procedure 33"
 PR34                         "Procedure 34"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRCCS26                      "CCS: procedure 26"
 PRCCS27                      "CCS: procedure 27"
 PRCCS28                      "CCS: procedure 28"
 PRCCS29                      "CCS: procedure 29"
 PRCCS30                      "CCS: procedure 30"
 PRCCS31                      "CCS: procedure 31"
 PRCCS32                      "CCS: procedure 32"
 PRCCS33                      "CCS: procedure 33"
 PRCCS34                      "CCS: procedure 34"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PRDAY21                      "Number of days from admission to PR21"
 PRDAY22                      "Number of days from admission to PR22"
 PRDAY23                      "Number of days from admission to PR23"
 PRDAY24                      "Number of days from admission to PR24"
 PRDAY25                      "Number of days from admission to PR25"
 PRDAY26                      "Number of days from admission to PR26"
 PRDAY27                      "Number of days from admission to PR27"
 PRDAY28                      "Number of days from admission to PR28"
 PRDAY29                      "Number of days from admission to PR29"
 PRDAY30                      "Number of days from admission to PR30"
 PRDAY31                      "Number of days from admission to PR31"
 PRDAY32                      "Number of days from admission to PR32"
 PRDAY33                      "Number of days from admission to PR33"
 PRDAY34                      "Number of days from admission to PR34"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 ZIP                          "Patient ZIP Code"
 AYEAR                        "Admission year"
 DMONTH                       "Discharge month"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE ADRGRISKMORTALITY
 (-9,-8,-6,-5=SYSMIS).
RECODE ADRGSEV
 (-9,-8,-6,-5=SYSMIS).
RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMDC
 (-9,-8,-6,-5=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MN_SID_2010_CORE.SAV' /COMPRESSED.
