define UFlags () .

* Program     : UtilizationFlags.sas                                               
* Date        : 09/17/2017                                                         
* Description : This program creates 30 Utilization Flag variables using UB-92    
*             : revenue codes and ICD-9-CM procedure codes from SAS data. The    
*             : program uses informats to map revenue codes and procedure codes   
*             : to the new variables. These programs were developed under the     
*             : HCUP contract, sponsored by AHRQ.
* Updates     : .                                 
* Sept 2015: Change label for U_MRT from Medical Resonance Technology to 
*            Magnetic Resonance Technology.

    *specify the names of input dataset, output dataset, and number of revenue 
     and procedure codes, respectively .

    !let !indata = "<input data>" .
    !let !outdata = "<output data>" .
    !let !nrevcds = <number revenue codes on input file> .
    !let !nprcods = <number of procedure codes on input file> .

    * do not edit below this line .
    * ---------------------------------------------------------------- .
    
    get file = !quote(!indata).
    
    numeric u_blood u_cath u_ccu u_chstxr u_ctscan u_dialys u_echo u_ed 
       u_eeg u_ekg u_epo u_icu u_lithot u_mhsa u_mrt u_nbrn2l u_nbrn3l 
       u_nbrn4l u_nucmed u_observ u_occthr u_organ u_implnt u_pacmkr 
       u_phythr u_radthr u_rspthr u_sphthr u_stress u_ultsnd (f1) .

    variable labels
       u_blood       "Utilization Flag: Blood"
       u_cath        "Utilization Flag: Cardiac Catheterization Lab"
       u_ccu         "Utilization Flag: Coronary Care Unit (CCU)"
       u_chstxr      "Utilization Flag: Chest X-Ray"
       u_ctscan      "Utilization Flag: Computed Tomography Scan"
       u_dialys      "Utilization Flag: Renal Dialysis"
       u_echo        "Utilization Flag: Echocardiology"
       u_ed          "Utilization Flag: Emergency Room"
       u_eeg         "Utilization Flag: Electroencephalogram"
       u_ekg         "Utilization Flag: Electrocardiogram"
       u_epo         "Utilization Flag: EPO"
       u_icu         "Utilization Flag: Intensive Care Unit (ICU)"
       u_lithot      "Utilization Flag: Lithotripsy"
       u_mhsa        "Utilization Flag: Mental Health and Substance Abuse"
       u_mrt         "Utilization Flag: Magnetic Resonance Technology"
       u_nbrn2l      "Utilization Flag: Nursery Level II"
       u_nbrn3l      "Utilization Flag: Nursery Level III"
       u_nbrn4l      "Utilization Flag: Nursery Level IV"
       u_nucmed      "Utilization Flag: Nuclear Medicine"
       u_observ      "Utilization Flag: Observation Room"
       u_occthr      "Utilization Flag: Occupational Therapy"
       u_organ       "Utilization Flag: Organ Acquisition"
       u_implnt      "Utilization Flag: Other Implants"
       u_pacmkr      "Utilization Flag: Pacemaker"
       u_phythr      "Utilization Flag: Physical Therapy"
       u_radthr      "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
       u_rspthr      "Utilization Flag: Respiratory Services"
       u_sphthr      "Utilization Flag: Speech - Language Pathology"
       u_stress      "Utilization Flag: Cardiac Stress Test"
       u_ultsnd      "Utilization Flag: Ultrasound" .

    vector uvars = u_blood to u_ultsnd .
    loop #uidx = 1 to 30 .
       compute uvars(#uidx) = 0 .
    end loop .

    vector rev = revcd1 to !concat("revcd", !nrevcds) .
    string #tmp (a4) .
    loop #ridx = 1 to !nrevcds .
       compute #tmp = lpad(rev(#ridx), 4, "0") .
       if (any (#tmp, "0399", "0380", "0381", "0382", "0383", "0384", "0385",
              "0386","0387", "0389", "0390", "0391", "0392")) uvars(1) = 1 .
       if (#tmp = "0481") uvars(2) = 1 .
       if (any (#tmp, "0210", "0211", "0212", "0213", "0214", "0219"))
              uvars(3) = 1 .
       if (#tmp = "0324") uvars(4) = 1 .
       if (any (#tmp, "0350", "0351", "0352", "0359")) uvars(5) = 1 .
       if (any (#tmp, "0800", "0801", "0802", "0803", "0804", "0809"))
              uvars(6) = 1 .
       if (#tmp = "0483") uvars(7) = 1 .
       if (any (#tmp, "0450", "0451", "0452", "0456", "0459")) uvars(8) = 1 .
       if (any (#tmp, "0740", "0749")) uvars(9) = 1 .
       if (any (#tmp, "0730", "0731", "0739")) uvars(10) = 1 .
       if (any (#tmp, "0634", "0635")) uvars(11) = 1 .
       if (any (#tmp, "0200", "0201", "0202", "0203", "0204", "0206", "0207",
             "0208", "0209")) uvars(12) = 1 .
       if (any (#tmp, "0790", "0799")) uvars(13) = 1 .
       if (any (#tmp, "1001", "1002", "0114", "0116", "0124", "0126", "0134",
             "0136", "0144", "0146", "0154", "0156", "0513", "0900", "0901",
             "0902", "0903", "0904", "0905", "0906", "0907", "0909", "0910",
             "0911", "0912", "0913", "0914", "0915", "0916", "0917", "0918",
             "0919", "0944", "0945")) uvars(14) = 1 .
       if (any (#tmp, "0610", "0611", "0612", "0614", "0615", "0616",
             "0618", "0619")) uvars(15) = 1 .
       if (#tmp = "0172") uvars(16) = 1 .
       if (#tmp = "0173") uvars(17) = 1 .
       if (#tmp = "0174") uvars(18) = 1 .
       if (any (#tmp, "0340", "0341", "0342", "0343", "0344", "0349"))
             uvars(19) = 1 .
       if (#tmp = "0762") uvars(20) = 1 .
       if (any (#tmp, "0430", "0431", "0432", "0433", "0434", "0439"))
             uvars(21) = 1 .
       if (any (#tmp, "0810", "0811", "0812", "0813", "0814", "0819"))
             uvars(22) = 1 .
       if (#tmp = "0278") uvars(23) = 1 .
       if (#tmp = "0275") uvars(24) = 1 .
       if (any (#tmp, "0420", "0421", "0422", "0423", "0424", "0429"))
             uvars(25) = 1 .
       if (any (#tmp, "0330", "0331", "0332", "0333", "0335", "0339"))
             uvars(26) = 1 .
       if (any (#tmp, "0410", "0412", "0413", "0419")) uvars(27) = 1 .
       if (any (#tmp, "0440", "0441", "0442", "0443", "0444", "0449"))
             uvars(28) = 1 .
       if (#tmp = "0482") uvars(29) = 1 .
       if (#tmp = "0402") uvars(30) = 1 .
    end loop if (#tmp = "0000") .

    vector pr  = pr1 to !concat("pr", !nprcods) .
    loop #pidx = 1 to !nprcods .
       if (any (pr(#pidx), "8744", "8749")) uvars(4) = uvars(4) + 10 .
       if (any (pr(#pidx), "3995", "5498")) uvars(6) = uvars(6) + 10 .
       if (any (pr(#pidx), "0024", "3728", "8872")) uvars(7) = uvars(7) + 10 .
       if (any (pr(#pidx), "8914", "8919")) uvars(9) = uvars(9) + 10 .
       if (any (pr(#pidx), "9851", "9852", "9859")) uvars(13) = uvars(13) + 10 .
       if (any (pr(#pidx), "9201", "9202", "9203", "9204", "9205", "9209",
           "9211", "9212", "9213", "9214", "9215", "9216", "9217", "9218",
           "9219", "9220", "9221", "9222", "9223", "9224", "9225", "9226",
           "9227", "9228", "9229", "9230", "9231", "9232", "9233", "9239",
           "9241")) uvars(19) = uvars(19) + 10 .
       if (pr(#pidx) = "9383") uvars(21) = uvars(21) + 10 .
       if (any (pr(#pidx), "9390", "9391", "9393", "9394", "9395", "9396",
           "9397", "9398", "9399", "9670", "9671", "9672"))
           uvars(27) = uvars(27) + 10 .
       if (any (pr(#pidx), "9371", "9372", "9373", "9374", "9375"))
           uvars(28) = uvars(28) + 10 .
       if (any (pr(#pidx), "0021", "8871", "8874", "0025", "8875", "8876",
           "0022", "0023", "0028", "0029", "8873", "8877", "8878", "8879",
           "9513")) uvars(30) = uvars(30) + 10 .
    end loop if (pr(#pidx) = "").

    vector ccs = prccs1 to !concat("prccs", !nprcods) .
    loop #cidx = 1 to !nprcods .       
       if (ccs(#cidx) = 222) uvars(1) = uvars(1) + 10 .
       if (ccs(#cidx) = 47) uvars(2) = uvars(2) + 10 .
       if (any (ccs(#cidx), 177, 178, 179, 180)) uvars(5) = uvars(5) + 10 .
       if (ccs(#cidx) = 202) uvars(10) = uvars(10) + 10 .
       if (any (ccs(#cidx), 218, 219)) uvars(14) = uvars(14) + 10 .
       if (ccs(#cidx) = 198) uvars(15) = uvars(15) + 10 .
       if (ccs(#cidx) = 48) uvars(24) = uvars(24) + 10 .
       if (any (ccs(#cidx), 212, 213)) uvars(25) = uvars(25) + 10 .
       if (any (ccs(#cidx), 211, 224)) uvars(26) = uvars(26) + 10 .
       if (ccs(#cidx) = 201) uvars(29) = uvars(29) + 10 .
    end loop if (missing(ccs(#cidx))) .

    loop #uidx = 1 to 30 .
       do if (uvars(#uidx) > 1) .
          do if (mod(uvars(#uidx), 10) = 1) .
              compute uvars(#uidx) = 3.
          else .
              compute uvars(#uidx) = 2.
          end if.
       end if.
    end loop .

    save out = !quote(!outdata).

!enddefine .

UFlags .

frequencies vars = u_blood to u_ultsnd .